/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.content.AssetDeliveryPolicyRestType;
import com.microsoft.windowsazure.services.media.models.AssetDeliveryPolicyConfigurationKey;
import com.microsoft.windowsazure.services.media.models.AssetDeliveryPolicyInfo;
import com.microsoft.windowsazure.services.media.models.AssetDeliveryPolicyType;
import com.microsoft.windowsazure.services.media.models.AssetDeliveryProtocol;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.sun.jersey.api.client.GenericType;
import java.util.EnumSet;
import java.util.Map;

public final class AssetDeliveryPolicy {
    private static final String ENTITY_SET = "AssetDeliveryPolicies";

    private AssetDeliveryPolicy() {
    }

    public static Creator create() {
        return new Creator();
    }

    public static EntityGetOperation<AssetDeliveryPolicyInfo> get(String assetDeliveryPolicyId) {
        return new DefaultGetOperation<AssetDeliveryPolicyInfo>(ENTITY_SET, assetDeliveryPolicyId, AssetDeliveryPolicyInfo.class);
    }

    public static DefaultListOperation<AssetDeliveryPolicyInfo> list() {
        return new DefaultListOperation<AssetDeliveryPolicyInfo>(ENTITY_SET, new GenericType<ListResult<AssetDeliveryPolicyInfo>>(){});
    }

    public static DefaultListOperation<AssetDeliveryPolicyInfo> list(LinkInfo<AssetDeliveryPolicyInfo> link) {
        return new DefaultListOperation<AssetDeliveryPolicyInfo>(link.getHref(), new GenericType<ListResult<AssetDeliveryPolicyInfo>>(){});
    }

    public static EntityDeleteOperation delete(String assetDeliveryPolicyId) {
        return new DefaultDeleteOperation(ENTITY_SET, assetDeliveryPolicyId);
    }

    public static Updater update(String assetDeliveryPolicyId) {
        return new Updater(assetDeliveryPolicyId);
    }

    public static class Updater
    extends EntityOperationBase
    implements EntityUpdateOperation {
        private EnumSet<AssetDeliveryProtocol> assetDeliveryProtocol;
        private AssetDeliveryPolicyType assetDeliveryPolicyType;
        private Map<AssetDeliveryPolicyConfigurationKey, String> assetDeliveryConfiguration;

        protected Updater(String assetDeliveryPolicyId) {
            super(new EntityOperationBase.EntityIdUriBuilder(AssetDeliveryPolicy.ENTITY_SET, assetDeliveryPolicyId));
        }

        @Override
        public Object getRequestContents() {
            return new AssetDeliveryPolicyRestType().setAssetDeliveryConfiguration(this.assetDeliveryConfiguration).setAssetDeliveryPolicyType(this.assetDeliveryPolicyType.getCode()).setAssetDeliveryProtocol(AssetDeliveryProtocol.bitsFromProtocols(this.assetDeliveryProtocol));
        }

        public Updater setAssetDeliveryProtocol(EnumSet<AssetDeliveryProtocol> assetDeliveryProtocol) {
            this.assetDeliveryProtocol = assetDeliveryProtocol;
            return this;
        }

        public Updater setAssetDeliveryPolicyType(AssetDeliveryPolicyType assetDeliveryPolicyType) {
            this.assetDeliveryPolicyType = assetDeliveryPolicyType;
            return this;
        }

        public Updater setAssetDeliveryConfiguration(Map<AssetDeliveryPolicyConfigurationKey, String> assetDeliveryPolicyConfiguration) {
            this.assetDeliveryConfiguration = assetDeliveryPolicyConfiguration;
            return this;
        }
    }

    public static class Creator
    extends EntityOperationSingleResultBase<AssetDeliveryPolicyInfo>
    implements EntityCreateOperation<AssetDeliveryPolicyInfo> {
        private String name;
        private EnumSet<AssetDeliveryProtocol> assetDeliveryProtocol;
        private AssetDeliveryPolicyType assetDeliveryPolicyType;
        private Map<AssetDeliveryPolicyConfigurationKey, String> assetDeliveryConfiguration;

        public Creator() {
            super(AssetDeliveryPolicy.ENTITY_SET, AssetDeliveryPolicyInfo.class);
        }

        @Override
        public Object getRequestContents() {
            return new AssetDeliveryPolicyRestType().setName(this.name).setAssetDeliveryConfiguration(this.assetDeliveryConfiguration).setAssetDeliveryPolicyType(this.assetDeliveryPolicyType.getCode()).setAssetDeliveryProtocol(AssetDeliveryProtocol.bitsFromProtocols(this.assetDeliveryProtocol));
        }

        public Creator setName(String name) {
            this.name = name;
            return this;
        }

        public Creator setAssetDeliveryProtocol(EnumSet<AssetDeliveryProtocol> assetDeliveryProtocol) {
            this.assetDeliveryProtocol = assetDeliveryProtocol;
            return this;
        }

        public Creator setAssetDeliveryPolicyType(AssetDeliveryPolicyType assetDeliveryPolicyType) {
            this.assetDeliveryPolicyType = assetDeliveryPolicyType;
            return this;
        }

        public Creator setAssetDeliveryConfiguration(Map<AssetDeliveryPolicyConfigurationKey, String> assetDeliveryPolicyConfiguration) {
            this.assetDeliveryConfiguration = assetDeliveryPolicyConfiguration;
            return this;
        }
    }
}

