/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.implementation.ODataEntity;
import com.microsoft.windowsazure.services.media.implementation.atom.EntryType;
import com.microsoft.windowsazure.services.media.implementation.content.JobNotificationSubscriptionType;
import com.microsoft.windowsazure.services.media.implementation.content.JobType;
import com.microsoft.windowsazure.services.media.models.AssetInfo;
import com.microsoft.windowsazure.services.media.models.JobNotificationSubscription;
import com.microsoft.windowsazure.services.media.models.JobNotificationSubscriptionListFactory;
import com.microsoft.windowsazure.services.media.models.JobState;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.TaskInfo;
import java.util.Date;
import java.util.List;

public class JobInfo
extends ODataEntity<JobType> {
    public JobInfo(EntryType entry, JobType content) {
        super(entry, content);
    }

    public String getId() {
        return ((JobType)this.getContent()).getId();
    }

    public String getName() {
        return ((JobType)this.getContent()).getName();
    }

    public Date getCreated() {
        return ((JobType)this.getContent()).getCreated();
    }

    public Date getLastModified() {
        return ((JobType)this.getContent()).getLastModified();
    }

    public Date getEndTime() {
        return ((JobType)this.getContent()).getEndTime();
    }

    public int getPriority() {
        return ((JobType)this.getContent()).getPriority();
    }

    public double getRunningDuration() {
        return ((JobType)this.getContent()).getRunningDuration();
    }

    public Date getStartTime() {
        return ((JobType)this.getContent()).getStartTime();
    }

    public JobState getState() {
        return JobState.fromCode(((JobType)this.getContent()).getState());
    }

    public String getTemplateId() {
        return ((JobType)this.getContent()).getTemplateId();
    }

    public LinkInfo<AssetInfo> getInputAssetsLink() {
        return this.getRelationLink("InputMediaAssets");
    }

    public LinkInfo<AssetInfo> getOutputAssetsLink() {
        return this.getRelationLink("OutputMediaAssets");
    }

    public LinkInfo<TaskInfo> getTasksLink() {
        return this.getRelationLink("Tasks");
    }

    public List<JobNotificationSubscription> getJobNotificationSubscriptions() {
        return JobNotificationSubscriptionListFactory.create(((JobType)this.getContent()).getJobNotificationSubscriptionTypes());
    }

    public JobInfo addJobNotificationSubscription(JobNotificationSubscription jobNotificationSubscription) {
        ((JobType)this.getContent()).addJobNotificationSubscriptionType(new JobNotificationSubscriptionType().setNotificationEndPointId(jobNotificationSubscription.getNotificationEndPointId()).setTargetJobState(jobNotificationSubscription.getTargetJobState().getCode()));
        return this;
    }
}

