/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for CheckNameResourceTypes.
 */
public final class CheckNameResourceTypes {
    /** Static value Site for CheckNameResourceTypes. */
    public static final CheckNameResourceTypes SITE = new CheckNameResourceTypes("Site");

    /** Static value Slot for CheckNameResourceTypes. */
    public static final CheckNameResourceTypes SLOT = new CheckNameResourceTypes("Slot");

    /** Static value HostingEnvironment for CheckNameResourceTypes. */
    public static final CheckNameResourceTypes HOSTING_ENVIRONMENT = new CheckNameResourceTypes("HostingEnvironment");

    private String value;

    /**
     * Creates a custom value for CheckNameResourceTypes.
     * @param value the custom value
     */
    public CheckNameResourceTypes(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CheckNameResourceTypes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CheckNameResourceTypes rhs = (CheckNameResourceTypes) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
