/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * MySQL migration request.
 */
@JsonFlatten
public class MigrateMySqlRequestInner extends Resource {
    /**
     * Connection string to the remote MySQL database to which data should be
     * migrated.
     */
    @JsonProperty(value = "properties.connectionString")
    private String connectionString;

    /**
     * Get the connectionString value.
     *
     * @return the connectionString value
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString value.
     *
     * @param connectionString the connectionString value to set
     * @return the MigrateMySqlRequestInner object itself.
     */
    public MigrateMySqlRequestInner withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

}
