/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.appservice.AppServiceDomain;
import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.CloningInfo;
import com.microsoft.azure.management.appservice.ConnectionString;
import com.microsoft.azure.management.appservice.ConnectionStringType;
import com.microsoft.azure.management.appservice.HostNameBinding;
import com.microsoft.azure.management.appservice.HostNameSslBinding;
import com.microsoft.azure.management.appservice.HostNameSslState;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.ManagedPipelineMode;
import com.microsoft.azure.management.appservice.NetFrameworkVersion;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PhpVersion;
import com.microsoft.azure.management.appservice.PlatformArchitecture;
import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.management.appservice.PythonVersion;
import com.microsoft.azure.management.appservice.RemoteVisualStudioVersion;
import com.microsoft.azure.management.appservice.SiteAvailabilityState;
import com.microsoft.azure.management.appservice.UsageState;
import com.microsoft.azure.management.appservice.WebAppAuthentication;
import com.microsoft.azure.management.appservice.WebAppSourceControl;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasName;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@Fluent(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
@Beta
public interface WebAppBase
extends HasName,
GroupableResource<AppServiceManager, SiteInner> {
    public String state();

    public Set<String> hostNames();

    public String repositorySiteName();

    public UsageState usageState();

    public boolean enabled();

    public Set<String> enabledHostNames();

    public SiteAvailabilityState availabilityState();

    public Map<String, HostNameSslState> hostNameSslStates();

    public String appServicePlanId();

    public DateTime lastModifiedTime();

    public Set<String> trafficManagerHostNames();

    public boolean isPremiumApp();

    public boolean scmSiteAlsoStopped();

    public String targetSwapSlot();

    public String microService();

    public String gatewaySiteName();

    public boolean clientAffinityEnabled();

    public boolean clientCertEnabled();

    public boolean hostNamesDisabled();

    public Set<String> outboundIPAddresses();

    public int containerSize();

    public CloningInfo cloningInfo();

    public boolean isDefaultContainer();

    public String defaultHostName();

    public List<String> defaultDocuments();

    public NetFrameworkVersion netFrameworkVersion();

    public PhpVersion phpVersion();

    public PythonVersion pythonVersion();

    public String nodeVersion();

    public boolean remoteDebuggingEnabled();

    public RemoteVisualStudioVersion remoteDebuggingVersion();

    public boolean webSocketsEnabled();

    public boolean alwaysOn();

    public JavaVersion javaVersion();

    public String javaContainer();

    public String javaContainerVersion();

    public ManagedPipelineMode managedPipelineMode();

    public String autoSwapSlotName();

    public Map<String, AppSetting> appSettings();

    public Map<String, ConnectionString> connectionStrings();

    public OperatingSystem operatingSystem();

    public PlatformArchitecture platformArchitecture();

    public String linuxFxVersion();

    @Method
    public Map<String, HostNameBinding> getHostNameBindings();

    @Method
    public Observable<Map<String, HostNameBinding>> getHostNameBindingsAsync();

    @Method
    public PublishingProfile getPublishingProfile();

    @Method
    public Observable<PublishingProfile> getPublishingProfileAsync();

    @Method
    public WebAppSourceControl getSourceControl();

    @Method
    public Observable<WebAppSourceControl> getSourceControlAsync();

    public void verifyDomainOwnership(String var1, String var2);

    public Completable verifyDomainOwnershipAsync(String var1, String var2);

    @Method
    public void start();

    @Method
    public Completable startAsync();

    @Method
    public void stop();

    @Method
    public Completable stopAsync();

    @Method
    public void restart();

    @Method
    public Completable restartAsync();

    public void swap(String var1);

    public Completable swapAsync(String var1);

    public void applySlotConfigurations(String var1);

    public Completable applySlotConfigurationsAsync(String var1);

    @Method
    public void resetSlotConfigurations();

    @Method
    public Completable resetSlotConfigurationsAsync();

    public static interface Update<FluentT>
    extends Appliable<FluentT>,
    Resource.UpdateWithTags<Update<FluentT>>,
    UpdateStages.WithClientAffinityEnabled<FluentT>,
    UpdateStages.WithClientCertEnabled<FluentT>,
    UpdateStages.WithScmSiteAlsoStopped<FluentT>,
    UpdateStages.WithSiteConfigs<FluentT>,
    UpdateStages.WithAppSettings<FluentT>,
    UpdateStages.WithConnectionString<FluentT>,
    UpdateStages.WithSourceControl<FluentT>,
    UpdateStages.WithHostNameBinding<FluentT>,
    UpdateStages.WithHostNameSslBinding<FluentT>,
    UpdateStages.WithAuthentication<FluentT> {
    }

    public static interface UpdateStages {

        public static interface WithAuthentication<FluentT> {
            @Method
            public WebAppAuthentication.UpdateDefinitionStages.Blank<Update<FluentT>> defineAuthentication();

            public WebAppAuthentication.Update<Update<FluentT>> updateAuthentication();

            public Update<FluentT> withoutAuthentication();
        }

        public static interface WithSourceControl<FluentT> {
            @Method
            public WebAppSourceControl.UpdateDefinitionStages.Blank<Update<FluentT>> defineSourceControl();

            public Update<FluentT> withoutSourceControl();

            public Update<FluentT> withLocalGitSourceControl();
        }

        public static interface WithConnectionString<FluentT> {
            public Update<FluentT> withConnectionString(String var1, String var2, ConnectionStringType var3);

            public Update<FluentT> withStickyConnectionString(String var1, String var2, ConnectionStringType var3);

            public Update<FluentT> withoutConnectionString(String var1);

            public Update<FluentT> withConnectionStringStickiness(String var1, boolean var2);
        }

        public static interface WithAppSettings<FluentT> {
            public Update<FluentT> withAppSetting(String var1, String var2);

            public Update<FluentT> withAppSettings(Map<String, String> var1);

            public Update<FluentT> withStickyAppSetting(String var1, String var2);

            public Update<FluentT> withStickyAppSettings(Map<String, String> var1);

            public Update<FluentT> withoutAppSetting(String var1);

            public Update<FluentT> withAppSettingStickiness(String var1, boolean var2);
        }

        public static interface WithSiteConfigs<FluentT> {
            public Update<FluentT> withNetFrameworkVersion(NetFrameworkVersion var1);

            public Update<FluentT> withPhpVersion(PhpVersion var1);

            public WithWebContainer<FluentT> withJavaVersion(JavaVersion var1);

            public Update<FluentT> withoutJava();

            public Update<FluentT> withPythonVersion(PythonVersion var1);

            public Update<FluentT> withoutPython();

            public Update<FluentT> withPlatformArchitecture(PlatformArchitecture var1);

            public Update<FluentT> withWebSocketsEnabled(boolean var1);

            public Update<FluentT> withWebAppAlwaysOn(boolean var1);

            public Update<FluentT> withManagedPipelineMode(ManagedPipelineMode var1);

            public Update<FluentT> withAutoSwapSlotName(String var1);

            public Update<FluentT> withRemoteDebuggingEnabled(RemoteVisualStudioVersion var1);

            public Update<FluentT> withRemoteDebuggingDisabled();

            public Update<FluentT> withDefaultDocument(String var1);

            public Update<FluentT> withDefaultDocuments(List<String> var1);

            public Update<FluentT> withoutDefaultDocument(String var1);
        }

        public static interface WithWebContainer<FluentT> {
            public Update<FluentT> withWebContainer(WebContainer var1);
        }

        public static interface WithClientCertEnabled<FluentT> {
            public Update<FluentT> withClientCertEnabled(boolean var1);
        }

        public static interface WithClientAffinityEnabled<FluentT> {
            public Update<FluentT> withClientAffinityEnabled(boolean var1);
        }

        public static interface WithScmSiteAlsoStopped<FluentT> {
            public Update<FluentT> withScmSiteAlsoStopped(boolean var1);
        }

        public static interface WithSiteEnabled<FluentT> {
            public Update<FluentT> withAppDisabledOnCreation();
        }

        public static interface WithHostNameSslBinding<FluentT> {
            @Method
            public HostNameSslBinding.UpdateDefinitionStages.Blank<Update<FluentT>> defineSslBinding();

            public Update<FluentT> withoutSslBinding(String var1);
        }

        public static interface WithHostNameBinding<FluentT> {
            @Method
            public HostNameBinding.UpdateDefinitionStages.Blank<Update<FluentT>> defineHostnameBinding();

            public Update<FluentT> withManagedHostnameBindings(AppServiceDomain var1, String ... var2);

            public Update<FluentT> withThirdPartyHostnameBinding(String var1, String ... var2);

            public Update<FluentT> withoutHostnameBinding(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate<FluentT>
        extends Creatable<FluentT>,
        Resource.DefinitionWithTags<WithCreate<FluentT>>,
        WithClientAffinityEnabled<FluentT>,
        WithClientCertEnabled<FluentT>,
        WithScmSiteAlsoStopped<FluentT>,
        WithSiteConfigs<FluentT>,
        WithAppSettings<FluentT>,
        WithConnectionString<FluentT>,
        WithSourceControl<FluentT>,
        WithHostNameBinding<FluentT>,
        WithHostNameSslBinding<FluentT>,
        WithAuthentication<FluentT> {
        }

        public static interface WithAuthentication<FluentT> {
            @Method
            public WebAppAuthentication.DefinitionStages.Blank<WithCreate<FluentT>> defineAuthentication();
        }

        public static interface WithSourceControl<FluentT> {
            @Method
            public WebAppSourceControl.DefinitionStages.Blank<WithCreate<FluentT>> defineSourceControl();

            public WithCreate<FluentT> withLocalGitSourceControl();
        }

        public static interface WithConnectionString<FluentT> {
            public WithCreate<FluentT> withConnectionString(String var1, String var2, ConnectionStringType var3);

            public WithCreate<FluentT> withStickyConnectionString(String var1, String var2, ConnectionStringType var3);
        }

        public static interface WithAppSettings<FluentT> {
            public WithCreate<FluentT> withAppSetting(String var1, String var2);

            public WithCreate<FluentT> withAppSettings(Map<String, String> var1);

            public WithCreate<FluentT> withStickyAppSetting(String var1, String var2);

            public WithCreate<FluentT> withStickyAppSettings(Map<String, String> var1);
        }

        public static interface WithSiteConfigs<FluentT> {
            public WithCreate<FluentT> withNetFrameworkVersion(NetFrameworkVersion var1);

            public WithCreate<FluentT> withPhpVersion(PhpVersion var1);

            public WithCreate<FluentT> withoutPhp();

            public WithWebContainer<FluentT> withJavaVersion(JavaVersion var1);

            public WithCreate<FluentT> withPythonVersion(PythonVersion var1);

            public WithCreate<FluentT> withPlatformArchitecture(PlatformArchitecture var1);

            public WithCreate<FluentT> withWebSocketsEnabled(boolean var1);

            public WithCreate<FluentT> withWebAppAlwaysOn(boolean var1);

            public WithCreate<FluentT> withManagedPipelineMode(ManagedPipelineMode var1);

            public WithCreate<FluentT> withAutoSwapSlotName(String var1);

            public WithCreate<FluentT> withRemoteDebuggingEnabled(RemoteVisualStudioVersion var1);

            public WithCreate<FluentT> withRemoteDebuggingDisabled();

            public WithCreate<FluentT> withDefaultDocument(String var1);

            public WithCreate<FluentT> withDefaultDocuments(List<String> var1);

            public WithCreate<FluentT> withoutDefaultDocument(String var1);
        }

        public static interface WithWebContainer<FluentT> {
            public WithCreate<FluentT> withWebContainer(WebContainer var1);
        }

        public static interface WithClientCertEnabled<FluentT> {
            public WithCreate<FluentT> withClientCertEnabled(boolean var1);
        }

        public static interface WithClientAffinityEnabled<FluentT> {
            public WithCreate<FluentT> withClientAffinityEnabled(boolean var1);
        }

        public static interface WithScmSiteAlsoStopped<FluentT> {
            public WithCreate<FluentT> withScmSiteAlsoStopped(boolean var1);
        }

        public static interface WithSiteEnabled<FluentT> {
            public WithCreate<FluentT> withAppDisabledOnCreation();
        }

        public static interface WithHostNameSslBinding<FluentT> {
            @Method
            public HostNameSslBinding.DefinitionStages.Blank<WithCreate<FluentT>> defineSslBinding();
        }

        public static interface WithHostNameBinding<FluentT> {
            @Method
            public HostNameBinding.DefinitionStages.Blank<WithCreate<FluentT>> defineHostnameBinding();

            public WithCreate<FluentT> withManagedHostnameBindings(AppServiceDomain var1, String ... var2);

            public WithCreate<FluentT> withThirdPartyHostnameBinding(String var1, String ... var2);
        }
    }

    public static interface Definition<FluentT>
    extends DefinitionStages.WithWebContainer<FluentT>,
    DefinitionStages.WithCreate<FluentT> {
    }
}

