/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.SkuDescription;
import com.microsoft.azure.management.appservice.implementation.AppServiceBaseImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import java.util.List;
import java.util.Map;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Completable;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class FunctionAppImpl
extends AppServiceBaseImpl<FunctionApp, FunctionAppImpl, FunctionApp.DefinitionStages.WithCreate, FunctionApp.Update>
implements FunctionApp,
FunctionApp.Definition,
FunctionApp.DefinitionStages.NewAppServicePlanWithGroup,
FunctionApp.Update {
    private Creatable<StorageAccount> storageAccountCreatable;
    private StorageAccount storageAccountToSet;
    private StorageAccount currentStorageAccount;
    private final FunctionAppKeyService functionAppKeyService;

    FunctionAppImpl(String name, SiteInner innerObject, SiteConfigResourceInner configObject, AppServiceManager manager) {
        super(name, innerObject, configObject, manager);
        innerObject.withKind("functionapp");
        this.functionAppKeyService = (FunctionAppKeyService)manager.restClient().retrofit().create(FunctionAppKeyService.class);
    }

    @Override
    public FunctionAppImpl withNewConsumptionPlan() {
        return this.withNewAppServicePlan(OperatingSystem.WINDOWS, new PricingTier("Dynamic", "Y1"));
    }

    @Override
    public FunctionAppImpl withRuntimeVersion(String version) {
        return (FunctionAppImpl)this.withAppSetting("FUNCTIONS_EXTENSION_VERSION", version.startsWith("~") ? version : "~" + version);
    }

    @Override
    public FunctionAppImpl withLatestRuntimeVersion() {
        return this.withRuntimeVersion("latest");
    }

    @Override
    Observable<SiteInner> submitAppSettings(final SiteInner site) {
        if (this.storageAccountCreatable != null && this.createdResource(this.storageAccountCreatable.key()) != null) {
            this.storageAccountToSet = (StorageAccount)this.createdResource(this.storageAccountCreatable.key());
        }
        if (this.storageAccountToSet == null) {
            return super.submitAppSettings(site);
        }
        return this.storageAccountToSet.getKeysAsync().flatMapIterable((Func1)new Func1<List<StorageAccountKey>, Iterable<StorageAccountKey>>(){

            public Iterable<StorageAccountKey> call(List<StorageAccountKey> storageAccountKeys) {
                return storageAccountKeys;
            }
        }).first().flatMap((Func1)new Func1<StorageAccountKey, Observable<SiteInner>>(){

            public Observable<SiteInner> call(StorageAccountKey storageAccountKey) {
                String connectionString = String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s", FunctionAppImpl.this.storageAccountToSet.name(), storageAccountKey.value());
                FunctionAppImpl.this.withAppSetting("AzureWebJobsStorage", connectionString);
                FunctionAppImpl.this.withAppSetting("AzureWebJobsDashboard", connectionString);
                FunctionAppImpl.this.withAppSetting("WEBSITE_CONTENTAZUREFILECONNECTIONSTRING", connectionString);
                FunctionAppImpl.this.withAppSetting("WEBSITE_CONTENTSHARE", SdkContext.randomResourceName((String)FunctionAppImpl.this.name(), (int)32));
                return FunctionAppImpl.super.submitAppSettings(site);
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                FunctionAppImpl.this.currentStorageAccount = FunctionAppImpl.this.storageAccountToSet;
                FunctionAppImpl.this.storageAccountToSet = null;
                FunctionAppImpl.this.storageAccountCreatable = null;
            }
        });
    }

    @Override
    FunctionAppImpl withNewAppServicePlan(OperatingSystem operatingSystem, PricingTier pricingTier) {
        return ((FunctionAppImpl)super.withNewAppServicePlan(operatingSystem, pricingTier)).autoSetAlwaysOn(pricingTier);
    }

    @Override
    public FunctionAppImpl withExistingAppServicePlan(AppServicePlan appServicePlan) {
        super.withExistingAppServicePlan(appServicePlan);
        return this.autoSetAlwaysOn(appServicePlan.pricingTier());
    }

    private FunctionAppImpl autoSetAlwaysOn(PricingTier pricingTier) {
        SkuDescription description = pricingTier.toSkuDescription();
        if (description.tier().equalsIgnoreCase("Basic") || description.tier().equalsIgnoreCase("Standard") || description.tier().equalsIgnoreCase("Premium")) {
            return (FunctionAppImpl)this.withWebAppAlwaysOn(true);
        }
        return (FunctionAppImpl)this.withWebAppAlwaysOn(false);
    }

    @Override
    public FunctionAppImpl withNewStorageAccount(String name, SkuName sku) {
        StorageAccount.DefinitionStages.WithGroup storageDefine = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)((AppServiceManager)this.manager()).storageManager().storageAccounts().define(name)).withRegion(this.regionName());
        this.storageAccountCreatable = this.creatableGroup != null && this.isInCreateMode() ? ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withNewResourceGroup(this.creatableGroup)).withGeneralPurposeAccountKind().withSku(sku) : ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withExistingResourceGroup(this.resourceGroupName())).withGeneralPurposeAccountKind().withSku(sku);
        this.addCreatableDependency(this.storageAccountCreatable);
        return this;
    }

    @Override
    public FunctionAppImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.storageAccountToSet = storageAccount;
        return this;
    }

    @Override
    public FunctionAppImpl withDailyUsageQuota(int quota) {
        ((SiteInner)((Object)this.inner())).withDailyMemoryTimeQuota(quota);
        return this;
    }

    @Override
    public FunctionAppImpl withoutDailyUsageQuota() {
        return this.withDailyUsageQuota(0);
    }

    @Override
    public StorageAccount storageAccount() {
        return this.currentStorageAccount;
    }

    @Override
    public String getMasterKey() {
        return (String)this.getMasterKeyAsync().toBlocking().single();
    }

    @Override
    public Observable<String> getMasterKeyAsync() {
        return this.functionAppKeyService.getMasterKey(this.resourceGroupName(), this.name(), ((AppServiceManager)this.manager()).subscriptionId(), "2016-08-01", ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).userAgent()).map((Func1)new Func1<Map<String, String>, String>(){

            public String call(Map<String, String> stringStringMap) {
                return stringStringMap.get("masterKey");
            }
        });
    }

    @Override
    public void syncTriggers() {
        this.syncTriggersAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable syncTriggersAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().syncFunctionTriggersAsync(this.resourceGroupName(), this.name()).toCompletable().onErrorResumeNext((Func1)new Func1<Throwable, Completable>(){

            public Completable call(Throwable throwable) {
                if (throwable instanceof CloudException && ((CloudException)throwable).response().code() == 200) {
                    return Completable.complete();
                }
                return Completable.error((Throwable)throwable);
            }
        });
    }

    public Observable<Indexable> createAsync() {
        if (((SiteInner)((Object)this.inner())).serverFarmId() == null) {
            this.withNewConsumptionPlan();
        }
        if (this.currentStorageAccount == null && this.storageAccountToSet == null && this.storageAccountCreatable == null) {
            this.withNewStorageAccount(SdkContext.randomResourceName((String)this.name(), (int)20), SkuName.STANDARD_GRS);
        }
        return super.createAsync();
    }

    private static interface FunctionAppKeyService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/masterkey")
        public Observable<Map<String, String>> getMasterKey(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="User-Agent") String var5);
    }
}

