/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.DeploymentSlots;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.implementation.AppServiceBaseImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.DeploymentSlotsImpl;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class WebAppImpl
extends AppServiceBaseImpl<WebApp, WebAppImpl, WebApp.DefinitionStages.WithCreate, WebApp.Update>
implements WebApp,
WebApp.Definition,
WebApp.DefinitionStages.ExistingWindowsPlanWithGroup,
WebApp.DefinitionStages.ExistingLinuxPlanWithGroup,
WebApp.Update,
WebApp.UpdateStages.WithCredentials,
WebApp.UpdateStages.WithStartUpCommand {
    private static final String SETTING_DOCKER_IMAGE = "DOCKER_CUSTOM_IMAGE_NAME";
    private static final String SETTING_REGISTRY_SERVER = "DOCKER_REGISTRY_SERVER_URL";
    private static final String SETTING_REGISTRY_USERNAME = "DOCKER_REGISTRY_SERVER_USERNAME";
    private static final String SETTING_REGISTRY_PASSWORD = "DOCKER_REGISTRY_SERVER_PASSWORD";
    private DeploymentSlots deploymentSlots;

    WebAppImpl(String name, SiteInner innerObject, SiteConfigResourceInner configObject, AppServiceManager manager) {
        super(name, innerObject, configObject, manager);
    }

    @Override
    public DeploymentSlots deploymentSlots() {
        if (this.deploymentSlots == null) {
            this.deploymentSlots = new DeploymentSlotsImpl(this);
        }
        return this.deploymentSlots;
    }

    @Override
    public WebAppImpl withBuiltInImage(RuntimeStack runtimeStack) {
        this.ensureLinuxPlan();
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withLinuxFxVersion(String.format("%s|%s", runtimeStack.stack(), runtimeStack.version()));
        if (runtimeStack.stack().equals("NODE")) {
            this.siteConfig.withNodeVersion(runtimeStack.version());
        }
        if (runtimeStack.stack().equals("PHP")) {
            this.siteConfig.withPhpVersion(runtimeStack.version());
        }
        if (runtimeStack.stack().equals("DOTNETCORE")) {
            this.siteConfig.withNetFrameworkVersion(runtimeStack.version());
        }
        return this;
    }

    @Override
    public WebAppImpl withPublicDockerHubImage(String imageAndTag) {
        this.ensureLinuxPlan();
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withLinuxFxVersion(String.format("DOCKER|%s", imageAndTag));
        this.withAppSetting(SETTING_DOCKER_IMAGE, imageAndTag);
        return this;
    }

    @Override
    public WebAppImpl withPrivateDockerHubImage(String imageAndTag) {
        return this.withPublicDockerHubImage(imageAndTag);
    }

    @Override
    public WebAppImpl withPrivateRegistryImage(String imageAndTag, String serverUrl) {
        this.ensureLinuxPlan();
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withLinuxFxVersion(String.format("DOCKER|%s", imageAndTag));
        this.withAppSetting(SETTING_DOCKER_IMAGE, imageAndTag);
        this.withAppSetting(SETTING_REGISTRY_SERVER, serverUrl);
        return this;
    }

    @Override
    public WebAppImpl withCredentials(String username, String password) {
        this.withAppSetting(SETTING_REGISTRY_USERNAME, username);
        this.withAppSetting(SETTING_REGISTRY_PASSWORD, password);
        return this;
    }

    private void ensureLinuxPlan() {
        if (OperatingSystem.WINDOWS.equals((Object)this.operatingSystem())) {
            throw new IllegalArgumentException("Docker container settings only apply to Linux app service plans.");
        }
    }

    private void cleanUpContainerSettings() {
        if (this.siteConfig != null && this.siteConfig.linuxFxVersion() != null) {
            this.siteConfig.withLinuxFxVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.phpVersion() != null) {
            this.siteConfig.withPhpVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.nodeVersion() != null) {
            this.siteConfig.withNodeVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.netFrameworkVersion() != null) {
            this.siteConfig.withNetFrameworkVersion("v4.0");
        }
        this.withoutAppSetting(SETTING_DOCKER_IMAGE);
        this.withoutAppSetting(SETTING_REGISTRY_SERVER);
        this.withoutAppSetting(SETTING_REGISTRY_USERNAME);
        this.withoutAppSetting(SETTING_REGISTRY_PASSWORD);
    }

    @Override
    public WebAppImpl withStartUpCommand(String startUpCommand) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withAppCommandLine(startUpCommand);
        return this;
    }

    @Override
    public WebAppImpl withExistingWindowsPlan(AppServicePlan appServicePlan) {
        return (WebAppImpl)super.withExistingAppServicePlan(appServicePlan);
    }

    @Override
    public WebAppImpl withExistingLinuxPlan(AppServicePlan appServicePlan) {
        return (WebAppImpl)super.withExistingAppServicePlan(appServicePlan);
    }

    @Override
    public WebAppImpl withNewWindowsPlan(PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(OperatingSystem.WINDOWS, pricingTier);
    }

    @Override
    public WebAppImpl withNewWindowsPlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanCreatable);
    }

    @Override
    public WebAppImpl withNewLinuxPlan(PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public WebAppImpl withNewLinuxPlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanCreatable);
    }
}

