/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.microsoft.azure.Page;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.HostNameBinding;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.WebAppSourceControl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.AppServicePlanImpl;
import com.microsoft.azure.management.appservice.implementation.AppServicePlanInner;
import com.microsoft.azure.management.appservice.implementation.ConnectionStringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.CsmSlotEntityInner;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingImpl;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingInner;
import com.microsoft.azure.management.appservice.implementation.IdentifierInner;
import com.microsoft.azure.management.appservice.implementation.PublishingProfileImpl;
import com.microsoft.azure.management.appservice.implementation.SiteAuthSettingsInner;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteSourceControlInner;
import com.microsoft.azure.management.appservice.implementation.SlotConfigNamesResourceInner;
import com.microsoft.azure.management.appservice.implementation.StringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppSourceControlImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
abstract class AppServiceBaseImpl<FluentT extends WebAppBase, FluentImplT extends AppServiceBaseImpl<FluentT, FluentImplT, FluentWithCreateT, FluentUpdateT>, FluentWithCreateT, FluentUpdateT>
extends WebAppBaseImpl<FluentT, FluentImplT> {
    AppServiceBaseImpl(String name, SiteInner innerObject, SiteConfigResourceInner configObject, AppServiceManager manager) {
        super(name, innerObject, configObject, manager);
    }

    @Override
    Observable<SiteInner> createOrUpdateInner(SiteInner site) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateAsync(this.resourceGroupName(), this.name(), site);
    }

    @Override
    Observable<SiteInner> getInner() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Observable<SiteConfigResourceInner> getConfigInner() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getConfigurationAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Observable<SiteConfigResourceInner> createOrUpdateSiteConfig(SiteConfigResourceInner siteConfig) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateConfigurationAsync(this.resourceGroupName(), this.name(), siteConfig);
    }

    @Override
    Observable<Void> deleteHostNameBinding(String hostname) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().deleteHostNameBindingAsync(this.resourceGroupName(), this.name(), hostname);
    }

    @Override
    Observable<StringDictionaryInner> listAppSettings() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listApplicationSettingsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Observable<StringDictionaryInner> updateAppSettings(StringDictionaryInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateApplicationSettingsAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Observable<ConnectionStringDictionaryInner> listConnectionStrings() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listConnectionStringsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Observable<ConnectionStringDictionaryInner> updateConnectionStrings(ConnectionStringDictionaryInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateConnectionStringsAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Observable<SlotConfigNamesResourceInner> listSlotConfigurations() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listSlotConfigurationNamesAsync(this.resourceGroupName(), this.name());
    }

    @Override
    Observable<SlotConfigNamesResourceInner> updateSlotConfigurations(SlotConfigNamesResourceInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateSlotConfigurationNamesAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Observable<SiteSourceControlInner> createOrUpdateSourceControl(SiteSourceControlInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateSourceControlAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Observable<Void> deleteSourceControl() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().deleteSourceControlAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<Object, Void>(){

            public Void call(Object o) {
                return null;
            }
        });
    }

    @Override
    Observable<SiteAuthSettingsInner> updateAuthentication(SiteAuthSettingsInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateAuthSettingsAsync(this.resourceGroupName(), this.name(), inner);
    }

    @Override
    Observable<SiteAuthSettingsInner> getAuthentication() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getAuthSettingsAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Map<String, HostNameBinding> getHostNameBindings() {
        return (Map)this.getHostNameBindingsAsync().toBlocking().single();
    }

    @Override
    public Observable<Map<String, HostNameBinding>> getHostNameBindingsAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listHostNameBindingsAsync(this.resourceGroupName(), this.name()).flatMap((Func1)new Func1<Page<HostNameBindingInner>, Observable<HostNameBindingInner>>(){

            public Observable<HostNameBindingInner> call(Page<HostNameBindingInner> hostNameBindingInnerPage) {
                return Observable.from((Iterable)hostNameBindingInnerPage.items());
            }
        }).map((Func1)new Func1<HostNameBindingInner, HostNameBinding>(){

            public HostNameBinding call(HostNameBindingInner hostNameBindingInner) {
                return new HostNameBindingImpl(hostNameBindingInner, AppServiceBaseImpl.this);
            }
        }).toList().map((Func1)new Func1<List<HostNameBinding>, Map<String, HostNameBinding>>(){

            public Map<String, HostNameBinding> call(List<HostNameBinding> hostNameBindings) {
                return Collections.unmodifiableMap(Maps.uniqueIndex(hostNameBindings, (Function)new Function<HostNameBinding, String>(){

                    public String apply(HostNameBinding input) {
                        return input.name().replace(AppServiceBaseImpl.this.name() + "/", "");
                    }
                }));
            }
        });
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return (PublishingProfile)this.getPublishingProfileAsync().toBlocking().single();
    }

    @Override
    public Observable<PublishingProfile> getPublishingProfileAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listPublishingProfileXmlWithSecretsAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<InputStream, PublishingProfile>(){

            public PublishingProfile call(InputStream stream) {
                try {
                    String xml = CharStreams.toString((Readable)new InputStreamReader(stream));
                    return new PublishingProfileImpl(xml, AppServiceBaseImpl.this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public WebAppSourceControl getSourceControl() {
        return (WebAppSourceControl)this.getSourceControlAsync().toBlocking().single();
    }

    @Override
    public Observable<WebAppSourceControl> getSourceControlAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getSourceControlAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<SiteSourceControlInner, WebAppSourceControl>(){

            public WebAppSourceControl call(SiteSourceControlInner siteSourceControlInner) {
                return new WebAppSourceControlImpl(siteSourceControlInner, AppServiceBaseImpl.this);
            }
        });
    }

    @Override
    public void verifyDomainOwnership(String certificateOrderName, String domainVerificationToken) {
        this.verifyDomainOwnershipAsync(certificateOrderName, domainVerificationToken).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable verifyDomainOwnershipAsync(String certificateOrderName, String domainVerificationToken) {
        IdentifierInner identifierInner = new IdentifierInner().withIdentifierId(domainVerificationToken);
        identifierInner.withLocation("global");
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateDomainOwnershipIdentifierAsync(this.resourceGroupName(), this.name(), certificateOrderName, identifierInner).map((Func1)new Func1<IdentifierInner, Void>(){

            public Void call(IdentifierInner identifierInner) {
                return null;
            }
        }).toCompletable();
    }

    @Override
    public void start() {
        this.startAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable startAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().startAsync(this.resourceGroupName(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return AppServiceBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void stop() {
        this.stopAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable stopAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().stopAsync(this.resourceGroupName(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return AppServiceBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void restart() {
        this.restartAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable restartAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().restartAsync(this.resourceGroupName(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return AppServiceBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void swap(String slotName) {
        this.swapAsync(slotName).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable swapAsync(String slotName) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().swapSlotWithProductionAsync(this.resourceGroupName(), this.name(), new CsmSlotEntityInner().withTargetSlot(slotName)).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return AppServiceBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void applySlotConfigurations(String slotName) {
        this.applySlotConfigurationsAsync(slotName).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable applySlotConfigurationsAsync(String slotName) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().applySlotConfigToProductionAsync(this.resourceGroupName(), this.name(), new CsmSlotEntityInner().withTargetSlot(slotName)).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return AppServiceBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void resetSlotConfigurations() {
        this.resetSlotConfigurationsAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable resetSlotConfigurationsAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().resetProductionSlotConfigAsync(this.resourceGroupName(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return AppServiceBaseImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    private AppServicePlanImpl newDefaultAppServicePlan() {
        String planName = SdkContext.randomResourceName((String)(this.name() + "plan"), (int)32);
        AppServicePlanImpl appServicePlan = (AppServicePlanImpl)((AppServicePlan.DefinitionStages.Blank)((AppServiceManager)this.manager()).appServicePlans().define(planName)).withRegion(this.regionName());
        appServicePlan.withOperatingSystem(this.operatingSystem());
        appServicePlan = this.creatableGroup != null && this.isInCreateMode() ? (AppServicePlanImpl)appServicePlan.withNewResourceGroup(this.creatableGroup) : (AppServicePlanImpl)appServicePlan.withExistingResourceGroup(this.resourceGroupName());
        return appServicePlan;
    }

    public FluentImplT withNewFreeAppServicePlan() {
        return this.withNewAppServicePlan(OperatingSystem.WINDOWS, PricingTier.FREE_F1);
    }

    public FluentImplT withNewSharedAppServicePlan() {
        return this.withNewAppServicePlan(OperatingSystem.WINDOWS, PricingTier.SHARED_D1);
    }

    FluentImplT withNewAppServicePlan(OperatingSystem operatingSystem, PricingTier pricingTier) {
        return this.withNewAppServicePlan(this.newDefaultAppServicePlan().withOperatingSystem(operatingSystem).withPricingTier(pricingTier));
    }

    public FluentImplT withNewAppServicePlan(PricingTier pricingTier) {
        return this.withNewAppServicePlan(this.operatingSystem(), pricingTier);
    }

    public FluentImplT withNewAppServicePlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        this.addCreatableDependency(appServicePlanCreatable);
        String id = ResourceUtils.constructResourceId((String)((AppServiceManager)this.manager()).subscriptionId(), (String)this.resourceGroupName(), (String)"Microsoft.Web", (String)"serverFarms", (String)appServicePlanCreatable.name(), (String)"");
        ((SiteInner)((Object)this.inner())).withServerFarmId(id);
        ((SiteInner)((Object)this.inner())).withReserved(((AppServicePlanInner)((Object)((AppServicePlanImpl)appServicePlanCreatable).inner())).reserved());
        return (FluentImplT)this;
    }

    public FluentImplT withExistingAppServicePlan(AppServicePlan appServicePlan) {
        ((SiteInner)((Object)this.inner())).withServerFarmId(appServicePlan.id());
        ((SiteInner)((Object)this.inner())).withReserved(((AppServicePlanInner)((Object)appServicePlan.inner())).reserved());
        this.withRegion(appServicePlan.regionName());
        return (FluentImplT)this;
    }
}

