/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionApps;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.FunctionAppImpl;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import rx.Completable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class FunctionAppsImpl
extends TopLevelModifiableResourcesImpl<FunctionApp, FunctionAppImpl, SiteInner, WebAppsInner, AppServiceManager>
implements FunctionApps {
    private final PagedListConverter<SiteInner, FunctionApp> converter;

    FunctionAppsImpl(final AppServiceManager manager) {
        super((InnerSupportsListing)((WebSiteManagementClientImpl)((Object)manager.inner())).webApps(), (ManagerBase)manager);
        this.converter = new PagedListConverter<SiteInner, FunctionApp>(){

            public FunctionApp typeConvert(SiteInner siteInner) {
                FunctionAppImpl impl = FunctionAppsImpl.this.wrapModel(siteInner, ((WebSiteManagementClientImpl)((Object)manager.inner())).webApps().getConfiguration(siteInner.resourceGroup(), siteInner.name()));
                return (FunctionApp)impl.cacheSiteProperties().toBlocking().single();
            }

            protected boolean filter(SiteInner inner) {
                return "functionapp".equals(inner.kind());
            }
        };
    }

    public FunctionApp getByResourceGroup(String groupName, String name) {
        SiteInner siteInner = ((WebAppsInner)this.inner()).getByResourceGroup(groupName, name);
        if (siteInner == null) {
            return null;
        }
        return (FunctionApp)this.wrapModel(siteInner, ((WebAppsInner)this.inner()).getConfiguration(groupName, name)).cacheSiteProperties().toBlocking().single();
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsInner)this.inner()).deleteAsync(resourceGroupName, name).toCompletable();
    }

    protected FunctionAppImpl wrapModel(String name) {
        return new FunctionAppImpl(name, new SiteInner(), null, (AppServiceManager)this.manager());
    }

    protected FunctionAppImpl wrapModel(SiteInner inner) {
        return this.wrapModel(inner, null);
    }

    private FunctionAppImpl wrapModel(SiteInner inner, SiteConfigResourceInner configResourceInner) {
        if (inner == null) {
            return null;
        }
        return new FunctionAppImpl(inner.name(), inner, configResourceInner, (AppServiceManager)this.manager());
    }

    protected PagedList<FunctionApp> wrapList(PagedList<SiteInner> pagedList) {
        return this.converter.convert(pagedList);
    }

    public FunctionAppImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByResourceGroupAsync(String groupName, String name) {
        return ((WebAppsInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }
}

