/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Virtual application in an app.
 */
public class VirtualApplication {
    /**
     * Virtual path.
     */
    @JsonProperty(value = "virtualPath")
    private String virtualPath;

    /**
     * Physical path.
     */
    @JsonProperty(value = "physicalPath")
    private String physicalPath;

    /**
     * &lt;code&gt;true&lt;/code&gt; if preloading is enabled; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     */
    @JsonProperty(value = "preloadEnabled")
    private Boolean preloadEnabled;

    /**
     * Virtual directories for virtual application.
     */
    @JsonProperty(value = "virtualDirectories")
    private List<VirtualDirectory> virtualDirectories;

    /**
     * Get virtual path.
     *
     * @return the virtualPath value
     */
    public String virtualPath() {
        return this.virtualPath;
    }

    /**
     * Set virtual path.
     *
     * @param virtualPath the virtualPath value to set
     * @return the VirtualApplication object itself.
     */
    public VirtualApplication withVirtualPath(String virtualPath) {
        this.virtualPath = virtualPath;
        return this;
    }

    /**
     * Get physical path.
     *
     * @return the physicalPath value
     */
    public String physicalPath() {
        return this.physicalPath;
    }

    /**
     * Set physical path.
     *
     * @param physicalPath the physicalPath value to set
     * @return the VirtualApplication object itself.
     */
    public VirtualApplication withPhysicalPath(String physicalPath) {
        this.physicalPath = physicalPath;
        return this;
    }

    /**
     * Get &lt;code&gt;true&lt;/code&gt; if preloading is enabled; otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the preloadEnabled value
     */
    public Boolean preloadEnabled() {
        return this.preloadEnabled;
    }

    /**
     * Set &lt;code&gt;true&lt;/code&gt; if preloading is enabled; otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @param preloadEnabled the preloadEnabled value to set
     * @return the VirtualApplication object itself.
     */
    public VirtualApplication withPreloadEnabled(Boolean preloadEnabled) {
        this.preloadEnabled = preloadEnabled;
        return this;
    }

    /**
     * Get virtual directories for virtual application.
     *
     * @return the virtualDirectories value
     */
    public List<VirtualDirectory> virtualDirectories() {
        return this.virtualDirectories;
    }

    /**
     * Set virtual directories for virtual application.
     *
     * @param virtualDirectories the virtualDirectories value to set
     * @return the VirtualApplication object itself.
     */
    public VirtualApplication withVirtualDirectories(List<VirtualDirectory> virtualDirectories) {
        this.virtualDirectories = virtualDirectories;
        return this;
    }

}
