/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Details about restoring a deleted app.
 */
@JsonFlatten
public class DeletedAppRestoreRequest extends ProxyOnlyResource {
    /**
     * ARM resource ID of the deleted app. Example:
     * /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
     */
    @JsonProperty(value = "properties.deletedSiteId")
    private String deletedSiteId;

    /**
     * If true, deleted site configuration, in addition to content, will be
     * restored.
     */
    @JsonProperty(value = "properties.recoverConfiguration")
    private Boolean recoverConfiguration;

    /**
     * Point in time to restore the deleted app from, formatted as a DateTime
     * string.
     * If unspecified, default value is the time that the app was deleted.
     */
    @JsonProperty(value = "properties.snapshotTime")
    private String snapshotTime;

    /**
     * Get aRM resource ID of the deleted app. Example:
     /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
     *
     * @return the deletedSiteId value
     */
    public String deletedSiteId() {
        return this.deletedSiteId;
    }

    /**
     * Set aRM resource ID of the deleted app. Example:
     /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
     *
     * @param deletedSiteId the deletedSiteId value to set
     * @return the DeletedAppRestoreRequest object itself.
     */
    public DeletedAppRestoreRequest withDeletedSiteId(String deletedSiteId) {
        this.deletedSiteId = deletedSiteId;
        return this;
    }

    /**
     * Get if true, deleted site configuration, in addition to content, will be restored.
     *
     * @return the recoverConfiguration value
     */
    public Boolean recoverConfiguration() {
        return this.recoverConfiguration;
    }

    /**
     * Set if true, deleted site configuration, in addition to content, will be restored.
     *
     * @param recoverConfiguration the recoverConfiguration value to set
     * @return the DeletedAppRestoreRequest object itself.
     */
    public DeletedAppRestoreRequest withRecoverConfiguration(Boolean recoverConfiguration) {
        this.recoverConfiguration = recoverConfiguration;
        return this;
    }

    /**
     * Get point in time to restore the deleted app from, formatted as a DateTime string.
     If unspecified, default value is the time that the app was deleted.
     *
     * @return the snapshotTime value
     */
    public String snapshotTime() {
        return this.snapshotTime;
    }

    /**
     * Set point in time to restore the deleted app from, formatted as a DateTime string.
     If unspecified, default value is the time that the app was deleted.
     *
     * @param snapshotTime the snapshotTime value to set
     * @return the DeletedAppRestoreRequest object itself.
     */
    public DeletedAppRestoreRequest withSnapshotTime(String snapshotTime) {
        this.snapshotTime = snapshotTime;
        return this;
    }

}
