/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.appservice.AppServiceEnvironmentPatchResource;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.VirtualNetworkProfile;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in AppServiceEnvironments.
 */
public class AppServiceEnvironmentsInner implements InnerSupportsGet<AppServiceEnvironmentResourceInner>, InnerSupportsDelete<Void>, InnerSupportsListing<AppServiceEnvironmentResourceInner> {
    /** The Retrofit service to perform REST calls. */
    private AppServiceEnvironmentsService service;
    /** The service client containing this operation class. */
    private WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of AppServiceEnvironmentsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public AppServiceEnvironmentsInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = retrofit.create(AppServiceEnvironmentsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for AppServiceEnvironments to be
     * used by Retrofit to perform actually REST calls.
     */
    interface AppServiceEnvironmentsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/hostingEnvironments")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("forceDelete") Boolean forceDelete, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("forceDelete") Boolean forceDelete, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body AppServiceEnvironmentPatchResource hostingEnvironmentEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listCapacities" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute")
        Observable<Response<ResponseBody>> listCapacities(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listVips" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip")
        Observable<Response<ResponseBody>> listVips(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments changeVnet" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/changeVirtualNetwork")
        Observable<Response<ResponseBody>> changeVnet(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body VirtualNetworkProfile vnetInfo, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginChangeVnet" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/changeVirtualNetwork")
        Observable<Response<ResponseBody>> beginChangeVnet(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body VirtualNetworkProfile vnetInfo, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listDiagnostics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics")
        Observable<Response<ResponseBody>> listDiagnostics(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments getDiagnosticsItem" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}")
        Observable<Response<ResponseBody>> getDiagnosticsItem(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("diagnosticsName") String diagnosticsName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMetricDefinitions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metricdefinitions")
        Observable<Response<ResponseBody>> listMetricDefinitions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metrics")
        Observable<Response<ResponseBody>> listMetrics(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("details") Boolean details, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRolePools" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools")
        Observable<Response<ResponseBody>> listMultiRolePools(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments getMultiRolePool" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default")
        Observable<Response<ResponseBody>> getMultiRolePool(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments createOrUpdateMultiRolePool" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default")
        Observable<Response<ResponseBody>> createOrUpdateMultiRolePool(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body WorkerPoolResourceInner multiRolePoolEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginCreateOrUpdateMultiRolePool" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default")
        Observable<Response<ResponseBody>> beginCreateOrUpdateMultiRolePool(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body WorkerPoolResourceInner multiRolePoolEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments updateMultiRolePool" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default")
        Observable<Response<ResponseBody>> updateMultiRolePool(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body WorkerPoolResourceInner multiRolePoolEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRolePoolInstanceMetricDefinitions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions")
        Observable<Response<ResponseBody>> listMultiRolePoolInstanceMetricDefinitions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("instance") String instance, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRolePoolInstanceMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metrics")
        Observable<Response<ResponseBody>> listMultiRolePoolInstanceMetrics(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("instance") String instance, @Path("subscriptionId") String subscriptionId, @Query("details") Boolean details, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRoleMetricDefinitions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions")
        Observable<Response<ResponseBody>> listMultiRoleMetricDefinitions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRoleMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metrics")
        Observable<Response<ResponseBody>> listMultiRoleMetrics(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("startTime") String startTime, @Query("endTime") String endTime, @Query("timeGrain") String timeGrain, @Query("details") Boolean details, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRolePoolSkus" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus")
        Observable<Response<ResponseBody>> listMultiRolePoolSkus(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRoleUsages" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages")
        Observable<Response<ResponseBody>> listMultiRoleUsages(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listOperations" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations")
        Observable<Response<ResponseBody>> listOperations(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments reboot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot")
        Observable<Response<ResponseBody>> reboot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments resume" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume")
        Observable<Response<ResponseBody>> resume(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginResume" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume")
        Observable<Response<ResponseBody>> beginResume(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listAppServicePlans" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms")
        Observable<Response<ResponseBody>> listAppServicePlans(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWebApps" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites")
        Observable<Response<ResponseBody>> listWebApps(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("propertiesToInclude") String propertiesToInclude, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments suspend" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend")
        Observable<Response<ResponseBody>> suspend(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginSuspend" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend")
        Observable<Response<ResponseBody>> beginSuspend(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments syncVirtualNetworkInfo" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/syncVirtualNetwork")
        Observable<Response<ResponseBody>> syncVirtualNetworkInfo(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listUsages" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages")
        Observable<Response<ResponseBody>> listUsages(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWorkerPools" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools")
        Observable<Response<ResponseBody>> listWorkerPools(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments getWorkerPool" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}")
        Observable<Response<ResponseBody>> getWorkerPool(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments createOrUpdateWorkerPool" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}")
        Observable<Response<ResponseBody>> createOrUpdateWorkerPool(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("subscriptionId") String subscriptionId, @Body WorkerPoolResourceInner workerPoolEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginCreateOrUpdateWorkerPool" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdateWorkerPool(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("subscriptionId") String subscriptionId, @Body WorkerPoolResourceInner workerPoolEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments updateWorkerPool" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}")
        Observable<Response<ResponseBody>> updateWorkerPool(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("subscriptionId") String subscriptionId, @Body WorkerPoolResourceInner workerPoolEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWorkerPoolInstanceMetricDefinitions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions")
        Observable<Response<ResponseBody>> listWorkerPoolInstanceMetricDefinitions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("instance") String instance, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWorkerPoolInstanceMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metrics")
        Observable<Response<ResponseBody>> listWorkerPoolInstanceMetrics(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("instance") String instance, @Path("subscriptionId") String subscriptionId, @Query("details") Boolean details, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWebWorkerMetricDefinitions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions")
        Observable<Response<ResponseBody>> listWebWorkerMetricDefinitions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWebWorkerMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metrics")
        Observable<Response<ResponseBody>> listWebWorkerMetrics(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("subscriptionId") String subscriptionId, @Query("details") Boolean details, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWorkerPoolSkus" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus")
        Observable<Response<ResponseBody>> listWorkerPoolSkus(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWebWorkerUsages" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages")
        Observable<Response<ResponseBody>> listWebWorkerUsages(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("workerPoolName") String workerPoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listCapacitiesNext" })
        @GET
        Observable<Response<ResponseBody>> listCapacitiesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments changeVnetNext" })
        @GET
        Observable<Response<ResponseBody>> changeVnetNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginChangeVnetNext" })
        @GET
        Observable<Response<ResponseBody>> beginChangeVnetNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMetricsNext" })
        @GET
        Observable<Response<ResponseBody>> listMetricsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRolePoolsNext" })
        @GET
        Observable<Response<ResponseBody>> listMultiRolePoolsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRolePoolInstanceMetricDefinitionsNext" })
        @GET
        Observable<Response<ResponseBody>> listMultiRolePoolInstanceMetricDefinitionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRolePoolInstanceMetricsNext" })
        @GET
        Observable<Response<ResponseBody>> listMultiRolePoolInstanceMetricsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRoleMetricDefinitionsNext" })
        @GET
        Observable<Response<ResponseBody>> listMultiRoleMetricDefinitionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRoleMetricsNext" })
        @GET
        Observable<Response<ResponseBody>> listMultiRoleMetricsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRolePoolSkusNext" })
        @GET
        Observable<Response<ResponseBody>> listMultiRolePoolSkusNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listMultiRoleUsagesNext" })
        @GET
        Observable<Response<ResponseBody>> listMultiRoleUsagesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments resumeNext" })
        @GET
        Observable<Response<ResponseBody>> resumeNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginResumeNext" })
        @GET
        Observable<Response<ResponseBody>> beginResumeNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listAppServicePlansNext" })
        @GET
        Observable<Response<ResponseBody>> listAppServicePlansNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWebAppsNext" })
        @GET
        Observable<Response<ResponseBody>> listWebAppsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments suspendNext" })
        @GET
        Observable<Response<ResponseBody>> suspendNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments beginSuspendNext" })
        @GET
        Observable<Response<ResponseBody>> beginSuspendNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listUsagesNext" })
        @GET
        Observable<Response<ResponseBody>> listUsagesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWorkerPoolsNext" })
        @GET
        Observable<Response<ResponseBody>> listWorkerPoolsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWorkerPoolInstanceMetricDefinitionsNext" })
        @GET
        Observable<Response<ResponseBody>> listWorkerPoolInstanceMetricDefinitionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWorkerPoolInstanceMetricsNext" })
        @GET
        Observable<Response<ResponseBody>> listWorkerPoolInstanceMetricsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWebWorkerMetricDefinitionsNext" })
        @GET
        Observable<Response<ResponseBody>> listWebWorkerMetricDefinitionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWebWorkerMetricsNext" })
        @GET
        Observable<Response<ResponseBody>> listWebWorkerMetricsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWorkerPoolSkusNext" })
        @GET
        Observable<Response<ResponseBody>> listWorkerPoolSkusNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceEnvironments listWebWorkerUsagesNext" })
        @GET
        Observable<Response<ResponseBody>> listWebWorkerUsagesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object if successful.
     */
    public PagedList<AppServiceEnvironmentResourceInner> list() {
        ServiceResponse<Page<AppServiceEnvironmentResourceInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<AppServiceEnvironmentResourceInner>(response.body()) {
            @Override
            public Page<AppServiceEnvironmentResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceEnvironmentResourceInner>> listAsync(final ListOperationCallback<AppServiceEnvironmentResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object
     */
    public Observable<Page<AppServiceEnvironmentResourceInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>, Page<AppServiceEnvironmentResourceInner>>() {
                @Override
                public Page<AppServiceEnvironmentResourceInner> call(ServiceResponse<Page<AppServiceEnvironmentResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(ServiceResponse<Page<AppServiceEnvironmentResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceEnvironmentResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceEnvironmentResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceEnvironmentResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object if successful.
     */
    public PagedList<AppServiceEnvironmentResourceInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<AppServiceEnvironmentResourceInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<AppServiceEnvironmentResourceInner>(response.body()) {
            @Override
            public Page<AppServiceEnvironmentResourceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceEnvironmentResourceInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<AppServiceEnvironmentResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object
     */
    public Observable<Page<AppServiceEnvironmentResourceInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>, Page<AppServiceEnvironmentResourceInner>>() {
                @Override
                public Page<AppServiceEnvironmentResourceInner> call(ServiceResponse<Page<AppServiceEnvironmentResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(ServiceResponse<Page<AppServiceEnvironmentResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
    ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceEnvironmentResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceEnvironmentResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceEnvironmentResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get the properties of an App Service Environment.
     * Get the properties of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceEnvironmentResourceInner object if successful.
     */
    public AppServiceEnvironmentResourceInner getByResourceGroup(String resourceGroupName, String name) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Get the properties of an App Service Environment.
     * Get the properties of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceEnvironmentResourceInner> getByResourceGroupAsync(String resourceGroupName, String name, final ServiceCallback<AppServiceEnvironmentResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Get the properties of an App Service Environment.
     * Get the properties of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceEnvironmentResourceInner object
     */
    public Observable<AppServiceEnvironmentResourceInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<AppServiceEnvironmentResourceInner>, AppServiceEnvironmentResourceInner>() {
            @Override
            public AppServiceEnvironmentResourceInner call(ServiceResponse<AppServiceEnvironmentResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the properties of an App Service Environment.
     * Get the properties of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceEnvironmentResourceInner object
     */
    public Observable<ServiceResponse<AppServiceEnvironmentResourceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceEnvironmentResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceEnvironmentResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceEnvironmentResourceInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceEnvironmentResourceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceEnvironmentResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceEnvironmentResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceEnvironmentResourceInner object if successful.
     */
    public AppServiceEnvironmentResourceInner createOrUpdate(String resourceGroupName, String name, AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope).toBlocking().last().body();
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceEnvironmentResourceInner> createOrUpdateAsync(String resourceGroupName, String name, AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope, final ServiceCallback<AppServiceEnvironmentResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope), serviceCallback);
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AppServiceEnvironmentResourceInner> createOrUpdateAsync(String resourceGroupName, String name, AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope).map(new Func1<ServiceResponse<AppServiceEnvironmentResourceInner>, AppServiceEnvironmentResourceInner>() {
            @Override
            public AppServiceEnvironmentResourceInner call(ServiceResponse<AppServiceEnvironmentResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AppServiceEnvironmentResourceInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String name, AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (hostingEnvironmentEnvelope == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(hostingEnvironmentEnvelope);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, name, this.client.subscriptionId(), hostingEnvironmentEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AppServiceEnvironmentResourceInner>() { }.getType());
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceEnvironmentResourceInner object if successful.
     */
    public AppServiceEnvironmentResourceInner beginCreateOrUpdate(String resourceGroupName, String name, AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope).toBlocking().single().body();
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceEnvironmentResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String name, AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope, final ServiceCallback<AppServiceEnvironmentResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope), serviceCallback);
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceEnvironmentResourceInner object
     */
    public Observable<AppServiceEnvironmentResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String name, AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope).map(new Func1<ServiceResponse<AppServiceEnvironmentResourceInner>, AppServiceEnvironmentResourceInner>() {
            @Override
            public AppServiceEnvironmentResourceInner call(ServiceResponse<AppServiceEnvironmentResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceEnvironmentResourceInner object
     */
    public Observable<ServiceResponse<AppServiceEnvironmentResourceInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String name, AppServiceEnvironmentResourceInner hostingEnvironmentEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (hostingEnvironmentEnvelope == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(hostingEnvironmentEnvelope);
        return service.beginCreateOrUpdate(resourceGroupName, name, this.client.subscriptionId(), hostingEnvironmentEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceEnvironmentResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceEnvironmentResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceEnvironmentResourceInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceEnvironmentResourceInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceEnvironmentResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceEnvironmentResourceInner>() { }.getType())
                .register(202, new TypeToken<AppServiceEnvironmentResourceInner>() { }.getType())
                .register(400, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String name) {
        deleteWithServiceResponseAsync(resourceGroupName, name).toBlocking().last().body();
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String name) {
        return deleteWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean forceDelete = null;
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, name, this.client.subscriptionId(), forceDelete, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }
    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param forceDelete Specify &lt;code&gt;true&lt;/code&gt; to force the deletion even if the App Service Environment contains resources. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String name, Boolean forceDelete) {
        deleteWithServiceResponseAsync(resourceGroupName, name, forceDelete).toBlocking().last().body();
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param forceDelete Specify &lt;code&gt;true&lt;/code&gt; to force the deletion even if the App Service Environment contains resources. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String name, Boolean forceDelete, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, name, forceDelete), serviceCallback);
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param forceDelete Specify &lt;code&gt;true&lt;/code&gt; to force the deletion even if the App Service Environment contains resources. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String name, Boolean forceDelete) {
        return deleteWithServiceResponseAsync(resourceGroupName, name, forceDelete).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param forceDelete Specify &lt;code&gt;true&lt;/code&gt; to force the deletion even if the App Service Environment contains resources. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String name, Boolean forceDelete) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, name, this.client.subscriptionId(), forceDelete, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String name) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String name) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean forceDelete = null;
        return service.beginDelete(resourceGroupName, name, this.client.subscriptionId(), forceDelete, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param forceDelete Specify &lt;code&gt;true&lt;/code&gt; to force the deletion even if the App Service Environment contains resources. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String name, Boolean forceDelete) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, name, forceDelete).toBlocking().single().body();
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param forceDelete Specify &lt;code&gt;true&lt;/code&gt; to force the deletion even if the App Service Environment contains resources. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String name, Boolean forceDelete, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, name, forceDelete), serviceCallback);
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param forceDelete Specify &lt;code&gt;true&lt;/code&gt; to force the deletion even if the App Service Environment contains resources. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String name, Boolean forceDelete) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, name, forceDelete).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete an App Service Environment.
     * Delete an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param forceDelete Specify &lt;code&gt;true&lt;/code&gt; to force the deletion even if the App Service Environment contains resources. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String name, Boolean forceDelete) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, name, this.client.subscriptionId(), forceDelete, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(400, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceEnvironmentResourceInner object if successful.
     */
    public AppServiceEnvironmentResourceInner update(String resourceGroupName, String name, AppServiceEnvironmentPatchResource hostingEnvironmentEnvelope) {
        return updateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope).toBlocking().single().body();
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceEnvironmentResourceInner> updateAsync(String resourceGroupName, String name, AppServiceEnvironmentPatchResource hostingEnvironmentEnvelope, final ServiceCallback<AppServiceEnvironmentResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope), serviceCallback);
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceEnvironmentResourceInner object
     */
    public Observable<AppServiceEnvironmentResourceInner> updateAsync(String resourceGroupName, String name, AppServiceEnvironmentPatchResource hostingEnvironmentEnvelope) {
        return updateWithServiceResponseAsync(resourceGroupName, name, hostingEnvironmentEnvelope).map(new Func1<ServiceResponse<AppServiceEnvironmentResourceInner>, AppServiceEnvironmentResourceInner>() {
            @Override
            public AppServiceEnvironmentResourceInner call(ServiceResponse<AppServiceEnvironmentResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update an App Service Environment.
     * Create or update an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param hostingEnvironmentEnvelope Configuration details of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceEnvironmentResourceInner object
     */
    public Observable<ServiceResponse<AppServiceEnvironmentResourceInner>> updateWithServiceResponseAsync(String resourceGroupName, String name, AppServiceEnvironmentPatchResource hostingEnvironmentEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (hostingEnvironmentEnvelope == null) {
            throw new IllegalArgumentException("Parameter hostingEnvironmentEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(hostingEnvironmentEnvelope);
        return service.update(resourceGroupName, name, this.client.subscriptionId(), hostingEnvironmentEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceEnvironmentResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceEnvironmentResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceEnvironmentResourceInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceEnvironmentResourceInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceEnvironmentResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceEnvironmentResourceInner>() { }.getType())
                .register(202, new TypeToken<AppServiceEnvironmentResourceInner>() { }.getType())
                .register(400, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;StampCapacityInner&gt; object if successful.
     */
    public PagedList<StampCapacityInner> listCapacities(final String resourceGroupName, final String name) {
        ServiceResponse<Page<StampCapacityInner>> response = listCapacitiesSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<StampCapacityInner>(response.body()) {
            @Override
            public Page<StampCapacityInner> nextPage(String nextPageLink) {
                return listCapacitiesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<StampCapacityInner>> listCapacitiesAsync(final String resourceGroupName, final String name, final ListOperationCallback<StampCapacityInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listCapacitiesSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<StampCapacityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<StampCapacityInner>>> call(String nextPageLink) {
                    return listCapacitiesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StampCapacityInner&gt; object
     */
    public Observable<Page<StampCapacityInner>> listCapacitiesAsync(final String resourceGroupName, final String name) {
        return listCapacitiesWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<StampCapacityInner>>, Page<StampCapacityInner>>() {
                @Override
                public Page<StampCapacityInner> call(ServiceResponse<Page<StampCapacityInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StampCapacityInner&gt; object
     */
    public Observable<ServiceResponse<Page<StampCapacityInner>>> listCapacitiesWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listCapacitiesSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<StampCapacityInner>>, Observable<ServiceResponse<Page<StampCapacityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<StampCapacityInner>>> call(ServiceResponse<Page<StampCapacityInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listCapacitiesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
    ServiceResponse<PageImpl<StampCapacityInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<StampCapacityInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;StampCapacityInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<StampCapacityInner>>> listCapacitiesSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listCapacities(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StampCapacityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<StampCapacityInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<StampCapacityInner>> result = listCapacitiesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<StampCapacityInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<StampCapacityInner>> listCapacitiesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<StampCapacityInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<StampCapacityInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get IP addresses assigned to an App Service Environment.
     * Get IP addresses assigned to an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AddressResponseInner object if successful.
     */
    public AddressResponseInner listVips(String resourceGroupName, String name) {
        return listVipsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Get IP addresses assigned to an App Service Environment.
     * Get IP addresses assigned to an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AddressResponseInner> listVipsAsync(String resourceGroupName, String name, final ServiceCallback<AddressResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(listVipsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Get IP addresses assigned to an App Service Environment.
     * Get IP addresses assigned to an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AddressResponseInner object
     */
    public Observable<AddressResponseInner> listVipsAsync(String resourceGroupName, String name) {
        return listVipsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<AddressResponseInner>, AddressResponseInner>() {
            @Override
            public AddressResponseInner call(ServiceResponse<AddressResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get IP addresses assigned to an App Service Environment.
     * Get IP addresses assigned to an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AddressResponseInner object
     */
    public Observable<ServiceResponse<AddressResponseInner>> listVipsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listVips(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AddressResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<AddressResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AddressResponseInner> clientResponse = listVipsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AddressResponseInner> listVipsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AddressResponseInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AddressResponseInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param vnetInfo Details for the new virtual network.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> changeVnet(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo) {
        ServiceResponse<Page<SiteInner>> response = changeVnetSinglePageAsync(resourceGroupName, name, vnetInfo).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return changeVnetNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param vnetInfo Details for the new virtual network.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> changeVnetAsync(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            changeVnetSinglePageAsync(resourceGroupName, name, vnetInfo),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return changeVnetNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param vnetInfo Details for the new virtual network.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> changeVnetAsync(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo) {
        return changeVnetWithServiceResponseAsync(resourceGroupName, name, vnetInfo)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param vnetInfo Details for the new virtual network.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> changeVnetWithServiceResponseAsync(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo) {
        return changeVnetSinglePageAsync(resourceGroupName, name, vnetInfo)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(changeVnetNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<SiteInner>> * @param vnetInfo Details for the new virtual network.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> changeVnetSinglePageAsync(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (vnetInfo == null) {
            throw new IllegalArgumentException("Parameter vnetInfo is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(vnetInfo);
        return service.changeVnet(resourceGroupName, name, this.client.subscriptionId(), vnetInfo, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = changeVnetDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> changeVnetDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException, InterruptedException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param vnetInfo Details for the new virtual network.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> beginChangeVnet(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo) {
        ServiceResponse<Page<SiteInner>> response = beginChangeVnetSinglePageAsync(resourceGroupName, name, vnetInfo).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return beginChangeVnetNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param vnetInfo Details for the new virtual network.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> beginChangeVnetAsync(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginChangeVnetSinglePageAsync(resourceGroupName, name, vnetInfo),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return beginChangeVnetNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param vnetInfo Details for the new virtual network.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> beginChangeVnetAsync(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo) {
        return beginChangeVnetWithServiceResponseAsync(resourceGroupName, name, vnetInfo)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param vnetInfo Details for the new virtual network.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginChangeVnetWithServiceResponseAsync(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo) {
        return beginChangeVnetSinglePageAsync(resourceGroupName, name, vnetInfo)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginChangeVnetNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<SiteInner>> * @param vnetInfo Details for the new virtual network.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginChangeVnetSinglePageAsync(final String resourceGroupName, final String name, final VirtualNetworkProfile vnetInfo) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (vnetInfo == null) {
            throw new IllegalArgumentException("Parameter vnetInfo is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(vnetInfo);
        return service.beginChangeVnet(resourceGroupName, name, this.client.subscriptionId(), vnetInfo, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = beginChangeVnetDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> beginChangeVnetDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get diagnostic information for an App Service Environment.
     * Get diagnostic information for an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;HostingEnvironmentDiagnosticsInner&gt; object if successful.
     */
    public List<HostingEnvironmentDiagnosticsInner> listDiagnostics(String resourceGroupName, String name) {
        return listDiagnosticsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Get diagnostic information for an App Service Environment.
     * Get diagnostic information for an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<HostingEnvironmentDiagnosticsInner>> listDiagnosticsAsync(String resourceGroupName, String name, final ServiceCallback<List<HostingEnvironmentDiagnosticsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listDiagnosticsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Get diagnostic information for an App Service Environment.
     * Get diagnostic information for an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;HostingEnvironmentDiagnosticsInner&gt; object
     */
    public Observable<List<HostingEnvironmentDiagnosticsInner>> listDiagnosticsAsync(String resourceGroupName, String name) {
        return listDiagnosticsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<List<HostingEnvironmentDiagnosticsInner>>, List<HostingEnvironmentDiagnosticsInner>>() {
            @Override
            public List<HostingEnvironmentDiagnosticsInner> call(ServiceResponse<List<HostingEnvironmentDiagnosticsInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Get diagnostic information for an App Service Environment.
     * Get diagnostic information for an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;HostingEnvironmentDiagnosticsInner&gt; object
     */
    public Observable<ServiceResponse<List<HostingEnvironmentDiagnosticsInner>>> listDiagnosticsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listDiagnostics(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<HostingEnvironmentDiagnosticsInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<HostingEnvironmentDiagnosticsInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<List<HostingEnvironmentDiagnosticsInner>> clientResponse = listDiagnosticsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<List<HostingEnvironmentDiagnosticsInner>> listDiagnosticsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<List<HostingEnvironmentDiagnosticsInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<List<HostingEnvironmentDiagnosticsInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get a diagnostics item for an App Service Environment.
     * Get a diagnostics item for an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param diagnosticsName Name of the diagnostics item.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the HostingEnvironmentDiagnosticsInner object if successful.
     */
    public HostingEnvironmentDiagnosticsInner getDiagnosticsItem(String resourceGroupName, String name, String diagnosticsName) {
        return getDiagnosticsItemWithServiceResponseAsync(resourceGroupName, name, diagnosticsName).toBlocking().single().body();
    }

    /**
     * Get a diagnostics item for an App Service Environment.
     * Get a diagnostics item for an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param diagnosticsName Name of the diagnostics item.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<HostingEnvironmentDiagnosticsInner> getDiagnosticsItemAsync(String resourceGroupName, String name, String diagnosticsName, final ServiceCallback<HostingEnvironmentDiagnosticsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getDiagnosticsItemWithServiceResponseAsync(resourceGroupName, name, diagnosticsName), serviceCallback);
    }

    /**
     * Get a diagnostics item for an App Service Environment.
     * Get a diagnostics item for an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param diagnosticsName Name of the diagnostics item.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HostingEnvironmentDiagnosticsInner object
     */
    public Observable<HostingEnvironmentDiagnosticsInner> getDiagnosticsItemAsync(String resourceGroupName, String name, String diagnosticsName) {
        return getDiagnosticsItemWithServiceResponseAsync(resourceGroupName, name, diagnosticsName).map(new Func1<ServiceResponse<HostingEnvironmentDiagnosticsInner>, HostingEnvironmentDiagnosticsInner>() {
            @Override
            public HostingEnvironmentDiagnosticsInner call(ServiceResponse<HostingEnvironmentDiagnosticsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get a diagnostics item for an App Service Environment.
     * Get a diagnostics item for an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param diagnosticsName Name of the diagnostics item.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HostingEnvironmentDiagnosticsInner object
     */
    public Observable<ServiceResponse<HostingEnvironmentDiagnosticsInner>> getDiagnosticsItemWithServiceResponseAsync(String resourceGroupName, String name, String diagnosticsName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (diagnosticsName == null) {
            throw new IllegalArgumentException("Parameter diagnosticsName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getDiagnosticsItem(resourceGroupName, name, diagnosticsName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<HostingEnvironmentDiagnosticsInner>>>() {
                @Override
                public Observable<ServiceResponse<HostingEnvironmentDiagnosticsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<HostingEnvironmentDiagnosticsInner> clientResponse = getDiagnosticsItemDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<HostingEnvironmentDiagnosticsInner> getDiagnosticsItemDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<HostingEnvironmentDiagnosticsInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<HostingEnvironmentDiagnosticsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get global metric definitions of an App Service Environment.
     * Get global metric definitions of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MetricDefinitionInner object if successful.
     */
    public MetricDefinitionInner listMetricDefinitions(String resourceGroupName, String name) {
        return listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Get global metric definitions of an App Service Environment.
     * Get global metric definitions of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MetricDefinitionInner> listMetricDefinitionsAsync(String resourceGroupName, String name, final ServiceCallback<MetricDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Get global metric definitions of an App Service Environment.
     * Get global metric definitions of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MetricDefinitionInner object
     */
    public Observable<MetricDefinitionInner> listMetricDefinitionsAsync(String resourceGroupName, String name) {
        return listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<MetricDefinitionInner>, MetricDefinitionInner>() {
            @Override
            public MetricDefinitionInner call(ServiceResponse<MetricDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get global metric definitions of an App Service Environment.
     * Get global metric definitions of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MetricDefinitionInner object
     */
    public Observable<ServiceResponse<MetricDefinitionInner>> listMetricDefinitionsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMetricDefinitions(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<MetricDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MetricDefinitionInner> clientResponse = listMetricDefinitionsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MetricDefinitionInner> listMetricDefinitionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MetricDefinitionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MetricDefinitionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMetrics(final String resourceGroupName, final String name) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMetricsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMetricsAsync(final String resourceGroupName, final String name, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMetricsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMetricsAsync(final String resourceGroupName, final String name) {
        return listMetricsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listMetricsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean details = null;
        final String filter = null;
        return service.listMetrics(resourceGroupName, name, this.client.subscriptionId(), details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMetrics(final String resourceGroupName, final String name, final Boolean details, final String filter) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMetricsSinglePageAsync(resourceGroupName, name, details, filter).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMetricsAsync(final String resourceGroupName, final String name, final Boolean details, final String filter, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMetricsSinglePageAsync(resourceGroupName, name, details, filter),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMetricsAsync(final String resourceGroupName, final String name, final Boolean details, final String filter) {
        return listMetricsWithServiceResponseAsync(resourceGroupName, name, details, filter)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final Boolean details, final String filter) {
        return listMetricsSinglePageAsync(resourceGroupName, name, details, filter)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsSinglePageAsync(final String resourceGroupName, final String name, final Boolean details, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMetrics(resourceGroupName, name, this.client.subscriptionId(), details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WorkerPoolResourceInner&gt; object if successful.
     */
    public PagedList<WorkerPoolResourceInner> listMultiRolePools(final String resourceGroupName, final String name) {
        ServiceResponse<Page<WorkerPoolResourceInner>> response = listMultiRolePoolsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<WorkerPoolResourceInner>(response.body()) {
            @Override
            public Page<WorkerPoolResourceInner> nextPage(String nextPageLink) {
                return listMultiRolePoolsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WorkerPoolResourceInner>> listMultiRolePoolsAsync(final String resourceGroupName, final String name, final ListOperationCallback<WorkerPoolResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(String nextPageLink) {
                    return listMultiRolePoolsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WorkerPoolResourceInner&gt; object
     */
    public Observable<Page<WorkerPoolResourceInner>> listMultiRolePoolsAsync(final String resourceGroupName, final String name) {
        return listMultiRolePoolsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<WorkerPoolResourceInner>>, Page<WorkerPoolResourceInner>>() {
                @Override
                public Page<WorkerPoolResourceInner> call(ServiceResponse<Page<WorkerPoolResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WorkerPoolResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> listMultiRolePoolsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listMultiRolePoolsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<WorkerPoolResourceInner>>, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(ServiceResponse<Page<WorkerPoolResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
    ServiceResponse<PageImpl<WorkerPoolResourceInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<WorkerPoolResourceInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WorkerPoolResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> listMultiRolePoolsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMultiRolePools(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WorkerPoolResourceInner>> result = listMultiRolePoolsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WorkerPoolResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WorkerPoolResourceInner>> listMultiRolePoolsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WorkerPoolResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WorkerPoolResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get properties of a multi-role pool.
     * Get properties of a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WorkerPoolResourceInner object if successful.
     */
    public WorkerPoolResourceInner getMultiRolePool(String resourceGroupName, String name) {
        return getMultiRolePoolWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Get properties of a multi-role pool.
     * Get properties of a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WorkerPoolResourceInner> getMultiRolePoolAsync(String resourceGroupName, String name, final ServiceCallback<WorkerPoolResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getMultiRolePoolWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Get properties of a multi-role pool.
     * Get properties of a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<WorkerPoolResourceInner> getMultiRolePoolAsync(String resourceGroupName, String name) {
        return getMultiRolePoolWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<WorkerPoolResourceInner>, WorkerPoolResourceInner>() {
            @Override
            public WorkerPoolResourceInner call(ServiceResponse<WorkerPoolResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get properties of a multi-role pool.
     * Get properties of a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<ServiceResponse<WorkerPoolResourceInner>> getMultiRolePoolWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getMultiRolePool(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkerPoolResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<WorkerPoolResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WorkerPoolResourceInner> clientResponse = getMultiRolePoolDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WorkerPoolResourceInner> getMultiRolePoolDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WorkerPoolResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WorkerPoolResourceInner object if successful.
     */
    public WorkerPoolResourceInner createOrUpdateMultiRolePool(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        return createOrUpdateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope).toBlocking().last().body();
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WorkerPoolResourceInner> createOrUpdateMultiRolePoolAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope, final ServiceCallback<WorkerPoolResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope), serviceCallback);
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<WorkerPoolResourceInner> createOrUpdateMultiRolePoolAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        return createOrUpdateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope).map(new Func1<ServiceResponse<WorkerPoolResourceInner>, WorkerPoolResourceInner>() {
            @Override
            public WorkerPoolResourceInner call(ServiceResponse<WorkerPoolResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<WorkerPoolResourceInner>> createOrUpdateMultiRolePoolWithServiceResponseAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (multiRolePoolEnvelope == null) {
            throw new IllegalArgumentException("Parameter multiRolePoolEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(multiRolePoolEnvelope);
        Observable<Response<ResponseBody>> observable = service.createOrUpdateMultiRolePool(resourceGroupName, name, this.client.subscriptionId(), multiRolePoolEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<WorkerPoolResourceInner>() { }.getType());
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WorkerPoolResourceInner object if successful.
     */
    public WorkerPoolResourceInner beginCreateOrUpdateMultiRolePool(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        return beginCreateOrUpdateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope).toBlocking().single().body();
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WorkerPoolResourceInner> beginCreateOrUpdateMultiRolePoolAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope, final ServiceCallback<WorkerPoolResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope), serviceCallback);
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<WorkerPoolResourceInner> beginCreateOrUpdateMultiRolePoolAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        return beginCreateOrUpdateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope).map(new Func1<ServiceResponse<WorkerPoolResourceInner>, WorkerPoolResourceInner>() {
            @Override
            public WorkerPoolResourceInner call(ServiceResponse<WorkerPoolResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<ServiceResponse<WorkerPoolResourceInner>> beginCreateOrUpdateMultiRolePoolWithServiceResponseAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (multiRolePoolEnvelope == null) {
            throw new IllegalArgumentException("Parameter multiRolePoolEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(multiRolePoolEnvelope);
        return service.beginCreateOrUpdateMultiRolePool(resourceGroupName, name, this.client.subscriptionId(), multiRolePoolEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkerPoolResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<WorkerPoolResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WorkerPoolResourceInner> clientResponse = beginCreateOrUpdateMultiRolePoolDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WorkerPoolResourceInner> beginCreateOrUpdateMultiRolePoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WorkerPoolResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .register(202, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .register(400, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WorkerPoolResourceInner object if successful.
     */
    public WorkerPoolResourceInner updateMultiRolePool(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        return updateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope).toBlocking().single().body();
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WorkerPoolResourceInner> updateMultiRolePoolAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope, final ServiceCallback<WorkerPoolResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope), serviceCallback);
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<WorkerPoolResourceInner> updateMultiRolePoolAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        return updateMultiRolePoolWithServiceResponseAsync(resourceGroupName, name, multiRolePoolEnvelope).map(new Func1<ServiceResponse<WorkerPoolResourceInner>, WorkerPoolResourceInner>() {
            @Override
            public WorkerPoolResourceInner call(ServiceResponse<WorkerPoolResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a multi-role pool.
     * Create or update a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param multiRolePoolEnvelope Properties of the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<ServiceResponse<WorkerPoolResourceInner>> updateMultiRolePoolWithServiceResponseAsync(String resourceGroupName, String name, WorkerPoolResourceInner multiRolePoolEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (multiRolePoolEnvelope == null) {
            throw new IllegalArgumentException("Parameter multiRolePoolEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(multiRolePoolEnvelope);
        return service.updateMultiRolePool(resourceGroupName, name, this.client.subscriptionId(), multiRolePoolEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkerPoolResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<WorkerPoolResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WorkerPoolResourceInner> clientResponse = updateMultiRolePoolDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WorkerPoolResourceInner> updateMultiRolePoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WorkerPoolResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .register(202, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .register(400, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listMultiRolePoolInstanceMetricDefinitions(final String resourceGroupName, final String name, final String instance) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listMultiRolePoolInstanceMetricDefinitionsSinglePageAsync(resourceGroupName, name, instance).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listMultiRolePoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listMultiRolePoolInstanceMetricDefinitionsAsync(final String resourceGroupName, final String name, final String instance, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolInstanceMetricDefinitionsSinglePageAsync(resourceGroupName, name, instance),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listMultiRolePoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listMultiRolePoolInstanceMetricDefinitionsAsync(final String resourceGroupName, final String name, final String instance) {
        return listMultiRolePoolInstanceMetricDefinitionsWithServiceResponseAsync(resourceGroupName, name, instance)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMultiRolePoolInstanceMetricDefinitionsWithServiceResponseAsync(final String resourceGroupName, final String name, final String instance) {
        return listMultiRolePoolInstanceMetricDefinitionsSinglePageAsync(resourceGroupName, name, instance)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolInstanceMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param instance Name of the instance in the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMultiRolePoolInstanceMetricDefinitionsSinglePageAsync(final String resourceGroupName, final String name, final String instance) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Parameter instance is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMultiRolePoolInstanceMetricDefinitions(resourceGroupName, name, instance, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listMultiRolePoolInstanceMetricDefinitionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listMultiRolePoolInstanceMetricDefinitionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMultiRolePoolInstanceMetrics(final String resourceGroupName, final String name, final String instance) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMultiRolePoolInstanceMetricsSinglePageAsync(resourceGroupName, name, instance).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMultiRolePoolInstanceMetricsAsync(final String resourceGroupName, final String name, final String instance, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolInstanceMetricsSinglePageAsync(resourceGroupName, name, instance),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMultiRolePoolInstanceMetricsAsync(final String resourceGroupName, final String name, final String instance) {
        return listMultiRolePoolInstanceMetricsWithServiceResponseAsync(resourceGroupName, name, instance)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRolePoolInstanceMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final String instance) {
        return listMultiRolePoolInstanceMetricsSinglePageAsync(resourceGroupName, name, instance)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolInstanceMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRolePoolInstanceMetricsSinglePageAsync(final String resourceGroupName, final String name, final String instance) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Parameter instance is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean details = null;
        return service.listMultiRolePoolInstanceMetrics(resourceGroupName, name, instance, this.client.subscriptionId(), details, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMultiRolePoolInstanceMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMultiRolePoolInstanceMetrics(final String resourceGroupName, final String name, final String instance, final Boolean details) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMultiRolePoolInstanceMetricsSinglePageAsync(resourceGroupName, name, instance, details).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMultiRolePoolInstanceMetricsAsync(final String resourceGroupName, final String name, final String instance, final Boolean details, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolInstanceMetricsSinglePageAsync(resourceGroupName, name, instance, details),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMultiRolePoolInstanceMetricsAsync(final String resourceGroupName, final String name, final String instance, final Boolean details) {
        return listMultiRolePoolInstanceMetricsWithServiceResponseAsync(resourceGroupName, name, instance, details)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param instance Name of the instance in the multi-role pool.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRolePoolInstanceMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final String instance, final Boolean details) {
        return listMultiRolePoolInstanceMetricsSinglePageAsync(resourceGroupName, name, instance, details)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolInstanceMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param instance Name of the instance in the multi-role pool.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRolePoolInstanceMetricsSinglePageAsync(final String resourceGroupName, final String name, final String instance, final Boolean details) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Parameter instance is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMultiRolePoolInstanceMetrics(resourceGroupName, name, instance, this.client.subscriptionId(), details, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMultiRolePoolInstanceMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listMultiRolePoolInstanceMetricsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listMultiRoleMetricDefinitions(final String resourceGroupName, final String name) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listMultiRoleMetricDefinitionsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listMultiRoleMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listMultiRoleMetricDefinitionsAsync(final String resourceGroupName, final String name, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRoleMetricDefinitionsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listMultiRoleMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listMultiRoleMetricDefinitionsAsync(final String resourceGroupName, final String name) {
        return listMultiRoleMetricDefinitionsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMultiRoleMetricDefinitionsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listMultiRoleMetricDefinitionsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRoleMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMultiRoleMetricDefinitionsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMultiRoleMetricDefinitions(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listMultiRoleMetricDefinitionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listMultiRoleMetricDefinitionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMultiRoleMetrics(final String resourceGroupName, final String name) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMultiRoleMetricsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMultiRoleMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMultiRoleMetricsAsync(final String resourceGroupName, final String name, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRoleMetricsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMultiRoleMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMultiRoleMetricsAsync(final String resourceGroupName, final String name) {
        return listMultiRoleMetricsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRoleMetricsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listMultiRoleMetricsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRoleMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRoleMetricsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String startTime = null;
        final String endTime = null;
        final String timeGrain = null;
        final Boolean details = null;
        final String filter = null;
        return service.listMultiRoleMetrics(resourceGroupName, name, this.client.subscriptionId(), startTime, endTime, timeGrain, details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMultiRoleMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param startTime Beginning time of the metrics query.
     * @param endTime End time of the metrics query.
     * @param timeGrain Time granularity of the metrics query.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMultiRoleMetrics(final String resourceGroupName, final String name, final String startTime, final String endTime, final String timeGrain, final Boolean details, final String filter) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMultiRoleMetricsSinglePageAsync(resourceGroupName, name, startTime, endTime, timeGrain, details, filter).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMultiRoleMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param startTime Beginning time of the metrics query.
     * @param endTime End time of the metrics query.
     * @param timeGrain Time granularity of the metrics query.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMultiRoleMetricsAsync(final String resourceGroupName, final String name, final String startTime, final String endTime, final String timeGrain, final Boolean details, final String filter, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRoleMetricsSinglePageAsync(resourceGroupName, name, startTime, endTime, timeGrain, details, filter),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMultiRoleMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param startTime Beginning time of the metrics query.
     * @param endTime End time of the metrics query.
     * @param timeGrain Time granularity of the metrics query.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMultiRoleMetricsAsync(final String resourceGroupName, final String name, final String startTime, final String endTime, final String timeGrain, final Boolean details, final String filter) {
        return listMultiRoleMetricsWithServiceResponseAsync(resourceGroupName, name, startTime, endTime, timeGrain, details, filter)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param startTime Beginning time of the metrics query.
     * @param endTime End time of the metrics query.
     * @param timeGrain Time granularity of the metrics query.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRoleMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final String startTime, final String endTime, final String timeGrain, final Boolean details, final String filter) {
        return listMultiRoleMetricsSinglePageAsync(resourceGroupName, name, startTime, endTime, timeGrain, details, filter)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRoleMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param startTime Beginning time of the metrics query.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param endTime End time of the metrics query.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param timeGrain Time granularity of the metrics query.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRoleMetricsSinglePageAsync(final String resourceGroupName, final String name, final String startTime, final String endTime, final String timeGrain, final Boolean details, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMultiRoleMetrics(resourceGroupName, name, this.client.subscriptionId(), startTime, endTime, timeGrain, details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMultiRoleMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listMultiRoleMetricsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SkuInfoInner&gt; object if successful.
     */
    public PagedList<SkuInfoInner> listMultiRolePoolSkus(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SkuInfoInner>> response = listMultiRolePoolSkusSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SkuInfoInner>(response.body()) {
            @Override
            public Page<SkuInfoInner> nextPage(String nextPageLink) {
                return listMultiRolePoolSkusNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SkuInfoInner>> listMultiRolePoolSkusAsync(final String resourceGroupName, final String name, final ListOperationCallback<SkuInfoInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolSkusSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(String nextPageLink) {
                    return listMultiRolePoolSkusNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SkuInfoInner&gt; object
     */
    public Observable<Page<SkuInfoInner>> listMultiRolePoolSkusAsync(final String resourceGroupName, final String name) {
        return listMultiRolePoolSkusWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SkuInfoInner>>, Page<SkuInfoInner>>() {
                @Override
                public Page<SkuInfoInner> call(ServiceResponse<Page<SkuInfoInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SkuInfoInner&gt; object
     */
    public Observable<ServiceResponse<Page<SkuInfoInner>>> listMultiRolePoolSkusWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listMultiRolePoolSkusSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SkuInfoInner>>, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(ServiceResponse<Page<SkuInfoInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolSkusNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
    ServiceResponse<PageImpl<SkuInfoInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SkuInfoInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SkuInfoInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SkuInfoInner>>> listMultiRolePoolSkusSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMultiRolePoolSkus(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SkuInfoInner>> result = listMultiRolePoolSkusDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SkuInfoInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SkuInfoInner>> listMultiRolePoolSkusDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SkuInfoInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SkuInfoInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;UsageInner&gt; object if successful.
     */
    public PagedList<UsageInner> listMultiRoleUsages(final String resourceGroupName, final String name) {
        ServiceResponse<Page<UsageInner>> response = listMultiRoleUsagesSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<UsageInner>(response.body()) {
            @Override
            public Page<UsageInner> nextPage(String nextPageLink) {
                return listMultiRoleUsagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageInner>> listMultiRoleUsagesAsync(final String resourceGroupName, final String name, final ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRoleUsagesSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                    return listMultiRoleUsagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<Page<UsageInner>> listMultiRoleUsagesAsync(final String resourceGroupName, final String name) {
        return listMultiRoleUsagesWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>() {
                @Override
                public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listMultiRoleUsagesWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listMultiRoleUsagesSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRoleUsagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<UsageInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<UsageInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;UsageInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listMultiRoleUsagesSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMultiRoleUsages(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageInner>> result = listMultiRoleUsagesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UsageInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UsageInner>> listMultiRoleUsagesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UsageInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UsageInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all currently running operations on the App Service Environment.
     * List all currently running operations on the App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;OperationInner&gt; object if successful.
     */
    public List<OperationInner> listOperations(String resourceGroupName, String name) {
        return listOperationsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * List all currently running operations on the App Service Environment.
     * List all currently running operations on the App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<OperationInner>> listOperationsAsync(String resourceGroupName, String name, final ServiceCallback<List<OperationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listOperationsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * List all currently running operations on the App Service Environment.
     * List all currently running operations on the App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;OperationInner&gt; object
     */
    public Observable<List<OperationInner>> listOperationsAsync(String resourceGroupName, String name) {
        return listOperationsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<List<OperationInner>>, List<OperationInner>>() {
            @Override
            public List<OperationInner> call(ServiceResponse<List<OperationInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * List all currently running operations on the App Service Environment.
     * List all currently running operations on the App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;OperationInner&gt; object
     */
    public Observable<ServiceResponse<List<OperationInner>>> listOperationsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listOperations(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<OperationInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<OperationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<List<OperationInner>> clientResponse = listOperationsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<List<OperationInner>> listOperationsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<List<OperationInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<List<OperationInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Reboot all machines in an App Service Environment.
     * Reboot all machines in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void reboot(String resourceGroupName, String name) {
        rebootWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Reboot all machines in an App Service Environment.
     * Reboot all machines in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> rebootAsync(String resourceGroupName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(rebootWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Reboot all machines in an App Service Environment.
     * Reboot all machines in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> rebootAsync(String resourceGroupName, String name) {
        return rebootWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Reboot all machines in an App Service Environment.
     * Reboot all machines in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> rebootWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.reboot(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = rebootDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> rebootDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(400, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> resume(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SiteInner>> response = resumeSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return resumeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> resumeAsync(final String resourceGroupName, final String name, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            resumeSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return resumeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> resumeAsync(final String resourceGroupName, final String name) {
        return resumeWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> resumeWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return resumeSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(resumeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> resumeSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.resume(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = resumeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> resumeDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException, InterruptedException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> beginResume(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SiteInner>> response = beginResumeSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return beginResumeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> beginResumeAsync(final String resourceGroupName, final String name, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginResumeSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return beginResumeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> beginResumeAsync(final String resourceGroupName, final String name) {
        return beginResumeWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginResumeWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return beginResumeSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginResumeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginResumeSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginResume(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = beginResumeDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> beginResumeDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServicePlanInner&gt; object if successful.
     */
    public PagedList<AppServicePlanInner> listAppServicePlans(final String resourceGroupName, final String name) {
        ServiceResponse<Page<AppServicePlanInner>> response = listAppServicePlansSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<AppServicePlanInner>(response.body()) {
            @Override
            public Page<AppServicePlanInner> nextPage(String nextPageLink) {
                return listAppServicePlansNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServicePlanInner>> listAppServicePlansAsync(final String resourceGroupName, final String name, final ListOperationCallback<AppServicePlanInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAppServicePlansSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<AppServicePlanInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServicePlanInner>>> call(String nextPageLink) {
                    return listAppServicePlansNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServicePlanInner&gt; object
     */
    public Observable<Page<AppServicePlanInner>> listAppServicePlansAsync(final String resourceGroupName, final String name) {
        return listAppServicePlansWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<AppServicePlanInner>>, Page<AppServicePlanInner>>() {
                @Override
                public Page<AppServicePlanInner> call(ServiceResponse<Page<AppServicePlanInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServicePlanInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServicePlanInner>>> listAppServicePlansWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listAppServicePlansSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<AppServicePlanInner>>, Observable<ServiceResponse<Page<AppServicePlanInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServicePlanInner>>> call(ServiceResponse<Page<AppServicePlanInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAppServicePlansNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
    ServiceResponse<PageImpl<AppServicePlanInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<AppServicePlanInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServicePlanInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServicePlanInner>>> listAppServicePlansSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAppServicePlans(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServicePlanInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServicePlanInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServicePlanInner>> result = listAppServicePlansDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServicePlanInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServicePlanInner>> listAppServicePlansDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServicePlanInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServicePlanInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> listWebApps(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SiteInner>> response = listWebAppsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return listWebAppsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> listWebAppsAsync(final String resourceGroupName, final String name, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebAppsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return listWebAppsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> listWebAppsAsync(final String resourceGroupName, final String name) {
        return listWebAppsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listWebAppsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listWebAppsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebAppsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listWebAppsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String propertiesToInclude = null;
        return service.listWebApps(resourceGroupName, name, this.client.subscriptionId(), propertiesToInclude, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = listWebAppsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param propertiesToInclude Comma separated list of app properties to include.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> listWebApps(final String resourceGroupName, final String name, final String propertiesToInclude) {
        ServiceResponse<Page<SiteInner>> response = listWebAppsSinglePageAsync(resourceGroupName, name, propertiesToInclude).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return listWebAppsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param propertiesToInclude Comma separated list of app properties to include.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> listWebAppsAsync(final String resourceGroupName, final String name, final String propertiesToInclude, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebAppsSinglePageAsync(resourceGroupName, name, propertiesToInclude),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return listWebAppsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param propertiesToInclude Comma separated list of app properties to include.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> listWebAppsAsync(final String resourceGroupName, final String name, final String propertiesToInclude) {
        return listWebAppsWithServiceResponseAsync(resourceGroupName, name, propertiesToInclude)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param propertiesToInclude Comma separated list of app properties to include.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listWebAppsWithServiceResponseAsync(final String resourceGroupName, final String name, final String propertiesToInclude) {
        return listWebAppsSinglePageAsync(resourceGroupName, name, propertiesToInclude)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebAppsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<SiteInner>> * @param propertiesToInclude Comma separated list of app properties to include.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listWebAppsSinglePageAsync(final String resourceGroupName, final String name, final String propertiesToInclude) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listWebApps(resourceGroupName, name, this.client.subscriptionId(), propertiesToInclude, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = listWebAppsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> listWebAppsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> suspend(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SiteInner>> response = suspendSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return suspendNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> suspendAsync(final String resourceGroupName, final String name, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            suspendSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return suspendNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> suspendAsync(final String resourceGroupName, final String name) {
        return suspendWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> suspendWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return suspendSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(suspendNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> suspendSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.suspend(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = suspendDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> suspendDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException, InterruptedException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> beginSuspend(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SiteInner>> response = beginSuspendSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return beginSuspendNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> beginSuspendAsync(final String resourceGroupName, final String name, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginSuspendSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return beginSuspendNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> beginSuspendAsync(final String resourceGroupName, final String name) {
        return beginSuspendWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginSuspendWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return beginSuspendSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginSuspendNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginSuspendSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginSuspend(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = beginSuspendDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> beginSuspendDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void syncVirtualNetworkInfo(String resourceGroupName, String name) {
        syncVirtualNetworkInfoWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> syncVirtualNetworkInfoAsync(String resourceGroupName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(syncVirtualNetworkInfoWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> syncVirtualNetworkInfoAsync(String resourceGroupName, String name) {
        return syncVirtualNetworkInfoWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> syncVirtualNetworkInfoWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.syncVirtualNetworkInfo(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = syncVirtualNetworkInfoDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> syncVirtualNetworkInfoDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CsmUsageQuotaInner&gt; object if successful.
     */
    public PagedList<CsmUsageQuotaInner> listUsages(final String resourceGroupName, final String name) {
        ServiceResponse<Page<CsmUsageQuotaInner>> response = listUsagesSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<CsmUsageQuotaInner>(response.body()) {
            @Override
            public Page<CsmUsageQuotaInner> nextPage(String nextPageLink) {
                return listUsagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CsmUsageQuotaInner>> listUsagesAsync(final String resourceGroupName, final String name, final ListOperationCallback<CsmUsageQuotaInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listUsagesSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(String nextPageLink) {
                    return listUsagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmUsageQuotaInner&gt; object
     */
    public Observable<Page<CsmUsageQuotaInner>> listUsagesAsync(final String resourceGroupName, final String name) {
        return listUsagesWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<CsmUsageQuotaInner>>, Page<CsmUsageQuotaInner>>() {
                @Override
                public Page<CsmUsageQuotaInner> call(ServiceResponse<Page<CsmUsageQuotaInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmUsageQuotaInner&gt; object
     */
    public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> listUsagesWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listUsagesSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<CsmUsageQuotaInner>>, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(ServiceResponse<Page<CsmUsageQuotaInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listUsagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CsmUsageQuotaInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> listUsagesSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String filter = null;
        return service.listUsages(resourceGroupName, name, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CsmUsageQuotaInner>> result = listUsagesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CsmUsageQuotaInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CsmUsageQuotaInner&gt; object if successful.
     */
    public PagedList<CsmUsageQuotaInner> listUsages(final String resourceGroupName, final String name, final String filter) {
        ServiceResponse<Page<CsmUsageQuotaInner>> response = listUsagesSinglePageAsync(resourceGroupName, name, filter).toBlocking().single();
        return new PagedList<CsmUsageQuotaInner>(response.body()) {
            @Override
            public Page<CsmUsageQuotaInner> nextPage(String nextPageLink) {
                return listUsagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CsmUsageQuotaInner>> listUsagesAsync(final String resourceGroupName, final String name, final String filter, final ListOperationCallback<CsmUsageQuotaInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listUsagesSinglePageAsync(resourceGroupName, name, filter),
            new Func1<String, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(String nextPageLink) {
                    return listUsagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmUsageQuotaInner&gt; object
     */
    public Observable<Page<CsmUsageQuotaInner>> listUsagesAsync(final String resourceGroupName, final String name, final String filter) {
        return listUsagesWithServiceResponseAsync(resourceGroupName, name, filter)
            .map(new Func1<ServiceResponse<Page<CsmUsageQuotaInner>>, Page<CsmUsageQuotaInner>>() {
                @Override
                public Page<CsmUsageQuotaInner> call(ServiceResponse<Page<CsmUsageQuotaInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmUsageQuotaInner&gt; object
     */
    public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> listUsagesWithServiceResponseAsync(final String resourceGroupName, final String name, final String filter) {
        return listUsagesSinglePageAsync(resourceGroupName, name, filter)
            .concatMap(new Func1<ServiceResponse<Page<CsmUsageQuotaInner>>, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(ServiceResponse<Page<CsmUsageQuotaInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listUsagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
    ServiceResponse<PageImpl<CsmUsageQuotaInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<CsmUsageQuotaInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<CsmUsageQuotaInner>> * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CsmUsageQuotaInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> listUsagesSinglePageAsync(final String resourceGroupName, final String name, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listUsages(resourceGroupName, name, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CsmUsageQuotaInner>> result = listUsagesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CsmUsageQuotaInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CsmUsageQuotaInner>> listUsagesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CsmUsageQuotaInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CsmUsageQuotaInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WorkerPoolResourceInner&gt; object if successful.
     */
    public PagedList<WorkerPoolResourceInner> listWorkerPools(final String resourceGroupName, final String name) {
        ServiceResponse<Page<WorkerPoolResourceInner>> response = listWorkerPoolsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<WorkerPoolResourceInner>(response.body()) {
            @Override
            public Page<WorkerPoolResourceInner> nextPage(String nextPageLink) {
                return listWorkerPoolsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WorkerPoolResourceInner>> listWorkerPoolsAsync(final String resourceGroupName, final String name, final ListOperationCallback<WorkerPoolResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(String nextPageLink) {
                    return listWorkerPoolsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WorkerPoolResourceInner&gt; object
     */
    public Observable<Page<WorkerPoolResourceInner>> listWorkerPoolsAsync(final String resourceGroupName, final String name) {
        return listWorkerPoolsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<WorkerPoolResourceInner>>, Page<WorkerPoolResourceInner>>() {
                @Override
                public Page<WorkerPoolResourceInner> call(ServiceResponse<Page<WorkerPoolResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WorkerPoolResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> listWorkerPoolsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listWorkerPoolsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<WorkerPoolResourceInner>>, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(ServiceResponse<Page<WorkerPoolResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
    ServiceResponse<PageImpl<WorkerPoolResourceInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<WorkerPoolResourceInner>> * @param name Name of the App Service Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WorkerPoolResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> listWorkerPoolsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listWorkerPools(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WorkerPoolResourceInner>> result = listWorkerPoolsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WorkerPoolResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WorkerPoolResourceInner>> listWorkerPoolsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WorkerPoolResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WorkerPoolResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get properties of a worker pool.
     * Get properties of a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WorkerPoolResourceInner object if successful.
     */
    public WorkerPoolResourceInner getWorkerPool(String resourceGroupName, String name, String workerPoolName) {
        return getWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName).toBlocking().single().body();
    }

    /**
     * Get properties of a worker pool.
     * Get properties of a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WorkerPoolResourceInner> getWorkerPoolAsync(String resourceGroupName, String name, String workerPoolName, final ServiceCallback<WorkerPoolResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName), serviceCallback);
    }

    /**
     * Get properties of a worker pool.
     * Get properties of a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<WorkerPoolResourceInner> getWorkerPoolAsync(String resourceGroupName, String name, String workerPoolName) {
        return getWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName).map(new Func1<ServiceResponse<WorkerPoolResourceInner>, WorkerPoolResourceInner>() {
            @Override
            public WorkerPoolResourceInner call(ServiceResponse<WorkerPoolResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get properties of a worker pool.
     * Get properties of a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<ServiceResponse<WorkerPoolResourceInner>> getWorkerPoolWithServiceResponseAsync(String resourceGroupName, String name, String workerPoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getWorkerPool(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkerPoolResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<WorkerPoolResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WorkerPoolResourceInner> clientResponse = getWorkerPoolDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WorkerPoolResourceInner> getWorkerPoolDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WorkerPoolResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WorkerPoolResourceInner object if successful.
     */
    public WorkerPoolResourceInner createOrUpdateWorkerPool(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        return createOrUpdateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope).toBlocking().last().body();
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WorkerPoolResourceInner> createOrUpdateWorkerPoolAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope, final ServiceCallback<WorkerPoolResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope), serviceCallback);
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<WorkerPoolResourceInner> createOrUpdateWorkerPoolAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        return createOrUpdateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope).map(new Func1<ServiceResponse<WorkerPoolResourceInner>, WorkerPoolResourceInner>() {
            @Override
            public WorkerPoolResourceInner call(ServiceResponse<WorkerPoolResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<WorkerPoolResourceInner>> createOrUpdateWorkerPoolWithServiceResponseAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (workerPoolEnvelope == null) {
            throw new IllegalArgumentException("Parameter workerPoolEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(workerPoolEnvelope);
        Observable<Response<ResponseBody>> observable = service.createOrUpdateWorkerPool(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), workerPoolEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<WorkerPoolResourceInner>() { }.getType());
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WorkerPoolResourceInner object if successful.
     */
    public WorkerPoolResourceInner beginCreateOrUpdateWorkerPool(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        return beginCreateOrUpdateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope).toBlocking().single().body();
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WorkerPoolResourceInner> beginCreateOrUpdateWorkerPoolAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope, final ServiceCallback<WorkerPoolResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope), serviceCallback);
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<WorkerPoolResourceInner> beginCreateOrUpdateWorkerPoolAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        return beginCreateOrUpdateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope).map(new Func1<ServiceResponse<WorkerPoolResourceInner>, WorkerPoolResourceInner>() {
            @Override
            public WorkerPoolResourceInner call(ServiceResponse<WorkerPoolResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<ServiceResponse<WorkerPoolResourceInner>> beginCreateOrUpdateWorkerPoolWithServiceResponseAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (workerPoolEnvelope == null) {
            throw new IllegalArgumentException("Parameter workerPoolEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(workerPoolEnvelope);
        return service.beginCreateOrUpdateWorkerPool(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), workerPoolEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkerPoolResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<WorkerPoolResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WorkerPoolResourceInner> clientResponse = beginCreateOrUpdateWorkerPoolDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WorkerPoolResourceInner> beginCreateOrUpdateWorkerPoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WorkerPoolResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .register(202, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .register(400, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the WorkerPoolResourceInner object if successful.
     */
    public WorkerPoolResourceInner updateWorkerPool(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        return updateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope).toBlocking().single().body();
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<WorkerPoolResourceInner> updateWorkerPoolAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope, final ServiceCallback<WorkerPoolResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope), serviceCallback);
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<WorkerPoolResourceInner> updateWorkerPoolAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        return updateWorkerPoolWithServiceResponseAsync(resourceGroupName, name, workerPoolName, workerPoolEnvelope).map(new Func1<ServiceResponse<WorkerPoolResourceInner>, WorkerPoolResourceInner>() {
            @Override
            public WorkerPoolResourceInner call(ServiceResponse<WorkerPoolResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a worker pool.
     * Create or update a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param workerPoolEnvelope Properties of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the WorkerPoolResourceInner object
     */
    public Observable<ServiceResponse<WorkerPoolResourceInner>> updateWorkerPoolWithServiceResponseAsync(String resourceGroupName, String name, String workerPoolName, WorkerPoolResourceInner workerPoolEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (workerPoolEnvelope == null) {
            throw new IllegalArgumentException("Parameter workerPoolEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(workerPoolEnvelope);
        return service.updateWorkerPool(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), workerPoolEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkerPoolResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<WorkerPoolResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<WorkerPoolResourceInner> clientResponse = updateWorkerPoolDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<WorkerPoolResourceInner> updateWorkerPoolDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<WorkerPoolResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .register(202, new TypeToken<WorkerPoolResourceInner>() { }.getType())
                .register(400, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listWorkerPoolInstanceMetricDefinitions(final String resourceGroupName, final String name, final String workerPoolName, final String instance) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listWorkerPoolInstanceMetricDefinitionsSinglePageAsync(resourceGroupName, name, workerPoolName, instance).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listWorkerPoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listWorkerPoolInstanceMetricDefinitionsAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolInstanceMetricDefinitionsSinglePageAsync(resourceGroupName, name, workerPoolName, instance),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listWorkerPoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listWorkerPoolInstanceMetricDefinitionsAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance) {
        return listWorkerPoolInstanceMetricDefinitionsWithServiceResponseAsync(resourceGroupName, name, workerPoolName, instance)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listWorkerPoolInstanceMetricDefinitionsWithServiceResponseAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance) {
        return listWorkerPoolInstanceMetricDefinitionsSinglePageAsync(resourceGroupName, name, workerPoolName, instance)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolInstanceMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param workerPoolName Name of the worker pool.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param instance Name of the instance in the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listWorkerPoolInstanceMetricDefinitionsSinglePageAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Parameter instance is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listWorkerPoolInstanceMetricDefinitions(resourceGroupName, name, workerPoolName, instance, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listWorkerPoolInstanceMetricDefinitionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listWorkerPoolInstanceMetricDefinitionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listWorkerPoolInstanceMetrics(final String resourceGroupName, final String name, final String workerPoolName, final String instance) {
        ServiceResponse<Page<ResourceMetricInner>> response = listWorkerPoolInstanceMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, instance).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listWorkerPoolInstanceMetricsAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolInstanceMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, instance),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listWorkerPoolInstanceMetricsAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance) {
        return listWorkerPoolInstanceMetricsWithServiceResponseAsync(resourceGroupName, name, workerPoolName, instance)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWorkerPoolInstanceMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance) {
        return listWorkerPoolInstanceMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, instance)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolInstanceMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWorkerPoolInstanceMetricsSinglePageAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Parameter instance is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean details = null;
        final String filter = null;
        return service.listWorkerPoolInstanceMetrics(resourceGroupName, name, workerPoolName, instance, this.client.subscriptionId(), details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listWorkerPoolInstanceMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listWorkerPoolInstanceMetrics(final String resourceGroupName, final String name, final String workerPoolName, final String instance, final Boolean details, final String filter) {
        ServiceResponse<Page<ResourceMetricInner>> response = listWorkerPoolInstanceMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, instance, details, filter).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listWorkerPoolInstanceMetricsAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance, final Boolean details, final String filter, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolInstanceMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, instance, details, filter),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listWorkerPoolInstanceMetricsAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance, final Boolean details, final String filter) {
        return listWorkerPoolInstanceMetricsWithServiceResponseAsync(resourceGroupName, name, workerPoolName, instance, details, filter)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param instance Name of the instance in the worker pool.
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWorkerPoolInstanceMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance, final Boolean details, final String filter) {
        return listWorkerPoolInstanceMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, instance, details, filter)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolInstanceMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param workerPoolName Name of the worker pool.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param instance Name of the instance in the worker pool.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWorkerPoolInstanceMetricsSinglePageAsync(final String resourceGroupName, final String name, final String workerPoolName, final String instance, final Boolean details, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Parameter instance is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listWorkerPoolInstanceMetrics(resourceGroupName, name, workerPoolName, instance, this.client.subscriptionId(), details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listWorkerPoolInstanceMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listWorkerPoolInstanceMetricsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listWebWorkerMetricDefinitions(final String resourceGroupName, final String name, final String workerPoolName) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listWebWorkerMetricDefinitionsSinglePageAsync(resourceGroupName, name, workerPoolName).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listWebWorkerMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listWebWorkerMetricDefinitionsAsync(final String resourceGroupName, final String name, final String workerPoolName, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebWorkerMetricDefinitionsSinglePageAsync(resourceGroupName, name, workerPoolName),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listWebWorkerMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listWebWorkerMetricDefinitionsAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        return listWebWorkerMetricDefinitionsWithServiceResponseAsync(resourceGroupName, name, workerPoolName)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listWebWorkerMetricDefinitionsWithServiceResponseAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        return listWebWorkerMetricDefinitionsSinglePageAsync(resourceGroupName, name, workerPoolName)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebWorkerMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listWebWorkerMetricDefinitionsSinglePageAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listWebWorkerMetricDefinitions(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listWebWorkerMetricDefinitionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listWebWorkerMetricDefinitionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listWebWorkerMetrics(final String resourceGroupName, final String name, final String workerPoolName) {
        ServiceResponse<Page<ResourceMetricInner>> response = listWebWorkerMetricsSinglePageAsync(resourceGroupName, name, workerPoolName).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listWebWorkerMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listWebWorkerMetricsAsync(final String resourceGroupName, final String name, final String workerPoolName, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebWorkerMetricsSinglePageAsync(resourceGroupName, name, workerPoolName),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listWebWorkerMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listWebWorkerMetricsAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        return listWebWorkerMetricsWithServiceResponseAsync(resourceGroupName, name, workerPoolName)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWebWorkerMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        return listWebWorkerMetricsSinglePageAsync(resourceGroupName, name, workerPoolName)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebWorkerMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWebWorkerMetricsSinglePageAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean details = null;
        final String filter = null;
        return service.listWebWorkerMetrics(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listWebWorkerMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listWebWorkerMetrics(final String resourceGroupName, final String name, final String workerPoolName, final Boolean details, final String filter) {
        ServiceResponse<Page<ResourceMetricInner>> response = listWebWorkerMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, details, filter).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listWebWorkerMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listWebWorkerMetricsAsync(final String resourceGroupName, final String name, final String workerPoolName, final Boolean details, final String filter, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebWorkerMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, details, filter),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listWebWorkerMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listWebWorkerMetricsAsync(final String resourceGroupName, final String name, final String workerPoolName, final Boolean details, final String filter) {
        return listWebWorkerMetricsWithServiceResponseAsync(resourceGroupName, name, workerPoolName, details, filter)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of worker pool
     * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWebWorkerMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final String workerPoolName, final Boolean details, final String filter) {
        return listWebWorkerMetricsSinglePageAsync(resourceGroupName, name, workerPoolName, details, filter)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebWorkerMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param workerPoolName Name of worker pool
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param details Specify &lt;code&gt;true&lt;/code&gt; to include instance details. The default is &lt;code&gt;false&lt;/code&gt;.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWebWorkerMetricsSinglePageAsync(final String resourceGroupName, final String name, final String workerPoolName, final Boolean details, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listWebWorkerMetrics(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listWebWorkerMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listWebWorkerMetricsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SkuInfoInner&gt; object if successful.
     */
    public PagedList<SkuInfoInner> listWorkerPoolSkus(final String resourceGroupName, final String name, final String workerPoolName) {
        ServiceResponse<Page<SkuInfoInner>> response = listWorkerPoolSkusSinglePageAsync(resourceGroupName, name, workerPoolName).toBlocking().single();
        return new PagedList<SkuInfoInner>(response.body()) {
            @Override
            public Page<SkuInfoInner> nextPage(String nextPageLink) {
                return listWorkerPoolSkusNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SkuInfoInner>> listWorkerPoolSkusAsync(final String resourceGroupName, final String name, final String workerPoolName, final ListOperationCallback<SkuInfoInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolSkusSinglePageAsync(resourceGroupName, name, workerPoolName),
            new Func1<String, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(String nextPageLink) {
                    return listWorkerPoolSkusNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SkuInfoInner&gt; object
     */
    public Observable<Page<SkuInfoInner>> listWorkerPoolSkusAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        return listWorkerPoolSkusWithServiceResponseAsync(resourceGroupName, name, workerPoolName)
            .map(new Func1<ServiceResponse<Page<SkuInfoInner>>, Page<SkuInfoInner>>() {
                @Override
                public Page<SkuInfoInner> call(ServiceResponse<Page<SkuInfoInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SkuInfoInner&gt; object
     */
    public Observable<ServiceResponse<Page<SkuInfoInner>>> listWorkerPoolSkusWithServiceResponseAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        return listWorkerPoolSkusSinglePageAsync(resourceGroupName, name, workerPoolName)
            .concatMap(new Func1<ServiceResponse<Page<SkuInfoInner>>, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(ServiceResponse<Page<SkuInfoInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolSkusNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
    ServiceResponse<PageImpl<SkuInfoInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SkuInfoInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<SkuInfoInner>> * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SkuInfoInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SkuInfoInner>>> listWorkerPoolSkusSinglePageAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listWorkerPoolSkus(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SkuInfoInner>> result = listWorkerPoolSkusDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SkuInfoInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SkuInfoInner>> listWorkerPoolSkusDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SkuInfoInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SkuInfoInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;UsageInner&gt; object if successful.
     */
    public PagedList<UsageInner> listWebWorkerUsages(final String resourceGroupName, final String name, final String workerPoolName) {
        ServiceResponse<Page<UsageInner>> response = listWebWorkerUsagesSinglePageAsync(resourceGroupName, name, workerPoolName).toBlocking().single();
        return new PagedList<UsageInner>(response.body()) {
            @Override
            public Page<UsageInner> nextPage(String nextPageLink) {
                return listWebWorkerUsagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageInner>> listWebWorkerUsagesAsync(final String resourceGroupName, final String name, final String workerPoolName, final ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebWorkerUsagesSinglePageAsync(resourceGroupName, name, workerPoolName),
            new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                    return listWebWorkerUsagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<Page<UsageInner>> listWebWorkerUsagesAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        return listWebWorkerUsagesWithServiceResponseAsync(resourceGroupName, name, workerPoolName)
            .map(new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>() {
                @Override
                public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the App Service Environment.
     * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listWebWorkerUsagesWithServiceResponseAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        return listWebWorkerUsagesSinglePageAsync(resourceGroupName, name, workerPoolName)
            .concatMap(new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebWorkerUsagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<UsageInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<UsageInner>> * @param name Name of the App Service Environment.
    ServiceResponse<PageImpl<UsageInner>> * @param workerPoolName Name of the worker pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;UsageInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listWebWorkerUsagesSinglePageAsync(final String resourceGroupName, final String name, final String workerPoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (workerPoolName == null) {
            throw new IllegalArgumentException("Parameter workerPoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listWebWorkerUsages(resourceGroupName, name, workerPoolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageInner>> result = listWebWorkerUsagesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UsageInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UsageInner>> listWebWorkerUsagesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UsageInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UsageInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object if successful.
     */
    public PagedList<AppServiceEnvironmentResourceInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<AppServiceEnvironmentResourceInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServiceEnvironmentResourceInner>(response.body()) {
            @Override
            public Page<AppServiceEnvironmentResourceInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceEnvironmentResourceInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<AppServiceEnvironmentResourceInner>> serviceFuture, final ListOperationCallback<AppServiceEnvironmentResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object
     */
    public Observable<Page<AppServiceEnvironmentResourceInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>, Page<AppServiceEnvironmentResourceInner>>() {
                @Override
                public Page<AppServiceEnvironmentResourceInner> call(ServiceResponse<Page<AppServiceEnvironmentResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(ServiceResponse<Page<AppServiceEnvironmentResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all App Service Environments for a subscription.
     * Get all App Service Environments for a subscription.
     *
    ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceEnvironmentResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceEnvironmentResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceEnvironmentResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object if successful.
     */
    public PagedList<AppServiceEnvironmentResourceInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<AppServiceEnvironmentResourceInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServiceEnvironmentResourceInner>(response.body()) {
            @Override
            public Page<AppServiceEnvironmentResourceInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceEnvironmentResourceInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<AppServiceEnvironmentResourceInner>> serviceFuture, final ListOperationCallback<AppServiceEnvironmentResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object
     */
    public Observable<Page<AppServiceEnvironmentResourceInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>, Page<AppServiceEnvironmentResourceInner>>() {
                @Override
                public Page<AppServiceEnvironmentResourceInner> call(ServiceResponse<Page<AppServiceEnvironmentResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(ServiceResponse<Page<AppServiceEnvironmentResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all App Service Environments in a resource group.
     * Get all App Service Environments in a resource group.
     *
    ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceEnvironmentResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceEnvironmentResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceEnvironmentResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceEnvironmentResourceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceEnvironmentResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceEnvironmentResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;StampCapacityInner&gt; object if successful.
     */
    public PagedList<StampCapacityInner> listCapacitiesNext(final String nextPageLink) {
        ServiceResponse<Page<StampCapacityInner>> response = listCapacitiesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<StampCapacityInner>(response.body()) {
            @Override
            public Page<StampCapacityInner> nextPage(String nextPageLink) {
                return listCapacitiesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<StampCapacityInner>> listCapacitiesNextAsync(final String nextPageLink, final ServiceFuture<List<StampCapacityInner>> serviceFuture, final ListOperationCallback<StampCapacityInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listCapacitiesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<StampCapacityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<StampCapacityInner>>> call(String nextPageLink) {
                    return listCapacitiesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StampCapacityInner&gt; object
     */
    public Observable<Page<StampCapacityInner>> listCapacitiesNextAsync(final String nextPageLink) {
        return listCapacitiesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<StampCapacityInner>>, Page<StampCapacityInner>>() {
                @Override
                public Page<StampCapacityInner> call(ServiceResponse<Page<StampCapacityInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;StampCapacityInner&gt; object
     */
    public Observable<ServiceResponse<Page<StampCapacityInner>>> listCapacitiesNextWithServiceResponseAsync(final String nextPageLink) {
        return listCapacitiesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<StampCapacityInner>>, Observable<ServiceResponse<Page<StampCapacityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<StampCapacityInner>>> call(ServiceResponse<Page<StampCapacityInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listCapacitiesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get the used, available, and total worker capacity an App Service Environment.
     * Get the used, available, and total worker capacity an App Service Environment.
     *
    ServiceResponse<PageImpl<StampCapacityInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;StampCapacityInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<StampCapacityInner>>> listCapacitiesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listCapacitiesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StampCapacityInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<StampCapacityInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<StampCapacityInner>> result = listCapacitiesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<StampCapacityInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<StampCapacityInner>> listCapacitiesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<StampCapacityInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<StampCapacityInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> changeVnetNext(final String nextPageLink) {
        ServiceResponse<Page<SiteInner>> response = changeVnetNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return changeVnetNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> changeVnetNextAsync(final String nextPageLink, final ServiceFuture<List<SiteInner>> serviceFuture, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            changeVnetNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return changeVnetNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> changeVnetNextAsync(final String nextPageLink) {
        return changeVnetNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> changeVnetNextWithServiceResponseAsync(final String nextPageLink) {
        return changeVnetNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(changeVnetNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> changeVnetNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.changeVnetNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = changeVnetNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> changeVnetNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException, InterruptedException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> beginChangeVnetNext(final String nextPageLink) {
        ServiceResponse<Page<SiteInner>> response = beginChangeVnetNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return beginChangeVnetNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> beginChangeVnetNextAsync(final String nextPageLink, final ServiceFuture<List<SiteInner>> serviceFuture, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginChangeVnetNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return beginChangeVnetNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> beginChangeVnetNextAsync(final String nextPageLink) {
        return beginChangeVnetNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginChangeVnetNextWithServiceResponseAsync(final String nextPageLink) {
        return beginChangeVnetNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginChangeVnetNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Move an App Service Environment to a different VNET.
     * Move an App Service Environment to a different VNET.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginChangeVnetNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.beginChangeVnetNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = beginChangeVnetNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> beginChangeVnetNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMetricsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMetricsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMetricsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricInner>> serviceFuture, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMetricsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMetricsNextAsync(final String nextPageLink) {
        return listMetricsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsNextWithServiceResponseAsync(final String nextPageLink) {
        return listMetricsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get global metrics of an App Service Environment.
     * Get global metrics of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMetricsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMetricsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listMetricsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WorkerPoolResourceInner&gt; object if successful.
     */
    public PagedList<WorkerPoolResourceInner> listMultiRolePoolsNext(final String nextPageLink) {
        ServiceResponse<Page<WorkerPoolResourceInner>> response = listMultiRolePoolsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WorkerPoolResourceInner>(response.body()) {
            @Override
            public Page<WorkerPoolResourceInner> nextPage(String nextPageLink) {
                return listMultiRolePoolsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WorkerPoolResourceInner>> listMultiRolePoolsNextAsync(final String nextPageLink, final ServiceFuture<List<WorkerPoolResourceInner>> serviceFuture, final ListOperationCallback<WorkerPoolResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(String nextPageLink) {
                    return listMultiRolePoolsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WorkerPoolResourceInner&gt; object
     */
    public Observable<Page<WorkerPoolResourceInner>> listMultiRolePoolsNextAsync(final String nextPageLink) {
        return listMultiRolePoolsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<WorkerPoolResourceInner>>, Page<WorkerPoolResourceInner>>() {
                @Override
                public Page<WorkerPoolResourceInner> call(ServiceResponse<Page<WorkerPoolResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WorkerPoolResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> listMultiRolePoolsNextWithServiceResponseAsync(final String nextPageLink) {
        return listMultiRolePoolsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<WorkerPoolResourceInner>>, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(ServiceResponse<Page<WorkerPoolResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all multi-role pools.
     * Get all multi-role pools.
     *
    ServiceResponse<PageImpl<WorkerPoolResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WorkerPoolResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> listMultiRolePoolsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMultiRolePoolsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WorkerPoolResourceInner>> result = listMultiRolePoolsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WorkerPoolResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WorkerPoolResourceInner>> listMultiRolePoolsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WorkerPoolResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WorkerPoolResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listMultiRolePoolInstanceMetricDefinitionsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listMultiRolePoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listMultiRolePoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listMultiRolePoolInstanceMetricDefinitionsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricDefinitionInner>> serviceFuture, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listMultiRolePoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listMultiRolePoolInstanceMetricDefinitionsNextAsync(final String nextPageLink) {
        return listMultiRolePoolInstanceMetricDefinitionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMultiRolePoolInstanceMetricDefinitionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listMultiRolePoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolInstanceMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     * Get metric definitions for a specific instance of a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMultiRolePoolInstanceMetricDefinitionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMultiRolePoolInstanceMetricDefinitionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listMultiRolePoolInstanceMetricDefinitionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listMultiRolePoolInstanceMetricDefinitionsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMultiRolePoolInstanceMetricsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMultiRolePoolInstanceMetricsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricInner>> serviceFuture, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMultiRolePoolInstanceMetricsNextAsync(final String nextPageLink) {
        return listMultiRolePoolInstanceMetricsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRolePoolInstanceMetricsNextWithServiceResponseAsync(final String nextPageLink) {
        return listMultiRolePoolInstanceMetricsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolInstanceMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     * Get metrics for a specific instance of a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRolePoolInstanceMetricsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMultiRolePoolInstanceMetricsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMultiRolePoolInstanceMetricsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listMultiRolePoolInstanceMetricsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listMultiRoleMetricDefinitionsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listMultiRoleMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listMultiRoleMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listMultiRoleMetricDefinitionsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricDefinitionInner>> serviceFuture, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRoleMetricDefinitionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listMultiRoleMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listMultiRoleMetricDefinitionsNextAsync(final String nextPageLink) {
        return listMultiRoleMetricDefinitionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMultiRoleMetricDefinitionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listMultiRoleMetricDefinitionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRoleMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metric definitions for a multi-role pool of an App Service Environment.
     * Get metric definitions for a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMultiRoleMetricDefinitionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMultiRoleMetricDefinitionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listMultiRoleMetricDefinitionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listMultiRoleMetricDefinitionsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMultiRoleMetricsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMultiRoleMetricsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMultiRoleMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMultiRoleMetricsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricInner>> serviceFuture, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRoleMetricsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMultiRoleMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMultiRoleMetricsNextAsync(final String nextPageLink) {
        return listMultiRoleMetricsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRoleMetricsNextWithServiceResponseAsync(final String nextPageLink) {
        return listMultiRoleMetricsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRoleMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a multi-role pool of an App Service Environment.
     * Get metrics for a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMultiRoleMetricsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMultiRoleMetricsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMultiRoleMetricsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listMultiRoleMetricsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SkuInfoInner&gt; object if successful.
     */
    public PagedList<SkuInfoInner> listMultiRolePoolSkusNext(final String nextPageLink) {
        ServiceResponse<Page<SkuInfoInner>> response = listMultiRolePoolSkusNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SkuInfoInner>(response.body()) {
            @Override
            public Page<SkuInfoInner> nextPage(String nextPageLink) {
                return listMultiRolePoolSkusNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SkuInfoInner>> listMultiRolePoolSkusNextAsync(final String nextPageLink, final ServiceFuture<List<SkuInfoInner>> serviceFuture, final ListOperationCallback<SkuInfoInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRolePoolSkusNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(String nextPageLink) {
                    return listMultiRolePoolSkusNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SkuInfoInner&gt; object
     */
    public Observable<Page<SkuInfoInner>> listMultiRolePoolSkusNextAsync(final String nextPageLink) {
        return listMultiRolePoolSkusNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SkuInfoInner>>, Page<SkuInfoInner>>() {
                @Override
                public Page<SkuInfoInner> call(ServiceResponse<Page<SkuInfoInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SkuInfoInner&gt; object
     */
    public Observable<ServiceResponse<Page<SkuInfoInner>>> listMultiRolePoolSkusNextWithServiceResponseAsync(final String nextPageLink) {
        return listMultiRolePoolSkusNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SkuInfoInner>>, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(ServiceResponse<Page<SkuInfoInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRolePoolSkusNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available SKUs for scaling a multi-role pool.
     * Get available SKUs for scaling a multi-role pool.
     *
    ServiceResponse<PageImpl<SkuInfoInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SkuInfoInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SkuInfoInner>>> listMultiRolePoolSkusNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMultiRolePoolSkusNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SkuInfoInner>> result = listMultiRolePoolSkusNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SkuInfoInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SkuInfoInner>> listMultiRolePoolSkusNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SkuInfoInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SkuInfoInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;UsageInner&gt; object if successful.
     */
    public PagedList<UsageInner> listMultiRoleUsagesNext(final String nextPageLink) {
        ServiceResponse<Page<UsageInner>> response = listMultiRoleUsagesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<UsageInner>(response.body()) {
            @Override
            public Page<UsageInner> nextPage(String nextPageLink) {
                return listMultiRoleUsagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageInner>> listMultiRoleUsagesNextAsync(final String nextPageLink, final ServiceFuture<List<UsageInner>> serviceFuture, final ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMultiRoleUsagesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                    return listMultiRoleUsagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<Page<UsageInner>> listMultiRoleUsagesNextAsync(final String nextPageLink) {
        return listMultiRoleUsagesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>() {
                @Override
                public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listMultiRoleUsagesNextWithServiceResponseAsync(final String nextPageLink) {
        return listMultiRoleUsagesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMultiRoleUsagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get usage metrics for a multi-role pool of an App Service Environment.
     * Get usage metrics for a multi-role pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<UsageInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;UsageInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listMultiRoleUsagesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listMultiRoleUsagesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageInner>> result = listMultiRoleUsagesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UsageInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UsageInner>> listMultiRoleUsagesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UsageInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UsageInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> resumeNext(final String nextPageLink) {
        ServiceResponse<Page<SiteInner>> response = resumeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return resumeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> resumeNextAsync(final String nextPageLink, final ServiceFuture<List<SiteInner>> serviceFuture, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            resumeNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return resumeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> resumeNextAsync(final String nextPageLink) {
        return resumeNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> resumeNextWithServiceResponseAsync(final String nextPageLink) {
        return resumeNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(resumeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> resumeNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.resumeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = resumeNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> resumeNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException, InterruptedException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> beginResumeNext(final String nextPageLink) {
        ServiceResponse<Page<SiteInner>> response = beginResumeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return beginResumeNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> beginResumeNextAsync(final String nextPageLink, final ServiceFuture<List<SiteInner>> serviceFuture, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginResumeNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return beginResumeNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> beginResumeNextAsync(final String nextPageLink) {
        return beginResumeNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginResumeNextWithServiceResponseAsync(final String nextPageLink) {
        return beginResumeNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginResumeNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Resume an App Service Environment.
     * Resume an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginResumeNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.beginResumeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = beginResumeNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> beginResumeNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServicePlanInner&gt; object if successful.
     */
    public PagedList<AppServicePlanInner> listAppServicePlansNext(final String nextPageLink) {
        ServiceResponse<Page<AppServicePlanInner>> response = listAppServicePlansNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServicePlanInner>(response.body()) {
            @Override
            public Page<AppServicePlanInner> nextPage(String nextPageLink) {
                return listAppServicePlansNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServicePlanInner>> listAppServicePlansNextAsync(final String nextPageLink, final ServiceFuture<List<AppServicePlanInner>> serviceFuture, final ListOperationCallback<AppServicePlanInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listAppServicePlansNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AppServicePlanInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServicePlanInner>>> call(String nextPageLink) {
                    return listAppServicePlansNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServicePlanInner&gt; object
     */
    public Observable<Page<AppServicePlanInner>> listAppServicePlansNextAsync(final String nextPageLink) {
        return listAppServicePlansNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AppServicePlanInner>>, Page<AppServicePlanInner>>() {
                @Override
                public Page<AppServicePlanInner> call(ServiceResponse<Page<AppServicePlanInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServicePlanInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServicePlanInner>>> listAppServicePlansNextWithServiceResponseAsync(final String nextPageLink) {
        return listAppServicePlansNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AppServicePlanInner>>, Observable<ServiceResponse<Page<AppServicePlanInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServicePlanInner>>> call(ServiceResponse<Page<AppServicePlanInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listAppServicePlansNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all App Service plans in an App Service Environment.
     * Get all App Service plans in an App Service Environment.
     *
    ServiceResponse<PageImpl<AppServicePlanInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServicePlanInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServicePlanInner>>> listAppServicePlansNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listAppServicePlansNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServicePlanInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServicePlanInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServicePlanInner>> result = listAppServicePlansNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServicePlanInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServicePlanInner>> listAppServicePlansNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServicePlanInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServicePlanInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> listWebAppsNext(final String nextPageLink) {
        ServiceResponse<Page<SiteInner>> response = listWebAppsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return listWebAppsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> listWebAppsNextAsync(final String nextPageLink, final ServiceFuture<List<SiteInner>> serviceFuture, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebAppsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return listWebAppsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> listWebAppsNextAsync(final String nextPageLink) {
        return listWebAppsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listWebAppsNextWithServiceResponseAsync(final String nextPageLink) {
        return listWebAppsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebAppsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all apps in an App Service Environment.
     * Get all apps in an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listWebAppsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listWebAppsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = listWebAppsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> listWebAppsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> suspendNext(final String nextPageLink) {
        ServiceResponse<Page<SiteInner>> response = suspendNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return suspendNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> suspendNextAsync(final String nextPageLink, final ServiceFuture<List<SiteInner>> serviceFuture, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            suspendNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return suspendNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> suspendNextAsync(final String nextPageLink) {
        return suspendNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> suspendNextWithServiceResponseAsync(final String nextPageLink) {
        return suspendNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(suspendNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> suspendNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.suspendNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = suspendNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> suspendNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException, InterruptedException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> beginSuspendNext(final String nextPageLink) {
        ServiceResponse<Page<SiteInner>> response = beginSuspendNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return beginSuspendNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> beginSuspendNextAsync(final String nextPageLink, final ServiceFuture<List<SiteInner>> serviceFuture, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            beginSuspendNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return beginSuspendNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> beginSuspendNextAsync(final String nextPageLink) {
        return beginSuspendNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginSuspendNextWithServiceResponseAsync(final String nextPageLink) {
        return beginSuspendNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(beginSuspendNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Suspend an App Service Environment.
     * Suspend an App Service Environment.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> beginSuspendNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.beginSuspendNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = beginSuspendNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> beginSuspendNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .register(202, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CsmUsageQuotaInner&gt; object if successful.
     */
    public PagedList<CsmUsageQuotaInner> listUsagesNext(final String nextPageLink) {
        ServiceResponse<Page<CsmUsageQuotaInner>> response = listUsagesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CsmUsageQuotaInner>(response.body()) {
            @Override
            public Page<CsmUsageQuotaInner> nextPage(String nextPageLink) {
                return listUsagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CsmUsageQuotaInner>> listUsagesNextAsync(final String nextPageLink, final ServiceFuture<List<CsmUsageQuotaInner>> serviceFuture, final ListOperationCallback<CsmUsageQuotaInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listUsagesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(String nextPageLink) {
                    return listUsagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmUsageQuotaInner&gt; object
     */
    public Observable<Page<CsmUsageQuotaInner>> listUsagesNextAsync(final String nextPageLink) {
        return listUsagesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<CsmUsageQuotaInner>>, Page<CsmUsageQuotaInner>>() {
                @Override
                public Page<CsmUsageQuotaInner> call(ServiceResponse<Page<CsmUsageQuotaInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CsmUsageQuotaInner&gt; object
     */
    public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> listUsagesNextWithServiceResponseAsync(final String nextPageLink) {
        return listUsagesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<CsmUsageQuotaInner>>, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(ServiceResponse<Page<CsmUsageQuotaInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listUsagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get global usage metrics of an App Service Environment.
     * Get global usage metrics of an App Service Environment.
     *
    ServiceResponse<PageImpl<CsmUsageQuotaInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CsmUsageQuotaInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> listUsagesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listUsagesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmUsageQuotaInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CsmUsageQuotaInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CsmUsageQuotaInner>> result = listUsagesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CsmUsageQuotaInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CsmUsageQuotaInner>> listUsagesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CsmUsageQuotaInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CsmUsageQuotaInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;WorkerPoolResourceInner&gt; object if successful.
     */
    public PagedList<WorkerPoolResourceInner> listWorkerPoolsNext(final String nextPageLink) {
        ServiceResponse<Page<WorkerPoolResourceInner>> response = listWorkerPoolsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WorkerPoolResourceInner>(response.body()) {
            @Override
            public Page<WorkerPoolResourceInner> nextPage(String nextPageLink) {
                return listWorkerPoolsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<WorkerPoolResourceInner>> listWorkerPoolsNextAsync(final String nextPageLink, final ServiceFuture<List<WorkerPoolResourceInner>> serviceFuture, final ListOperationCallback<WorkerPoolResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(String nextPageLink) {
                    return listWorkerPoolsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WorkerPoolResourceInner&gt; object
     */
    public Observable<Page<WorkerPoolResourceInner>> listWorkerPoolsNextAsync(final String nextPageLink) {
        return listWorkerPoolsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<WorkerPoolResourceInner>>, Page<WorkerPoolResourceInner>>() {
                @Override
                public Page<WorkerPoolResourceInner> call(ServiceResponse<Page<WorkerPoolResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;WorkerPoolResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> listWorkerPoolsNextWithServiceResponseAsync(final String nextPageLink) {
        return listWorkerPoolsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<WorkerPoolResourceInner>>, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(ServiceResponse<Page<WorkerPoolResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all worker pools of an App Service Environment.
     * Get all worker pools of an App Service Environment.
     *
    ServiceResponse<PageImpl<WorkerPoolResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;WorkerPoolResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> listWorkerPoolsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listWorkerPoolsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkerPoolResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<WorkerPoolResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<WorkerPoolResourceInner>> result = listWorkerPoolsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<WorkerPoolResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<WorkerPoolResourceInner>> listWorkerPoolsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<WorkerPoolResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<WorkerPoolResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listWorkerPoolInstanceMetricDefinitionsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listWorkerPoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listWorkerPoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listWorkerPoolInstanceMetricDefinitionsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricDefinitionInner>> serviceFuture, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listWorkerPoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listWorkerPoolInstanceMetricDefinitionsNextAsync(final String nextPageLink) {
        return listWorkerPoolInstanceMetricDefinitionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listWorkerPoolInstanceMetricDefinitionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listWorkerPoolInstanceMetricDefinitionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolInstanceMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     * Get metric definitions for a specific instance of a worker pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listWorkerPoolInstanceMetricDefinitionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listWorkerPoolInstanceMetricDefinitionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listWorkerPoolInstanceMetricDefinitionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listWorkerPoolInstanceMetricDefinitionsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listWorkerPoolInstanceMetricsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricInner>> response = listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listWorkerPoolInstanceMetricsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricInner>> serviceFuture, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listWorkerPoolInstanceMetricsNextAsync(final String nextPageLink) {
        return listWorkerPoolInstanceMetricsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWorkerPoolInstanceMetricsNextWithServiceResponseAsync(final String nextPageLink) {
        return listWorkerPoolInstanceMetricsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolInstanceMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     * Get metrics for a specific instance of a worker pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWorkerPoolInstanceMetricsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listWorkerPoolInstanceMetricsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listWorkerPoolInstanceMetricsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listWorkerPoolInstanceMetricsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listWebWorkerMetricDefinitionsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listWebWorkerMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listWebWorkerMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listWebWorkerMetricDefinitionsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricDefinitionInner>> serviceFuture, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebWorkerMetricDefinitionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listWebWorkerMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listWebWorkerMetricDefinitionsNextAsync(final String nextPageLink) {
        return listWebWorkerMetricDefinitionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listWebWorkerMetricDefinitionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listWebWorkerMetricDefinitionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebWorkerMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metric definitions for a worker pool of an App Service Environment.
     * Get metric definitions for a worker pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listWebWorkerMetricDefinitionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listWebWorkerMetricDefinitionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listWebWorkerMetricDefinitionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listWebWorkerMetricDefinitionsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listWebWorkerMetricsNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceMetricInner>> response = listWebWorkerMetricsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listWebWorkerMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listWebWorkerMetricsNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceMetricInner>> serviceFuture, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebWorkerMetricsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listWebWorkerMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listWebWorkerMetricsNextAsync(final String nextPageLink) {
        return listWebWorkerMetricsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWebWorkerMetricsNextWithServiceResponseAsync(final String nextPageLink) {
        return listWebWorkerMetricsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebWorkerMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     * Get metrics for a worker pool of a AppServiceEnvironment (App Service Environment).
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listWebWorkerMetricsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listWebWorkerMetricsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listWebWorkerMetricsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listWebWorkerMetricsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SkuInfoInner&gt; object if successful.
     */
    public PagedList<SkuInfoInner> listWorkerPoolSkusNext(final String nextPageLink) {
        ServiceResponse<Page<SkuInfoInner>> response = listWorkerPoolSkusNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SkuInfoInner>(response.body()) {
            @Override
            public Page<SkuInfoInner> nextPage(String nextPageLink) {
                return listWorkerPoolSkusNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SkuInfoInner>> listWorkerPoolSkusNextAsync(final String nextPageLink, final ServiceFuture<List<SkuInfoInner>> serviceFuture, final ListOperationCallback<SkuInfoInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWorkerPoolSkusNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(String nextPageLink) {
                    return listWorkerPoolSkusNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SkuInfoInner&gt; object
     */
    public Observable<Page<SkuInfoInner>> listWorkerPoolSkusNextAsync(final String nextPageLink) {
        return listWorkerPoolSkusNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SkuInfoInner>>, Page<SkuInfoInner>>() {
                @Override
                public Page<SkuInfoInner> call(ServiceResponse<Page<SkuInfoInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SkuInfoInner&gt; object
     */
    public Observable<ServiceResponse<Page<SkuInfoInner>>> listWorkerPoolSkusNextWithServiceResponseAsync(final String nextPageLink) {
        return listWorkerPoolSkusNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SkuInfoInner>>, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(ServiceResponse<Page<SkuInfoInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWorkerPoolSkusNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get available SKUs for scaling a worker pool.
     * Get available SKUs for scaling a worker pool.
     *
    ServiceResponse<PageImpl<SkuInfoInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SkuInfoInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SkuInfoInner>>> listWorkerPoolSkusNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listWorkerPoolSkusNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SkuInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SkuInfoInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SkuInfoInner>> result = listWorkerPoolSkusNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SkuInfoInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SkuInfoInner>> listWorkerPoolSkusNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SkuInfoInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SkuInfoInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;UsageInner&gt; object if successful.
     */
    public PagedList<UsageInner> listWebWorkerUsagesNext(final String nextPageLink) {
        ServiceResponse<Page<UsageInner>> response = listWebWorkerUsagesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<UsageInner>(response.body()) {
            @Override
            public Page<UsageInner> nextPage(String nextPageLink) {
                return listWebWorkerUsagesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<UsageInner>> listWebWorkerUsagesNextAsync(final String nextPageLink, final ServiceFuture<List<UsageInner>> serviceFuture, final ListOperationCallback<UsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listWebWorkerUsagesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(String nextPageLink) {
                    return listWebWorkerUsagesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<Page<UsageInner>> listWebWorkerUsagesNextAsync(final String nextPageLink) {
        return listWebWorkerUsagesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<UsageInner>>, Page<UsageInner>>() {
                @Override
                public Page<UsageInner> call(ServiceResponse<Page<UsageInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;UsageInner&gt; object
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listWebWorkerUsagesNextWithServiceResponseAsync(final String nextPageLink) {
        return listWebWorkerUsagesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<UsageInner>>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(ServiceResponse<Page<UsageInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listWebWorkerUsagesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get usage metrics for a worker pool of an App Service Environment.
     * Get usage metrics for a worker pool of an App Service Environment.
     *
    ServiceResponse<PageImpl<UsageInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;UsageInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<UsageInner>>> listWebWorkerUsagesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listWebWorkerUsagesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<UsageInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<UsageInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<UsageInner>> result = listWebWorkerUsagesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<UsageInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<UsageInner>> listWebWorkerUsagesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<UsageInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<UsageInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

}
