/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Slot Config names azure resource.
 */
@JsonFlatten
public class SlotConfigNamesResourceInner extends ProxyOnlyResource {
    /**
     * List of connection string names.
     */
    @JsonProperty(value = "properties.connectionStringNames")
    private List<String> connectionStringNames;

    /**
     * List of application settings names.
     */
    @JsonProperty(value = "properties.appSettingNames")
    private List<String> appSettingNames;

    /**
     * Get list of connection string names.
     *
     * @return the connectionStringNames value
     */
    public List<String> connectionStringNames() {
        return this.connectionStringNames;
    }

    /**
     * Set list of connection string names.
     *
     * @param connectionStringNames the connectionStringNames value to set
     * @return the SlotConfigNamesResourceInner object itself.
     */
    public SlotConfigNamesResourceInner withConnectionStringNames(List<String> connectionStringNames) {
        this.connectionStringNames = connectionStringNames;
        return this;
    }

    /**
     * Get list of application settings names.
     *
     * @return the appSettingNames value
     */
    public List<String> appSettingNames() {
        return this.appSettingNames;
    }

    /**
     * Set list of application settings names.
     *
     * @param appSettingNames the appSettingNames value to set
     * @return the SlotConfigNamesResourceInner object itself.
     */
    public SlotConfigNamesResourceInner withAppSettingNames(List<String> appSettingNames) {
        this.appSettingNames = appSettingNames;
        return this;
    }

}
