/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServiceCertificateKeyVaultBinding;
import com.microsoft.azure.management.appservice.AppServiceCertificateOrder;
import com.microsoft.azure.management.appservice.AppServiceDomain;
import com.microsoft.azure.management.appservice.CertificateDetails;
import com.microsoft.azure.management.appservice.CertificateOrderStatus;
import com.microsoft.azure.management.appservice.CertificateProductType;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.AppServiceCertificateKeyVaultBindingImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceCertificateOrderInner;
import com.microsoft.azure.management.appservice.implementation.AppServiceCertificateResourceInner;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.keyvault.SecretPermissions;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class AppServiceCertificateOrderImpl
extends GroupableResourceImpl<AppServiceCertificateOrder, AppServiceCertificateOrderInner, AppServiceCertificateOrderImpl, AppServiceManager>
implements AppServiceCertificateOrder,
AppServiceCertificateOrder.Definition,
AppServiceCertificateOrder.Update {
    private WebAppBase domainVerifyWebApp;
    private AppServiceDomain domainVerifyDomain;
    private Observable<Vault> bindingVault;

    AppServiceCertificateOrderImpl(String key, AppServiceCertificateOrderInner innerObject, AppServiceManager manager) {
        super(key, (Resource)innerObject, (ManagerBase)manager);
        ((AppServiceCertificateOrderImpl)this.withRegion("global")).withValidYears(1);
    }

    protected Observable<AppServiceCertificateOrderInner> getInnerAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).appServiceCertificateOrders().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public AppServiceCertificateKeyVaultBinding getKeyVaultBinding() {
        return (AppServiceCertificateKeyVaultBinding)this.getKeyVaultBindingAsync().toBlocking().single();
    }

    @Override
    public Observable<AppServiceCertificateKeyVaultBinding> getKeyVaultBindingAsync() {
        final AppServiceCertificateOrderImpl self = this;
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).appServiceCertificateOrders().listCertificatesAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<Page<AppServiceCertificateResourceInner>, AppServiceCertificateKeyVaultBinding>(){

            public AppServiceCertificateKeyVaultBinding call(Page<AppServiceCertificateResourceInner> appServiceCertificateInnerPage) {
                if (appServiceCertificateInnerPage.items() == null || appServiceCertificateInnerPage.items().isEmpty()) {
                    return null;
                }
                return new AppServiceCertificateKeyVaultBindingImpl((AppServiceCertificateResourceInner)((Object)appServiceCertificateInnerPage.items().get(0)), self);
            }
        });
    }

    @Override
    public void verifyDomainOwnership(AppServiceDomain domain) {
        this.verifyDomainOwnershipAsync(domain).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable verifyDomainOwnershipAsync(AppServiceDomain domain) {
        return domain.verifyDomainOwnershipAsync(this.name(), this.domainVerificationToken());
    }

    @Override
    public String distinguishedName() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).distinguishedName();
    }

    @Override
    public String domainVerificationToken() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).domainVerificationToken();
    }

    @Override
    public int validityInYears() {
        return Utils.toPrimitiveInt((Integer)((AppServiceCertificateOrderInner)((Object)this.inner())).validityInYears());
    }

    @Override
    public int keySize() {
        return Utils.toPrimitiveInt((Integer)((AppServiceCertificateOrderInner)((Object)this.inner())).keySize());
    }

    @Override
    public CertificateProductType productType() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).productType();
    }

    @Override
    public boolean autoRenew() {
        return Utils.toPrimitiveBoolean((Boolean)((AppServiceCertificateOrderInner)((Object)this.inner())).autoRenew());
    }

    @Override
    public CertificateOrderStatus status() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).status();
    }

    @Override
    public CertificateDetails signedCertificate() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).signedCertificate();
    }

    @Override
    public String certificateSigningRequest() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).csr();
    }

    @Override
    public CertificateDetails intermediate() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).intermediate();
    }

    @Override
    public CertificateDetails root() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).root();
    }

    @Override
    public String serialNumber() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).serialNumber();
    }

    @Override
    public DateTime lastCertificateIssuanceTime() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).lastCertificateIssuanceTime();
    }

    @Override
    public DateTime expirationTime() {
        return ((AppServiceCertificateOrderInner)((Object)this.inner())).expirationTime();
    }

    @Override
    public AppServiceCertificateKeyVaultBinding createKeyVaultBinding(String certificateName, Vault vault) {
        return (AppServiceCertificateKeyVaultBinding)this.createKeyVaultBindingAsync(certificateName, vault).toBlocking().single();
    }

    @Override
    public Observable<AppServiceCertificateKeyVaultBinding> createKeyVaultBindingAsync(String certificateName, Vault vault) {
        AppServiceCertificateResourceInner certInner = new AppServiceCertificateResourceInner();
        certInner.withLocation(vault.regionName());
        certInner.withKeyVaultId(vault.id());
        certInner.withKeyVaultSecretName(certificateName);
        final AppServiceCertificateOrderImpl self = this;
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).appServiceCertificateOrders().createOrUpdateCertificateAsync(this.resourceGroupName(), this.name(), certificateName, certInner).map((Func1)new Func1<AppServiceCertificateResourceInner, AppServiceCertificateKeyVaultBinding>(){

            public AppServiceCertificateKeyVaultBinding call(AppServiceCertificateResourceInner appServiceCertificateInner) {
                return new AppServiceCertificateKeyVaultBindingImpl(appServiceCertificateInner, self);
            }
        });
    }

    @Override
    public AppServiceCertificateOrderImpl withHostName(String hostName) {
        ((AppServiceCertificateOrderInner)((Object)this.inner())).withDistinguishedName("CN=" + hostName);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withStandardSku() {
        ((AppServiceCertificateOrderInner)((Object)this.inner())).withProductType(CertificateProductType.STANDARD_DOMAIN_VALIDATED_SSL);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withWildcardSku() {
        ((AppServiceCertificateOrderInner)((Object)this.inner())).withProductType(CertificateProductType.STANDARD_DOMAIN_VALIDATED_WILD_CARD_SSL);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withValidYears(int years) {
        ((AppServiceCertificateOrderInner)((Object)this.inner())).withValidityInYears(years);
        return this;
    }

    public Observable<AppServiceCertificateOrder> createResourceAsync() {
        final AppServiceCertificateOrderImpl self = this;
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).appServiceCertificateOrders().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AppServiceCertificateOrderInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap((Func1)new Func1<AppServiceCertificateOrder, Observable<Void>>(){

            public Observable<Void> call(AppServiceCertificateOrder certificateOrder) {
                if (AppServiceCertificateOrderImpl.this.domainVerifyWebApp != null) {
                    return AppServiceCertificateOrderImpl.this.domainVerifyWebApp.verifyDomainOwnershipAsync(AppServiceCertificateOrderImpl.this.name(), AppServiceCertificateOrderImpl.this.domainVerificationToken()).toObservable();
                }
                if (AppServiceCertificateOrderImpl.this.domainVerifyDomain != null) {
                    return AppServiceCertificateOrderImpl.this.domainVerifyDomain.verifyDomainOwnershipAsync(AppServiceCertificateOrderImpl.this.name(), AppServiceCertificateOrderImpl.this.domainVerificationToken()).toObservable();
                }
                throw new IllegalArgumentException("Please specify a non-null web app or domain to verify the domain ownership for hostname " + AppServiceCertificateOrderImpl.this.distinguishedName());
            }
        }).flatMap((Func1)new Func1<Void, Observable<AppServiceCertificateKeyVaultBinding>>(){

            public Observable<AppServiceCertificateKeyVaultBinding> call(Void aVoid) {
                return AppServiceCertificateOrderImpl.this.bindingVault.flatMap((Func1)new Func1<Vault, Observable<AppServiceCertificateKeyVaultBinding>>(){

                    public Observable<AppServiceCertificateKeyVaultBinding> call(Vault vault) {
                        return AppServiceCertificateOrderImpl.this.createKeyVaultBindingAsync(AppServiceCertificateOrderImpl.this.name(), vault);
                    }
                });
            }
        }).map((Func1)new Func1<AppServiceCertificateKeyVaultBinding, AppServiceCertificateOrder>(){

            public AppServiceCertificateOrder call(AppServiceCertificateKeyVaultBinding appServiceCertificateKeyVaultBinding) {
                return self;
            }
        });
    }

    @Override
    public AppServiceCertificateOrderImpl withAutoRenew(boolean enabled) {
        ((AppServiceCertificateOrderInner)((Object)this.inner())).withAutoRenew(enabled);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withDomainVerification(AppServiceDomain domain) {
        this.domainVerifyDomain = domain;
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withWebAppVerification(WebAppBase webApp) {
        this.domainVerifyWebApp = webApp;
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withExistingKeyVault(Vault vault) {
        this.bindingVault = Observable.just((Object)vault);
        return this;
    }

    @Override
    public AppServiceCertificateOrderImpl withNewKeyVault(String vaultName, Region region) {
        Observable resourceStream = ((Vault.DefinitionStages.WithCreate)((Vault.DefinitionStages.WithCreate)((Vault.DefinitionStages.WithAccessPolicy)((Vault.DefinitionStages.WithGroup)((Vault.DefinitionStages.Blank)((AppServiceManager)this.myManager).keyVaultManager().vaults().define(vaultName)).withRegion(region)).withExistingResourceGroup(this.resourceGroupName())).defineAccessPolicy().forServicePrincipal("f3c21649-0979-4721-ac85-b0216b2cf413").allowSecretPermissions(new SecretPermissions[]{SecretPermissions.GET, SecretPermissions.SET, SecretPermissions.DELETE}).attach()).defineAccessPolicy().forServicePrincipal("abfa0a7c-a6b6-4736-8310-5855508787cd").allowSecretPermissions(new SecretPermissions[]{SecretPermissions.GET}).attach()).createAsync();
        this.bindingVault = Utils.rootResource((Observable)resourceStream);
        return this;
    }
}

