/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionApps;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.FunctionAppImpl;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class FunctionAppsImpl
extends TopLevelModifiableResourcesImpl<FunctionApp, FunctionAppImpl, SiteInner, WebAppsInner, AppServiceManager>
implements FunctionApps {
    private final PagedListConverter<SiteInner, FunctionApp> converter;

    FunctionAppsImpl(final AppServiceManager manager) {
        super((InnerSupportsListing)((WebSiteManagementClientImpl)((Object)manager.inner())).webApps(), (ManagerBase)manager);
        this.converter = new PagedListConverter<SiteInner, FunctionApp>(){

            public Observable<FunctionApp> typeConvertAsync(final SiteInner siteInner) {
                return ((WebSiteManagementClientImpl)((Object)manager.inner())).webApps().getConfigurationAsync(siteInner.resourceGroup(), siteInner.name()).subscribeOn(SdkContext.getRxScheduler()).map((Func1)new Func1<SiteConfigResourceInner, FunctionApp>(){

                    public FunctionApp call(SiteConfigResourceInner siteConfigResourceInner) {
                        return FunctionAppsImpl.this.wrapModel(siteInner, siteConfigResourceInner);
                    }
                });
            }

            protected boolean filter(SiteInner inner) {
                return "functionapp".equalsIgnoreCase(inner.kind());
            }
        };
    }

    public FunctionApp getByResourceGroup(String groupName, String name) {
        SiteInner siteInner = ((WebAppsInner)this.inner()).getByResourceGroup(groupName, name);
        if (siteInner == null) {
            return null;
        }
        return this.wrapModel(siteInner, ((WebAppsInner)this.inner()).getConfiguration(groupName, name));
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsInner)this.inner()).deleteAsync(resourceGroupName, name).toCompletable();
    }

    protected FunctionAppImpl wrapModel(String name) {
        return new FunctionAppImpl(name, new SiteInner().withKind("functionapp"), null, (AppServiceManager)this.manager());
    }

    protected FunctionAppImpl wrapModel(SiteInner inner) {
        if (inner == null) {
            return null;
        }
        return this.wrapModel(inner, null);
    }

    private FunctionAppImpl wrapModel(SiteInner inner, SiteConfigResourceInner configResourceInner) {
        if (inner == null) {
            return null;
        }
        return new FunctionAppImpl(inner.name(), inner, configResourceInner, (AppServiceManager)this.manager());
    }

    protected PagedList<FunctionApp> wrapList(PagedList<SiteInner> pagedList) {
        return this.converter.convert(pagedList);
    }

    public FunctionAppImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByResourceGroupAsync(String groupName, String name) {
        return ((WebAppsInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }
}

