/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A deleted app.
 */
public class DeletedSiteInner {
    /**
     * Numeric id for the deleted site.
     */
    @JsonProperty(value = "deletedSiteId")
    private Integer deletedSiteId;

    /**
     * Time in UTC when the app was deleted.
     */
    @JsonProperty(value = "deletedTimestamp", access = JsonProperty.Access.WRITE_ONLY)
    private String deletedTimestamp;

    /**
     * Subscription containing the deleted site.
     */
    @JsonProperty(value = "subscription", access = JsonProperty.Access.WRITE_ONLY)
    private String subscription;

    /**
     * ResourceGroup that contained the deleted site.
     */
    @JsonProperty(value = "resourceGroup", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceGroup;

    /**
     * Name of the deleted site.
     */
    @JsonProperty(value = "deletedSiteName", access = JsonProperty.Access.WRITE_ONLY)
    private String deletedSiteName;

    /**
     * Slot of the deleted site.
     */
    @JsonProperty(value = "slot", access = JsonProperty.Access.WRITE_ONLY)
    private String slot;

    /**
     * Get numeric id for the deleted site.
     *
     * @return the deletedSiteId value
     */
    public Integer deletedSiteId() {
        return this.deletedSiteId;
    }

    /**
     * Set numeric id for the deleted site.
     *
     * @param deletedSiteId the deletedSiteId value to set
     * @return the DeletedSiteInner object itself.
     */
    public DeletedSiteInner withDeletedSiteId(Integer deletedSiteId) {
        this.deletedSiteId = deletedSiteId;
        return this;
    }

    /**
     * Get time in UTC when the app was deleted.
     *
     * @return the deletedTimestamp value
     */
    public String deletedTimestamp() {
        return this.deletedTimestamp;
    }

    /**
     * Get subscription containing the deleted site.
     *
     * @return the subscription value
     */
    public String subscription() {
        return this.subscription;
    }

    /**
     * Get resourceGroup that contained the deleted site.
     *
     * @return the resourceGroup value
     */
    public String resourceGroup() {
        return this.resourceGroup;
    }

    /**
     * Get name of the deleted site.
     *
     * @return the deletedSiteName value
     */
    public String deletedSiteName() {
        return this.deletedSiteName;
    }

    /**
     * Get slot of the deleted site.
     *
     * @return the slot value
     */
    public String slot() {
        return this.slot;
    }

}
