/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionApps;
import com.microsoft.azure.management.appservice.FunctionEnvelope;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.FunctionAppImpl;
import com.microsoft.azure.management.appservice.implementation.FunctionEnvelopeImpl;
import com.microsoft.azure.management.appservice.implementation.FunctionEnvelopeInner;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class FunctionAppsImpl
extends TopLevelModifiableResourcesImpl<FunctionApp, FunctionAppImpl, SiteInner, WebAppsInner, AppServiceManager>
implements FunctionApps {
    private final PagedListConverter<SiteInner, FunctionApp> converter = new PagedListConverter<SiteInner, FunctionApp>(){

        public Observable<FunctionApp> typeConvertAsync(final SiteInner siteInner) {
            return Observable.zip(((WebSiteManagementClientImpl)((Object)((AppServiceManager)FunctionAppsImpl.this.manager()).inner())).webApps().getConfigurationAsync(siteInner.resourceGroup(), siteInner.name()), ((WebSiteManagementClientImpl)((Object)((AppServiceManager)FunctionAppsImpl.this.manager()).inner())).webApps().getDiagnosticLogsConfigurationAsync(siteInner.resourceGroup(), siteInner.name()), (Func2)new Func2<SiteConfigResourceInner, SiteLogsConfigInner, FunctionApp>(){

                public FunctionApp call(SiteConfigResourceInner siteConfigResourceInner, SiteLogsConfigInner logsConfigInner) {
                    return FunctionAppsImpl.this.wrapModel(siteInner, siteConfigResourceInner, logsConfigInner);
                }
            });
        }

        protected boolean filter(SiteInner inner) {
            return "functionapp".equalsIgnoreCase(inner.kind());
        }
    };

    FunctionAppsImpl(AppServiceManager manager) {
        super((InnerSupportsListing)((WebSiteManagementClientImpl)((Object)manager.inner())).webApps(), (ManagerBase)manager);
    }

    public FunctionApp getByResourceGroup(String groupName, String name) {
        SiteInner siteInner = ((WebAppsInner)this.inner()).getByResourceGroup(groupName, name);
        if (siteInner == null) {
            return null;
        }
        return this.wrapModel(siteInner, ((WebAppsInner)this.inner()).getConfiguration(groupName, name), ((WebAppsInner)this.inner()).getDiagnosticLogsConfiguration(groupName, name));
    }

    public Observable<FunctionApp> getByResourceGroupAsync(final String groupName, final String name) {
        final FunctionAppsImpl self = this;
        return ((WebAppsInner)this.inner()).getByResourceGroupAsync(groupName, name).flatMap((Func1)new Func1<SiteInner, Observable<FunctionApp>>(){

            public Observable<FunctionApp> call(final SiteInner siteInner) {
                if (siteInner == null) {
                    return null;
                }
                return Observable.zip(((WebAppsInner)self.inner()).getConfigurationAsync(groupName, name), ((WebAppsInner)self.inner()).getDiagnosticLogsConfigurationAsync(groupName, name), (Func2)new Func2<SiteConfigResourceInner, SiteLogsConfigInner, FunctionApp>(){

                    public FunctionApp call(SiteConfigResourceInner siteConfigResourceInner, SiteLogsConfigInner logsConfigInner) {
                        return FunctionAppsImpl.this.wrapModel(siteInner, siteConfigResourceInner, logsConfigInner);
                    }
                });
            }
        });
    }

    @Override
    public PagedList<FunctionEnvelope> listFunctions(String resourceGroupName, String name) {
        return new PagedListConverter<FunctionEnvelopeInner, FunctionEnvelope>(){

            public Observable<FunctionEnvelope> typeConvertAsync(FunctionEnvelopeInner functionEnvelopeInner) {
                return Observable.just((Object)new FunctionEnvelopeImpl(functionEnvelopeInner));
            }
        }.convert(((WebAppsInner)((AppServiceManager)this.manager()).webApps().inner()).listFunctions(resourceGroupName, name));
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((WebAppsInner)this.inner()).deleteAsync(resourceGroupName, name).toCompletable();
    }

    protected FunctionAppImpl wrapModel(String name) {
        return new FunctionAppImpl(name, new SiteInner().withKind("functionapp"), null, null, (AppServiceManager)this.manager());
    }

    protected FunctionAppImpl wrapModel(SiteInner inner) {
        if (inner == null) {
            return null;
        }
        return this.wrapModel(inner, null, null);
    }

    private FunctionAppImpl wrapModel(SiteInner inner, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig) {
        if (inner == null) {
            return null;
        }
        return new FunctionAppImpl(inner.name(), inner, siteConfig, logConfig, (AppServiceManager)this.manager());
    }

    protected PagedList<FunctionApp> wrapList(PagedList<SiteInner> pagedList) {
        return this.converter.convert(pagedList);
    }

    public FunctionAppImpl define(String name) {
        return this.wrapModel(name);
    }

    public Completable deleteByResourceGroupAsync(String groupName, String name) {
        return ((WebAppsInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }
}

