/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Container settings validation request context.
 */
public class ValidateContainerSettingsRequest {
    /**
     * Base URL of the container registry.
     */
    @JsonProperty(value = "baseUrl")
    private String baseUrl;

    /**
     * Username for to access the container registry.
     */
    @JsonProperty(value = "username")
    private String username;

    /**
     * Password for to access the container registry.
     */
    @JsonProperty(value = "password")
    private String password;

    /**
     * Repository name (image name).
     */
    @JsonProperty(value = "repository")
    private String repository;

    /**
     * Image tag.
     */
    @JsonProperty(value = "tag")
    private String tag;

    /**
     * Platform (windows or linux).
     */
    @JsonProperty(value = "platform")
    private String platform;

    /**
     * Get base URL of the container registry.
     *
     * @return the baseUrl value
     */
    public String baseUrl() {
        return this.baseUrl;
    }

    /**
     * Set base URL of the container registry.
     *
     * @param baseUrl the baseUrl value to set
     * @return the ValidateContainerSettingsRequest object itself.
     */
    public ValidateContainerSettingsRequest withBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    /**
     * Get username for to access the container registry.
     *
     * @return the username value
     */
    public String username() {
        return this.username;
    }

    /**
     * Set username for to access the container registry.
     *
     * @param username the username value to set
     * @return the ValidateContainerSettingsRequest object itself.
     */
    public ValidateContainerSettingsRequest withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get password for to access the container registry.
     *
     * @return the password value
     */
    public String password() {
        return this.password;
    }

    /**
     * Set password for to access the container registry.
     *
     * @param password the password value to set
     * @return the ValidateContainerSettingsRequest object itself.
     */
    public ValidateContainerSettingsRequest withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get repository name (image name).
     *
     * @return the repository value
     */
    public String repository() {
        return this.repository;
    }

    /**
     * Set repository name (image name).
     *
     * @param repository the repository value to set
     * @return the ValidateContainerSettingsRequest object itself.
     */
    public ValidateContainerSettingsRequest withRepository(String repository) {
        this.repository = repository;
        return this;
    }

    /**
     * Get image tag.
     *
     * @return the tag value
     */
    public String tag() {
        return this.tag;
    }

    /**
     * Set image tag.
     *
     * @param tag the tag value to set
     * @return the ValidateContainerSettingsRequest object itself.
     */
    public ValidateContainerSettingsRequest withTag(String tag) {
        this.tag = tag;
        return this;
    }

    /**
     * Get platform (windows or linux).
     *
     * @return the platform value
     */
    public String platform() {
        return this.platform;
    }

    /**
     * Set platform (windows or linux).
     *
     * @param platform the platform value to set
     * @return the ValidateContainerSettingsRequest object itself.
     */
    public ValidateContainerSettingsRequest withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

}
