/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.appservice.AppServiceCertificateOrderPatchResource;
import com.microsoft.azure.management.appservice.AppServiceCertificatePatchResource;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.ReissueCertificateOrderRequest;
import com.microsoft.azure.management.appservice.RenewCertificateOrderRequest;
import com.microsoft.azure.management.appservice.SiteSealRequest;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in AppServiceCertificateOrders.
 */
public class AppServiceCertificateOrdersInner implements InnerSupportsGet<AppServiceCertificateOrderInner>, InnerSupportsDelete<Void>, InnerSupportsListing<AppServiceCertificateOrderInner> {
    /** The Retrofit service to perform REST calls. */
    private AppServiceCertificateOrdersService service;
    /** The service client containing this operation class. */
    private WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of AppServiceCertificateOrdersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public AppServiceCertificateOrdersInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = retrofit.create(AppServiceCertificateOrdersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for AppServiceCertificateOrders to be
     * used by Retrofit to perform actually REST calls.
     */
    interface AppServiceCertificateOrdersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/certificateOrders")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders validatePurchaseInformation" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/validateCertificateRegistrationInformation")
        Observable<Response<ResponseBody>> validatePurchaseInformation(@Path("subscriptionId") String subscriptionId, @Body AppServiceCertificateOrderInner appServiceCertificateOrder, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Body AppServiceCertificateOrderInner certificateDistinguishedName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Body AppServiceCertificateOrderInner certificateDistinguishedName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Body AppServiceCertificateOrderPatchResource certificateDistinguishedName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listCertificates" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates")
        Observable<Response<ResponseBody>> listCertificates(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders getCertificate" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        Observable<Response<ResponseBody>> getCertificate(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders createOrUpdateCertificate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        Observable<Response<ResponseBody>> createOrUpdateCertificate(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body AppServiceCertificateResourceInner keyVaultCertificate, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders beginCreateOrUpdateCertificate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        Observable<Response<ResponseBody>> beginCreateOrUpdateCertificate(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body AppServiceCertificateResourceInner keyVaultCertificate, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders deleteCertificate" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteCertificate(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders updateCertificate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        Observable<Response<ResponseBody>> updateCertificate(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body AppServiceCertificatePatchResource keyVaultCertificate, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders reissue" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/reissue")
        Observable<Response<ResponseBody>> reissue(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Body ReissueCertificateOrderRequest reissueCertificateOrderRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders renew" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/renew")
        Observable<Response<ResponseBody>> renew(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Body RenewCertificateOrderRequest renewCertificateOrderRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders resendEmail" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendEmail")
        Observable<Response<ResponseBody>> resendEmail(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders resendRequestEmails" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendRequestEmails")
        Observable<Response<ResponseBody>> resendRequestEmails(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body NameIdentifierInner nameIdentifier, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders retrieveSiteSeal" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/retrieveSiteSeal")
        Observable<Response<ResponseBody>> retrieveSiteSeal(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Body SiteSealRequest siteSealRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders verifyDomainOwnership" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/verifyDomainOwnership")
        Observable<Response<ResponseBody>> verifyDomainOwnership(@Path("resourceGroupName") String resourceGroupName, @Path("certificateOrderName") String certificateOrderName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders retrieveCertificateActions" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions")
        Observable<Response<ResponseBody>> retrieveCertificateActions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders retrieveCertificateEmailHistory" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory")
        Observable<Response<ResponseBody>> retrieveCertificateEmailHistory(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listCertificatesNext" })
        @GET
        Observable<Response<ResponseBody>> listCertificatesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceCertificateOrderInner&gt; object if successful.
     */
    public PagedList<AppServiceCertificateOrderInner> list() {
        ServiceResponse<Page<AppServiceCertificateOrderInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<AppServiceCertificateOrderInner>(response.body()) {
            @Override
            public Page<AppServiceCertificateOrderInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceCertificateOrderInner>> listAsync(final ListOperationCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateOrderInner&gt; object
     */
    public Observable<Page<AppServiceCertificateOrderInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Page<AppServiceCertificateOrderInner>>() {
                @Override
                public Page<AppServiceCertificateOrderInner> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateOrderInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceCertificateOrderInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceCertificateOrderInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceCertificateOrderInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceCertificateOrderInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Validate information for a certificate order.
     * Validate information for a certificate order.
     *
     * @param appServiceCertificateOrder Information for a certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void validatePurchaseInformation(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        validatePurchaseInformationWithServiceResponseAsync(appServiceCertificateOrder).toBlocking().single().body();
    }

    /**
     * Validate information for a certificate order.
     * Validate information for a certificate order.
     *
     * @param appServiceCertificateOrder Information for a certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> validatePurchaseInformationAsync(AppServiceCertificateOrderInner appServiceCertificateOrder, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(validatePurchaseInformationWithServiceResponseAsync(appServiceCertificateOrder), serviceCallback);
    }

    /**
     * Validate information for a certificate order.
     * Validate information for a certificate order.
     *
     * @param appServiceCertificateOrder Information for a certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> validatePurchaseInformationAsync(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        return validatePurchaseInformationWithServiceResponseAsync(appServiceCertificateOrder).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Validate information for a certificate order.
     * Validate information for a certificate order.
     *
     * @param appServiceCertificateOrder Information for a certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> validatePurchaseInformationWithServiceResponseAsync(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (appServiceCertificateOrder == null) {
            throw new IllegalArgumentException("Parameter appServiceCertificateOrder is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(appServiceCertificateOrder);
        return service.validatePurchaseInformation(this.client.subscriptionId(), appServiceCertificateOrder, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = validatePurchaseInformationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> validatePurchaseInformationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceCertificateOrderInner&gt; object if successful.
     */
    public PagedList<AppServiceCertificateOrderInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<AppServiceCertificateOrderInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<AppServiceCertificateOrderInner>(response.body()) {
            @Override
            public Page<AppServiceCertificateOrderInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceCertificateOrderInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateOrderInner&gt; object
     */
    public Observable<Page<AppServiceCertificateOrderInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Page<AppServiceCertificateOrderInner>>() {
                @Override
                public Page<AppServiceCertificateOrderInner> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateOrderInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
    ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceCertificateOrderInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceCertificateOrderInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceCertificateOrderInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceCertificateOrderInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get a certificate order.
     * Get a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order..
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceCertificateOrderInner object if successful.
     */
    public AppServiceCertificateOrderInner getByResourceGroup(String resourceGroupName, String certificateOrderName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single().body();
    }

    /**
     * Get a certificate order.
     * Get a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order..
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceCertificateOrderInner> getByResourceGroupAsync(String resourceGroupName, String certificateOrderName, final ServiceCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    /**
     * Get a certificate order.
     * Get a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order..
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateOrderInner object
     */
    public Observable<AppServiceCertificateOrderInner> getByResourceGroupAsync(String resourceGroupName, String certificateOrderName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, certificateOrderName).map(new Func1<ServiceResponse<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner>() {
            @Override
            public AppServiceCertificateOrderInner call(ServiceResponse<AppServiceCertificateOrderInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get a certificate order.
     * Get a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order..
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateOrderInner object
     */
    public Observable<ServiceResponse<AppServiceCertificateOrderInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateOrderInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceCertificateOrderInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceCertificateOrderInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceCertificateOrderInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceCertificateOrderInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceCertificateOrderInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceCertificateOrderInner object if successful.
     */
    public AppServiceCertificateOrderInner createOrUpdate(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).toBlocking().last().body();
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceCertificateOrderInner> createOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, final ServiceCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName), serviceCallback);
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AppServiceCertificateOrderInner> createOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).map(new Func1<ServiceResponse<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner>() {
            @Override
            public AppServiceCertificateOrderInner call(ServiceResponse<AppServiceCertificateOrderInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AppServiceCertificateOrderInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (certificateDistinguishedName == null) {
            throw new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(certificateDistinguishedName);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, certificateOrderName, this.client.subscriptionId(), certificateDistinguishedName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AppServiceCertificateOrderInner>() { }.getType());
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceCertificateOrderInner object if successful.
     */
    public AppServiceCertificateOrderInner beginCreateOrUpdate(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).toBlocking().single().body();
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceCertificateOrderInner> beginCreateOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, final ServiceCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName), serviceCallback);
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateOrderInner object
     */
    public Observable<AppServiceCertificateOrderInner> beginCreateOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).map(new Func1<ServiceResponse<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner>() {
            @Override
            public AppServiceCertificateOrderInner call(ServiceResponse<AppServiceCertificateOrderInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateOrderInner object
     */
    public Observable<ServiceResponse<AppServiceCertificateOrderInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (certificateDistinguishedName == null) {
            throw new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(certificateDistinguishedName);
        return service.beginCreateOrUpdate(resourceGroupName, certificateOrderName, this.client.subscriptionId(), certificateDistinguishedName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateOrderInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceCertificateOrderInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceCertificateOrderInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceCertificateOrderInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceCertificateOrderInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceCertificateOrderInner>() { }.getType())
                .register(201, new TypeToken<AppServiceCertificateOrderInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Delete an existing certificate order.
     * Delete an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String certificateOrderName) {
        deleteWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single().body();
    }

    /**
     * Delete an existing certificate order.
     * Delete an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String certificateOrderName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    /**
     * Delete an existing certificate order.
     * Delete an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String certificateOrderName) {
        return deleteWithServiceResponseAsync(resourceGroupName, certificateOrderName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete an existing certificate order.
     * Delete an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceCertificateOrderInner object if successful.
     */
    public AppServiceCertificateOrderInner update(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        return updateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).toBlocking().single().body();
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceCertificateOrderInner> updateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName, final ServiceCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName), serviceCallback);
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateOrderInner object
     */
    public Observable<AppServiceCertificateOrderInner> updateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        return updateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).map(new Func1<ServiceResponse<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner>() {
            @Override
            public AppServiceCertificateOrderInner call(ServiceResponse<AppServiceCertificateOrderInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update a certificate purchase order.
     * Create or update a certificate purchase order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param certificateDistinguishedName Distinguished name to use for the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateOrderInner object
     */
    public Observable<ServiceResponse<AppServiceCertificateOrderInner>> updateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (certificateDistinguishedName == null) {
            throw new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(certificateDistinguishedName);
        return service.update(resourceGroupName, certificateOrderName, this.client.subscriptionId(), certificateDistinguishedName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateOrderInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceCertificateOrderInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceCertificateOrderInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceCertificateOrderInner> updateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceCertificateOrderInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceCertificateOrderInner>() { }.getType())
                .register(201, new TypeToken<AppServiceCertificateOrderInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceCertificateResourceInner&gt; object if successful.
     */
    public PagedList<AppServiceCertificateResourceInner> listCertificates(final String resourceGroupName, final String certificateOrderName) {
        ServiceResponse<Page<AppServiceCertificateResourceInner>> response = listCertificatesSinglePageAsync(resourceGroupName, certificateOrderName).toBlocking().single();
        return new PagedList<AppServiceCertificateResourceInner>(response.body()) {
            @Override
            public Page<AppServiceCertificateResourceInner> nextPage(String nextPageLink) {
                return listCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceCertificateResourceInner>> listCertificatesAsync(final String resourceGroupName, final String certificateOrderName, final ListOperationCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listCertificatesSinglePageAsync(resourceGroupName, certificateOrderName),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(String nextPageLink) {
                    return listCertificatesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateResourceInner&gt; object
     */
    public Observable<Page<AppServiceCertificateResourceInner>> listCertificatesAsync(final String resourceGroupName, final String certificateOrderName) {
        return listCertificatesWithServiceResponseAsync(resourceGroupName, certificateOrderName)
            .map(new Func1<ServiceResponse<Page<AppServiceCertificateResourceInner>>, Page<AppServiceCertificateResourceInner>>() {
                @Override
                public Page<AppServiceCertificateResourceInner> call(ServiceResponse<Page<AppServiceCertificateResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> listCertificatesWithServiceResponseAsync(final String resourceGroupName, final String certificateOrderName) {
        return listCertificatesSinglePageAsync(resourceGroupName, certificateOrderName)
            .concatMap(new Func1<ServiceResponse<Page<AppServiceCertificateResourceInner>>, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(ServiceResponse<Page<AppServiceCertificateResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listCertificatesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
    ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceCertificateResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> listCertificatesSinglePageAsync(final String resourceGroupName, final String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listCertificates(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> result = listCertificatesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceCertificateResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> listCertificatesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceCertificateResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceCertificateResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get the certificate associated with a certificate order.
     * Get the certificate associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceCertificateResourceInner object if successful.
     */
    public AppServiceCertificateResourceInner getCertificate(String resourceGroupName, String certificateOrderName, String name) {
        return getCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).toBlocking().single().body();
    }

    /**
     * Get the certificate associated with a certificate order.
     * Get the certificate associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceCertificateResourceInner> getCertificateAsync(String resourceGroupName, String certificateOrderName, String name, final ServiceCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name), serviceCallback);
    }

    /**
     * Get the certificate associated with a certificate order.
     * Get the certificate associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateResourceInner object
     */
    public Observable<AppServiceCertificateResourceInner> getCertificateAsync(String resourceGroupName, String certificateOrderName, String name) {
        return getCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).map(new Func1<ServiceResponse<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner>() {
            @Override
            public AppServiceCertificateResourceInner call(ServiceResponse<AppServiceCertificateResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the certificate associated with a certificate order.
     * Get the certificate associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateResourceInner object
     */
    public Observable<ServiceResponse<AppServiceCertificateResourceInner>> getCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceCertificateResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceCertificateResourceInner> clientResponse = getCertificateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceCertificateResourceInner> getCertificateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceCertificateResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceCertificateResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceCertificateResourceInner object if successful.
     */
    public AppServiceCertificateResourceInner createOrUpdateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return createOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).toBlocking().last().body();
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceCertificateResourceInner> createOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, final ServiceCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate), serviceCallback);
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<AppServiceCertificateResourceInner> createOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return createOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).map(new Func1<ServiceResponse<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner>() {
            @Override
            public AppServiceCertificateResourceInner call(ServiceResponse<AppServiceCertificateResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<AppServiceCertificateResourceInner>> createOrUpdateCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (keyVaultCertificate == null) {
            throw new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(keyVaultCertificate);
        Observable<Response<ResponseBody>> observable = service.createOrUpdateCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), keyVaultCertificate, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AppServiceCertificateResourceInner>() { }.getType());
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceCertificateResourceInner object if successful.
     */
    public AppServiceCertificateResourceInner beginCreateOrUpdateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return beginCreateOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).toBlocking().single().body();
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceCertificateResourceInner> beginCreateOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, final ServiceCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate), serviceCallback);
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateResourceInner object
     */
    public Observable<AppServiceCertificateResourceInner> beginCreateOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return beginCreateOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).map(new Func1<ServiceResponse<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner>() {
            @Override
            public AppServiceCertificateResourceInner call(ServiceResponse<AppServiceCertificateResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateResourceInner object
     */
    public Observable<ServiceResponse<AppServiceCertificateResourceInner>> beginCreateOrUpdateCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (keyVaultCertificate == null) {
            throw new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(keyVaultCertificate);
        return service.beginCreateOrUpdateCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), keyVaultCertificate, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceCertificateResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceCertificateResourceInner> clientResponse = beginCreateOrUpdateCertificateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceCertificateResourceInner> beginCreateOrUpdateCertificateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceCertificateResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceCertificateResourceInner>() { }.getType())
                .register(201, new TypeToken<AppServiceCertificateResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Delete the certificate associated with a certificate order.
     * Delete the certificate associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteCertificate(String resourceGroupName, String certificateOrderName, String name) {
        deleteCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).toBlocking().single().body();
    }

    /**
     * Delete the certificate associated with a certificate order.
     * Delete the certificate associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteCertificateAsync(String resourceGroupName, String certificateOrderName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name), serviceCallback);
    }

    /**
     * Delete the certificate associated with a certificate order.
     * Delete the certificate associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteCertificateAsync(String resourceGroupName, String certificateOrderName, String name) {
        return deleteCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete the certificate associated with a certificate order.
     * Delete the certificate associated with a certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteCertificateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteCertificateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AppServiceCertificateResourceInner object if successful.
     */
    public AppServiceCertificateResourceInner updateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResource keyVaultCertificate) {
        return updateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).toBlocking().single().body();
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AppServiceCertificateResourceInner> updateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResource keyVaultCertificate, final ServiceCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate), serviceCallback);
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateResourceInner object
     */
    public Observable<AppServiceCertificateResourceInner> updateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResource keyVaultCertificate) {
        return updateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).map(new Func1<ServiceResponse<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner>() {
            @Override
            public AppServiceCertificateResourceInner call(ServiceResponse<AppServiceCertificateResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a certificate and associates with key vault secret.
     * Creates or updates a certificate and associates with key vault secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the certificate.
     * @param keyVaultCertificate Key vault certificate resource Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AppServiceCertificateResourceInner object
     */
    public Observable<ServiceResponse<AppServiceCertificateResourceInner>> updateCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResource keyVaultCertificate) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (keyVaultCertificate == null) {
            throw new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(keyVaultCertificate);
        return service.updateCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), keyVaultCertificate, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AppServiceCertificateResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AppServiceCertificateResourceInner> clientResponse = updateCertificateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AppServiceCertificateResourceInner> updateCertificateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AppServiceCertificateResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AppServiceCertificateResourceInner>() { }.getType())
                .register(201, new TypeToken<AppServiceCertificateResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Reissue an existing certificate order.
     * Reissue an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param reissueCertificateOrderRequest Parameters for the reissue.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void reissue(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        reissueWithServiceResponseAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest).toBlocking().single().body();
    }

    /**
     * Reissue an existing certificate order.
     * Reissue an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param reissueCertificateOrderRequest Parameters for the reissue.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> reissueAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(reissueWithServiceResponseAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest), serviceCallback);
    }

    /**
     * Reissue an existing certificate order.
     * Reissue an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param reissueCertificateOrderRequest Parameters for the reissue.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> reissueAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        return reissueWithServiceResponseAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Reissue an existing certificate order.
     * Reissue an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param reissueCertificateOrderRequest Parameters for the reissue.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> reissueWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (reissueCertificateOrderRequest == null) {
            throw new IllegalArgumentException("Parameter reissueCertificateOrderRequest is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(reissueCertificateOrderRequest);
        return service.reissue(resourceGroupName, certificateOrderName, this.client.subscriptionId(), reissueCertificateOrderRequest, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = reissueDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> reissueDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Renew an existing certificate order.
     * Renew an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param renewCertificateOrderRequest Renew parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void renew(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        renewWithServiceResponseAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest).toBlocking().single().body();
    }

    /**
     * Renew an existing certificate order.
     * Renew an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param renewCertificateOrderRequest Renew parameters
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> renewAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(renewWithServiceResponseAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest), serviceCallback);
    }

    /**
     * Renew an existing certificate order.
     * Renew an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param renewCertificateOrderRequest Renew parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> renewAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        return renewWithServiceResponseAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Renew an existing certificate order.
     * Renew an existing certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param renewCertificateOrderRequest Renew parameters
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> renewWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (renewCertificateOrderRequest == null) {
            throw new IllegalArgumentException("Parameter renewCertificateOrderRequest is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(renewCertificateOrderRequest);
        return service.renew(resourceGroupName, certificateOrderName, this.client.subscriptionId(), renewCertificateOrderRequest, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = renewDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> renewDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Resend certificate email.
     * Resend certificate email.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void resendEmail(String resourceGroupName, String certificateOrderName) {
        resendEmailWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single().body();
    }

    /**
     * Resend certificate email.
     * Resend certificate email.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> resendEmailAsync(String resourceGroupName, String certificateOrderName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(resendEmailWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    /**
     * Resend certificate email.
     * Resend certificate email.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> resendEmailAsync(String resourceGroupName, String certificateOrderName) {
        return resendEmailWithServiceResponseAsync(resourceGroupName, certificateOrderName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Resend certificate email.
     * Resend certificate email.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> resendEmailWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.resendEmail(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = resendEmailDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> resendEmailDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void resendRequestEmails(String resourceGroupName, String certificateOrderName) {
        resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single().body();
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName) {
        return resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> resendRequestEmailsWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String name = null;
        NameIdentifierInner nameIdentifier = new NameIdentifierInner();
        nameIdentifier.withName(null);
        return service.resendRequestEmails(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), nameIdentifier, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = resendRequestEmailsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void resendRequestEmails(String resourceGroupName, String certificateOrderName, String name) {
        resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).toBlocking().single().body();
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the object.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName, name), serviceCallback);
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName, String name) {
        return resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param name Name of the object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> resendRequestEmailsWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        NameIdentifierInner nameIdentifier = new NameIdentifierInner();
        nameIdentifier.withName(name);
        return service.resendRequestEmails(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), nameIdentifier, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = resendRequestEmailsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> resendRequestEmailsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param siteSealRequest Site seal request.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteSealInner object if successful.
     */
    public SiteSealInner retrieveSiteSeal(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        return retrieveSiteSealWithServiceResponseAsync(resourceGroupName, certificateOrderName, siteSealRequest).toBlocking().single().body();
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param siteSealRequest Site seal request.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteSealInner> retrieveSiteSealAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest, final ServiceCallback<SiteSealInner> serviceCallback) {
        return ServiceFuture.fromResponse(retrieveSiteSealWithServiceResponseAsync(resourceGroupName, certificateOrderName, siteSealRequest), serviceCallback);
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param siteSealRequest Site seal request.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteSealInner object
     */
    public Observable<SiteSealInner> retrieveSiteSealAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        return retrieveSiteSealWithServiceResponseAsync(resourceGroupName, certificateOrderName, siteSealRequest).map(new Func1<ServiceResponse<SiteSealInner>, SiteSealInner>() {
            @Override
            public SiteSealInner call(ServiceResponse<SiteSealInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param siteSealRequest Site seal request.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteSealInner object
     */
    public Observable<ServiceResponse<SiteSealInner>> retrieveSiteSealWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteSealRequest == null) {
            throw new IllegalArgumentException("Parameter siteSealRequest is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(siteSealRequest);
        return service.retrieveSiteSeal(resourceGroupName, certificateOrderName, this.client.subscriptionId(), siteSealRequest, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteSealInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteSealInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteSealInner> clientResponse = retrieveSiteSealDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteSealInner> retrieveSiteSealDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteSealInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteSealInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void verifyDomainOwnership(String resourceGroupName, String certificateOrderName) {
        verifyDomainOwnershipWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single().body();
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> verifyDomainOwnershipAsync(String resourceGroupName, String certificateOrderName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(verifyDomainOwnershipWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> verifyDomainOwnershipAsync(String resourceGroupName, String certificateOrderName) {
        return verifyDomainOwnershipWithServiceResponseAsync(resourceGroupName, certificateOrderName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Verify domain ownership for this certificate order.
     * Verify domain ownership for this certificate order.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param certificateOrderName Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> verifyDomainOwnershipWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.verifyDomainOwnership(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = verifyDomainOwnershipDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> verifyDomainOwnershipDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieve the list of certificate actions.
     * Retrieve the list of certificate actions.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;CertificateOrderActionInner&gt; object if successful.
     */
    public List<CertificateOrderActionInner> retrieveCertificateActions(String resourceGroupName, String name) {
        return retrieveCertificateActionsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Retrieve the list of certificate actions.
     * Retrieve the list of certificate actions.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CertificateOrderActionInner>> retrieveCertificateActionsAsync(String resourceGroupName, String name, final ServiceCallback<List<CertificateOrderActionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(retrieveCertificateActionsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Retrieve the list of certificate actions.
     * Retrieve the list of certificate actions.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;CertificateOrderActionInner&gt; object
     */
    public Observable<List<CertificateOrderActionInner>> retrieveCertificateActionsAsync(String resourceGroupName, String name) {
        return retrieveCertificateActionsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<List<CertificateOrderActionInner>>, List<CertificateOrderActionInner>>() {
            @Override
            public List<CertificateOrderActionInner> call(ServiceResponse<List<CertificateOrderActionInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieve the list of certificate actions.
     * Retrieve the list of certificate actions.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;CertificateOrderActionInner&gt; object
     */
    public Observable<ServiceResponse<List<CertificateOrderActionInner>>> retrieveCertificateActionsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.retrieveCertificateActions(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CertificateOrderActionInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<CertificateOrderActionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<List<CertificateOrderActionInner>> clientResponse = retrieveCertificateActionsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<List<CertificateOrderActionInner>> retrieveCertificateActionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<List<CertificateOrderActionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<List<CertificateOrderActionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Retrieve email history.
     * Retrieve email history.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;CertificateEmailInner&gt; object if successful.
     */
    public List<CertificateEmailInner> retrieveCertificateEmailHistory(String resourceGroupName, String name) {
        return retrieveCertificateEmailHistoryWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Retrieve email history.
     * Retrieve email history.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the certificate order.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CertificateEmailInner>> retrieveCertificateEmailHistoryAsync(String resourceGroupName, String name, final ServiceCallback<List<CertificateEmailInner>> serviceCallback) {
        return ServiceFuture.fromResponse(retrieveCertificateEmailHistoryWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Retrieve email history.
     * Retrieve email history.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;CertificateEmailInner&gt; object
     */
    public Observable<List<CertificateEmailInner>> retrieveCertificateEmailHistoryAsync(String resourceGroupName, String name) {
        return retrieveCertificateEmailHistoryWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<List<CertificateEmailInner>>, List<CertificateEmailInner>>() {
            @Override
            public List<CertificateEmailInner> call(ServiceResponse<List<CertificateEmailInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieve email history.
     * Retrieve email history.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the certificate order.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;CertificateEmailInner&gt; object
     */
    public Observable<ServiceResponse<List<CertificateEmailInner>>> retrieveCertificateEmailHistoryWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.retrieveCertificateEmailHistory(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CertificateEmailInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<CertificateEmailInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<List<CertificateEmailInner>> clientResponse = retrieveCertificateEmailHistoryDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<List<CertificateEmailInner>> retrieveCertificateEmailHistoryDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<List<CertificateEmailInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<List<CertificateEmailInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceCertificateOrderInner&gt; object if successful.
     */
    public PagedList<AppServiceCertificateOrderInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<AppServiceCertificateOrderInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServiceCertificateOrderInner>(response.body()) {
            @Override
            public Page<AppServiceCertificateOrderInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceCertificateOrderInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<AppServiceCertificateOrderInner>> serviceFuture, final ListOperationCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateOrderInner&gt; object
     */
    public Observable<Page<AppServiceCertificateOrderInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Page<AppServiceCertificateOrderInner>>() {
                @Override
                public Page<AppServiceCertificateOrderInner> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateOrderInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all certificate orders in a subscription.
     * List all certificate orders in a subscription.
     *
    ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceCertificateOrderInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceCertificateOrderInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceCertificateOrderInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceCertificateOrderInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceCertificateOrderInner&gt; object if successful.
     */
    public PagedList<AppServiceCertificateOrderInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<AppServiceCertificateOrderInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServiceCertificateOrderInner>(response.body()) {
            @Override
            public Page<AppServiceCertificateOrderInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceCertificateOrderInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<AppServiceCertificateOrderInner>> serviceFuture, final ListOperationCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateOrderInner&gt; object
     */
    public Observable<Page<AppServiceCertificateOrderInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Page<AppServiceCertificateOrderInner>>() {
                @Override
                public Page<AppServiceCertificateOrderInner> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateOrderInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get certificate orders in a resource group.
     * Get certificate orders in a resource group.
     *
    ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceCertificateOrderInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceCertificateOrderInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceCertificateOrderInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceCertificateOrderInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AppServiceCertificateResourceInner&gt; object if successful.
     */
    public PagedList<AppServiceCertificateResourceInner> listCertificatesNext(final String nextPageLink) {
        ServiceResponse<Page<AppServiceCertificateResourceInner>> response = listCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServiceCertificateResourceInner>(response.body()) {
            @Override
            public Page<AppServiceCertificateResourceInner> nextPage(String nextPageLink) {
                return listCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AppServiceCertificateResourceInner>> listCertificatesNextAsync(final String nextPageLink, final ServiceFuture<List<AppServiceCertificateResourceInner>> serviceFuture, final ListOperationCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listCertificatesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(String nextPageLink) {
                    return listCertificatesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateResourceInner&gt; object
     */
    public Observable<Page<AppServiceCertificateResourceInner>> listCertificatesNextAsync(final String nextPageLink) {
        return listCertificatesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AppServiceCertificateResourceInner>>, Page<AppServiceCertificateResourceInner>>() {
                @Override
                public Page<AppServiceCertificateResourceInner> call(ServiceResponse<Page<AppServiceCertificateResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AppServiceCertificateResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> listCertificatesNextWithServiceResponseAsync(final String nextPageLink) {
        return listCertificatesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AppServiceCertificateResourceInner>>, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(ServiceResponse<Page<AppServiceCertificateResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listCertificatesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all certificates associated with a certificate order.
     * List all certificates associated with a certificate order.
     *
    ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AppServiceCertificateResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> listCertificatesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listCertificatesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> result = listCertificatesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AppServiceCertificateResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> listCertificatesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AppServiceCertificateResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AppServiceCertificateResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

}
