/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ResourceHealthMetadatas.
 */
public class ResourceHealthMetadatasInner implements InnerSupportsListing<ResourceHealthMetadataInner> {
    /** The Retrofit service to perform REST calls. */
    private ResourceHealthMetadatasService service;
    /** The service client containing this operation class. */
    private WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of ResourceHealthMetadatasInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ResourceHealthMetadatasInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = retrofit.create(ResourceHealthMetadatasService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ResourceHealthMetadatas to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ResourceHealthMetadatasService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/resourceHealthMetadata")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/resourceHealthMetadata")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listBySite" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata")
        Observable<Response<ResponseBody>> listBySite(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas getBySite" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata/default")
        Observable<Response<ResponseBody>> getBySite(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listBySiteSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata")
        Observable<Response<ResponseBody>> listBySiteSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas getBySiteSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata/default")
        Observable<Response<ResponseBody>> getBySiteSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listBySiteNext" })
        @GET
        Observable<Response<ResponseBody>> listBySiteNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.ResourceHealthMetadatas listBySiteSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listBySiteSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object if successful.
     */
    public PagedList<ResourceHealthMetadataInner> list() {
        ServiceResponse<Page<ResourceHealthMetadataInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>(response.body()) {
            @Override
            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceHealthMetadataInner>> listAsync(final ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<Page<ResourceHealthMetadataInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>() {
                @Override
                public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceHealthMetadataInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceHealthMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceHealthMetadataInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object if successful.
     */
    public PagedList<ResourceHealthMetadataInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<ResourceHealthMetadataInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>(response.body()) {
            @Override
            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceHealthMetadataInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<Page<ResourceHealthMetadataInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>() {
                @Override
                public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceHealthMetadataInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceHealthMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceHealthMetadataInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object if successful.
     */
    public PagedList<ResourceHealthMetadataInner> listBySite(final String resourceGroupName, final String name) {
        ServiceResponse<Page<ResourceHealthMetadataInner>> response = listBySiteSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>(response.body()) {
            @Override
            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return listBySiteNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceHealthMetadataInner>> listBySiteAsync(final String resourceGroupName, final String name, final ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySiteSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                    return listBySiteNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<Page<ResourceHealthMetadataInner>> listBySiteAsync(final String resourceGroupName, final String name) {
        return listBySiteWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>() {
                @Override
                public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listBySiteSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySiteNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listBySite(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceHealthMetadataInner>> result = listBySiteDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceHealthMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listBySiteDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceHealthMetadataInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site.
     * Gets the category of ResourceHealthMetadata to use for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceHealthMetadataInner object if successful.
     */
    public ResourceHealthMetadataInner getBySite(String resourceGroupName, String name) {
        return getBySiteWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site.
     * Gets the category of ResourceHealthMetadata to use for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceHealthMetadataInner> getBySiteAsync(String resourceGroupName, String name, final ServiceCallback<ResourceHealthMetadataInner> serviceCallback) {
        return ServiceFuture.fromResponse(getBySiteWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site.
     * Gets the category of ResourceHealthMetadata to use for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceHealthMetadataInner object
     */
    public Observable<ResourceHealthMetadataInner> getBySiteAsync(String resourceGroupName, String name) {
        return getBySiteWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<ResourceHealthMetadataInner>, ResourceHealthMetadataInner>() {
            @Override
            public ResourceHealthMetadataInner call(ServiceResponse<ResourceHealthMetadataInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site.
     * Gets the category of ResourceHealthMetadata to use for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceHealthMetadataInner object
     */
    public Observable<ServiceResponse<ResourceHealthMetadataInner>> getBySiteWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getBySite(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceHealthMetadataInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceHealthMetadataInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceHealthMetadataInner> clientResponse = getBySiteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ResourceHealthMetadataInner> getBySiteDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ResourceHealthMetadataInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ResourceHealthMetadataInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object if successful.
     */
    public PagedList<ResourceHealthMetadataInner> listBySiteSlot(final String resourceGroupName, final String name, final String slot) {
        ServiceResponse<Page<ResourceHealthMetadataInner>> response = listBySiteSlotSinglePageAsync(resourceGroupName, name, slot).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>(response.body()) {
            @Override
            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return listBySiteSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceHealthMetadataInner>> listBySiteSlotAsync(final String resourceGroupName, final String name, final String slot, final ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySiteSlotSinglePageAsync(resourceGroupName, name, slot),
            new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                    return listBySiteSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<Page<ResourceHealthMetadataInner>> listBySiteSlotAsync(final String resourceGroupName, final String name, final String slot) {
        return listBySiteSlotWithServiceResponseAsync(resourceGroupName, name, slot)
            .map(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>() {
                @Override
                public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSlotWithServiceResponseAsync(final String resourceGroupName, final String name, final String slot) {
        return listBySiteSlotSinglePageAsync(resourceGroupName, name, slot)
            .concatMap(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySiteSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param name Name of web app.
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSlotSinglePageAsync(final String resourceGroupName, final String name, final String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listBySiteSlot(resourceGroupName, name, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceHealthMetadataInner>> result = listBySiteSlotDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceHealthMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listBySiteSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceHealthMetadataInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site.
     * Gets the category of ResourceHealthMetadata to use for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceHealthMetadataInner object if successful.
     */
    public ResourceHealthMetadataInner getBySiteSlot(String resourceGroupName, String name, String slot) {
        return getBySiteSlotWithServiceResponseAsync(resourceGroupName, name, slot).toBlocking().single().body();
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site.
     * Gets the category of ResourceHealthMetadata to use for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceHealthMetadataInner> getBySiteSlotAsync(String resourceGroupName, String name, String slot, final ServiceCallback<ResourceHealthMetadataInner> serviceCallback) {
        return ServiceFuture.fromResponse(getBySiteSlotWithServiceResponseAsync(resourceGroupName, name, slot), serviceCallback);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site.
     * Gets the category of ResourceHealthMetadata to use for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceHealthMetadataInner object
     */
    public Observable<ResourceHealthMetadataInner> getBySiteSlotAsync(String resourceGroupName, String name, String slot) {
        return getBySiteSlotWithServiceResponseAsync(resourceGroupName, name, slot).map(new Func1<ServiceResponse<ResourceHealthMetadataInner>, ResourceHealthMetadataInner>() {
            @Override
            public ResourceHealthMetadataInner call(ServiceResponse<ResourceHealthMetadataInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site.
     * Gets the category of ResourceHealthMetadata to use for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceHealthMetadataInner object
     */
    public Observable<ServiceResponse<ResourceHealthMetadataInner>> getBySiteSlotWithServiceResponseAsync(String resourceGroupName, String name, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getBySiteSlot(resourceGroupName, name, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceHealthMetadataInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceHealthMetadataInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceHealthMetadataInner> clientResponse = getBySiteSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ResourceHealthMetadataInner> getBySiteSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ResourceHealthMetadataInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ResourceHealthMetadataInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object if successful.
     */
    public PagedList<ResourceHealthMetadataInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceHealthMetadataInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>(response.body()) {
            @Override
            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceHealthMetadataInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceHealthMetadataInner>> serviceFuture, final ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<Page<ResourceHealthMetadataInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>() {
                @Override
                public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all ResourceHealthMetadata for all sites in the subscription.
     * List all ResourceHealthMetadata for all sites in the subscription.
     *
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceHealthMetadataInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceHealthMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceHealthMetadataInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object if successful.
     */
    public PagedList<ResourceHealthMetadataInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceHealthMetadataInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>(response.body()) {
            @Override
            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceHealthMetadataInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceHealthMetadataInner>> serviceFuture, final ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<Page<ResourceHealthMetadataInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>() {
                @Override
                public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     * List all ResourceHealthMetadata for all sites in the resource group in the subscription.
     *
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceHealthMetadataInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceHealthMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceHealthMetadataInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object if successful.
     */
    public PagedList<ResourceHealthMetadataInner> listBySiteNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceHealthMetadataInner>> response = listBySiteNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>(response.body()) {
            @Override
            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return listBySiteNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceHealthMetadataInner>> listBySiteNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceHealthMetadataInner>> serviceFuture, final ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySiteNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                    return listBySiteNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<Page<ResourceHealthMetadataInner>> listBySiteNextAsync(final String nextPageLink) {
        return listBySiteNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>() {
                @Override
                public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteNextWithServiceResponseAsync(final String nextPageLink) {
        return listBySiteNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySiteNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listBySiteNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceHealthMetadataInner>> result = listBySiteNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceHealthMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listBySiteNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceHealthMetadataInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object if successful.
     */
    public PagedList<ResourceHealthMetadataInner> listBySiteSlotNext(final String nextPageLink) {
        ServiceResponse<Page<ResourceHealthMetadataInner>> response = listBySiteSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceHealthMetadataInner>(response.body()) {
            @Override
            public Page<ResourceHealthMetadataInner> nextPage(String nextPageLink) {
                return listBySiteSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceHealthMetadataInner>> listBySiteSlotNextAsync(final String nextPageLink, final ServiceFuture<List<ResourceHealthMetadataInner>> serviceFuture, final ListOperationCallback<ResourceHealthMetadataInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBySiteSlotNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(String nextPageLink) {
                    return listBySiteSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<Page<ResourceHealthMetadataInner>> listBySiteSlotNextAsync(final String nextPageLink) {
        return listBySiteSlotNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Page<ResourceHealthMetadataInner>>() {
                @Override
                public Page<ResourceHealthMetadataInner> call(ServiceResponse<Page<ResourceHealthMetadataInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceHealthMetadataInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSlotNextWithServiceResponseAsync(final String nextPageLink) {
        return listBySiteSlotNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ResourceHealthMetadataInner>>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(ServiceResponse<Page<ResourceHealthMetadataInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBySiteSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     * Gets the category of ResourceHealthMetadata to use for the given site as a collection.
     *
    ServiceResponse<PageImpl<ResourceHealthMetadataInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceHealthMetadataInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> listBySiteSlotNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listBySiteSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceHealthMetadataInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceHealthMetadataInner>> result = listBySiteSlotNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceHealthMetadataInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceHealthMetadataInner>> listBySiteSlotNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceHealthMetadataInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceHealthMetadataInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

}
