/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.appservice.CsmPublishingProfileOptions;
import com.microsoft.azure.management.appservice.CsmSlotEntity;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.DeletedAppRestoreRequest;
import com.microsoft.azure.management.appservice.MigrateMySqlRequest;
import com.microsoft.azure.management.appservice.MSDeploy;
import com.microsoft.azure.management.appservice.PremierAddOnPatchResource;
import com.microsoft.azure.management.appservice.SitePatchResource;
import com.microsoft.azure.management.appservice.SnapshotRestoreRequest;
import com.microsoft.azure.management.appservice.StorageMigrationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.InputStream;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Streaming;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in WebApps.
 */
public class WebAppsInner implements InnerSupportsGet<SiteInner>, InnerSupportsDelete<Void>, InnerSupportsListing<SiteInner> {
    /** The Retrofit service to perform REST calls. */
    private WebAppsService service;
    /** The service client containing this operation class. */
    private WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of WebAppsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public WebAppsInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = retrofit.create(WebAppsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for WebApps to be
     * used by Retrofit to perform actually REST calls.
     */
    interface WebAppsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/sites")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("includeSlots") Boolean includeSlots, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteInner siteEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteInner siteEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("deleteMetrics") Boolean deleteMetrics, @Query("deleteEmptyServerFarm") Boolean deleteEmptyServerFarm, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SitePatchResource siteEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps analyzeCustomHostname" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname")
        Observable<Response<ResponseBody>> analyzeCustomHostname(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("hostName") String hostName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps applySlotConfigToProduction" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig")
        Observable<Response<ResponseBody>> applySlotConfigToProduction(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body CsmSlotEntity slotSwapEntity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps backup" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup")
        Observable<Response<ResponseBody>> backup(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body BackupRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listBackups" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups")
        Observable<Response<ResponseBody>> listBackups(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getBackupStatus" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}")
        Observable<Response<ResponseBody>> getBackupStatus(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteBackup" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteBackup(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listBackupStatusSecrets" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list")
        Observable<Response<ResponseBody>> listBackupStatusSecrets(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("subscriptionId") String subscriptionId, @Body BackupRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restore" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore")
        Observable<Response<ResponseBody>> restore(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginRestore" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore")
        Observable<Response<ResponseBody>> beginRestore(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConfigurations" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config")
        Observable<Response<ResponseBody>> listConfigurations(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateApplicationSettings" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings")
        Observable<Response<ResponseBody>> updateApplicationSettings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body StringDictionaryInner appSettings, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listApplicationSettings" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list")
        Observable<Response<ResponseBody>> listApplicationSettings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateAuthSettings" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings")
        Observable<Response<ResponseBody>> updateAuthSettings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteAuthSettingsInner siteAuthSettings, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getAuthSettings" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list")
        Observable<Response<ResponseBody>> getAuthSettings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateAzureStorageAccounts" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts")
        Observable<Response<ResponseBody>> updateAzureStorageAccounts(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body AzureStoragePropertyDictionaryResourceInner azureStorageAccounts, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listAzureStorageAccounts" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts/list")
        Observable<Response<ResponseBody>> listAzureStorageAccounts(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateBackupConfiguration" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup")
        Observable<Response<ResponseBody>> updateBackupConfiguration(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body BackupRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteBackupConfiguration" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteBackupConfiguration(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getBackupConfiguration" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list")
        Observable<Response<ResponseBody>> getBackupConfiguration(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateConnectionStrings" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings")
        Observable<Response<ResponseBody>> updateConnectionStrings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body ConnectionStringDictionaryInner connectionStrings, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConnectionStrings" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list")
        Observable<Response<ResponseBody>> listConnectionStrings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getDiagnosticLogsConfiguration" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs")
        Observable<Response<ResponseBody>> getDiagnosticLogsConfiguration(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateDiagnosticLogsConfig" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs")
        Observable<Response<ResponseBody>> updateDiagnosticLogsConfig(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteLogsConfigInner siteLogsConfig, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateMetadata" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata")
        Observable<Response<ResponseBody>> updateMetadata(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body StringDictionaryInner metadata, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetadata" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list")
        Observable<Response<ResponseBody>> listMetadata(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPublishingCredentials" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list")
        Observable<Response<ResponseBody>> listPublishingCredentials(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginListPublishingCredentials" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list")
        Observable<Response<ResponseBody>> beginListPublishingCredentials(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateSitePushSettings" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings")
        Observable<Response<ResponseBody>> updateSitePushSettings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body PushSettingsInner pushSettings, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSitePushSettings" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list")
        Observable<Response<ResponseBody>> listSitePushSettings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSlotConfigurationNames" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames")
        Observable<Response<ResponseBody>> listSlotConfigurationNames(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateSlotConfigurationNames" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames")
        Observable<Response<ResponseBody>> updateSlotConfigurationNames(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SlotConfigNamesResourceInner slotConfigNames, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getConfiguration" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web")
        Observable<Response<ResponseBody>> getConfiguration(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateConfiguration" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web")
        Observable<Response<ResponseBody>> createOrUpdateConfiguration(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteConfigResourceInner siteConfig, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateConfiguration" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web")
        Observable<Response<ResponseBody>> updateConfiguration(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteConfigResourceInner siteConfig, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConfigurationSnapshotInfo" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots")
        Observable<Response<ResponseBody>> listConfigurationSnapshotInfo(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getConfigurationSnapshot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}")
        Observable<Response<ResponseBody>> getConfigurationSnapshot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("snapshotId") String snapshotId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps recoverSiteConfigurationSnapshot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}/recover")
        Observable<Response<ResponseBody>> recoverSiteConfigurationSnapshot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("snapshotId") String snapshotId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getWebSiteContainerLogs" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs")
        @Streaming
        Observable<Response<ResponseBody>> getWebSiteContainerLogs(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getContainerLogsZip" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs/zip/download")
        @Streaming
        Observable<Response<ResponseBody>> getContainerLogsZip(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listContinuousWebJobs" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs")
        Observable<Response<ResponseBody>> listContinuousWebJobs(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getContinuousWebJob" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}")
        Observable<Response<ResponseBody>> getContinuousWebJob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteContinuousWebJob" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteContinuousWebJob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startContinuousWebJob" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}/start")
        Observable<Response<ResponseBody>> startContinuousWebJob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps stopContinuousWebJob" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}/stop")
        Observable<Response<ResponseBody>> stopContinuousWebJob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDeployments" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments")
        Observable<Response<ResponseBody>> listDeployments(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getDeployment" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}")
        Observable<Response<ResponseBody>> getDeployment(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("id") String id, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createDeployment" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}")
        Observable<Response<ResponseBody>> createDeployment(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("id") String id, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner deployment, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteDeployment" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteDeployment(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("id") String id, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDeploymentLog" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}/log")
        Observable<Response<ResponseBody>> listDeploymentLog(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("id") String id, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps discoverBackup" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/discoverbackup")
        Observable<Response<ResponseBody>> discoverBackup(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDomainOwnershipIdentifiers" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers")
        Observable<Response<ResponseBody>> listDomainOwnershipIdentifiers(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getDomainOwnershipIdentifier" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        Observable<Response<ResponseBody>> getDomainOwnershipIdentifier(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("domainOwnershipIdentifierName") String domainOwnershipIdentifierName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateDomainOwnershipIdentifier" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        Observable<Response<ResponseBody>> createOrUpdateDomainOwnershipIdentifier(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("domainOwnershipIdentifierName") String domainOwnershipIdentifierName, @Path("subscriptionId") String subscriptionId, @Body IdentifierInner domainOwnershipIdentifier, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteDomainOwnershipIdentifier" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteDomainOwnershipIdentifier(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("domainOwnershipIdentifierName") String domainOwnershipIdentifierName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateDomainOwnershipIdentifier" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        Observable<Response<ResponseBody>> updateDomainOwnershipIdentifier(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("domainOwnershipIdentifierName") String domainOwnershipIdentifierName, @Path("subscriptionId") String subscriptionId, @Body IdentifierInner domainOwnershipIdentifier, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getMSDeployStatus" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> getMSDeployStatus(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createMSDeployOperation" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> createMSDeployOperation(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body MSDeploy mSDeploy, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateMSDeployOperation" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> beginCreateMSDeployOperation(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body MSDeploy mSDeploy, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getMSDeployLog" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy/log")
        Observable<Response<ResponseBody>> getMSDeployLog(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listFunctions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions")
        Observable<Response<ResponseBody>> listFunctions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getFunctionsAdminToken" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/token")
        Observable<Response<ResponseBody>> getFunctionsAdminToken(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getFunction" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}")
        Observable<Response<ResponseBody>> getFunction(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createFunction" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}")
        Observable<Response<ResponseBody>> createFunction(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("subscriptionId") String subscriptionId, @Body FunctionEnvelopeInner functionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateFunction" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}")
        Observable<Response<ResponseBody>> beginCreateFunction(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("subscriptionId") String subscriptionId, @Body FunctionEnvelopeInner functionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteFunction" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteFunction(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listFunctionSecrets" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listsecrets")
        Observable<Response<ResponseBody>> listFunctionSecrets(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listHostNameBindings" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings")
        Observable<Response<ResponseBody>> listHostNameBindings(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getHostNameBinding" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}")
        Observable<Response<ResponseBody>> getHostNameBinding(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateHostNameBinding" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}")
        Observable<Response<ResponseBody>> createOrUpdateHostNameBinding(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Body HostNameBindingInner hostNameBinding, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteHostNameBinding" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteHostNameBinding(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getHybridConnection" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        Observable<Response<ResponseBody>> getHybridConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateHybridConnection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        Observable<Response<ResponseBody>> createOrUpdateHybridConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("subscriptionId") String subscriptionId, @Body HybridConnectionInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteHybridConnection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteHybridConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateHybridConnection" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        Observable<Response<ResponseBody>> updateHybridConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("subscriptionId") String subscriptionId, @Body HybridConnectionInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listHybridConnectionKeys" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys")
        Observable<Response<ResponseBody>> listHybridConnectionKeys(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listHybridConnections" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays")
        Observable<Response<ResponseBody>> listHybridConnections(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listRelayServiceConnections" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection")
        Observable<Response<ResponseBody>> listRelayServiceConnections(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getRelayServiceConnection" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}")
        Observable<Response<ResponseBody>> getRelayServiceConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("entityName") String entityName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateRelayServiceConnection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}")
        Observable<Response<ResponseBody>> createOrUpdateRelayServiceConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("entityName") String entityName, @Path("subscriptionId") String subscriptionId, @Body RelayServiceConnectionEntityInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteRelayServiceConnection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteRelayServiceConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("entityName") String entityName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateRelayServiceConnection" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}")
        Observable<Response<ResponseBody>> updateRelayServiceConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("entityName") String entityName, @Path("subscriptionId") String subscriptionId, @Body RelayServiceConnectionEntityInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceIdentifiers" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances")
        Observable<Response<ResponseBody>> listInstanceIdentifiers(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceMsDeployStatus" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> getInstanceMsDeployStatus(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createInstanceMSDeployOperation" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> createInstanceMSDeployOperation(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Body MSDeploy mSDeploy, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateInstanceMSDeployOperation" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> beginCreateInstanceMSDeployOperation(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Body MSDeploy mSDeploy, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceMSDeployLog" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy/log")
        Observable<Response<ResponseBody>> getInstanceMSDeployLog(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcesses" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes")
        Observable<Response<ResponseBody>> listInstanceProcesses(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceProcess" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}")
        Observable<Response<ResponseBody>> getInstanceProcess(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteInstanceProcess" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteInstanceProcess(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceProcessDump" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/dump")
        @Streaming
        Observable<Response<ResponseBody>> getInstanceProcessDump(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessModules" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules")
        Observable<Response<ResponseBody>> listInstanceProcessModules(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceProcessModule" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}")
        Observable<Response<ResponseBody>> getInstanceProcessModule(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("baseAddress") String baseAddress, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessThreads" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads")
        Observable<Response<ResponseBody>> listInstanceProcessThreads(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceProcessThread" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads/{threadId}")
        Observable<Response<ResponseBody>> getInstanceProcessThread(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("threadId") String threadId, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps isCloneable" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable")
        Observable<Response<ResponseBody>> isCloneable(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSyncFunctionTriggers" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listsyncfunctiontriggerstatus")
        Observable<Response<ResponseBody>> listSyncFunctionTriggers(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetricDefinitions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions")
        Observable<Response<ResponseBody>> listMetricDefinitions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetrics" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics")
        Observable<Response<ResponseBody>> listMetrics(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("details") Boolean details, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps migrateStorage" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migrate")
        Observable<Response<ResponseBody>> migrateStorage(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("subscriptionName") String subscriptionName, @Body StorageMigrationOptions migrationOptions, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginMigrateStorage" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migrate")
        Observable<Response<ResponseBody>> beginMigrateStorage(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("subscriptionName") String subscriptionName, @Body StorageMigrationOptions migrationOptions, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps migrateMySql" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql")
        Observable<Response<ResponseBody>> migrateMySql(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body MigrateMySqlRequest migrationRequestEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginMigrateMySql" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql")
        Observable<Response<ResponseBody>> beginMigrateMySql(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body MigrateMySqlRequest migrationRequestEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getMigrateMySqlStatus" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status")
        Observable<Response<ResponseBody>> getMigrateMySqlStatus(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSwiftVirtualNetworkConnection" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork")
        Observable<Response<ResponseBody>> getSwiftVirtualNetworkConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateSwiftVirtualNetworkConnection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork")
        Observable<Response<ResponseBody>> createOrUpdateSwiftVirtualNetworkConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SwiftVirtualNetworkInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteSwiftVirtualNetwork" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSwiftVirtualNetwork(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateSwiftVirtualNetworkConnection" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork")
        Observable<Response<ResponseBody>> updateSwiftVirtualNetworkConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SwiftVirtualNetworkInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listNetworkFeatures" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}")
        Observable<Response<ResponseBody>> listNetworkFeatures(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("view") String view, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getNetworkTraceOperation" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/operationresults/{operationId}")
        Observable<Response<ResponseBody>> getNetworkTraceOperation(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("operationId") String operationId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startWebSiteNetworkTrace" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/start")
        Observable<Response<ResponseBody>> startWebSiteNetworkTrace(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startWebSiteNetworkTraceOperation" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/startOperation")
        Observable<Response<ResponseBody>> startWebSiteNetworkTraceOperation(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginStartWebSiteNetworkTraceOperation" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/startOperation")
        Observable<Response<ResponseBody>> beginStartWebSiteNetworkTraceOperation(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps stopWebSiteNetworkTrace" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/stop")
        Observable<Response<ResponseBody>> stopWebSiteNetworkTrace(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getNetworkTraces" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/{operationId}")
        Observable<Response<ResponseBody>> getNetworkTraces(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("operationId") String operationId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getNetworkTraceOperationV2" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/current/operationresults/{operationId}")
        Observable<Response<ResponseBody>> getNetworkTraceOperationV2(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("operationId") String operationId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getNetworkTracesV2" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/{operationId}")
        Observable<Response<ResponseBody>> getNetworkTracesV2(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("operationId") String operationId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps generateNewSitePublishingPassword" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword")
        Observable<Response<ResponseBody>> generateNewSitePublishingPassword(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPerfMonCounters" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters")
        Observable<Response<ResponseBody>> listPerfMonCounters(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSitePhpErrorLogFlag" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging")
        Observable<Response<ResponseBody>> getSitePhpErrorLogFlag(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPremierAddOns" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons")
        Observable<Response<ResponseBody>> listPremierAddOns(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getPremierAddOn" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}")
        Observable<Response<ResponseBody>> getPremierAddOn(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("premierAddOnName") String premierAddOnName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps addPremierAddOn" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}")
        Observable<Response<ResponseBody>> addPremierAddOn(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("premierAddOnName") String premierAddOnName, @Path("subscriptionId") String subscriptionId, @Body PremierAddOnInner premierAddOn, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deletePremierAddOn" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deletePremierAddOn(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("premierAddOnName") String premierAddOnName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updatePremierAddOn" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}")
        Observable<Response<ResponseBody>> updatePremierAddOn(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("premierAddOnName") String premierAddOnName, @Path("subscriptionId") String subscriptionId, @Body PremierAddOnPatchResource premierAddOn, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getPrivateAccess" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks")
        Observable<Response<ResponseBody>> getPrivateAccess(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps putPrivateAccessVnet" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks")
        Observable<Response<ResponseBody>> putPrivateAccessVnet(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body PrivateAccessInner access, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcesses" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes")
        Observable<Response<ResponseBody>> listProcesses(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getProcess" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}")
        Observable<Response<ResponseBody>> getProcess(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteProcess" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteProcess(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getProcessDump" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/dump")
        @Streaming
        Observable<Response<ResponseBody>> getProcessDump(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessModules" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules")
        Observable<Response<ResponseBody>> listProcessModules(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getProcessModule" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules/{baseAddress}")
        Observable<Response<ResponseBody>> getProcessModule(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("baseAddress") String baseAddress, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessThreads" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads")
        Observable<Response<ResponseBody>> listProcessThreads(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getProcessThread" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads/{threadId}")
        Observable<Response<ResponseBody>> getProcessThread(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("threadId") String threadId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPublicCertificates" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates")
        Observable<Response<ResponseBody>> listPublicCertificates(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getPublicCertificate" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}")
        Observable<Response<ResponseBody>> getPublicCertificate(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("publicCertificateName") String publicCertificateName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdatePublicCertificate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}")
        Observable<Response<ResponseBody>> createOrUpdatePublicCertificate(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("publicCertificateName") String publicCertificateName, @Path("subscriptionId") String subscriptionId, @Body PublicCertificateInner publicCertificate, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deletePublicCertificate" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deletePublicCertificate(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("publicCertificateName") String publicCertificateName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPublishingProfileXmlWithSecrets" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml")
        @Streaming
        Observable<Response<ResponseBody>> listPublishingProfileXmlWithSecrets(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body CsmPublishingProfileOptions publishingProfileOptions, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps resetProductionSlotConfig" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig")
        Observable<Response<ResponseBody>> resetProductionSlotConfig(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restart" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart")
        Observable<Response<ResponseBody>> restart(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("softRestart") Boolean softRestart, @Query("synchronous") Boolean synchronous, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restoreFromBackupBlob" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromBackupBlob")
        Observable<Response<ResponseBody>> restoreFromBackupBlob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginRestoreFromBackupBlob" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromBackupBlob")
        Observable<Response<ResponseBody>> beginRestoreFromBackupBlob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restoreFromDeletedApp" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromDeletedApp")
        Observable<Response<ResponseBody>> restoreFromDeletedApp(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body DeletedAppRestoreRequest restoreRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginRestoreFromDeletedApp" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromDeletedApp")
        Observable<Response<ResponseBody>> beginRestoreFromDeletedApp(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body DeletedAppRestoreRequest restoreRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restoreSnapshot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreSnapshot")
        Observable<Response<ResponseBody>> restoreSnapshot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SnapshotRestoreRequest restoreRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginRestoreSnapshot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreSnapshot")
        Observable<Response<ResponseBody>> beginRestoreSnapshot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SnapshotRestoreRequest restoreRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSiteExtensions" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions")
        Observable<Response<ResponseBody>> listSiteExtensions(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSiteExtension" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}")
        Observable<Response<ResponseBody>> getSiteExtension(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("siteExtensionId") String siteExtensionId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps installSiteExtension" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}")
        Observable<Response<ResponseBody>> installSiteExtension(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("siteExtensionId") String siteExtensionId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginInstallSiteExtension" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}")
        Observable<Response<ResponseBody>> beginInstallSiteExtension(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("siteExtensionId") String siteExtensionId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteSiteExtension" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSiteExtension(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("siteExtensionId") String siteExtensionId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSlots" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots")
        Observable<Response<ResponseBody>> listSlots(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}")
        Observable<Response<ResponseBody>> getSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}")
        Observable<Response<ResponseBody>> createOrUpdateSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteInner siteEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateOrUpdateSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}")
        Observable<Response<ResponseBody>> beginCreateOrUpdateSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteInner siteEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("deleteMetrics") Boolean deleteMetrics, @Query("deleteEmptyServerFarm") Boolean deleteEmptyServerFarm, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}")
        Observable<Response<ResponseBody>> updateSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SitePatchResource siteEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps analyzeCustomHostnameSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname")
        Observable<Response<ResponseBody>> analyzeCustomHostnameSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("hostName") String hostName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps applySlotConfigurationSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig")
        Observable<Response<ResponseBody>> applySlotConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body CsmSlotEntity slotSwapEntity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps backupSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup")
        Observable<Response<ResponseBody>> backupSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body BackupRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listBackupsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups")
        Observable<Response<ResponseBody>> listBackupsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getBackupStatusSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}")
        Observable<Response<ResponseBody>> getBackupStatusSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteBackupSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteBackupSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listBackupStatusSecretsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list")
        Observable<Response<ResponseBody>> listBackupStatusSecretsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body BackupRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restoreSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore")
        Observable<Response<ResponseBody>> restoreSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginRestoreSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore")
        Observable<Response<ResponseBody>> beginRestoreSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("backupId") String backupId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConfigurationsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config")
        Observable<Response<ResponseBody>> listConfigurationsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateApplicationSettingsSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings")
        Observable<Response<ResponseBody>> updateApplicationSettingsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body StringDictionaryInner appSettings, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listApplicationSettingsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list")
        Observable<Response<ResponseBody>> listApplicationSettingsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateAuthSettingsSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings")
        Observable<Response<ResponseBody>> updateAuthSettingsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteAuthSettingsInner siteAuthSettings, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getAuthSettingsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list")
        Observable<Response<ResponseBody>> getAuthSettingsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateAzureStorageAccountsSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts")
        Observable<Response<ResponseBody>> updateAzureStorageAccountsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body AzureStoragePropertyDictionaryResourceInner azureStorageAccounts, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listAzureStorageAccountsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts/list")
        Observable<Response<ResponseBody>> listAzureStorageAccountsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateBackupConfigurationSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup")
        Observable<Response<ResponseBody>> updateBackupConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body BackupRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteBackupConfigurationSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteBackupConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getBackupConfigurationSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list")
        Observable<Response<ResponseBody>> getBackupConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateConnectionStringsSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings")
        Observable<Response<ResponseBody>> updateConnectionStringsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body ConnectionStringDictionaryInner connectionStrings, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConnectionStringsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list")
        Observable<Response<ResponseBody>> listConnectionStringsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getDiagnosticLogsConfigurationSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs")
        Observable<Response<ResponseBody>> getDiagnosticLogsConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateDiagnosticLogsConfigSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs")
        Observable<Response<ResponseBody>> updateDiagnosticLogsConfigSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteLogsConfigInner siteLogsConfig, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateMetadataSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata")
        Observable<Response<ResponseBody>> updateMetadataSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body StringDictionaryInner metadata, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetadataSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list")
        Observable<Response<ResponseBody>> listMetadataSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPublishingCredentialsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list")
        Observable<Response<ResponseBody>> listPublishingCredentialsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginListPublishingCredentialsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list")
        Observable<Response<ResponseBody>> beginListPublishingCredentialsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateSitePushSettingsSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings")
        Observable<Response<ResponseBody>> updateSitePushSettingsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body PushSettingsInner pushSettings, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSitePushSettingsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings/list")
        Observable<Response<ResponseBody>> listSitePushSettingsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getConfigurationSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web")
        Observable<Response<ResponseBody>> getConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateConfigurationSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web")
        Observable<Response<ResponseBody>> createOrUpdateConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteConfigResourceInner siteConfig, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateConfigurationSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web")
        Observable<Response<ResponseBody>> updateConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteConfigResourceInner siteConfig, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConfigurationSnapshotInfoSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots")
        Observable<Response<ResponseBody>> listConfigurationSnapshotInfoSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getConfigurationSnapshotSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}")
        Observable<Response<ResponseBody>> getConfigurationSnapshotSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("snapshotId") String snapshotId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps recoverSiteConfigurationSnapshotSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}/recover")
        Observable<Response<ResponseBody>> recoverSiteConfigurationSnapshotSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("snapshotId") String snapshotId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getWebSiteContainerLogsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs")
        @Streaming
        Observable<Response<ResponseBody>> getWebSiteContainerLogsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getContainerLogsZipSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/containerlogs/zip/download")
        @Streaming
        Observable<Response<ResponseBody>> getContainerLogsZipSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listContinuousWebJobsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs")
        Observable<Response<ResponseBody>> listContinuousWebJobsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getContinuousWebJobSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}")
        Observable<Response<ResponseBody>> getContinuousWebJobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteContinuousWebJobSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteContinuousWebJobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startContinuousWebJobSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}/start")
        Observable<Response<ResponseBody>> startContinuousWebJobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps stopContinuousWebJobSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}/stop")
        Observable<Response<ResponseBody>> stopContinuousWebJobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDeploymentsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments")
        Observable<Response<ResponseBody>> listDeploymentsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getDeploymentSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}")
        Observable<Response<ResponseBody>> getDeploymentSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("id") String id, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createDeploymentSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}")
        Observable<Response<ResponseBody>> createDeploymentSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("id") String id, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body DeploymentInner deployment, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteDeploymentSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteDeploymentSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("id") String id, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDeploymentLogSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}/log")
        Observable<Response<ResponseBody>> listDeploymentLogSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("id") String id, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps discoverBackupSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/discoverbackup")
        Observable<Response<ResponseBody>> discoverBackupSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDomainOwnershipIdentifiersSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers")
        Observable<Response<ResponseBody>> listDomainOwnershipIdentifiersSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getDomainOwnershipIdentifierSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        Observable<Response<ResponseBody>> getDomainOwnershipIdentifierSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("domainOwnershipIdentifierName") String domainOwnershipIdentifierName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateDomainOwnershipIdentifierSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        Observable<Response<ResponseBody>> createOrUpdateDomainOwnershipIdentifierSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("domainOwnershipIdentifierName") String domainOwnershipIdentifierName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body IdentifierInner domainOwnershipIdentifier, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteDomainOwnershipIdentifierSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteDomainOwnershipIdentifierSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("domainOwnershipIdentifierName") String domainOwnershipIdentifierName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateDomainOwnershipIdentifierSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}")
        Observable<Response<ResponseBody>> updateDomainOwnershipIdentifierSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("domainOwnershipIdentifierName") String domainOwnershipIdentifierName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body IdentifierInner domainOwnershipIdentifier, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getMSDeployStatusSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> getMSDeployStatusSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createMSDeployOperationSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> createMSDeployOperationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body MSDeploy mSDeploy, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateMSDeployOperationSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> beginCreateMSDeployOperationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body MSDeploy mSDeploy, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getMSDeployLogSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy/log")
        Observable<Response<ResponseBody>> getMSDeployLogSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceFunctionsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions")
        Observable<Response<ResponseBody>> listInstanceFunctionsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getFunctionsAdminTokenSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/admin/token")
        Observable<Response<ResponseBody>> getFunctionsAdminTokenSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceFunctionSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}")
        Observable<Response<ResponseBody>> getInstanceFunctionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createInstanceFunctionSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}")
        Observable<Response<ResponseBody>> createInstanceFunctionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body FunctionEnvelopeInner functionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateInstanceFunctionSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}")
        Observable<Response<ResponseBody>> beginCreateInstanceFunctionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body FunctionEnvelopeInner functionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteInstanceFunctionSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteInstanceFunctionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listFunctionSecretsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listsecrets")
        Observable<Response<ResponseBody>> listFunctionSecretsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("functionName") String functionName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listHostNameBindingsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings")
        Observable<Response<ResponseBody>> listHostNameBindingsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getHostNameBindingSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}")
        Observable<Response<ResponseBody>> getHostNameBindingSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateHostNameBindingSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}")
        Observable<Response<ResponseBody>> createOrUpdateHostNameBindingSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("hostName") String hostName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body HostNameBindingInner hostNameBinding, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteHostNameBindingSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteHostNameBindingSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("hostName") String hostName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getHybridConnectionSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        Observable<Response<ResponseBody>> getHybridConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateHybridConnectionSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        Observable<Response<ResponseBody>> createOrUpdateHybridConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body HybridConnectionInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteHybridConnectionSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteHybridConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateHybridConnectionSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}")
        Observable<Response<ResponseBody>> updateHybridConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body HybridConnectionInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listHybridConnectionKeysSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys")
        Observable<Response<ResponseBody>> listHybridConnectionKeysSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("namespaceName") String namespaceName, @Path("relayName") String relayName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listHybridConnectionsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays")
        Observable<Response<ResponseBody>> listHybridConnectionsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listRelayServiceConnectionsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection")
        Observable<Response<ResponseBody>> listRelayServiceConnectionsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getRelayServiceConnectionSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}")
        Observable<Response<ResponseBody>> getRelayServiceConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("entityName") String entityName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateRelayServiceConnectionSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}")
        Observable<Response<ResponseBody>> createOrUpdateRelayServiceConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("entityName") String entityName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body RelayServiceConnectionEntityInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteRelayServiceConnectionSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteRelayServiceConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("entityName") String entityName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateRelayServiceConnectionSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}")
        Observable<Response<ResponseBody>> updateRelayServiceConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("entityName") String entityName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body RelayServiceConnectionEntityInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceIdentifiersSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances")
        Observable<Response<ResponseBody>> listInstanceIdentifiersSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceMsDeployStatusSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> getInstanceMsDeployStatusSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createInstanceMSDeployOperationSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> createInstanceMSDeployOperationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Body MSDeploy mSDeploy, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateInstanceMSDeployOperationSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy")
        Observable<Response<ResponseBody>> beginCreateInstanceMSDeployOperationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Body MSDeploy mSDeploy, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceMSDeployLogSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy/log")
        Observable<Response<ResponseBody>> getInstanceMSDeployLogSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes")
        Observable<Response<ResponseBody>> listInstanceProcessesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceProcessSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}")
        Observable<Response<ResponseBody>> getInstanceProcessSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteInstanceProcessSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteInstanceProcessSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceProcessDumpSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/dump")
        @Streaming
        Observable<Response<ResponseBody>> getInstanceProcessDumpSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessModulesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules")
        Observable<Response<ResponseBody>> listInstanceProcessModulesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceProcessModuleSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}")
        Observable<Response<ResponseBody>> getInstanceProcessModuleSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("baseAddress") String baseAddress, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessThreadsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads")
        Observable<Response<ResponseBody>> listInstanceProcessThreadsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getInstanceProcessThreadSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads/{threadId}")
        Observable<Response<ResponseBody>> getInstanceProcessThreadSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("threadId") String threadId, @Path("slot") String slot, @Path("instanceId") String instanceId, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps isCloneableSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable")
        Observable<Response<ResponseBody>> isCloneableSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSyncFunctionTriggersSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/listsyncfunctiontriggerstatus")
        Observable<Response<ResponseBody>> listSyncFunctionTriggersSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetricDefinitionsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions")
        Observable<Response<ResponseBody>> listMetricDefinitionsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetricsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics")
        Observable<Response<ResponseBody>> listMetricsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("details") Boolean details, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getMigrateMySqlStatusSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/migratemysql/status")
        Observable<Response<ResponseBody>> getMigrateMySqlStatusSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSwiftVirtualNetworkConnectionSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork")
        Observable<Response<ResponseBody>> getSwiftVirtualNetworkConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateSwiftVirtualNetworkConnectionSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork")
        Observable<Response<ResponseBody>> createOrUpdateSwiftVirtualNetworkConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SwiftVirtualNetworkInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteSwiftVirtualNetworkSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSwiftVirtualNetworkSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateSwiftVirtualNetworkConnectionSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkConfig/virtualNetwork")
        Observable<Response<ResponseBody>> updateSwiftVirtualNetworkConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SwiftVirtualNetworkInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listNetworkFeaturesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}")
        Observable<Response<ResponseBody>> listNetworkFeaturesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("view") String view, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getNetworkTraceOperationSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/operationresults/{operationId}")
        Observable<Response<ResponseBody>> getNetworkTraceOperationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("operationId") String operationId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startWebSiteNetworkTraceSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/start")
        Observable<Response<ResponseBody>> startWebSiteNetworkTraceSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startWebSiteNetworkTraceOperationSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/startOperation")
        Observable<Response<ResponseBody>> startWebSiteNetworkTraceOperationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginStartWebSiteNetworkTraceOperationSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/startOperation")
        Observable<Response<ResponseBody>> beginStartWebSiteNetworkTraceOperationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps stopWebSiteNetworkTraceSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/stop")
        Observable<Response<ResponseBody>> stopWebSiteNetworkTraceSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getNetworkTracesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/{operationId}")
        Observable<Response<ResponseBody>> getNetworkTracesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("operationId") String operationId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getNetworkTraceOperationSlotV2" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTraces/current/operationresults/{operationId}")
        Observable<Response<ResponseBody>> getNetworkTraceOperationSlotV2(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("operationId") String operationId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getNetworkTracesSlotV2" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTraces/{operationId}")
        Observable<Response<ResponseBody>> getNetworkTracesSlotV2(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("operationId") String operationId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps generateNewSitePublishingPasswordSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword")
        Observable<Response<ResponseBody>> generateNewSitePublishingPasswordSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPerfMonCountersSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters")
        Observable<Response<ResponseBody>> listPerfMonCountersSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSitePhpErrorLogFlagSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging")
        Observable<Response<ResponseBody>> getSitePhpErrorLogFlagSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPremierAddOnsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons")
        Observable<Response<ResponseBody>> listPremierAddOnsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getPremierAddOnSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}")
        Observable<Response<ResponseBody>> getPremierAddOnSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("premierAddOnName") String premierAddOnName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps addPremierAddOnSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}")
        Observable<Response<ResponseBody>> addPremierAddOnSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("premierAddOnName") String premierAddOnName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body PremierAddOnInner premierAddOn, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deletePremierAddOnSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deletePremierAddOnSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("premierAddOnName") String premierAddOnName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updatePremierAddOnSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}")
        Observable<Response<ResponseBody>> updatePremierAddOnSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("premierAddOnName") String premierAddOnName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body PremierAddOnPatchResource premierAddOn, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getPrivateAccessSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateAccess/virtualNetworks")
        Observable<Response<ResponseBody>> getPrivateAccessSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps putPrivateAccessVnetSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/privateAccess/virtualNetworks")
        Observable<Response<ResponseBody>> putPrivateAccessVnetSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body PrivateAccessInner access, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes")
        Observable<Response<ResponseBody>> listProcessesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getProcessSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}")
        Observable<Response<ResponseBody>> getProcessSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteProcessSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteProcessSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getProcessDumpSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/dump")
        @Streaming
        Observable<Response<ResponseBody>> getProcessDumpSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessModulesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules")
        Observable<Response<ResponseBody>> listProcessModulesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getProcessModuleSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules/{baseAddress}")
        Observable<Response<ResponseBody>> getProcessModuleSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("baseAddress") String baseAddress, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessThreadsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/threads")
        Observable<Response<ResponseBody>> listProcessThreadsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getProcessThreadSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/threads/{threadId}")
        Observable<Response<ResponseBody>> getProcessThreadSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("processId") String processId, @Path("threadId") String threadId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPublicCertificatesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates")
        Observable<Response<ResponseBody>> listPublicCertificatesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getPublicCertificateSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}")
        Observable<Response<ResponseBody>> getPublicCertificateSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("publicCertificateName") String publicCertificateName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdatePublicCertificateSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}")
        Observable<Response<ResponseBody>> createOrUpdatePublicCertificateSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("publicCertificateName") String publicCertificateName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body PublicCertificateInner publicCertificate, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deletePublicCertificateSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deletePublicCertificateSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("publicCertificateName") String publicCertificateName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPublishingProfileXmlWithSecretsSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml")
        @Streaming
        Observable<Response<ResponseBody>> listPublishingProfileXmlWithSecretsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body CsmPublishingProfileOptions publishingProfileOptions, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps resetSlotConfigurationSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig")
        Observable<Response<ResponseBody>> resetSlotConfigurationSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restartSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart")
        Observable<Response<ResponseBody>> restartSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("softRestart") Boolean softRestart, @Query("synchronous") Boolean synchronous, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restoreFromBackupBlobSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreFromBackupBlob")
        Observable<Response<ResponseBody>> restoreFromBackupBlobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginRestoreFromBackupBlobSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreFromBackupBlob")
        Observable<Response<ResponseBody>> beginRestoreFromBackupBlobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body RestoreRequestInner request, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restoreFromDeletedAppSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreFromDeletedApp")
        Observable<Response<ResponseBody>> restoreFromDeletedAppSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body DeletedAppRestoreRequest restoreRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginRestoreFromDeletedAppSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreFromDeletedApp")
        Observable<Response<ResponseBody>> beginRestoreFromDeletedAppSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body DeletedAppRestoreRequest restoreRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps restoreSnapshotSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreSnapshot")
        Observable<Response<ResponseBody>> restoreSnapshotSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SnapshotRestoreRequest restoreRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginRestoreSnapshotSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restoreSnapshot")
        Observable<Response<ResponseBody>> beginRestoreSnapshotSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SnapshotRestoreRequest restoreRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSiteExtensionsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions")
        Observable<Response<ResponseBody>> listSiteExtensionsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSiteExtensionSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}")
        Observable<Response<ResponseBody>> getSiteExtensionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("siteExtensionId") String siteExtensionId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps installSiteExtensionSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}")
        Observable<Response<ResponseBody>> installSiteExtensionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("siteExtensionId") String siteExtensionId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginInstallSiteExtensionSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}")
        Observable<Response<ResponseBody>> beginInstallSiteExtensionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("siteExtensionId") String siteExtensionId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteSiteExtensionSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{siteExtensionId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSiteExtensionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("siteExtensionId") String siteExtensionId, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSlotDifferencesSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs")
        Observable<Response<ResponseBody>> listSlotDifferencesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body CsmSlotEntity slotSwapEntity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps swapSlotSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap")
        Observable<Response<ResponseBody>> swapSlotSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body CsmSlotEntity slotSwapEntity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginSwapSlotSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap")
        Observable<Response<ResponseBody>> beginSwapSlotSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body CsmSlotEntity slotSwapEntity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSnapshotsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots")
        Observable<Response<ResponseBody>> listSnapshotsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSnapshotsFromDRSecondarySlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshotsdr")
        Observable<Response<ResponseBody>> listSnapshotsFromDRSecondarySlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSourceControlSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web")
        Observable<Response<ResponseBody>> getSourceControlSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateSourceControlSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web")
        Observable<Response<ResponseBody>> createOrUpdateSourceControlSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteSourceControlInner siteSourceControl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateOrUpdateSourceControlSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web")
        Observable<Response<ResponseBody>> beginCreateOrUpdateSourceControlSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteSourceControlInner siteSourceControl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteSourceControlSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSourceControlSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateSourceControlSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web")
        Observable<Response<ResponseBody>> updateSourceControlSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body SiteSourceControlInner siteSourceControl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start")
        Observable<Response<ResponseBody>> startSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startNetworkTraceSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/startNetworkTrace")
        Observable<Response<ResponseBody>> startNetworkTraceSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginStartNetworkTraceSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/startNetworkTrace")
        Observable<Response<ResponseBody>> beginStartNetworkTraceSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps stopSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop")
        Observable<Response<ResponseBody>> stopSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps stopNetworkTraceSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stopNetworkTrace")
        Observable<Response<ResponseBody>> stopNetworkTraceSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps syncRepositorySlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync")
        Observable<Response<ResponseBody>> syncRepositorySlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps syncFunctionTriggersSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/syncfunctiontriggers")
        Observable<Response<ResponseBody>> syncFunctionTriggersSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listTriggeredWebJobsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs")
        Observable<Response<ResponseBody>> listTriggeredWebJobsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getTriggeredWebJobSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}")
        Observable<Response<ResponseBody>> getTriggeredWebJobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteTriggeredWebJobSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteTriggeredWebJobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listTriggeredWebJobHistorySlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history")
        Observable<Response<ResponseBody>> listTriggeredWebJobHistorySlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getTriggeredWebJobHistorySlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history/{id}")
        Observable<Response<ResponseBody>> getTriggeredWebJobHistorySlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("id") String id, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps runTriggeredWebJobSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/run")
        Observable<Response<ResponseBody>> runTriggeredWebJobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listUsagesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages")
        Observable<Response<ResponseBody>> listUsagesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listVnetConnectionsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections")
        Observable<Response<ResponseBody>> listVnetConnectionsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getVnetConnectionSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}")
        Observable<Response<ResponseBody>> getVnetConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateVnetConnectionSlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}")
        Observable<Response<ResponseBody>> createOrUpdateVnetConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body VnetInfoInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteVnetConnectionSlot" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteVnetConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateVnetConnectionSlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}")
        Observable<Response<ResponseBody>> updateVnetConnectionSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body VnetInfoInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getVnetConnectionGatewaySlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        Observable<Response<ResponseBody>> getVnetConnectionGatewaySlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("gatewayName") String gatewayName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateVnetConnectionGatewaySlot" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        Observable<Response<ResponseBody>> createOrUpdateVnetConnectionGatewaySlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("gatewayName") String gatewayName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body VnetGatewayInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateVnetConnectionGatewaySlot" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        Observable<Response<ResponseBody>> updateVnetConnectionGatewaySlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("gatewayName") String gatewayName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Body VnetGatewayInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listWebJobsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs")
        Observable<Response<ResponseBody>> listWebJobsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getWebJobSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs/{webJobName}")
        Observable<Response<ResponseBody>> getWebJobSlot(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSlotDifferencesFromProduction" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs")
        Observable<Response<ResponseBody>> listSlotDifferencesFromProduction(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body CsmSlotEntity slotSwapEntity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps swapSlotWithProduction" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap")
        Observable<Response<ResponseBody>> swapSlotWithProduction(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body CsmSlotEntity slotSwapEntity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginSwapSlotWithProduction" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap")
        Observable<Response<ResponseBody>> beginSwapSlotWithProduction(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body CsmSlotEntity slotSwapEntity, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSnapshots" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots")
        Observable<Response<ResponseBody>> listSnapshots(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSnapshotsFromDRSecondary" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshotsdr")
        Observable<Response<ResponseBody>> listSnapshotsFromDRSecondary(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getSourceControl" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web")
        Observable<Response<ResponseBody>> getSourceControl(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateSourceControl" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web")
        Observable<Response<ResponseBody>> createOrUpdateSourceControl(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteSourceControlInner siteSourceControl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginCreateOrUpdateSourceControl" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web")
        Observable<Response<ResponseBody>> beginCreateOrUpdateSourceControl(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteSourceControlInner siteSourceControl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteSourceControl" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteSourceControl(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateSourceControl" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web")
        Observable<Response<ResponseBody>> updateSourceControl(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Body SiteSourceControlInner siteSourceControl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps start" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start")
        Observable<Response<ResponseBody>> start(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps startNetworkTrace" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/startNetworkTrace")
        Observable<Response<ResponseBody>> startNetworkTrace(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps beginStartNetworkTrace" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/startNetworkTrace")
        Observable<Response<ResponseBody>> beginStartNetworkTrace(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("durationInSeconds") Integer durationInSeconds, @Query("maxFrameLength") Integer maxFrameLength, @Query("sasUrl") String sasUrl, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps stop" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop")
        Observable<Response<ResponseBody>> stop(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps stopNetworkTrace" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stopNetworkTrace")
        Observable<Response<ResponseBody>> stopNetworkTrace(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps syncRepository" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync")
        Observable<Response<ResponseBody>> syncRepository(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps syncFunctionTriggers" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/syncfunctiontriggers")
        Observable<Response<ResponseBody>> syncFunctionTriggers(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listTriggeredWebJobs" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs")
        Observable<Response<ResponseBody>> listTriggeredWebJobs(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getTriggeredWebJob" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}")
        Observable<Response<ResponseBody>> getTriggeredWebJob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteTriggeredWebJob" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteTriggeredWebJob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listTriggeredWebJobHistory" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history")
        Observable<Response<ResponseBody>> listTriggeredWebJobHistory(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getTriggeredWebJobHistory" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history/{id}")
        Observable<Response<ResponseBody>> getTriggeredWebJobHistory(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("id") String id, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps runTriggeredWebJob" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/run")
        Observable<Response<ResponseBody>> runTriggeredWebJob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listUsages" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages")
        Observable<Response<ResponseBody>> listUsages(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query(value = "$filter", encoded = true) String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listVnetConnections" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections")
        Observable<Response<ResponseBody>> listVnetConnections(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getVnetConnection" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}")
        Observable<Response<ResponseBody>> getVnetConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateVnetConnection" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}")
        Observable<Response<ResponseBody>> createOrUpdateVnetConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("subscriptionId") String subscriptionId, @Body VnetInfoInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteVnetConnection" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> deleteVnetConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateVnetConnection" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}")
        Observable<Response<ResponseBody>> updateVnetConnection(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("subscriptionId") String subscriptionId, @Body VnetInfoInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getVnetConnectionGateway" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        Observable<Response<ResponseBody>> getVnetConnectionGateway(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("gatewayName") String gatewayName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps createOrUpdateVnetConnectionGateway" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        Observable<Response<ResponseBody>> createOrUpdateVnetConnectionGateway(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("gatewayName") String gatewayName, @Path("subscriptionId") String subscriptionId, @Body VnetGatewayInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps updateVnetConnectionGateway" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}")
        Observable<Response<ResponseBody>> updateVnetConnectionGateway(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("vnetName") String vnetName, @Path("gatewayName") String gatewayName, @Path("subscriptionId") String subscriptionId, @Body VnetGatewayInner connectionEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listWebJobs" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs")
        Observable<Response<ResponseBody>> listWebJobs(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getWebJob" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs/{webJobName}")
        Observable<Response<ResponseBody>> getWebJob(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("webJobName") String webJobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listBackupsNext" })
        @GET
        Observable<Response<ResponseBody>> listBackupsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConfigurationsNext" })
        @GET
        Observable<Response<ResponseBody>> listConfigurationsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConfigurationSnapshotInfoNext" })
        @GET
        Observable<Response<ResponseBody>> listConfigurationSnapshotInfoNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listContinuousWebJobsNext" })
        @GET
        Observable<Response<ResponseBody>> listContinuousWebJobsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDeploymentsNext" })
        @GET
        Observable<Response<ResponseBody>> listDeploymentsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDomainOwnershipIdentifiersNext" })
        @GET
        Observable<Response<ResponseBody>> listDomainOwnershipIdentifiersNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listFunctionsNext" })
        @GET
        Observable<Response<ResponseBody>> listFunctionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listHostNameBindingsNext" })
        @GET
        Observable<Response<ResponseBody>> listHostNameBindingsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceIdentifiersNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceIdentifiersNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessesNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceProcessesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessModulesNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceProcessModulesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessThreadsNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceProcessThreadsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetricDefinitionsNext" })
        @GET
        Observable<Response<ResponseBody>> listMetricDefinitionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetricsNext" })
        @GET
        Observable<Response<ResponseBody>> listMetricsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPerfMonCountersNext" })
        @GET
        Observable<Response<ResponseBody>> listPerfMonCountersNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessesNext" })
        @GET
        Observable<Response<ResponseBody>> listProcessesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessModulesNext" })
        @GET
        Observable<Response<ResponseBody>> listProcessModulesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessThreadsNext" })
        @GET
        Observable<Response<ResponseBody>> listProcessThreadsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPublicCertificatesNext" })
        @GET
        Observable<Response<ResponseBody>> listPublicCertificatesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSiteExtensionsNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteExtensionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSlotsNext" })
        @GET
        Observable<Response<ResponseBody>> listSlotsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listBackupsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listBackupsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConfigurationsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listConfigurationsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listConfigurationSnapshotInfoSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listConfigurationSnapshotInfoSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listContinuousWebJobsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listContinuousWebJobsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDeploymentsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listDeploymentsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listDomainOwnershipIdentifiersSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listDomainOwnershipIdentifiersSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceFunctionsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceFunctionsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listHostNameBindingsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listHostNameBindingsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceIdentifiersSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceIdentifiersSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceProcessesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessModulesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceProcessModulesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listInstanceProcessThreadsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listInstanceProcessThreadsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetricDefinitionsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listMetricDefinitionsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listMetricsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listMetricsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPerfMonCountersSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listPerfMonCountersSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listProcessesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessModulesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listProcessModulesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listProcessThreadsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listProcessThreadsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listPublicCertificatesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listPublicCertificatesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSiteExtensionsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteExtensionsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSlotDifferencesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listSlotDifferencesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSnapshotsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listSnapshotsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSnapshotsFromDRSecondarySlotNext" })
        @GET
        Observable<Response<ResponseBody>> listSnapshotsFromDRSecondarySlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listTriggeredWebJobsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listTriggeredWebJobsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listTriggeredWebJobHistorySlotNext" })
        @GET
        Observable<Response<ResponseBody>> listTriggeredWebJobHistorySlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listUsagesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listUsagesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listWebJobsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listWebJobsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSlotDifferencesFromProductionNext" })
        @GET
        Observable<Response<ResponseBody>> listSlotDifferencesFromProductionNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSnapshotsNext" })
        @GET
        Observable<Response<ResponseBody>> listSnapshotsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listSnapshotsFromDRSecondaryNext" })
        @GET
        Observable<Response<ResponseBody>> listSnapshotsFromDRSecondaryNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listTriggeredWebJobsNext" })
        @GET
        Observable<Response<ResponseBody>> listTriggeredWebJobsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listTriggeredWebJobHistoryNext" })
        @GET
        Observable<Response<ResponseBody>> listTriggeredWebJobHistoryNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listUsagesNext" })
        @GET
        Observable<Response<ResponseBody>> listUsagesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listWebJobsNext" })
        @GET
        Observable<Response<ResponseBody>> listWebJobsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Get all apps for a subscription.
     * Get all apps for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> list() {
        ServiceResponse<Page<SiteInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get all apps for a subscription.
     * Get all apps for a subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> listAsync(final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get all apps for a subscription.
     * Get all apps for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get all apps for a subscription.
     * Get all apps for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get all apps for a subscription.
     * Get all apps for a subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<SiteInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean includeSlots = null;
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), includeSlots, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default is false, which only gives you the production slot of all apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInner&gt; object if successful.
     */
    public PagedList<SiteInner> listByResourceGroup(final String resourceGroupName, final Boolean includeSlots) {
        ServiceResponse<Page<SiteInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots).toBlocking().single();
        return new PagedList<SiteInner>(response.body()) {
            @Override
            public Page<SiteInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default is false, which only gives you the production slot of all apps.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInner>> listByResourceGroupAsync(final String resourceGroupName, final Boolean includeSlots, final ListOperationCallback<SiteInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots),
            new Func1<String, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default is false, which only gives you the production slot of all apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<Page<SiteInner>> listByResourceGroupAsync(final String resourceGroupName, final Boolean includeSlots) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName, includeSlots)
            .map(new Func1<ServiceResponse<Page<SiteInner>>, Page<SiteInner>>() {
                @Override
                public Page<SiteInner> call(ServiceResponse<Page<SiteInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default is false, which only gives you the production slot of all apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName, final Boolean includeSlots) {
        return listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots)
            .concatMap(new Func1<ServiceResponse<Page<SiteInner>>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(ServiceResponse<Page<SiteInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all web, mobile, and API apps in the specified resource group.
     * Gets all web, mobile, and API apps in the specified resource group.
     *
    ServiceResponse<PageImpl<SiteInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInner>> * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default is false, which only gives you the production slot of all apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName, final Boolean includeSlots) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), includeSlots, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteInner object if successful.
     */
    public SiteInner getByResourceGroup(String resourceGroupName, String name) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteInner> getByResourceGroupAsync(String resourceGroupName, String name, final ServiceCallback<SiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteInner object
     */
    public Observable<SiteInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<SiteInner>, SiteInner>() {
            @Override
            public SiteInner call(ServiceResponse<SiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the details of a web, mobile, or API app.
     * Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteInner object
     */
    public Observable<ServiceResponse<SiteInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getByResourceGroup(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteInner object if successful.
     */
    public SiteInner createOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope).toBlocking().last().body();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteInner> createOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope, final ServiceCallback<SiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope), serviceCallback);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<SiteInner> createOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope).map(new Func1<ServiceResponse<SiteInner>, SiteInner>() {
            @Override
            public SiteInner call(ServiceResponse<SiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<SiteInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String name, SiteInner siteEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteEnvelope == null) {
            throw new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(siteEnvelope);
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, name, this.client.subscriptionId(), siteEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SiteInner>() { }.getType());
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteInner object if successful.
     */
    public SiteInner beginCreateOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope).toBlocking().single().body();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope, final ServiceCallback<SiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope), serviceCallback);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteInner object
     */
    public Observable<SiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope).map(new Func1<ServiceResponse<SiteInner>, SiteInner>() {
            @Override
            public SiteInner call(ServiceResponse<SiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteInner object
     */
    public Observable<ServiceResponse<SiteInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String name, SiteInner siteEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteEnvelope == null) {
            throw new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(siteEnvelope);
        return service.beginCreateOrUpdate(resourceGroupName, name, this.client.subscriptionId(), siteEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteInner>() { }.getType())
                .register(202, new TypeToken<SiteInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String name) {
        deleteWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String name) {
        return deleteWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean deleteMetrics = null;
        final Boolean deleteEmptyServerFarm = null;
        return service.delete(resourceGroupName, name, this.client.subscriptionId(), deleteMetrics, deleteEmptyServerFarm, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify true if the App Service plan will be empty after app deletion and you want to delete the empty App Service plan. By default, the empty App Service plan is not deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm) {
        deleteWithServiceResponseAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm).toBlocking().single().body();
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify true if the App Service plan will be empty after app deletion and you want to delete the empty App Service plan. By default, the empty App Service plan is not deleted.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm), serviceCallback);
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify true if the App Service plan will be empty after app deletion and you want to delete the empty App Service plan. By default, the empty App Service plan is not deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm) {
        return deleteWithServiceResponseAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     * Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify true if the App Service plan will be empty after app deletion and you want to delete the empty App Service plan. By default, the empty App Service plan is not deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, name, this.client.subscriptionId(), deleteMetrics, deleteEmptyServerFarm, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteInner object if successful.
     */
    public SiteInner update(String resourceGroupName, String name, SitePatchResource siteEnvelope) {
        return updateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope).toBlocking().single().body();
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteInner> updateAsync(String resourceGroupName, String name, SitePatchResource siteEnvelope, final ServiceCallback<SiteInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope), serviceCallback);
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteInner object
     */
    public Observable<SiteInner> updateAsync(String resourceGroupName, String name, SitePatchResource siteEnvelope) {
        return updateWithServiceResponseAsync(resourceGroupName, name, siteEnvelope).map(new Func1<ServiceResponse<SiteInner>, SiteInner>() {
            @Override
            public SiteInner call(ServiceResponse<SiteInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     * Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot} parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteInner object
     */
    public Observable<ServiceResponse<SiteInner>> updateWithServiceResponseAsync(String resourceGroupName, String name, SitePatchResource siteEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteEnvelope == null) {
            throw new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(siteEnvelope);
        return service.update(resourceGroupName, name, this.client.subscriptionId(), siteEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteInner> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteInner> updateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteInner>() { }.getType())
                .register(202, new TypeToken<SiteInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Analyze a custom hostname.
     * Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomHostnameAnalysisResultInner object if successful.
     */
    public CustomHostnameAnalysisResultInner analyzeCustomHostname(String resourceGroupName, String name) {
        return analyzeCustomHostnameWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Analyze a custom hostname.
     * Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(String resourceGroupName, String name, final ServiceCallback<CustomHostnameAnalysisResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(analyzeCustomHostnameWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Analyze a custom hostname.
     * Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomHostnameAnalysisResultInner object
     */
    public Observable<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(String resourceGroupName, String name) {
        return analyzeCustomHostnameWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<CustomHostnameAnalysisResultInner>, CustomHostnameAnalysisResultInner>() {
            @Override
            public CustomHostnameAnalysisResultInner call(ServiceResponse<CustomHostnameAnalysisResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Analyze a custom hostname.
     * Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomHostnameAnalysisResultInner object
     */
    public Observable<ServiceResponse<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final String hostName = null;
        return service.analyzeCustomHostname(resourceGroupName, name, this.client.subscriptionId(), hostName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomHostnameAnalysisResultInner>>>() {
                @Override
                public Observable<ServiceResponse<CustomHostnameAnalysisResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CustomHostnameAnalysisResultInner> clientResponse = analyzeCustomHostnameDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Analyze a custom hostname.
     * Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostName Custom hostname.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CustomHostnameAnalysisResultInner object if successful.
     */
    public CustomHostnameAnalysisResultInner analyzeCustomHostname(String resourceGroupName, String name, String hostName) {
        return analyzeCustomHostnameWithServiceResponseAsync(resourceGroupName, name, hostName).toBlocking().single().body();
    }

    /**
     * Analyze a custom hostname.
     * Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostName Custom hostname.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(String resourceGroupName, String name, String hostName, final ServiceCallback<CustomHostnameAnalysisResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(analyzeCustomHostnameWithServiceResponseAsync(resourceGroupName, name, hostName), serviceCallback);
    }

    /**
     * Analyze a custom hostname.
     * Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostName Custom hostname.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomHostnameAnalysisResultInner object
     */
    public Observable<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(String resourceGroupName, String name, String hostName) {
        return analyzeCustomHostnameWithServiceResponseAsync(resourceGroupName, name, hostName).map(new Func1<ServiceResponse<CustomHostnameAnalysisResultInner>, CustomHostnameAnalysisResultInner>() {
            @Override
            public CustomHostnameAnalysisResultInner call(ServiceResponse<CustomHostnameAnalysisResultInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Analyze a custom hostname.
     * Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostName Custom hostname.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CustomHostnameAnalysisResultInner object
     */
    public Observable<ServiceResponse<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameWithServiceResponseAsync(String resourceGroupName, String name, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.analyzeCustomHostname(resourceGroupName, name, this.client.subscriptionId(), hostName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<CustomHostnameAnalysisResultInner>>>() {
                @Override
                public Observable<ServiceResponse<CustomHostnameAnalysisResultInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<CustomHostnameAnalysisResultInner> clientResponse = analyzeCustomHostnameDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<CustomHostnameAnalysisResultInner> analyzeCustomHostnameDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CustomHostnameAnalysisResultInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CustomHostnameAnalysisResultInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void applySlotConfigToProduction(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity) {
        applySlotConfigToProductionWithServiceResponseAsync(resourceGroupName, name, slotSwapEntity).toBlocking().single().body();
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> applySlotConfigToProductionAsync(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(applySlotConfigToProductionWithServiceResponseAsync(resourceGroupName, name, slotSwapEntity), serviceCallback);
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> applySlotConfigToProductionAsync(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity) {
        return applySlotConfigToProductionWithServiceResponseAsync(resourceGroupName, name, slotSwapEntity).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Applies the configuration settings from the target slot onto the current slot.
     * Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> applySlotConfigToProductionWithServiceResponseAsync(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (slotSwapEntity == null) {
            throw new IllegalArgumentException("Parameter slotSwapEntity is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(slotSwapEntity);
        return service.applySlotConfigToProduction(resourceGroupName, name, this.client.subscriptionId(), slotSwapEntity, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = applySlotConfigToProductionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> applySlotConfigToProductionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a backup of an app.
     * Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupItemInner object if successful.
     */
    public BackupItemInner backup(String resourceGroupName, String name, BackupRequestInner request) {
        return backupWithServiceResponseAsync(resourceGroupName, name, request).toBlocking().single().body();
    }

    /**
     * Creates a backup of an app.
     * Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BackupItemInner> backupAsync(String resourceGroupName, String name, BackupRequestInner request, final ServiceCallback<BackupItemInner> serviceCallback) {
        return ServiceFuture.fromResponse(backupWithServiceResponseAsync(resourceGroupName, name, request), serviceCallback);
    }

    /**
     * Creates a backup of an app.
     * Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupItemInner object
     */
    public Observable<BackupItemInner> backupAsync(String resourceGroupName, String name, BackupRequestInner request) {
        return backupWithServiceResponseAsync(resourceGroupName, name, request).map(new Func1<ServiceResponse<BackupItemInner>, BackupItemInner>() {
            @Override
            public BackupItemInner call(ServiceResponse<BackupItemInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a backup of an app.
     * Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupItemInner object
     */
    public Observable<ServiceResponse<BackupItemInner>> backupWithServiceResponseAsync(String resourceGroupName, String name, BackupRequestInner request) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(request);
        return service.backup(resourceGroupName, name, this.client.subscriptionId(), request, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupItemInner>>>() {
                @Override
                public Observable<ServiceResponse<BackupItemInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BackupItemInner> clientResponse = backupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BackupItemInner> backupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BackupItemInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BackupItemInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets existing backups of an app.
     * Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BackupItemInner&gt; object if successful.
     */
    public PagedList<BackupItemInner> listBackups(final String resourceGroupName, final String name) {
        ServiceResponse<Page<BackupItemInner>> response = listBackupsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<BackupItemInner>(response.body()) {
            @Override
            public Page<BackupItemInner> nextPage(String nextPageLink) {
                return listBackupsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets existing backups of an app.
     * Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BackupItemInner>> listBackupsAsync(final String resourceGroupName, final String name, final ListOperationCallback<BackupItemInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBackupsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<BackupItemInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BackupItemInner>>> call(String nextPageLink) {
                    return listBackupsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets existing backups of an app.
     * Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BackupItemInner&gt; object
     */
    public Observable<Page<BackupItemInner>> listBackupsAsync(final String resourceGroupName, final String name) {
        return listBackupsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<BackupItemInner>>, Page<BackupItemInner>>() {
                @Override
                public Page<BackupItemInner> call(ServiceResponse<Page<BackupItemInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets existing backups of an app.
     * Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BackupItemInner&gt; object
     */
    public Observable<ServiceResponse<Page<BackupItemInner>>> listBackupsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listBackupsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<BackupItemInner>>, Observable<ServiceResponse<Page<BackupItemInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BackupItemInner>>> call(ServiceResponse<Page<BackupItemInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBackupsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets existing backups of an app.
     * Gets existing backups of an app.
     *
    ServiceResponse<PageImpl<BackupItemInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<BackupItemInner>> * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BackupItemInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BackupItemInner>>> listBackupsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listBackups(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BackupItemInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BackupItemInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BackupItemInner>> result = listBackupsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BackupItemInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BackupItemInner>> listBackupsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<BackupItemInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BackupItemInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a backup of an app by its ID.
     * Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupItemInner object if successful.
     */
    public BackupItemInner getBackupStatus(String resourceGroupName, String name, String backupId) {
        return getBackupStatusWithServiceResponseAsync(resourceGroupName, name, backupId).toBlocking().single().body();
    }

    /**
     * Gets a backup of an app by its ID.
     * Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BackupItemInner> getBackupStatusAsync(String resourceGroupName, String name, String backupId, final ServiceCallback<BackupItemInner> serviceCallback) {
        return ServiceFuture.fromResponse(getBackupStatusWithServiceResponseAsync(resourceGroupName, name, backupId), serviceCallback);
    }

    /**
     * Gets a backup of an app by its ID.
     * Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupItemInner object
     */
    public Observable<BackupItemInner> getBackupStatusAsync(String resourceGroupName, String name, String backupId) {
        return getBackupStatusWithServiceResponseAsync(resourceGroupName, name, backupId).map(new Func1<ServiceResponse<BackupItemInner>, BackupItemInner>() {
            @Override
            public BackupItemInner call(ServiceResponse<BackupItemInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a backup of an app by its ID.
     * Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupItemInner object
     */
    public Observable<ServiceResponse<BackupItemInner>> getBackupStatusWithServiceResponseAsync(String resourceGroupName, String name, String backupId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (backupId == null) {
            throw new IllegalArgumentException("Parameter backupId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getBackupStatus(resourceGroupName, name, backupId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupItemInner>>>() {
                @Override
                public Observable<ServiceResponse<BackupItemInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BackupItemInner> clientResponse = getBackupStatusDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BackupItemInner> getBackupStatusDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BackupItemInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BackupItemInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a backup of an app by its ID.
     * Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteBackup(String resourceGroupName, String name, String backupId) {
        deleteBackupWithServiceResponseAsync(resourceGroupName, name, backupId).toBlocking().single().body();
    }

    /**
     * Deletes a backup of an app by its ID.
     * Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteBackupAsync(String resourceGroupName, String name, String backupId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteBackupWithServiceResponseAsync(resourceGroupName, name, backupId), serviceCallback);
    }

    /**
     * Deletes a backup of an app by its ID.
     * Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteBackupAsync(String resourceGroupName, String name, String backupId) {
        return deleteBackupWithServiceResponseAsync(resourceGroupName, name, backupId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a backup of an app by its ID.
     * Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteBackupWithServiceResponseAsync(String resourceGroupName, String name, String backupId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (backupId == null) {
            throw new IllegalArgumentException("Parameter backupId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteBackup(resourceGroupName, name, backupId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteBackupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteBackupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body.
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupItemInner object if successful.
     */
    public BackupItemInner listBackupStatusSecrets(String resourceGroupName, String name, String backupId, BackupRequestInner request) {
        return listBackupStatusSecretsWithServiceResponseAsync(resourceGroupName, name, backupId, request).toBlocking().single().body();
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body.
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BackupItemInner> listBackupStatusSecretsAsync(String resourceGroupName, String name, String backupId, BackupRequestInner request, final ServiceCallback<BackupItemInner> serviceCallback) {
        return ServiceFuture.fromResponse(listBackupStatusSecretsWithServiceResponseAsync(resourceGroupName, name, backupId, request), serviceCallback);
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body.
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupItemInner object
     */
    public Observable<BackupItemInner> listBackupStatusSecretsAsync(String resourceGroupName, String name, String backupId, BackupRequestInner request) {
        return listBackupStatusSecretsWithServiceResponseAsync(resourceGroupName, name, backupId, request).map(new Func1<ServiceResponse<BackupItemInner>, BackupItemInner>() {
            @Override
            public BackupItemInner call(ServiceResponse<BackupItemInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body.
     * Gets status of a web app backup that may be in progress, including secrets associated with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupItemInner object
     */
    public Observable<ServiceResponse<BackupItemInner>> listBackupStatusSecretsWithServiceResponseAsync(String resourceGroupName, String name, String backupId, BackupRequestInner request) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (backupId == null) {
            throw new IllegalArgumentException("Parameter backupId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(request);
        return service.listBackupStatusSecrets(resourceGroupName, name, backupId, this.client.subscriptionId(), request, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupItemInner>>>() {
                @Override
                public Observable<ServiceResponse<BackupItemInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BackupItemInner> clientResponse = listBackupStatusSecretsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BackupItemInner> listBackupStatusSecretsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BackupItemInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BackupItemInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void restore(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        restoreWithServiceResponseAsync(resourceGroupName, name, backupId, request).toBlocking().last().body();
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> restoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(restoreWithServiceResponseAsync(resourceGroupName, name, backupId, request), serviceCallback);
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> restoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        return restoreWithServiceResponseAsync(resourceGroupName, name, backupId, request).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> restoreWithServiceResponseAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (backupId == null) {
            throw new IllegalArgumentException("Parameter backupId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(request);
        Observable<Response<ResponseBody>> observable = service.restore(resourceGroupName, name, backupId, this.client.subscriptionId(), request, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginRestore(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        beginRestoreWithServiceResponseAsync(resourceGroupName, name, backupId, request).toBlocking().single().body();
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginRestoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginRestoreWithServiceResponseAsync(resourceGroupName, name, backupId, request), serviceCallback);
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginRestoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        return beginRestoreWithServiceResponseAsync(resourceGroupName, name, backupId, request).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Restores a specific backup to another app (or deployment slot, if specified).
     * Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginRestoreWithServiceResponseAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (backupId == null) {
            throw new IllegalArgumentException("Parameter backupId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(request);
        return service.beginRestore(resourceGroupName, name, backupId, this.client.subscriptionId(), request, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginRestoreDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginRestoreDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List the configurations of an app.
     * List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteConfigResourceInner&gt; object if successful.
     */
    public PagedList<SiteConfigResourceInner> listConfigurations(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SiteConfigResourceInner>> response = listConfigurationsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SiteConfigResourceInner>(response.body()) {
            @Override
            public Page<SiteConfigResourceInner> nextPage(String nextPageLink) {
                return listConfigurationsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List the configurations of an app.
     * List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteConfigResourceInner>> listConfigurationsAsync(final String resourceGroupName, final String name, final ListOperationCallback<SiteConfigResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listConfigurationsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SiteConfigResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteConfigResourceInner>>> call(String nextPageLink) {
                    return listConfigurationsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List the configurations of an app.
     * List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteConfigResourceInner&gt; object
     */
    public Observable<Page<SiteConfigResourceInner>> listConfigurationsAsync(final String resourceGroupName, final String name) {
        return listConfigurationsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SiteConfigResourceInner>>, Page<SiteConfigResourceInner>>() {
                @Override
                public Page<SiteConfigResourceInner> call(ServiceResponse<Page<SiteConfigResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List the configurations of an app.
     * List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteConfigResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteConfigResourceInner>>> listConfigurationsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listConfigurationsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SiteConfigResourceInner>>, Observable<ServiceResponse<Page<SiteConfigResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteConfigResourceInner>>> call(ServiceResponse<Page<SiteConfigResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listConfigurationsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List the configurations of an app.
     * List the configurations of an app.
     *
    ServiceResponse<PageImpl<SiteConfigResourceInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteConfigResourceInner>> * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteConfigResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteConfigResourceInner>>> listConfigurationsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listConfigurations(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteConfigResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteConfigResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteConfigResourceInner>> result = listConfigurationsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteConfigResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteConfigResourceInner>> listConfigurationsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteConfigResourceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteConfigResourceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Replaces the application settings of an app.
     * Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StringDictionaryInner object if successful.
     */
    public StringDictionaryInner updateApplicationSettings(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return updateApplicationSettingsWithServiceResponseAsync(resourceGroupName, name, appSettings).toBlocking().single().body();
    }

    /**
     * Replaces the application settings of an app.
     * Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<StringDictionaryInner> updateApplicationSettingsAsync(String resourceGroupName, String name, StringDictionaryInner appSettings, final ServiceCallback<StringDictionaryInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateApplicationSettingsWithServiceResponseAsync(resourceGroupName, name, appSettings), serviceCallback);
    }

    /**
     * Replaces the application settings of an app.
     * Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StringDictionaryInner object
     */
    public Observable<StringDictionaryInner> updateApplicationSettingsAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return updateApplicationSettingsWithServiceResponseAsync(resourceGroupName, name, appSettings).map(new Func1<ServiceResponse<StringDictionaryInner>, StringDictionaryInner>() {
            @Override
            public StringDictionaryInner call(ServiceResponse<StringDictionaryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Replaces the application settings of an app.
     * Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StringDictionaryInner object
     */
    public Observable<ServiceResponse<StringDictionaryInner>> updateApplicationSettingsWithServiceResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (appSettings == null) {
            throw new IllegalArgumentException("Parameter appSettings is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(appSettings);
        return service.updateApplicationSettings(resourceGroupName, name, this.client.subscriptionId(), appSettings, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<StringDictionaryInner>>>() {
                @Override
                public Observable<ServiceResponse<StringDictionaryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<StringDictionaryInner> clientResponse = updateApplicationSettingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<StringDictionaryInner> updateApplicationSettingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<StringDictionaryInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<StringDictionaryInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the application settings of an app.
     * Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StringDictionaryInner object if successful.
     */
    public StringDictionaryInner listApplicationSettings(String resourceGroupName, String name) {
        return listApplicationSettingsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the application settings of an app.
     * Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<StringDictionaryInner> listApplicationSettingsAsync(String resourceGroupName, String name, final ServiceCallback<StringDictionaryInner> serviceCallback) {
        return ServiceFuture.fromResponse(listApplicationSettingsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the application settings of an app.
     * Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StringDictionaryInner object
     */
    public Observable<StringDictionaryInner> listApplicationSettingsAsync(String resourceGroupName, String name) {
        return listApplicationSettingsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<StringDictionaryInner>, StringDictionaryInner>() {
            @Override
            public StringDictionaryInner call(ServiceResponse<StringDictionaryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the application settings of an app.
     * Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StringDictionaryInner object
     */
    public Observable<ServiceResponse<StringDictionaryInner>> listApplicationSettingsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listApplicationSettings(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<StringDictionaryInner>>>() {
                @Override
                public Observable<ServiceResponse<StringDictionaryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<StringDictionaryInner> clientResponse = listApplicationSettingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<StringDictionaryInner> listApplicationSettingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<StringDictionaryInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<StringDictionaryInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteAuthSettingsInner object if successful.
     */
    public SiteAuthSettingsInner updateAuthSettings(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings) {
        return updateAuthSettingsWithServiceResponseAsync(resourceGroupName, name, siteAuthSettings).toBlocking().single().body();
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteAuthSettingsInner> updateAuthSettingsAsync(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings, final ServiceCallback<SiteAuthSettingsInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateAuthSettingsWithServiceResponseAsync(resourceGroupName, name, siteAuthSettings), serviceCallback);
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteAuthSettingsInner object
     */
    public Observable<SiteAuthSettingsInner> updateAuthSettingsAsync(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings) {
        return updateAuthSettingsWithServiceResponseAsync(resourceGroupName, name, siteAuthSettings).map(new Func1<ServiceResponse<SiteAuthSettingsInner>, SiteAuthSettingsInner>() {
            @Override
            public SiteAuthSettingsInner call(ServiceResponse<SiteAuthSettingsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the Authentication / Authorization settings associated with web app.
     * Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteAuthSettingsInner object
     */
    public Observable<ServiceResponse<SiteAuthSettingsInner>> updateAuthSettingsWithServiceResponseAsync(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteAuthSettings == null) {
            throw new IllegalArgumentException("Parameter siteAuthSettings is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(siteAuthSettings);
        return service.updateAuthSettings(resourceGroupName, name, this.client.subscriptionId(), siteAuthSettings, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteAuthSettingsInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteAuthSettingsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteAuthSettingsInner> clientResponse = updateAuthSettingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteAuthSettingsInner> updateAuthSettingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteAuthSettingsInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteAuthSettingsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteAuthSettingsInner object if successful.
     */
    public SiteAuthSettingsInner getAuthSettings(String resourceGroupName, String name) {
        return getAuthSettingsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteAuthSettingsInner> getAuthSettingsAsync(String resourceGroupName, String name, final ServiceCallback<SiteAuthSettingsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getAuthSettingsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteAuthSettingsInner object
     */
    public Observable<SiteAuthSettingsInner> getAuthSettingsAsync(String resourceGroupName, String name) {
        return getAuthSettingsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<SiteAuthSettingsInner>, SiteAuthSettingsInner>() {
            @Override
            public SiteAuthSettingsInner call(ServiceResponse<SiteAuthSettingsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Authentication/Authorization settings of an app.
     * Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteAuthSettingsInner object
     */
    public Observable<ServiceResponse<SiteAuthSettingsInner>> getAuthSettingsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getAuthSettings(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteAuthSettingsInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteAuthSettingsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteAuthSettingsInner> clientResponse = getAuthSettingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteAuthSettingsInner> getAuthSettingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteAuthSettingsInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteAuthSettingsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AzureStoragePropertyDictionaryResourceInner object if successful.
     */
    public AzureStoragePropertyDictionaryResourceInner updateAzureStorageAccounts(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        return updateAzureStorageAccountsWithServiceResponseAsync(resourceGroupName, name, azureStorageAccounts).toBlocking().single().body();
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsAsync(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts, final ServiceCallback<AzureStoragePropertyDictionaryResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateAzureStorageAccountsWithServiceResponseAsync(resourceGroupName, name, azureStorageAccounts), serviceCallback);
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AzureStoragePropertyDictionaryResourceInner object
     */
    public Observable<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsAsync(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        return updateAzureStorageAccountsWithServiceResponseAsync(resourceGroupName, name, azureStorageAccounts).map(new Func1<ServiceResponse<AzureStoragePropertyDictionaryResourceInner>, AzureStoragePropertyDictionaryResourceInner>() {
            @Override
            public AzureStoragePropertyDictionaryResourceInner call(ServiceResponse<AzureStoragePropertyDictionaryResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the Azure storage account configurations of an app.
     * Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AzureStoragePropertyDictionaryResourceInner object
     */
    public Observable<ServiceResponse<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsWithServiceResponseAsync(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (azureStorageAccounts == null) {
            throw new IllegalArgumentException("Parameter azureStorageAccounts is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(azureStorageAccounts);
        return service.updateAzureStorageAccounts(resourceGroupName, name, this.client.subscriptionId(), azureStorageAccounts, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AzureStoragePropertyDictionaryResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AzureStoragePropertyDictionaryResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AzureStoragePropertyDictionaryResourceInner> clientResponse = updateAzureStorageAccountsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AzureStoragePropertyDictionaryResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AzureStoragePropertyDictionaryResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AzureStoragePropertyDictionaryResourceInner object if successful.
     */
    public AzureStoragePropertyDictionaryResourceInner listAzureStorageAccounts(String resourceGroupName, String name) {
        return listAzureStorageAccountsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsAsync(String resourceGroupName, String name, final ServiceCallback<AzureStoragePropertyDictionaryResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(listAzureStorageAccountsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AzureStoragePropertyDictionaryResourceInner object
     */
    public Observable<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsAsync(String resourceGroupName, String name) {
        return listAzureStorageAccountsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<AzureStoragePropertyDictionaryResourceInner>, AzureStoragePropertyDictionaryResourceInner>() {
            @Override
            public AzureStoragePropertyDictionaryResourceInner call(ServiceResponse<AzureStoragePropertyDictionaryResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Azure storage account configurations of an app.
     * Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AzureStoragePropertyDictionaryResourceInner object
     */
    public Observable<ServiceResponse<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccountsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listAzureStorageAccounts(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AzureStoragePropertyDictionaryResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<AzureStoragePropertyDictionaryResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AzureStoragePropertyDictionaryResourceInner> clientResponse = listAzureStorageAccountsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AzureStoragePropertyDictionaryResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AzureStoragePropertyDictionaryResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the backup configuration of an app.
     * Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupRequestInner object if successful.
     */
    public BackupRequestInner updateBackupConfiguration(String resourceGroupName, String name, BackupRequestInner request) {
        return updateBackupConfigurationWithServiceResponseAsync(resourceGroupName, name, request).toBlocking().single().body();
    }

    /**
     * Updates the backup configuration of an app.
     * Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BackupRequestInner> updateBackupConfigurationAsync(String resourceGroupName, String name, BackupRequestInner request, final ServiceCallback<BackupRequestInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateBackupConfigurationWithServiceResponseAsync(resourceGroupName, name, request), serviceCallback);
    }

    /**
     * Updates the backup configuration of an app.
     * Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupRequestInner object
     */
    public Observable<BackupRequestInner> updateBackupConfigurationAsync(String resourceGroupName, String name, BackupRequestInner request) {
        return updateBackupConfigurationWithServiceResponseAsync(resourceGroupName, name, request).map(new Func1<ServiceResponse<BackupRequestInner>, BackupRequestInner>() {
            @Override
            public BackupRequestInner call(ServiceResponse<BackupRequestInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the backup configuration of an app.
     * Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupRequestInner object
     */
    public Observable<ServiceResponse<BackupRequestInner>> updateBackupConfigurationWithServiceResponseAsync(String resourceGroupName, String name, BackupRequestInner request) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(request);
        return service.updateBackupConfiguration(resourceGroupName, name, this.client.subscriptionId(), request, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupRequestInner>>>() {
                @Override
                public Observable<ServiceResponse<BackupRequestInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BackupRequestInner> clientResponse = updateBackupConfigurationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BackupRequestInner> updateBackupConfigurationDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BackupRequestInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BackupRequestInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes the backup configuration of an app.
     * Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteBackupConfiguration(String resourceGroupName, String name) {
        deleteBackupConfigurationWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Deletes the backup configuration of an app.
     * Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteBackupConfigurationAsync(String resourceGroupName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteBackupConfigurationWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Deletes the backup configuration of an app.
     * Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteBackupConfigurationAsync(String resourceGroupName, String name) {
        return deleteBackupConfigurationWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the backup configuration of an app.
     * Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteBackupConfigurationWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteBackupConfiguration(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteBackupConfigurationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteBackupConfigurationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the backup configuration of an app.
     * Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the BackupRequestInner object if successful.
     */
    public BackupRequestInner getBackupConfiguration(String resourceGroupName, String name) {
        return getBackupConfigurationWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the backup configuration of an app.
     * Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<BackupRequestInner> getBackupConfigurationAsync(String resourceGroupName, String name, final ServiceCallback<BackupRequestInner> serviceCallback) {
        return ServiceFuture.fromResponse(getBackupConfigurationWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the backup configuration of an app.
     * Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupRequestInner object
     */
    public Observable<BackupRequestInner> getBackupConfigurationAsync(String resourceGroupName, String name) {
        return getBackupConfigurationWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<BackupRequestInner>, BackupRequestInner>() {
            @Override
            public BackupRequestInner call(ServiceResponse<BackupRequestInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the backup configuration of an app.
     * Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the BackupRequestInner object
     */
    public Observable<ServiceResponse<BackupRequestInner>> getBackupConfigurationWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getBackupConfiguration(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupRequestInner>>>() {
                @Override
                public Observable<ServiceResponse<BackupRequestInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<BackupRequestInner> clientResponse = getBackupConfigurationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<BackupRequestInner> getBackupConfigurationDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<BackupRequestInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<BackupRequestInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Replaces the connection strings of an app.
     * Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ConnectionStringDictionaryInner object if successful.
     */
    public ConnectionStringDictionaryInner updateConnectionStrings(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings) {
        return updateConnectionStringsWithServiceResponseAsync(resourceGroupName, name, connectionStrings).toBlocking().single().body();
    }

    /**
     * Replaces the connection strings of an app.
     * Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ConnectionStringDictionaryInner> updateConnectionStringsAsync(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings, final ServiceCallback<ConnectionStringDictionaryInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateConnectionStringsWithServiceResponseAsync(resourceGroupName, name, connectionStrings), serviceCallback);
    }

    /**
     * Replaces the connection strings of an app.
     * Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConnectionStringDictionaryInner object
     */
    public Observable<ConnectionStringDictionaryInner> updateConnectionStringsAsync(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings) {
        return updateConnectionStringsWithServiceResponseAsync(resourceGroupName, name, connectionStrings).map(new Func1<ServiceResponse<ConnectionStringDictionaryInner>, ConnectionStringDictionaryInner>() {
            @Override
            public ConnectionStringDictionaryInner call(ServiceResponse<ConnectionStringDictionaryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Replaces the connection strings of an app.
     * Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConnectionStringDictionaryInner object
     */
    public Observable<ServiceResponse<ConnectionStringDictionaryInner>> updateConnectionStringsWithServiceResponseAsync(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (connectionStrings == null) {
            throw new IllegalArgumentException("Parameter connectionStrings is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(connectionStrings);
        return service.updateConnectionStrings(resourceGroupName, name, this.client.subscriptionId(), connectionStrings, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConnectionStringDictionaryInner>>>() {
                @Override
                public Observable<ServiceResponse<ConnectionStringDictionaryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ConnectionStringDictionaryInner> clientResponse = updateConnectionStringsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ConnectionStringDictionaryInner> updateConnectionStringsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ConnectionStringDictionaryInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ConnectionStringDictionaryInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the connection strings of an app.
     * Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ConnectionStringDictionaryInner object if successful.
     */
    public ConnectionStringDictionaryInner listConnectionStrings(String resourceGroupName, String name) {
        return listConnectionStringsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the connection strings of an app.
     * Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ConnectionStringDictionaryInner> listConnectionStringsAsync(String resourceGroupName, String name, final ServiceCallback<ConnectionStringDictionaryInner> serviceCallback) {
        return ServiceFuture.fromResponse(listConnectionStringsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the connection strings of an app.
     * Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConnectionStringDictionaryInner object
     */
    public Observable<ConnectionStringDictionaryInner> listConnectionStringsAsync(String resourceGroupName, String name) {
        return listConnectionStringsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<ConnectionStringDictionaryInner>, ConnectionStringDictionaryInner>() {
            @Override
            public ConnectionStringDictionaryInner call(ServiceResponse<ConnectionStringDictionaryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the connection strings of an app.
     * Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ConnectionStringDictionaryInner object
     */
    public Observable<ServiceResponse<ConnectionStringDictionaryInner>> listConnectionStringsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listConnectionStrings(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ConnectionStringDictionaryInner>>>() {
                @Override
                public Observable<ServiceResponse<ConnectionStringDictionaryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ConnectionStringDictionaryInner> clientResponse = listConnectionStringsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ConnectionStringDictionaryInner> listConnectionStringsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ConnectionStringDictionaryInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ConnectionStringDictionaryInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the logging configuration of an app.
     * Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteLogsConfigInner object if successful.
     */
    public SiteLogsConfigInner getDiagnosticLogsConfiguration(String resourceGroupName, String name) {
        return getDiagnosticLogsConfigurationWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the logging configuration of an app.
     * Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteLogsConfigInner> getDiagnosticLogsConfigurationAsync(String resourceGroupName, String name, final ServiceCallback<SiteLogsConfigInner> serviceCallback) {
        return ServiceFuture.fromResponse(getDiagnosticLogsConfigurationWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the logging configuration of an app.
     * Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteLogsConfigInner object
     */
    public Observable<SiteLogsConfigInner> getDiagnosticLogsConfigurationAsync(String resourceGroupName, String name) {
        return getDiagnosticLogsConfigurationWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<SiteLogsConfigInner>, SiteLogsConfigInner>() {
            @Override
            public SiteLogsConfigInner call(ServiceResponse<SiteLogsConfigInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the logging configuration of an app.
     * Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteLogsConfigInner object
     */
    public Observable<ServiceResponse<SiteLogsConfigInner>> getDiagnosticLogsConfigurationWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getDiagnosticLogsConfiguration(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteLogsConfigInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteLogsConfigInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteLogsConfigInner> clientResponse = getDiagnosticLogsConfigurationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteLogsConfigInner> getDiagnosticLogsConfigurationDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteLogsConfigInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteLogsConfigInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the logging configuration of an app.
     * Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteLogsConfigInner object if successful.
     */
    public SiteLogsConfigInner updateDiagnosticLogsConfig(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig) {
        return updateDiagnosticLogsConfigWithServiceResponseAsync(resourceGroupName, name, siteLogsConfig).toBlocking().single().body();
    }

    /**
     * Updates the logging configuration of an app.
     * Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the "properties" property.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteLogsConfigInner> updateDiagnosticLogsConfigAsync(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig, final ServiceCallback<SiteLogsConfigInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateDiagnosticLogsConfigWithServiceResponseAsync(resourceGroupName, name, siteLogsConfig), serviceCallback);
    }

    /**
     * Updates the logging configuration of an app.
     * Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteLogsConfigInner object
     */
    public Observable<SiteLogsConfigInner> updateDiagnosticLogsConfigAsync(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig) {
        return updateDiagnosticLogsConfigWithServiceResponseAsync(resourceGroupName, name, siteLogsConfig).map(new Func1<ServiceResponse<SiteLogsConfigInner>, SiteLogsConfigInner>() {
            @Override
            public SiteLogsConfigInner call(ServiceResponse<SiteLogsConfigInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the logging configuration of an app.
     * Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteLogsConfigInner object
     */
    public Observable<ServiceResponse<SiteLogsConfigInner>> updateDiagnosticLogsConfigWithServiceResponseAsync(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteLogsConfig == null) {
            throw new IllegalArgumentException("Parameter siteLogsConfig is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(siteLogsConfig);
        return service.updateDiagnosticLogsConfig(resourceGroupName, name, this.client.subscriptionId(), siteLogsConfig, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteLogsConfigInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteLogsConfigInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteLogsConfigInner> clientResponse = updateDiagnosticLogsConfigDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteLogsConfigInner> updateDiagnosticLogsConfigDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteLogsConfigInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteLogsConfigInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Replaces the metadata of an app.
     * Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StringDictionaryInner object if successful.
     */
    public StringDictionaryInner updateMetadata(String resourceGroupName, String name, StringDictionaryInner metadata) {
        return updateMetadataWithServiceResponseAsync(resourceGroupName, name, metadata).toBlocking().single().body();
    }

    /**
     * Replaces the metadata of an app.
     * Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<StringDictionaryInner> updateMetadataAsync(String resourceGroupName, String name, StringDictionaryInner metadata, final ServiceCallback<StringDictionaryInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateMetadataWithServiceResponseAsync(resourceGroupName, name, metadata), serviceCallback);
    }

    /**
     * Replaces the metadata of an app.
     * Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StringDictionaryInner object
     */
    public Observable<StringDictionaryInner> updateMetadataAsync(String resourceGroupName, String name, StringDictionaryInner metadata) {
        return updateMetadataWithServiceResponseAsync(resourceGroupName, name, metadata).map(new Func1<ServiceResponse<StringDictionaryInner>, StringDictionaryInner>() {
            @Override
            public StringDictionaryInner call(ServiceResponse<StringDictionaryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Replaces the metadata of an app.
     * Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StringDictionaryInner object
     */
    public Observable<ServiceResponse<StringDictionaryInner>> updateMetadataWithServiceResponseAsync(String resourceGroupName, String name, StringDictionaryInner metadata) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("Parameter metadata is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(metadata);
        return service.updateMetadata(resourceGroupName, name, this.client.subscriptionId(), metadata, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<StringDictionaryInner>>>() {
                @Override
                public Observable<ServiceResponse<StringDictionaryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<StringDictionaryInner> clientResponse = updateMetadataDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<StringDictionaryInner> updateMetadataDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<StringDictionaryInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<StringDictionaryInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the metadata of an app.
     * Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StringDictionaryInner object if successful.
     */
    public StringDictionaryInner listMetadata(String resourceGroupName, String name) {
        return listMetadataWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the metadata of an app.
     * Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<StringDictionaryInner> listMetadataAsync(String resourceGroupName, String name, final ServiceCallback<StringDictionaryInner> serviceCallback) {
        return ServiceFuture.fromResponse(listMetadataWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the metadata of an app.
     * Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StringDictionaryInner object
     */
    public Observable<StringDictionaryInner> listMetadataAsync(String resourceGroupName, String name) {
        return listMetadataWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<StringDictionaryInner>, StringDictionaryInner>() {
            @Override
            public StringDictionaryInner call(ServiceResponse<StringDictionaryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the metadata of an app.
     * Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StringDictionaryInner object
     */
    public Observable<ServiceResponse<StringDictionaryInner>> listMetadataWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMetadata(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<StringDictionaryInner>>>() {
                @Override
                public Observable<ServiceResponse<StringDictionaryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<StringDictionaryInner> clientResponse = listMetadataDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<StringDictionaryInner> listMetadataDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<StringDictionaryInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<StringDictionaryInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the UserInner object if successful.
     */
    public UserInner listPublishingCredentials(String resourceGroupName, String name) {
        return listPublishingCredentialsWithServiceResponseAsync(resourceGroupName, name).toBlocking().last().body();
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<UserInner> listPublishingCredentialsAsync(String resourceGroupName, String name, final ServiceCallback<UserInner> serviceCallback) {
        return ServiceFuture.fromResponse(listPublishingCredentialsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<UserInner> listPublishingCredentialsAsync(String resourceGroupName, String name) {
        return listPublishingCredentialsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<UserInner>, UserInner>() {
            @Override
            public UserInner call(ServiceResponse<UserInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<UserInner>> listPublishingCredentialsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.listPublishingCredentials(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<UserInner>() { }.getType());
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the UserInner object if successful.
     */
    public UserInner beginListPublishingCredentials(String resourceGroupName, String name) {
        return beginListPublishingCredentialsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<UserInner> beginListPublishingCredentialsAsync(String resourceGroupName, String name, final ServiceCallback<UserInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginListPublishingCredentialsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserInner object
     */
    public Observable<UserInner> beginListPublishingCredentialsAsync(String resourceGroupName, String name) {
        return beginListPublishingCredentialsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<UserInner>, UserInner>() {
            @Override
            public UserInner call(ServiceResponse<UserInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Git/FTP publishing credentials of an app.
     * Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserInner object
     */
    public Observable<ServiceResponse<UserInner>> beginListPublishingCredentialsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginListPublishingCredentials(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>() {
                @Override
                public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<UserInner> clientResponse = beginListPublishingCredentialsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<UserInner> beginListPublishingCredentialsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<UserInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<UserInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the Push settings associated with web app.
     * Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PushSettingsInner object if successful.
     */
    public PushSettingsInner updateSitePushSettings(String resourceGroupName, String name, PushSettingsInner pushSettings) {
        return updateSitePushSettingsWithServiceResponseAsync(resourceGroupName, name, pushSettings).toBlocking().single().body();
    }

    /**
     * Updates the Push settings associated with web app.
     * Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PushSettingsInner> updateSitePushSettingsAsync(String resourceGroupName, String name, PushSettingsInner pushSettings, final ServiceCallback<PushSettingsInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateSitePushSettingsWithServiceResponseAsync(resourceGroupName, name, pushSettings), serviceCallback);
    }

    /**
     * Updates the Push settings associated with web app.
     * Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PushSettingsInner object
     */
    public Observable<PushSettingsInner> updateSitePushSettingsAsync(String resourceGroupName, String name, PushSettingsInner pushSettings) {
        return updateSitePushSettingsWithServiceResponseAsync(resourceGroupName, name, pushSettings).map(new Func1<ServiceResponse<PushSettingsInner>, PushSettingsInner>() {
            @Override
            public PushSettingsInner call(ServiceResponse<PushSettingsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the Push settings associated with web app.
     * Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PushSettingsInner object
     */
    public Observable<ServiceResponse<PushSettingsInner>> updateSitePushSettingsWithServiceResponseAsync(String resourceGroupName, String name, PushSettingsInner pushSettings) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (pushSettings == null) {
            throw new IllegalArgumentException("Parameter pushSettings is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(pushSettings);
        return service.updateSitePushSettings(resourceGroupName, name, this.client.subscriptionId(), pushSettings, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PushSettingsInner>>>() {
                @Override
                public Observable<ServiceResponse<PushSettingsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PushSettingsInner> clientResponse = updateSitePushSettingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PushSettingsInner> updateSitePushSettingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PushSettingsInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PushSettingsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the Push settings associated with web app.
     * Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PushSettingsInner object if successful.
     */
    public PushSettingsInner listSitePushSettings(String resourceGroupName, String name) {
        return listSitePushSettingsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the Push settings associated with web app.
     * Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PushSettingsInner> listSitePushSettingsAsync(String resourceGroupName, String name, final ServiceCallback<PushSettingsInner> serviceCallback) {
        return ServiceFuture.fromResponse(listSitePushSettingsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the Push settings associated with web app.
     * Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PushSettingsInner object
     */
    public Observable<PushSettingsInner> listSitePushSettingsAsync(String resourceGroupName, String name) {
        return listSitePushSettingsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<PushSettingsInner>, PushSettingsInner>() {
            @Override
            public PushSettingsInner call(ServiceResponse<PushSettingsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the Push settings associated with web app.
     * Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PushSettingsInner object
     */
    public Observable<ServiceResponse<PushSettingsInner>> listSitePushSettingsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSitePushSettings(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PushSettingsInner>>>() {
                @Override
                public Observable<ServiceResponse<PushSettingsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PushSettingsInner> clientResponse = listSitePushSettingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PushSettingsInner> listSitePushSettingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PushSettingsInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PushSettingsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SlotConfigNamesResourceInner object if successful.
     */
    public SlotConfigNamesResourceInner listSlotConfigurationNames(String resourceGroupName, String name) {
        return listSlotConfigurationNamesWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SlotConfigNamesResourceInner> listSlotConfigurationNamesAsync(String resourceGroupName, String name, final ServiceCallback<SlotConfigNamesResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(listSlotConfigurationNamesWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SlotConfigNamesResourceInner object
     */
    public Observable<SlotConfigNamesResourceInner> listSlotConfigurationNamesAsync(String resourceGroupName, String name) {
        return listSlotConfigurationNamesWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<SlotConfigNamesResourceInner>, SlotConfigNamesResourceInner>() {
            @Override
            public SlotConfigNamesResourceInner call(ServiceResponse<SlotConfigNamesResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     * Gets the names of app settings and connection strings that stick to the slot (not swapped).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SlotConfigNamesResourceInner object
     */
    public Observable<ServiceResponse<SlotConfigNamesResourceInner>> listSlotConfigurationNamesWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSlotConfigurationNames(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SlotConfigNamesResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SlotConfigNamesResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SlotConfigNamesResourceInner> clientResponse = listSlotConfigurationNamesDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SlotConfigNamesResourceInner> listSlotConfigurationNamesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SlotConfigNamesResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SlotConfigNamesResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SlotConfigNamesResourceInner object if successful.
     */
    public SlotConfigNamesResourceInner updateSlotConfigurationNames(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames) {
        return updateSlotConfigurationNamesWithServiceResponseAsync(resourceGroupName, name, slotConfigNames).toBlocking().single().body();
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SlotConfigNamesResourceInner> updateSlotConfigurationNamesAsync(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames, final ServiceCallback<SlotConfigNamesResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateSlotConfigurationNamesWithServiceResponseAsync(resourceGroupName, name, slotConfigNames), serviceCallback);
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SlotConfigNamesResourceInner object
     */
    public Observable<SlotConfigNamesResourceInner> updateSlotConfigurationNamesAsync(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames) {
        return updateSlotConfigurationNamesWithServiceResponseAsync(resourceGroupName, name, slotConfigNames).map(new Func1<ServiceResponse<SlotConfigNamesResourceInner>, SlotConfigNamesResourceInner>() {
            @Override
            public SlotConfigNamesResourceInner call(ServiceResponse<SlotConfigNamesResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     * Updates the names of application settings and connection string that remain with the slot during swap operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SlotConfigNamesResourceInner object
     */
    public Observable<ServiceResponse<SlotConfigNamesResourceInner>> updateSlotConfigurationNamesWithServiceResponseAsync(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (slotConfigNames == null) {
            throw new IllegalArgumentException("Parameter slotConfigNames is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(slotConfigNames);
        return service.updateSlotConfigurationNames(resourceGroupName, name, this.client.subscriptionId(), slotConfigNames, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SlotConfigNamesResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SlotConfigNamesResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SlotConfigNamesResourceInner> clientResponse = updateSlotConfigurationNamesDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SlotConfigNamesResourceInner> updateSlotConfigurationNamesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SlotConfigNamesResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SlotConfigNamesResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc.
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteConfigResourceInner object if successful.
     */
    public SiteConfigResourceInner getConfiguration(String resourceGroupName, String name) {
        return getConfigurationWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc.
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteConfigResourceInner> getConfigurationAsync(String resourceGroupName, String name, final ServiceCallback<SiteConfigResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getConfigurationWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc.
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteConfigResourceInner object
     */
    public Observable<SiteConfigResourceInner> getConfigurationAsync(String resourceGroupName, String name) {
        return getConfigurationWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<SiteConfigResourceInner>, SiteConfigResourceInner>() {
            @Override
            public SiteConfigResourceInner call(ServiceResponse<SiteConfigResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc.
     * Gets the configuration of an app, such as platform version and bitness, default documents, virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteConfigResourceInner object
     */
    public Observable<ServiceResponse<SiteConfigResourceInner>> getConfigurationWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getConfiguration(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteConfigResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteConfigResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteConfigResourceInner> clientResponse = getConfigurationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteConfigResourceInner> getConfigurationDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteConfigResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteConfigResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the configuration of an app.
     * Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteConfigResourceInner object if successful.
     */
    public SiteConfigResourceInner createOrUpdateConfiguration(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return createOrUpdateConfigurationWithServiceResponseAsync(resourceGroupName, name, siteConfig).toBlocking().single().body();
    }

    /**
     * Updates the configuration of an app.
     * Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteConfigResourceInner> createOrUpdateConfigurationAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig, final ServiceCallback<SiteConfigResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateConfigurationWithServiceResponseAsync(resourceGroupName, name, siteConfig), serviceCallback);
    }

    /**
     * Updates the configuration of an app.
     * Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteConfigResourceInner object
     */
    public Observable<SiteConfigResourceInner> createOrUpdateConfigurationAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return createOrUpdateConfigurationWithServiceResponseAsync(resourceGroupName, name, siteConfig).map(new Func1<ServiceResponse<SiteConfigResourceInner>, SiteConfigResourceInner>() {
            @Override
            public SiteConfigResourceInner call(ServiceResponse<SiteConfigResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the configuration of an app.
     * Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteConfigResourceInner object
     */
    public Observable<ServiceResponse<SiteConfigResourceInner>> createOrUpdateConfigurationWithServiceResponseAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteConfig == null) {
            throw new IllegalArgumentException("Parameter siteConfig is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(siteConfig);
        return service.createOrUpdateConfiguration(resourceGroupName, name, this.client.subscriptionId(), siteConfig, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteConfigResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteConfigResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteConfigResourceInner> clientResponse = createOrUpdateConfigurationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteConfigResourceInner> createOrUpdateConfigurationDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteConfigResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteConfigResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates the configuration of an app.
     * Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteConfigResourceInner object if successful.
     */
    public SiteConfigResourceInner updateConfiguration(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return updateConfigurationWithServiceResponseAsync(resourceGroupName, name, siteConfig).toBlocking().single().body();
    }

    /**
     * Updates the configuration of an app.
     * Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteConfigResourceInner> updateConfigurationAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig, final ServiceCallback<SiteConfigResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateConfigurationWithServiceResponseAsync(resourceGroupName, name, siteConfig), serviceCallback);
    }

    /**
     * Updates the configuration of an app.
     * Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteConfigResourceInner object
     */
    public Observable<SiteConfigResourceInner> updateConfigurationAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return updateConfigurationWithServiceResponseAsync(resourceGroupName, name, siteConfig).map(new Func1<ServiceResponse<SiteConfigResourceInner>, SiteConfigResourceInner>() {
            @Override
            public SiteConfigResourceInner call(ServiceResponse<SiteConfigResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the configuration of an app.
     * Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteConfigResourceInner object
     */
    public Observable<ServiceResponse<SiteConfigResourceInner>> updateConfigurationWithServiceResponseAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteConfig == null) {
            throw new IllegalArgumentException("Parameter siteConfig is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(siteConfig);
        return service.updateConfiguration(resourceGroupName, name, this.client.subscriptionId(), siteConfig, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteConfigResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteConfigResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteConfigResourceInner> clientResponse = updateConfigurationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteConfigResourceInner> updateConfigurationDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteConfigResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteConfigResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteConfigurationSnapshotInfoInner&gt; object if successful.
     */
    public PagedList<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfo(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>> response = listConfigurationSnapshotInfoSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SiteConfigurationSnapshotInfoInner>(response.body()) {
            @Override
            public Page<SiteConfigurationSnapshotInfoInner> nextPage(String nextPageLink) {
                return listConfigurationSnapshotInfoNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteConfigurationSnapshotInfoInner>> listConfigurationSnapshotInfoAsync(final String resourceGroupName, final String name, final ListOperationCallback<SiteConfigurationSnapshotInfoInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listConfigurationSnapshotInfoSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>> call(String nextPageLink) {
                    return listConfigurationSnapshotInfoNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteConfigurationSnapshotInfoInner&gt; object
     */
    public Observable<Page<SiteConfigurationSnapshotInfoInner>> listConfigurationSnapshotInfoAsync(final String resourceGroupName, final String name) {
        return listConfigurationSnapshotInfoWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>, Page<SiteConfigurationSnapshotInfoInner>>() {
                @Override
                public Page<SiteConfigurationSnapshotInfoInner> call(ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteConfigurationSnapshotInfoInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>> listConfigurationSnapshotInfoWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listConfigurationSnapshotInfoSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>, Observable<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>> call(ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listConfigurationSnapshotInfoNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     * Gets a list of web app configuration snapshots identifiers. Each element of the list contains a timestamp and the ID of the snapshot.
     *
    ServiceResponse<PageImpl<SiteConfigurationSnapshotInfoInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteConfigurationSnapshotInfoInner>> * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteConfigurationSnapshotInfoInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>> listConfigurationSnapshotInfoSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listConfigurationSnapshotInfo(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteConfigurationSnapshotInfoInner>> result = listConfigurationSnapshotInfoDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteConfigurationSnapshotInfoInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteConfigurationSnapshotInfoInner>> listConfigurationSnapshotInfoDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteConfigurationSnapshotInfoInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteConfigurationSnapshotInfoInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteConfigResourceInner object if successful.
     */
    public SiteConfigResourceInner getConfigurationSnapshot(String resourceGroupName, String name, String snapshotId) {
        return getConfigurationSnapshotWithServiceResponseAsync(resourceGroupName, name, snapshotId).toBlocking().single().body();
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteConfigResourceInner> getConfigurationSnapshotAsync(String resourceGroupName, String name, String snapshotId, final ServiceCallback<SiteConfigResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getConfigurationSnapshotWithServiceResponseAsync(resourceGroupName, name, snapshotId), serviceCallback);
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteConfigResourceInner object
     */
    public Observable<SiteConfigResourceInner> getConfigurationSnapshotAsync(String resourceGroupName, String name, String snapshotId) {
        return getConfigurationSnapshotWithServiceResponseAsync(resourceGroupName, name, snapshotId).map(new Func1<ServiceResponse<SiteConfigResourceInner>, SiteConfigResourceInner>() {
            @Override
            public SiteConfigResourceInner call(ServiceResponse<SiteConfigResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a snapshot of the configuration of an app at a previous point in time.
     * Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteConfigResourceInner object
     */
    public Observable<ServiceResponse<SiteConfigResourceInner>> getConfigurationSnapshotWithServiceResponseAsync(String resourceGroupName, String name, String snapshotId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (snapshotId == null) {
            throw new IllegalArgumentException("Parameter snapshotId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getConfigurationSnapshot(resourceGroupName, name, snapshotId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteConfigResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteConfigResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteConfigResourceInner> clientResponse = getConfigurationSnapshotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteConfigResourceInner> getConfigurationSnapshotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteConfigResourceInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteConfigResourceInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void recoverSiteConfigurationSnapshot(String resourceGroupName, String name, String snapshotId) {
        recoverSiteConfigurationSnapshotWithServiceResponseAsync(resourceGroupName, name, snapshotId).toBlocking().single().body();
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> recoverSiteConfigurationSnapshotAsync(String resourceGroupName, String name, String snapshotId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(recoverSiteConfigurationSnapshotWithServiceResponseAsync(resourceGroupName, name, snapshotId), serviceCallback);
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> recoverSiteConfigurationSnapshotAsync(String resourceGroupName, String name, String snapshotId) {
        return recoverSiteConfigurationSnapshotWithServiceResponseAsync(resourceGroupName, name, snapshotId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Reverts the configuration of an app to a previous snapshot.
     * Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> recoverSiteConfigurationSnapshotWithServiceResponseAsync(String resourceGroupName, String name, String snapshotId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (snapshotId == null) {
            throw new IllegalArgumentException("Parameter snapshotId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.recoverSiteConfigurationSnapshot(resourceGroupName, name, snapshotId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = recoverSiteConfigurationSnapshotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> recoverSiteConfigurationSnapshotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the last lines of docker logs for the given site.
     * Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InputStream object if successful.
     */
    public InputStream getWebSiteContainerLogs(String resourceGroupName, String name) {
        return getWebSiteContainerLogsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the last lines of docker logs for the given site.
     * Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InputStream> getWebSiteContainerLogsAsync(String resourceGroupName, String name, final ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromResponse(getWebSiteContainerLogsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the last lines of docker logs for the given site.
     * Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InputStream object
     */
    public Observable<InputStream> getWebSiteContainerLogsAsync(String resourceGroupName, String name) {
        return getWebSiteContainerLogsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<InputStream>, InputStream>() {
            @Override
            public InputStream call(ServiceResponse<InputStream> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the last lines of docker logs for the given site.
     * Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InputStream object
     */
    public Observable<ServiceResponse<InputStream>> getWebSiteContainerLogsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getWebSiteContainerLogs(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InputStream>>>() {
                @Override
                public Observable<ServiceResponse<InputStream>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InputStream> clientResponse = getWebSiteContainerLogsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InputStream> getWebSiteContainerLogsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InputStream, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InputStream>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the ZIP archived docker log files for the given site.
     * Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InputStream object if successful.
     */
    public InputStream getContainerLogsZip(String resourceGroupName, String name) {
        return getContainerLogsZipWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets the ZIP archived docker log files for the given site.
     * Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InputStream> getContainerLogsZipAsync(String resourceGroupName, String name, final ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromResponse(getContainerLogsZipWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets the ZIP archived docker log files for the given site.
     * Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InputStream object
     */
    public Observable<InputStream> getContainerLogsZipAsync(String resourceGroupName, String name) {
        return getContainerLogsZipWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<InputStream>, InputStream>() {
            @Override
            public InputStream call(ServiceResponse<InputStream> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the ZIP archived docker log files for the given site.
     * Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InputStream object
     */
    public Observable<ServiceResponse<InputStream>> getContainerLogsZipWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getContainerLogsZip(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InputStream>>>() {
                @Override
                public Observable<ServiceResponse<InputStream>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InputStream> clientResponse = getContainerLogsZipDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InputStream> getContainerLogsZipDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InputStream, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InputStream>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ContinuousWebJobInner&gt; object if successful.
     */
    public PagedList<ContinuousWebJobInner> listContinuousWebJobs(final String resourceGroupName, final String name) {
        ServiceResponse<Page<ContinuousWebJobInner>> response = listContinuousWebJobsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<ContinuousWebJobInner>(response.body()) {
            @Override
            public Page<ContinuousWebJobInner> nextPage(String nextPageLink) {
                return listContinuousWebJobsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ContinuousWebJobInner>> listContinuousWebJobsAsync(final String resourceGroupName, final String name, final ListOperationCallback<ContinuousWebJobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listContinuousWebJobsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<ContinuousWebJobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ContinuousWebJobInner>>> call(String nextPageLink) {
                    return listContinuousWebJobsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ContinuousWebJobInner&gt; object
     */
    public Observable<Page<ContinuousWebJobInner>> listContinuousWebJobsAsync(final String resourceGroupName, final String name) {
        return listContinuousWebJobsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<ContinuousWebJobInner>>, Page<ContinuousWebJobInner>>() {
                @Override
                public Page<ContinuousWebJobInner> call(ServiceResponse<Page<ContinuousWebJobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ContinuousWebJobInner&gt; object
     */
    public Observable<ServiceResponse<Page<ContinuousWebJobInner>>> listContinuousWebJobsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listContinuousWebJobsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<ContinuousWebJobInner>>, Observable<ServiceResponse<Page<ContinuousWebJobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ContinuousWebJobInner>>> call(ServiceResponse<Page<ContinuousWebJobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listContinuousWebJobsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List continuous web jobs for an app, or a deployment slot.
     * List continuous web jobs for an app, or a deployment slot.
     *
    ServiceResponse<PageImpl<ContinuousWebJobInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ContinuousWebJobInner>> * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ContinuousWebJobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ContinuousWebJobInner>>> listContinuousWebJobsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listContinuousWebJobs(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ContinuousWebJobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ContinuousWebJobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ContinuousWebJobInner>> result = listContinuousWebJobsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ContinuousWebJobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ContinuousWebJobInner>> listContinuousWebJobsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ContinuousWebJobInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ContinuousWebJobInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ContinuousWebJobInner object if successful.
     */
    public ContinuousWebJobInner getContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        return getContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName).toBlocking().single().body();
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ContinuousWebJobInner> getContinuousWebJobAsync(String resourceGroupName, String name, String webJobName, final ServiceCallback<ContinuousWebJobInner> serviceCallback) {
        return ServiceFuture.fromResponse(getContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName), serviceCallback);
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ContinuousWebJobInner object
     */
    public Observable<ContinuousWebJobInner> getContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return getContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName).map(new Func1<ServiceResponse<ContinuousWebJobInner>, ContinuousWebJobInner>() {
            @Override
            public ContinuousWebJobInner call(ServiceResponse<ContinuousWebJobInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     * Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ContinuousWebJobInner object
     */
    public Observable<ServiceResponse<ContinuousWebJobInner>> getContinuousWebJobWithServiceResponseAsync(String resourceGroupName, String name, String webJobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (webJobName == null) {
            throw new IllegalArgumentException("Parameter webJobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getContinuousWebJob(resourceGroupName, name, webJobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ContinuousWebJobInner>>>() {
                @Override
                public Observable<ServiceResponse<ContinuousWebJobInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ContinuousWebJobInner> clientResponse = getContinuousWebJobDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ContinuousWebJobInner> getContinuousWebJobDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ContinuousWebJobInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ContinuousWebJobInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        deleteContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName).toBlocking().single().body();
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteContinuousWebJobAsync(String resourceGroupName, String name, String webJobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName), serviceCallback);
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return deleteContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     * Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteContinuousWebJobWithServiceResponseAsync(String resourceGroupName, String name, String webJobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (webJobName == null) {
            throw new IllegalArgumentException("Parameter webJobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteContinuousWebJob(resourceGroupName, name, webJobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteContinuousWebJobDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteContinuousWebJobDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void startContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        startContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName).toBlocking().single().body();
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> startContinuousWebJobAsync(String resourceGroupName, String name, String webJobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(startContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName), serviceCallback);
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> startContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return startContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Start a continuous web job for an app, or a deployment slot.
     * Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> startContinuousWebJobWithServiceResponseAsync(String resourceGroupName, String name, String webJobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (webJobName == null) {
            throw new IllegalArgumentException("Parameter webJobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.startContinuousWebJob(resourceGroupName, name, webJobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = startContinuousWebJobDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> startContinuousWebJobDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void stopContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        stopContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName).toBlocking().single().body();
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> stopContinuousWebJobAsync(String resourceGroupName, String name, String webJobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(stopContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName), serviceCallback);
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> stopContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return stopContinuousWebJobWithServiceResponseAsync(resourceGroupName, name, webJobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Stop a continuous web job for an app, or a deployment slot.
     * Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> stopContinuousWebJobWithServiceResponseAsync(String resourceGroupName, String name, String webJobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (webJobName == null) {
            throw new IllegalArgumentException("Parameter webJobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.stopContinuousWebJob(resourceGroupName, name, webJobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = stopContinuousWebJobDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> stopContinuousWebJobDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List deployments for an app, or a deployment slot.
     * List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DeploymentInner&gt; object if successful.
     */
    public PagedList<DeploymentInner> listDeployments(final String resourceGroupName, final String name) {
        ServiceResponse<Page<DeploymentInner>> response = listDeploymentsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<DeploymentInner>(response.body()) {
            @Override
            public Page<DeploymentInner> nextPage(String nextPageLink) {
                return listDeploymentsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List deployments for an app, or a deployment slot.
     * List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DeploymentInner>> listDeploymentsAsync(final String resourceGroupName, final String name, final ListOperationCallback<DeploymentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listDeploymentsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<DeploymentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentInner>>> call(String nextPageLink) {
                    return listDeploymentsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List deployments for an app, or a deployment slot.
     * List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentInner&gt; object
     */
    public Observable<Page<DeploymentInner>> listDeploymentsAsync(final String resourceGroupName, final String name) {
        return listDeploymentsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<DeploymentInner>>, Page<DeploymentInner>>() {
                @Override
                public Page<DeploymentInner> call(ServiceResponse<Page<DeploymentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List deployments for an app, or a deployment slot.
     * List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DeploymentInner&gt; object
     */
    public Observable<ServiceResponse<Page<DeploymentInner>>> listDeploymentsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listDeploymentsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<DeploymentInner>>, Observable<ServiceResponse<Page<DeploymentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentInner>>> call(ServiceResponse<Page<DeploymentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listDeploymentsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List deployments for an app, or a deployment slot.
     * List deployments for an app, or a deployment slot.
     *
    ServiceResponse<PageImpl<DeploymentInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<DeploymentInner>> * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DeploymentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DeploymentInner>>> listDeploymentsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listDeployments(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DeploymentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DeploymentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DeploymentInner>> result = listDeploymentsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DeploymentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DeploymentInner>> listDeploymentsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DeploymentInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DeploymentInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentInner object if successful.
     */
    public DeploymentInner getDeployment(String resourceGroupName, String name, String id) {
        return getDeploymentWithServiceResponseAsync(resourceGroupName, name, id).toBlocking().single().body();
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentInner> getDeploymentAsync(String resourceGroupName, String name, String id, final ServiceCallback<DeploymentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getDeploymentWithServiceResponseAsync(resourceGroupName, name, id), serviceCallback);
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentInner object
     */
    public Observable<DeploymentInner> getDeploymentAsync(String resourceGroupName, String name, String id) {
        return getDeploymentWithServiceResponseAsync(resourceGroupName, name, id).map(new Func1<ServiceResponse<DeploymentInner>, DeploymentInner>() {
            @Override
            public DeploymentInner call(ServiceResponse<DeploymentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get a deployment by its ID for an app, or a deployment slot.
     * Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentInner object
     */
    public Observable<ServiceResponse<DeploymentInner>> getDeploymentWithServiceResponseAsync(String resourceGroupName, String name, String id) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getDeployment(resourceGroupName, name, id, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentInner> clientResponse = getDeploymentDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentInner> getDeploymentDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentInner object if successful.
     */
    public DeploymentInner createDeployment(String resourceGroupName, String name, String id, DeploymentInner deployment) {
        return createDeploymentWithServiceResponseAsync(resourceGroupName, name, id, deployment).toBlocking().single().body();
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentInner> createDeploymentAsync(String resourceGroupName, String name, String id, DeploymentInner deployment, final ServiceCallback<DeploymentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createDeploymentWithServiceResponseAsync(resourceGroupName, name, id, deployment), serviceCallback);
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentInner object
     */
    public Observable<DeploymentInner> createDeploymentAsync(String resourceGroupName, String name, String id, DeploymentInner deployment) {
        return createDeploymentWithServiceResponseAsync(resourceGroupName, name, id, deployment).map(new Func1<ServiceResponse<DeploymentInner>, DeploymentInner>() {
            @Override
            public DeploymentInner call(ServiceResponse<DeploymentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create a deployment for an app, or a deployment slot.
     * Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentInner object
     */
    public Observable<ServiceResponse<DeploymentInner>> createDeploymentWithServiceResponseAsync(String resourceGroupName, String name, String id, DeploymentInner deployment) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (deployment == null) {
            throw new IllegalArgumentException("Parameter deployment is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(deployment);
        return service.createDeployment(resourceGroupName, name, id, this.client.subscriptionId(), deployment, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentInner> clientResponse = createDeploymentDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentInner> createDeploymentDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteDeployment(String resourceGroupName, String name, String id) {
        deleteDeploymentWithServiceResponseAsync(resourceGroupName, name, id).toBlocking().single().body();
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteDeploymentAsync(String resourceGroupName, String name, String id, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteDeploymentWithServiceResponseAsync(resourceGroupName, name, id), serviceCallback);
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteDeploymentAsync(String resourceGroupName, String name, String id) {
        return deleteDeploymentWithServiceResponseAsync(resourceGroupName, name, id).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a deployment by its ID for an app, or a deployment slot.
     * Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteDeploymentWithServiceResponseAsync(String resourceGroupName, String name, String id) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteDeployment(resourceGroupName, name, id, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDeploymentDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDeploymentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentInner object if successful.
     */
    public DeploymentInner listDeploymentLog(String resourceGroupName, String name, String id) {
        return listDeploymentLogWithServiceResponseAsync(resourceGroupName, name, id).toBlocking().single().body();
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET /api/sites/{siteName}/deployments".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentInner> listDeploymentLogAsync(String resourceGroupName, String name, String id, final ServiceCallback<DeploymentInner> serviceCallback) {
        return ServiceFuture.fromResponse(listDeploymentLogWithServiceResponseAsync(resourceGroupName, name, id), serviceCallback);
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentInner object
     */
    public Observable<DeploymentInner> listDeploymentLogAsync(String resourceGroupName, String name, String id) {
        return listDeploymentLogWithServiceResponseAsync(resourceGroupName, name, id).map(new Func1<ServiceResponse<DeploymentInner>, DeploymentInner>() {
            @Override
            public DeploymentInner call(ServiceResponse<DeploymentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * List deployment log for specific deployment for an app, or a deployment slot.
     * List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentInner object
     */
    public Observable<ServiceResponse<DeploymentInner>> listDeploymentLogWithServiceResponseAsync(String resourceGroupName, String name, String id) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Parameter id is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listDeploymentLog(resourceGroupName, name, id, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentInner> clientResponse = listDeploymentLogDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentInner> listDeploymentLogDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DeploymentInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DeploymentInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup.
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RestoreRequestInner object if successful.
     */
    public RestoreRequestInner discoverBackup(String resourceGroupName, String name, RestoreRequestInner request) {
        return discoverBackupWithServiceResponseAsync(resourceGroupName, name, request).toBlocking().single().body();
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup.
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RestoreRequestInner> discoverBackupAsync(String resourceGroupName, String name, RestoreRequestInner request, final ServiceCallback<RestoreRequestInner> serviceCallback) {
        return ServiceFuture.fromResponse(discoverBackupWithServiceResponseAsync(resourceGroupName, name, request), serviceCallback);
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup.
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RestoreRequestInner object
     */
    public Observable<RestoreRequestInner> discoverBackupAsync(String resourceGroupName, String name, RestoreRequestInner request) {
        return discoverBackupWithServiceResponseAsync(resourceGroupName, name, request).map(new Func1<ServiceResponse<RestoreRequestInner>, RestoreRequestInner>() {
            @Override
            public RestoreRequestInner call(ServiceResponse<RestoreRequestInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup.
     * Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RestoreRequestInner object
     */
    public Observable<ServiceResponse<RestoreRequestInner>> discoverBackupWithServiceResponseAsync(String resourceGroupName, String name, RestoreRequestInner request) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (request == null) {
            throw new IllegalArgumentException("Parameter request is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(request);
        return service.discoverBackup(resourceGroupName, name, this.client.subscriptionId(), request, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RestoreRequestInner>>>() {
                @Override
                public Observable<ServiceResponse<RestoreRequestInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RestoreRequestInner> clientResponse = discoverBackupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RestoreRequestInner> discoverBackupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RestoreRequestInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RestoreRequestInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IdentifierInner&gt; object if successful.
     */
    public PagedList<IdentifierInner> listDomainOwnershipIdentifiers(final String resourceGroupName, final String name) {
        ServiceResponse<Page<IdentifierInner>> response = listDomainOwnershipIdentifiersSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<IdentifierInner>(response.body()) {
            @Override
            public Page<IdentifierInner> nextPage(String nextPageLink) {
                return listDomainOwnershipIdentifiersNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IdentifierInner>> listDomainOwnershipIdentifiersAsync(final String resourceGroupName, final String name, final ListOperationCallback<IdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listDomainOwnershipIdentifiersSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(String nextPageLink) {
                    return listDomainOwnershipIdentifiersNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentifierInner&gt; object
     */
    public Observable<Page<IdentifierInner>> listDomainOwnershipIdentifiersAsync(final String resourceGroupName, final String name) {
        return listDomainOwnershipIdentifiersWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<IdentifierInner>>, Page<IdentifierInner>>() {
                @Override
                public Page<IdentifierInner> call(ServiceResponse<Page<IdentifierInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentifierInner&gt; object
     */
    public Observable<ServiceResponse<Page<IdentifierInner>>> listDomainOwnershipIdentifiersWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listDomainOwnershipIdentifiersSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<IdentifierInner>>, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(ServiceResponse<Page<IdentifierInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listDomainOwnershipIdentifiersNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists ownership identifiers for domain associated with web app.
     * Lists ownership identifiers for domain associated with web app.
     *
    ServiceResponse<PageImpl<IdentifierInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<IdentifierInner>> * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IdentifierInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IdentifierInner>>> listDomainOwnershipIdentifiersSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listDomainOwnershipIdentifiers(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IdentifierInner>> result = listDomainOwnershipIdentifiersDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IdentifierInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IdentifierInner>> listDomainOwnershipIdentifiersDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<IdentifierInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IdentifierInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get domain ownership identifier for web app.
     * Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IdentifierInner object if successful.
     */
    public IdentifierInner getDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        return getDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName).toBlocking().single().body();
    }

    /**
     * Get domain ownership identifier for web app.
     * Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IdentifierInner> getDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, final ServiceCallback<IdentifierInner> serviceCallback) {
        return ServiceFuture.fromResponse(getDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName), serviceCallback);
    }

    /**
     * Get domain ownership identifier for web app.
     * Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentifierInner object
     */
    public Observable<IdentifierInner> getDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        return getDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName).map(new Func1<ServiceResponse<IdentifierInner>, IdentifierInner>() {
            @Override
            public IdentifierInner call(ServiceResponse<IdentifierInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get domain ownership identifier for web app.
     * Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentifierInner object
     */
    public Observable<ServiceResponse<IdentifierInner>> getDomainOwnershipIdentifierWithServiceResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (domainOwnershipIdentifierName == null) {
            throw new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getDomainOwnershipIdentifier(resourceGroupName, name, domainOwnershipIdentifierName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IdentifierInner>>>() {
                @Override
                public Observable<ServiceResponse<IdentifierInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IdentifierInner> clientResponse = getDomainOwnershipIdentifierDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IdentifierInner> getDomainOwnershipIdentifierDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IdentifierInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IdentifierInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IdentifierInner object if successful.
     */
    public IdentifierInner createOrUpdateDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return createOrUpdateDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier).toBlocking().single().body();
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IdentifierInner> createOrUpdateDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier, final ServiceCallback<IdentifierInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier), serviceCallback);
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentifierInner object
     */
    public Observable<IdentifierInner> createOrUpdateDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return createOrUpdateDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier).map(new Func1<ServiceResponse<IdentifierInner>, IdentifierInner>() {
            @Override
            public IdentifierInner call(ServiceResponse<IdentifierInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentifierInner object
     */
    public Observable<ServiceResponse<IdentifierInner>> createOrUpdateDomainOwnershipIdentifierWithServiceResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (domainOwnershipIdentifierName == null) {
            throw new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (domainOwnershipIdentifier == null) {
            throw new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(domainOwnershipIdentifier);
        return service.createOrUpdateDomainOwnershipIdentifier(resourceGroupName, name, domainOwnershipIdentifierName, this.client.subscriptionId(), domainOwnershipIdentifier, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IdentifierInner>>>() {
                @Override
                public Observable<ServiceResponse<IdentifierInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IdentifierInner> clientResponse = createOrUpdateDomainOwnershipIdentifierDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IdentifierInner> createOrUpdateDomainOwnershipIdentifierDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IdentifierInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IdentifierInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        deleteDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName).toBlocking().single().body();
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName), serviceCallback);
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        return deleteDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a domain ownership identifier for a web app.
     * Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteDomainOwnershipIdentifierWithServiceResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (domainOwnershipIdentifierName == null) {
            throw new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteDomainOwnershipIdentifier(resourceGroupName, name, domainOwnershipIdentifierName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDomainOwnershipIdentifierDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDomainOwnershipIdentifierDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the IdentifierInner object if successful.
     */
    public IdentifierInner updateDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return updateDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier).toBlocking().single().body();
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<IdentifierInner> updateDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier, final ServiceCallback<IdentifierInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier), serviceCallback);
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentifierInner object
     */
    public Observable<IdentifierInner> updateDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return updateDomainOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier).map(new Func1<ServiceResponse<IdentifierInner>, IdentifierInner>() {
            @Override
            public IdentifierInner call(ServiceResponse<IdentifierInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     * Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the IdentifierInner object
     */
    public Observable<ServiceResponse<IdentifierInner>> updateDomainOwnershipIdentifierWithServiceResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (domainOwnershipIdentifierName == null) {
            throw new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (domainOwnershipIdentifier == null) {
            throw new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(domainOwnershipIdentifier);
        return service.updateDomainOwnershipIdentifier(resourceGroupName, name, domainOwnershipIdentifierName, this.client.subscriptionId(), domainOwnershipIdentifier, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<IdentifierInner>>>() {
                @Override
                public Observable<ServiceResponse<IdentifierInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<IdentifierInner> clientResponse = updateDomainOwnershipIdentifierDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<IdentifierInner> updateDomainOwnershipIdentifierDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<IdentifierInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<IdentifierInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get the status of the last MSDeploy operation.
     * Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MSDeployStatusInner object if successful.
     */
    public MSDeployStatusInner getMSDeployStatus(String resourceGroupName, String name) {
        return getMSDeployStatusWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Get the status of the last MSDeploy operation.
     * Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MSDeployStatusInner> getMSDeployStatusAsync(String resourceGroupName, String name, final ServiceCallback<MSDeployStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(getMSDeployStatusWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Get the status of the last MSDeploy operation.
     * Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployStatusInner object
     */
    public Observable<MSDeployStatusInner> getMSDeployStatusAsync(String resourceGroupName, String name) {
        return getMSDeployStatusWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<MSDeployStatusInner>, MSDeployStatusInner>() {
            @Override
            public MSDeployStatusInner call(ServiceResponse<MSDeployStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the status of the last MSDeploy operation.
     * Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployStatusInner object
     */
    public Observable<ServiceResponse<MSDeployStatusInner>> getMSDeployStatusWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getMSDeployStatus(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MSDeployStatusInner>>>() {
                @Override
                public Observable<ServiceResponse<MSDeployStatusInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MSDeployStatusInner> clientResponse = getMSDeployStatusDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MSDeployStatusInner> getMSDeployStatusDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MSDeployStatusInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MSDeployStatusInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MSDeployStatusInner object if successful.
     */
    public MSDeployStatusInner createMSDeployOperation(String resourceGroupName, String name, MSDeploy mSDeploy) {
        return createMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, mSDeploy).toBlocking().last().body();
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MSDeployStatusInner> createMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy, final ServiceCallback<MSDeployStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(createMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, mSDeploy), serviceCallback);
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<MSDeployStatusInner> createMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy) {
        return createMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, mSDeploy).map(new Func1<ServiceResponse<MSDeployStatusInner>, MSDeployStatusInner>() {
            @Override
            public MSDeployStatusInner call(ServiceResponse<MSDeployStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<MSDeployStatusInner>> createMSDeployOperationWithServiceResponseAsync(String resourceGroupName, String name, MSDeploy mSDeploy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (mSDeploy == null) {
            throw new IllegalArgumentException("Parameter mSDeploy is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(mSDeploy);
        Observable<Response<ResponseBody>> observable = service.createMSDeployOperation(resourceGroupName, name, this.client.subscriptionId(), mSDeploy, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MSDeployStatusInner>() { }.getType());
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MSDeployStatusInner object if successful.
     */
    public MSDeployStatusInner beginCreateMSDeployOperation(String resourceGroupName, String name, MSDeploy mSDeploy) {
        return beginCreateMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, mSDeploy).toBlocking().single().body();
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MSDeployStatusInner> beginCreateMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy, final ServiceCallback<MSDeployStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, mSDeploy), serviceCallback);
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployStatusInner object
     */
    public Observable<MSDeployStatusInner> beginCreateMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy) {
        return beginCreateMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, mSDeploy).map(new Func1<ServiceResponse<MSDeployStatusInner>, MSDeployStatusInner>() {
            @Override
            public MSDeployStatusInner call(ServiceResponse<MSDeployStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployStatusInner object
     */
    public Observable<ServiceResponse<MSDeployStatusInner>> beginCreateMSDeployOperationWithServiceResponseAsync(String resourceGroupName, String name, MSDeploy mSDeploy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (mSDeploy == null) {
            throw new IllegalArgumentException("Parameter mSDeploy is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(mSDeploy);
        return service.beginCreateMSDeployOperation(resourceGroupName, name, this.client.subscriptionId(), mSDeploy, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MSDeployStatusInner>>>() {
                @Override
                public Observable<ServiceResponse<MSDeployStatusInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MSDeployStatusInner> clientResponse = beginCreateMSDeployOperationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MSDeployStatusInner> beginCreateMSDeployOperationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MSDeployStatusInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<MSDeployStatusInner>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the MSDeploy Log for the last MSDeploy operation.
     * Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MSDeployLogInner object if successful.
     */
    public MSDeployLogInner getMSDeployLog(String resourceGroupName, String name) {
        return getMSDeployLogWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Get the MSDeploy Log for the last MSDeploy operation.
     * Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MSDeployLogInner> getMSDeployLogAsync(String resourceGroupName, String name, final ServiceCallback<MSDeployLogInner> serviceCallback) {
        return ServiceFuture.fromResponse(getMSDeployLogWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Get the MSDeploy Log for the last MSDeploy operation.
     * Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployLogInner object
     */
    public Observable<MSDeployLogInner> getMSDeployLogAsync(String resourceGroupName, String name) {
        return getMSDeployLogWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<MSDeployLogInner>, MSDeployLogInner>() {
            @Override
            public MSDeployLogInner call(ServiceResponse<MSDeployLogInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the MSDeploy Log for the last MSDeploy operation.
     * Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployLogInner object
     */
    public Observable<ServiceResponse<MSDeployLogInner>> getMSDeployLogWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getMSDeployLog(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MSDeployLogInner>>>() {
                @Override
                public Observable<ServiceResponse<MSDeployLogInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MSDeployLogInner> clientResponse = getMSDeployLogDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MSDeployLogInner> getMSDeployLogDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MSDeployLogInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MSDeployLogInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List the functions for a web site, or a deployment slot.
     * List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FunctionEnvelopeInner&gt; object if successful.
     */
    public PagedList<FunctionEnvelopeInner> listFunctions(final String resourceGroupName, final String name) {
        ServiceResponse<Page<FunctionEnvelopeInner>> response = listFunctionsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<FunctionEnvelopeInner>(response.body()) {
            @Override
            public Page<FunctionEnvelopeInner> nextPage(String nextPageLink) {
                return listFunctionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List the functions for a web site, or a deployment slot.
     * List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FunctionEnvelopeInner>> listFunctionsAsync(final String resourceGroupName, final String name, final ListOperationCallback<FunctionEnvelopeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listFunctionsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<FunctionEnvelopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FunctionEnvelopeInner>>> call(String nextPageLink) {
                    return listFunctionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List the functions for a web site, or a deployment slot.
     * List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FunctionEnvelopeInner&gt; object
     */
    public Observable<Page<FunctionEnvelopeInner>> listFunctionsAsync(final String resourceGroupName, final String name) {
        return listFunctionsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<FunctionEnvelopeInner>>, Page<FunctionEnvelopeInner>>() {
                @Override
                public Page<FunctionEnvelopeInner> call(ServiceResponse<Page<FunctionEnvelopeInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List the functions for a web site, or a deployment slot.
     * List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FunctionEnvelopeInner&gt; object
     */
    public Observable<ServiceResponse<Page<FunctionEnvelopeInner>>> listFunctionsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listFunctionsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<FunctionEnvelopeInner>>, Observable<ServiceResponse<Page<FunctionEnvelopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FunctionEnvelopeInner>>> call(ServiceResponse<Page<FunctionEnvelopeInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listFunctionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List the functions for a web site, or a deployment slot.
     * List the functions for a web site, or a deployment slot.
     *
    ServiceResponse<PageImpl<FunctionEnvelopeInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<FunctionEnvelopeInner>> * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FunctionEnvelopeInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FunctionEnvelopeInner>>> listFunctionsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listFunctions(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FunctionEnvelopeInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FunctionEnvelopeInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FunctionEnvelopeInner>> result = listFunctionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FunctionEnvelopeInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FunctionEnvelopeInner>> listFunctionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FunctionEnvelopeInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FunctionEnvelopeInner>>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Fetch a short lived token that can be exchanged for a master key.
     * Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the String object if successful.
     */
    public String getFunctionsAdminToken(String resourceGroupName, String name) {
        return getFunctionsAdminTokenWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Fetch a short lived token that can be exchanged for a master key.
     * Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<String> getFunctionsAdminTokenAsync(String resourceGroupName, String name, final ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(getFunctionsAdminTokenWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Fetch a short lived token that can be exchanged for a master key.
     * Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the String object
     */
    public Observable<String> getFunctionsAdminTokenAsync(String resourceGroupName, String name) {
        return getFunctionsAdminTokenWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<String>, String>() {
            @Override
            public String call(ServiceResponse<String> response) {
                return response.body();
            }
        });
    }

    /**
     * Fetch a short lived token that can be exchanged for a master key.
     * Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the String object
     */
    public Observable<ServiceResponse<String>> getFunctionsAdminTokenWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getFunctionsAdminToken(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<String>>>() {
                @Override
                public Observable<ServiceResponse<String>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<String> clientResponse = getFunctionsAdminTokenDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<String> getFunctionsAdminTokenDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<String, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<String>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get function information by its ID for web site, or a deployment slot.
     * Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FunctionEnvelopeInner object if successful.
     */
    public FunctionEnvelopeInner getFunction(String resourceGroupName, String name, String functionName) {
        return getFunctionWithServiceResponseAsync(resourceGroupName, name, functionName).toBlocking().single().body();
    }

    /**
     * Get function information by its ID for web site, or a deployment slot.
     * Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FunctionEnvelopeInner> getFunctionAsync(String resourceGroupName, String name, String functionName, final ServiceCallback<FunctionEnvelopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(getFunctionWithServiceResponseAsync(resourceGroupName, name, functionName), serviceCallback);
    }

    /**
     * Get function information by its ID for web site, or a deployment slot.
     * Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FunctionEnvelopeInner object
     */
    public Observable<FunctionEnvelopeInner> getFunctionAsync(String resourceGroupName, String name, String functionName) {
        return getFunctionWithServiceResponseAsync(resourceGroupName, name, functionName).map(new Func1<ServiceResponse<FunctionEnvelopeInner>, FunctionEnvelopeInner>() {
            @Override
            public FunctionEnvelopeInner call(ServiceResponse<FunctionEnvelopeInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get function information by its ID for web site, or a deployment slot.
     * Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FunctionEnvelopeInner object
     */
    public Observable<ServiceResponse<FunctionEnvelopeInner>> getFunctionWithServiceResponseAsync(String resourceGroupName, String name, String functionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (functionName == null) {
            throw new IllegalArgumentException("Parameter functionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getFunction(resourceGroupName, name, functionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FunctionEnvelopeInner>>>() {
                @Override
                public Observable<ServiceResponse<FunctionEnvelopeInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FunctionEnvelopeInner> clientResponse = getFunctionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FunctionEnvelopeInner> getFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FunctionEnvelopeInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FunctionEnvelopeInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Create function for web site, or a deployment slot.
     * Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FunctionEnvelopeInner object if successful.
     */
    public FunctionEnvelopeInner createFunction(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        return createFunctionWithServiceResponseAsync(resourceGroupName, name, functionName, functionEnvelope).toBlocking().last().body();
    }

    /**
     * Create function for web site, or a deployment slot.
     * Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FunctionEnvelopeInner> createFunctionAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope, final ServiceCallback<FunctionEnvelopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(createFunctionWithServiceResponseAsync(resourceGroupName, name, functionName, functionEnvelope), serviceCallback);
    }

    /**
     * Create function for web site, or a deployment slot.
     * Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<FunctionEnvelopeInner> createFunctionAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        return createFunctionWithServiceResponseAsync(resourceGroupName, name, functionName, functionEnvelope).map(new Func1<ServiceResponse<FunctionEnvelopeInner>, FunctionEnvelopeInner>() {
            @Override
            public FunctionEnvelopeInner call(ServiceResponse<FunctionEnvelopeInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create function for web site, or a deployment slot.
     * Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<FunctionEnvelopeInner>> createFunctionWithServiceResponseAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (functionName == null) {
            throw new IllegalArgumentException("Parameter functionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (functionEnvelope == null) {
            throw new IllegalArgumentException("Parameter functionEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(functionEnvelope);
        Observable<Response<ResponseBody>> observable = service.createFunction(resourceGroupName, name, functionName, this.client.subscriptionId(), functionEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FunctionEnvelopeInner>() { }.getType());
    }

    /**
     * Create function for web site, or a deployment slot.
     * Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FunctionEnvelopeInner object if successful.
     */
    public FunctionEnvelopeInner beginCreateFunction(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        return beginCreateFunctionWithServiceResponseAsync(resourceGroupName, name, functionName, functionEnvelope).toBlocking().single().body();
    }

    /**
     * Create function for web site, or a deployment slot.
     * Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FunctionEnvelopeInner> beginCreateFunctionAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope, final ServiceCallback<FunctionEnvelopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateFunctionWithServiceResponseAsync(resourceGroupName, name, functionName, functionEnvelope), serviceCallback);
    }

    /**
     * Create function for web site, or a deployment slot.
     * Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FunctionEnvelopeInner object
     */
    public Observable<FunctionEnvelopeInner> beginCreateFunctionAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        return beginCreateFunctionWithServiceResponseAsync(resourceGroupName, name, functionName, functionEnvelope).map(new Func1<ServiceResponse<FunctionEnvelopeInner>, FunctionEnvelopeInner>() {
            @Override
            public FunctionEnvelopeInner call(ServiceResponse<FunctionEnvelopeInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create function for web site, or a deployment slot.
     * Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FunctionEnvelopeInner object
     */
    public Observable<ServiceResponse<FunctionEnvelopeInner>> beginCreateFunctionWithServiceResponseAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (functionName == null) {
            throw new IllegalArgumentException("Parameter functionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (functionEnvelope == null) {
            throw new IllegalArgumentException("Parameter functionEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(functionEnvelope);
        return service.beginCreateFunction(resourceGroupName, name, functionName, this.client.subscriptionId(), functionEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FunctionEnvelopeInner>>>() {
                @Override
                public Observable<ServiceResponse<FunctionEnvelopeInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FunctionEnvelopeInner> clientResponse = beginCreateFunctionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FunctionEnvelopeInner> beginCreateFunctionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FunctionEnvelopeInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<FunctionEnvelopeInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Delete a function for web site, or a deployment slot.
     * Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteFunction(String resourceGroupName, String name, String functionName) {
        deleteFunctionWithServiceResponseAsync(resourceGroupName, name, functionName).toBlocking().single().body();
    }

    /**
     * Delete a function for web site, or a deployment slot.
     * Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteFunctionAsync(String resourceGroupName, String name, String functionName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteFunctionWithServiceResponseAsync(resourceGroupName, name, functionName), serviceCallback);
    }

    /**
     * Delete a function for web site, or a deployment slot.
     * Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteFunctionAsync(String resourceGroupName, String name, String functionName) {
        return deleteFunctionWithServiceResponseAsync(resourceGroupName, name, functionName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Delete a function for web site, or a deployment slot.
     * Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteFunctionWithServiceResponseAsync(String resourceGroupName, String name, String functionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (functionName == null) {
            throw new IllegalArgumentException("Parameter functionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteFunction(resourceGroupName, name, functionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteFunctionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get function secrets for a function in a web site, or a deployment slot.
     * Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FunctionSecretsInner object if successful.
     */
    public FunctionSecretsInner listFunctionSecrets(String resourceGroupName, String name, String functionName) {
        return listFunctionSecretsWithServiceResponseAsync(resourceGroupName, name, functionName).toBlocking().single().body();
    }

    /**
     * Get function secrets for a function in a web site, or a deployment slot.
     * Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FunctionSecretsInner> listFunctionSecretsAsync(String resourceGroupName, String name, String functionName, final ServiceCallback<FunctionSecretsInner> serviceCallback) {
        return ServiceFuture.fromResponse(listFunctionSecretsWithServiceResponseAsync(resourceGroupName, name, functionName), serviceCallback);
    }

    /**
     * Get function secrets for a function in a web site, or a deployment slot.
     * Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FunctionSecretsInner object
     */
    public Observable<FunctionSecretsInner> listFunctionSecretsAsync(String resourceGroupName, String name, String functionName) {
        return listFunctionSecretsWithServiceResponseAsync(resourceGroupName, name, functionName).map(new Func1<ServiceResponse<FunctionSecretsInner>, FunctionSecretsInner>() {
            @Override
            public FunctionSecretsInner call(ServiceResponse<FunctionSecretsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get function secrets for a function in a web site, or a deployment slot.
     * Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FunctionSecretsInner object
     */
    public Observable<ServiceResponse<FunctionSecretsInner>> listFunctionSecretsWithServiceResponseAsync(String resourceGroupName, String name, String functionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (functionName == null) {
            throw new IllegalArgumentException("Parameter functionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listFunctionSecrets(resourceGroupName, name, functionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FunctionSecretsInner>>>() {
                @Override
                public Observable<ServiceResponse<FunctionSecretsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FunctionSecretsInner> clientResponse = listFunctionSecretsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FunctionSecretsInner> listFunctionSecretsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FunctionSecretsInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FunctionSecretsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get hostname bindings for an app or a deployment slot.
     * Get hostname bindings for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;HostNameBindingInner&gt; object if successful.
     */
    public PagedList<HostNameBindingInner> listHostNameBindings(final String resourceGroupName, final String name) {
        ServiceResponse<Page<HostNameBindingInner>> response = listHostNameBindingsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<HostNameBindingInner>(response.body()) {
            @Override
            public Page<HostNameBindingInner> nextPage(String nextPageLink) {
                return listHostNameBindingsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get hostname bindings for an app or a deployment slot.
     * Get hostname bindings for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<HostNameBindingInner>> listHostNameBindingsAsync(final String resourceGroupName, final String name, final ListOperationCallback<HostNameBindingInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listHostNameBindingsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<HostNameBindingInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<HostNameBindingInner>>> call(String nextPageLink) {
                    return listHostNameBindingsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get hostname bindings for an app or a deployment slot.
     * Get hostname bindings for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;HostNameBindingInner&gt; object
     */
    public Observable<Page<HostNameBindingInner>> listHostNameBindingsAsync(final String resourceGroupName, final String name) {
        return listHostNameBindingsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<HostNameBindingInner>>, Page<HostNameBindingInner>>() {
                @Override
                public Page<HostNameBindingInner> call(ServiceResponse<Page<HostNameBindingInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get hostname bindings for an app or a deployment slot.
     * Get hostname bindings for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;HostNameBindingInner&gt; object
     */
    public Observable<ServiceResponse<Page<HostNameBindingInner>>> listHostNameBindingsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listHostNameBindingsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<HostNameBindingInner>>, Observable<ServiceResponse<Page<HostNameBindingInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<HostNameBindingInner>>> call(ServiceResponse<Page<HostNameBindingInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listHostNameBindingsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get hostname bindings for an app or a deployment slot.
     * Get hostname bindings for an app or a deployment slot.
     *
    ServiceResponse<PageImpl<HostNameBindingInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<HostNameBindingInner>> * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;HostNameBindingInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<HostNameBindingInner>>> listHostNameBindingsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listHostNameBindings(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<HostNameBindingInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<HostNameBindingInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<HostNameBindingInner>> result = listHostNameBindingsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<HostNameBindingInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<HostNameBindingInner>> listHostNameBindingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<HostNameBindingInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<HostNameBindingInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get the named hostname binding for an app (or deployment slot, if specified).
     * Get the named hostname binding for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the HostNameBindingInner object if successful.
     */
    public HostNameBindingInner getHostNameBinding(String resourceGroupName, String name, String hostName) {
        return getHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName).toBlocking().single().body();
    }

    /**
     * Get the named hostname binding for an app (or deployment slot, if specified).
     * Get the named hostname binding for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<HostNameBindingInner> getHostNameBindingAsync(String resourceGroupName, String name, String hostName, final ServiceCallback<HostNameBindingInner> serviceCallback) {
        return ServiceFuture.fromResponse(getHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName), serviceCallback);
    }

    /**
     * Get the named hostname binding for an app (or deployment slot, if specified).
     * Get the named hostname binding for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HostNameBindingInner object
     */
    public Observable<HostNameBindingInner> getHostNameBindingAsync(String resourceGroupName, String name, String hostName) {
        return getHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName).map(new Func1<ServiceResponse<HostNameBindingInner>, HostNameBindingInner>() {
            @Override
            public HostNameBindingInner call(ServiceResponse<HostNameBindingInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the named hostname binding for an app (or deployment slot, if specified).
     * Get the named hostname binding for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HostNameBindingInner object
     */
    public Observable<ServiceResponse<HostNameBindingInner>> getHostNameBindingWithServiceResponseAsync(String resourceGroupName, String name, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getHostNameBinding(resourceGroupName, name, hostName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<HostNameBindingInner>>>() {
                @Override
                public Observable<ServiceResponse<HostNameBindingInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<HostNameBindingInner> clientResponse = getHostNameBindingDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<HostNameBindingInner> getHostNameBindingDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<HostNameBindingInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<HostNameBindingInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a hostname binding for an app.
     * Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @param hostNameBinding Binding details. This is the JSON representation of a HostNameBinding object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the HostNameBindingInner object if successful.
     */
    public HostNameBindingInner createOrUpdateHostNameBinding(String resourceGroupName, String name, String hostName, HostNameBindingInner hostNameBinding) {
        return createOrUpdateHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName, hostNameBinding).toBlocking().single().body();
    }

    /**
     * Creates a hostname binding for an app.
     * Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @param hostNameBinding Binding details. This is the JSON representation of a HostNameBinding object.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<HostNameBindingInner> createOrUpdateHostNameBindingAsync(String resourceGroupName, String name, String hostName, HostNameBindingInner hostNameBinding, final ServiceCallback<HostNameBindingInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName, hostNameBinding), serviceCallback);
    }

    /**
     * Creates a hostname binding for an app.
     * Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @param hostNameBinding Binding details. This is the JSON representation of a HostNameBinding object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HostNameBindingInner object
     */
    public Observable<HostNameBindingInner> createOrUpdateHostNameBindingAsync(String resourceGroupName, String name, String hostName, HostNameBindingInner hostNameBinding) {
        return createOrUpdateHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName, hostNameBinding).map(new Func1<ServiceResponse<HostNameBindingInner>, HostNameBindingInner>() {
            @Override
            public HostNameBindingInner call(ServiceResponse<HostNameBindingInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a hostname binding for an app.
     * Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @param hostNameBinding Binding details. This is the JSON representation of a HostNameBinding object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HostNameBindingInner object
     */
    public Observable<ServiceResponse<HostNameBindingInner>> createOrUpdateHostNameBindingWithServiceResponseAsync(String resourceGroupName, String name, String hostName, HostNameBindingInner hostNameBinding) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (hostNameBinding == null) {
            throw new IllegalArgumentException("Parameter hostNameBinding is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(hostNameBinding);
        return service.createOrUpdateHostNameBinding(resourceGroupName, name, hostName, this.client.subscriptionId(), hostNameBinding, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<HostNameBindingInner>>>() {
                @Override
                public Observable<ServiceResponse<HostNameBindingInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<HostNameBindingInner> clientResponse = createOrUpdateHostNameBindingDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<HostNameBindingInner> createOrUpdateHostNameBindingDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<HostNameBindingInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<HostNameBindingInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a hostname binding for an app.
     * Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteHostNameBinding(String resourceGroupName, String name, String hostName) {
        deleteHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName).toBlocking().single().body();
    }

    /**
     * Deletes a hostname binding for an app.
     * Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteHostNameBindingAsync(String resourceGroupName, String name, String hostName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName), serviceCallback);
    }

    /**
     * Deletes a hostname binding for an app.
     * Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteHostNameBindingAsync(String resourceGroupName, String name, String hostName) {
        return deleteHostNameBindingWithServiceResponseAsync(resourceGroupName, name, hostName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a hostname binding for an app.
     * Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostName Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteHostNameBindingWithServiceResponseAsync(String resourceGroupName, String name, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteHostNameBinding(resourceGroupName, name, hostName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteHostNameBindingDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteHostNameBindingDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     * Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the HybridConnectionInner object if successful.
     */
    public HybridConnectionInner getHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName) {
        return getHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName).toBlocking().single().body();
    }

    /**
     * Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     * Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<HybridConnectionInner> getHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName, final ServiceCallback<HybridConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName), serviceCallback);
    }

    /**
     * Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     * Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionInner object
     */
    public Observable<HybridConnectionInner> getHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        return getHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName).map(new Func1<ServiceResponse<HybridConnectionInner>, HybridConnectionInner>() {
            @Override
            public HybridConnectionInner call(ServiceResponse<HybridConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     * Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionInner object
     */
    public Observable<ServiceResponse<HybridConnectionInner>> getHybridConnectionWithServiceResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (relayName == null) {
            throw new IllegalArgumentException("Parameter relayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getHybridConnection(resourceGroupName, name, namespaceName, relayName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<HybridConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<HybridConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<HybridConnectionInner> clientResponse = getHybridConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<HybridConnectionInner> getHybridConnectionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<HybridConnectionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<HybridConnectionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new Hybrid Connection using a Service Bus relay.
     * Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the HybridConnectionInner object if successful.
     */
    public HybridConnectionInner createOrUpdateHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        return createOrUpdateHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope).toBlocking().single().body();
    }

    /**
     * Creates a new Hybrid Connection using a Service Bus relay.
     * Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<HybridConnectionInner> createOrUpdateHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope, final ServiceCallback<HybridConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope), serviceCallback);
    }

    /**
     * Creates a new Hybrid Connection using a Service Bus relay.
     * Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionInner object
     */
    public Observable<HybridConnectionInner> createOrUpdateHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        return createOrUpdateHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope).map(new Func1<ServiceResponse<HybridConnectionInner>, HybridConnectionInner>() {
            @Override
            public HybridConnectionInner call(ServiceResponse<HybridConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new Hybrid Connection using a Service Bus relay.
     * Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionInner object
     */
    public Observable<ServiceResponse<HybridConnectionInner>> createOrUpdateHybridConnectionWithServiceResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (relayName == null) {
            throw new IllegalArgumentException("Parameter relayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (connectionEnvelope == null) {
            throw new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(connectionEnvelope);
        return service.createOrUpdateHybridConnection(resourceGroupName, name, namespaceName, relayName, this.client.subscriptionId(), connectionEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<HybridConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<HybridConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<HybridConnectionInner> clientResponse = createOrUpdateHybridConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<HybridConnectionInner> createOrUpdateHybridConnectionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<HybridConnectionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<HybridConnectionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Removes a Hybrid Connection from this site.
     * Removes a Hybrid Connection from this site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName) {
        deleteHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName).toBlocking().single().body();
    }

    /**
     * Removes a Hybrid Connection from this site.
     * Removes a Hybrid Connection from this site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName), serviceCallback);
    }

    /**
     * Removes a Hybrid Connection from this site.
     * Removes a Hybrid Connection from this site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        return deleteHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Removes a Hybrid Connection from this site.
     * Removes a Hybrid Connection from this site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteHybridConnectionWithServiceResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (relayName == null) {
            throw new IllegalArgumentException("Parameter relayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteHybridConnection(resourceGroupName, name, namespaceName, relayName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteHybridConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteHybridConnectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a new Hybrid Connection using a Service Bus relay.
     * Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the HybridConnectionInner object if successful.
     */
    public HybridConnectionInner updateHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        return updateHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope).toBlocking().single().body();
    }

    /**
     * Creates a new Hybrid Connection using a Service Bus relay.
     * Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<HybridConnectionInner> updateHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope, final ServiceCallback<HybridConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope), serviceCallback);
    }

    /**
     * Creates a new Hybrid Connection using a Service Bus relay.
     * Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionInner object
     */
    public Observable<HybridConnectionInner> updateHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        return updateHybridConnectionWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope).map(new Func1<ServiceResponse<HybridConnectionInner>, HybridConnectionInner>() {
            @Override
            public HybridConnectionInner call(ServiceResponse<HybridConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new Hybrid Connection using a Service Bus relay.
     * Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionInner object
     */
    public Observable<ServiceResponse<HybridConnectionInner>> updateHybridConnectionWithServiceResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (relayName == null) {
            throw new IllegalArgumentException("Parameter relayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (connectionEnvelope == null) {
            throw new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(connectionEnvelope);
        return service.updateHybridConnection(resourceGroupName, name, namespaceName, relayName, this.client.subscriptionId(), connectionEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<HybridConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<HybridConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<HybridConnectionInner> clientResponse = updateHybridConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<HybridConnectionInner> updateHybridConnectionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<HybridConnectionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<HybridConnectionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the send key name and value for a Hybrid Connection.
     * Gets the send key name and value for a Hybrid Connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the HybridConnectionKeyInner object if successful.
     */
    public HybridConnectionKeyInner listHybridConnectionKeys(String resourceGroupName, String name, String namespaceName, String relayName) {
        return listHybridConnectionKeysWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName).toBlocking().single().body();
    }

    /**
     * Gets the send key name and value for a Hybrid Connection.
     * Gets the send key name and value for a Hybrid Connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<HybridConnectionKeyInner> listHybridConnectionKeysAsync(String resourceGroupName, String name, String namespaceName, String relayName, final ServiceCallback<HybridConnectionKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(listHybridConnectionKeysWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName), serviceCallback);
    }

    /**
     * Gets the send key name and value for a Hybrid Connection.
     * Gets the send key name and value for a Hybrid Connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionKeyInner object
     */
    public Observable<HybridConnectionKeyInner> listHybridConnectionKeysAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        return listHybridConnectionKeysWithServiceResponseAsync(resourceGroupName, name, namespaceName, relayName).map(new Func1<ServiceResponse<HybridConnectionKeyInner>, HybridConnectionKeyInner>() {
            @Override
            public HybridConnectionKeyInner call(ServiceResponse<HybridConnectionKeyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the send key name and value for a Hybrid Connection.
     * Gets the send key name and value for a Hybrid Connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionKeyInner object
     */
    public Observable<ServiceResponse<HybridConnectionKeyInner>> listHybridConnectionKeysWithServiceResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (relayName == null) {
            throw new IllegalArgumentException("Parameter relayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listHybridConnectionKeys(resourceGroupName, name, namespaceName, relayName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<HybridConnectionKeyInner>>>() {
                @Override
                public Observable<ServiceResponse<HybridConnectionKeyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<HybridConnectionKeyInner> clientResponse = listHybridConnectionKeysDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<HybridConnectionKeyInner> listHybridConnectionKeysDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<HybridConnectionKeyInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<HybridConnectionKeyInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Retrieves all Service Bus Hybrid Connections used by this Web App.
     * Retrieves all Service Bus Hybrid Connections used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the HybridConnectionInner object if successful.
     */
    public HybridConnectionInner listHybridConnections(String resourceGroupName, String name) {
        return listHybridConnectionsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Retrieves all Service Bus Hybrid Connections used by this Web App.
     * Retrieves all Service Bus Hybrid Connections used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<HybridConnectionInner> listHybridConnectionsAsync(String resourceGroupName, String name, final ServiceCallback<HybridConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(listHybridConnectionsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Retrieves all Service Bus Hybrid Connections used by this Web App.
     * Retrieves all Service Bus Hybrid Connections used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionInner object
     */
    public Observable<HybridConnectionInner> listHybridConnectionsAsync(String resourceGroupName, String name) {
        return listHybridConnectionsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<HybridConnectionInner>, HybridConnectionInner>() {
            @Override
            public HybridConnectionInner call(ServiceResponse<HybridConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Retrieves all Service Bus Hybrid Connections used by this Web App.
     * Retrieves all Service Bus Hybrid Connections used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the HybridConnectionInner object
     */
    public Observable<ServiceResponse<HybridConnectionInner>> listHybridConnectionsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listHybridConnections(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<HybridConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<HybridConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<HybridConnectionInner> clientResponse = listHybridConnectionsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<HybridConnectionInner> listHybridConnectionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<HybridConnectionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<HybridConnectionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets hybrid connections configured for an app (or deployment slot, if specified).
     * Gets hybrid connections configured for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RelayServiceConnectionEntityInner object if successful.
     */
    public RelayServiceConnectionEntityInner listRelayServiceConnections(String resourceGroupName, String name) {
        return listRelayServiceConnectionsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets hybrid connections configured for an app (or deployment slot, if specified).
     * Gets hybrid connections configured for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RelayServiceConnectionEntityInner> listRelayServiceConnectionsAsync(String resourceGroupName, String name, final ServiceCallback<RelayServiceConnectionEntityInner> serviceCallback) {
        return ServiceFuture.fromResponse(listRelayServiceConnectionsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets hybrid connections configured for an app (or deployment slot, if specified).
     * Gets hybrid connections configured for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RelayServiceConnectionEntityInner object
     */
    public Observable<RelayServiceConnectionEntityInner> listRelayServiceConnectionsAsync(String resourceGroupName, String name) {
        return listRelayServiceConnectionsWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<RelayServiceConnectionEntityInner>, RelayServiceConnectionEntityInner>() {
            @Override
            public RelayServiceConnectionEntityInner call(ServiceResponse<RelayServiceConnectionEntityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets hybrid connections configured for an app (or deployment slot, if specified).
     * Gets hybrid connections configured for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RelayServiceConnectionEntityInner object
     */
    public Observable<ServiceResponse<RelayServiceConnectionEntityInner>> listRelayServiceConnectionsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listRelayServiceConnections(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RelayServiceConnectionEntityInner>>>() {
                @Override
                public Observable<ServiceResponse<RelayServiceConnectionEntityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RelayServiceConnectionEntityInner> clientResponse = listRelayServiceConnectionsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RelayServiceConnectionEntityInner> listRelayServiceConnectionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RelayServiceConnectionEntityInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RelayServiceConnectionEntityInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a hybrid connection configuration by its name.
     * Gets a hybrid connection configuration by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RelayServiceConnectionEntityInner object if successful.
     */
    public RelayServiceConnectionEntityInner getRelayServiceConnection(String resourceGroupName, String name, String entityName) {
        return getRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName).toBlocking().single().body();
    }

    /**
     * Gets a hybrid connection configuration by its name.
     * Gets a hybrid connection configuration by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RelayServiceConnectionEntityInner> getRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName, final ServiceCallback<RelayServiceConnectionEntityInner> serviceCallback) {
        return ServiceFuture.fromResponse(getRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName), serviceCallback);
    }

    /**
     * Gets a hybrid connection configuration by its name.
     * Gets a hybrid connection configuration by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RelayServiceConnectionEntityInner object
     */
    public Observable<RelayServiceConnectionEntityInner> getRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName) {
        return getRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName).map(new Func1<ServiceResponse<RelayServiceConnectionEntityInner>, RelayServiceConnectionEntityInner>() {
            @Override
            public RelayServiceConnectionEntityInner call(ServiceResponse<RelayServiceConnectionEntityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a hybrid connection configuration by its name.
     * Gets a hybrid connection configuration by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RelayServiceConnectionEntityInner object
     */
    public Observable<ServiceResponse<RelayServiceConnectionEntityInner>> getRelayServiceConnectionWithServiceResponseAsync(String resourceGroupName, String name, String entityName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (entityName == null) {
            throw new IllegalArgumentException("Parameter entityName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getRelayServiceConnection(resourceGroupName, name, entityName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RelayServiceConnectionEntityInner>>>() {
                @Override
                public Observable<ServiceResponse<RelayServiceConnectionEntityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RelayServiceConnectionEntityInner> clientResponse = getRelayServiceConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RelayServiceConnectionEntityInner> getRelayServiceConnectionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RelayServiceConnectionEntityInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RelayServiceConnectionEntityInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RelayServiceConnectionEntityInner object if successful.
     */
    public RelayServiceConnectionEntityInner createOrUpdateRelayServiceConnection(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        return createOrUpdateRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName, connectionEnvelope).toBlocking().single().body();
    }

    /**
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RelayServiceConnectionEntityInner> createOrUpdateRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope, final ServiceCallback<RelayServiceConnectionEntityInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName, connectionEnvelope), serviceCallback);
    }

    /**
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RelayServiceConnectionEntityInner object
     */
    public Observable<RelayServiceConnectionEntityInner> createOrUpdateRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        return createOrUpdateRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName, connectionEnvelope).map(new Func1<ServiceResponse<RelayServiceConnectionEntityInner>, RelayServiceConnectionEntityInner>() {
            @Override
            public RelayServiceConnectionEntityInner call(ServiceResponse<RelayServiceConnectionEntityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RelayServiceConnectionEntityInner object
     */
    public Observable<ServiceResponse<RelayServiceConnectionEntityInner>> createOrUpdateRelayServiceConnectionWithServiceResponseAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (entityName == null) {
            throw new IllegalArgumentException("Parameter entityName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (connectionEnvelope == null) {
            throw new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(connectionEnvelope);
        return service.createOrUpdateRelayServiceConnection(resourceGroupName, name, entityName, this.client.subscriptionId(), connectionEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RelayServiceConnectionEntityInner>>>() {
                @Override
                public Observable<ServiceResponse<RelayServiceConnectionEntityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RelayServiceConnectionEntityInner> clientResponse = createOrUpdateRelayServiceConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RelayServiceConnectionEntityInner> createOrUpdateRelayServiceConnectionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RelayServiceConnectionEntityInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RelayServiceConnectionEntityInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a relay service connection by its name.
     * Deletes a relay service connection by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteRelayServiceConnection(String resourceGroupName, String name, String entityName) {
        deleteRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName).toBlocking().single().body();
    }

    /**
     * Deletes a relay service connection by its name.
     * Deletes a relay service connection by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName), serviceCallback);
    }

    /**
     * Deletes a relay service connection by its name.
     * Deletes a relay service connection by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName) {
        return deleteRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a relay service connection by its name.
     * Deletes a relay service connection by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteRelayServiceConnectionWithServiceResponseAsync(String resourceGroupName, String name, String entityName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (entityName == null) {
            throw new IllegalArgumentException("Parameter entityName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteRelayServiceConnection(resourceGroupName, name, entityName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteRelayServiceConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteRelayServiceConnectionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the RelayServiceConnectionEntityInner object if successful.
     */
    public RelayServiceConnectionEntityInner updateRelayServiceConnection(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        return updateRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName, connectionEnvelope).toBlocking().single().body();
    }

    /**
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<RelayServiceConnectionEntityInner> updateRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope, final ServiceCallback<RelayServiceConnectionEntityInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName, connectionEnvelope), serviceCallback);
    }

    /**
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RelayServiceConnectionEntityInner object
     */
    public Observable<RelayServiceConnectionEntityInner> updateRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        return updateRelayServiceConnectionWithServiceResponseAsync(resourceGroupName, name, entityName, connectionEnvelope).map(new Func1<ServiceResponse<RelayServiceConnectionEntityInner>, RelayServiceConnectionEntityInner>() {
            @Override
            public RelayServiceConnectionEntityInner call(ServiceResponse<RelayServiceConnectionEntityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     * Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the RelayServiceConnectionEntityInner object
     */
    public Observable<ServiceResponse<RelayServiceConnectionEntityInner>> updateRelayServiceConnectionWithServiceResponseAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (entityName == null) {
            throw new IllegalArgumentException("Parameter entityName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (connectionEnvelope == null) {
            throw new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(connectionEnvelope);
        return service.updateRelayServiceConnection(resourceGroupName, name, entityName, this.client.subscriptionId(), connectionEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<RelayServiceConnectionEntityInner>>>() {
                @Override
                public Observable<ServiceResponse<RelayServiceConnectionEntityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<RelayServiceConnectionEntityInner> clientResponse = updateRelayServiceConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<RelayServiceConnectionEntityInner> updateRelayServiceConnectionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<RelayServiceConnectionEntityInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<RelayServiceConnectionEntityInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all scale-out instances of an app.
     * Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SiteInstanceInner&gt; object if successful.
     */
    public PagedList<SiteInstanceInner> listInstanceIdentifiers(final String resourceGroupName, final String name) {
        ServiceResponse<Page<SiteInstanceInner>> response = listInstanceIdentifiersSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<SiteInstanceInner>(response.body()) {
            @Override
            public Page<SiteInstanceInner> nextPage(String nextPageLink) {
                return listInstanceIdentifiersNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all scale-out instances of an app.
     * Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SiteInstanceInner>> listInstanceIdentifiersAsync(final String resourceGroupName, final String name, final ListOperationCallback<SiteInstanceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listInstanceIdentifiersSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<SiteInstanceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInstanceInner>>> call(String nextPageLink) {
                    return listInstanceIdentifiersNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all scale-out instances of an app.
     * Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInstanceInner&gt; object
     */
    public Observable<Page<SiteInstanceInner>> listInstanceIdentifiersAsync(final String resourceGroupName, final String name) {
        return listInstanceIdentifiersWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<SiteInstanceInner>>, Page<SiteInstanceInner>>() {
                @Override
                public Page<SiteInstanceInner> call(ServiceResponse<Page<SiteInstanceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all scale-out instances of an app.
     * Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SiteInstanceInner&gt; object
     */
    public Observable<ServiceResponse<Page<SiteInstanceInner>>> listInstanceIdentifiersWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listInstanceIdentifiersSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<SiteInstanceInner>>, Observable<ServiceResponse<Page<SiteInstanceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInstanceInner>>> call(ServiceResponse<Page<SiteInstanceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listInstanceIdentifiersNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all scale-out instances of an app.
     * Gets all scale-out instances of an app.
     *
    ServiceResponse<PageImpl<SiteInstanceInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<SiteInstanceInner>> * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SiteInstanceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SiteInstanceInner>>> listInstanceIdentifiersSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listInstanceIdentifiers(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SiteInstanceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SiteInstanceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SiteInstanceInner>> result = listInstanceIdentifiersDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SiteInstanceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SiteInstanceInner>> listInstanceIdentifiersDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<SiteInstanceInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SiteInstanceInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get the status of the last MSDeploy operation.
     * Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MSDeployStatusInner object if successful.
     */
    public MSDeployStatusInner getInstanceMsDeployStatus(String resourceGroupName, String name, String instanceId) {
        return getInstanceMsDeployStatusWithServiceResponseAsync(resourceGroupName, name, instanceId).toBlocking().single().body();
    }

    /**
     * Get the status of the last MSDeploy operation.
     * Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MSDeployStatusInner> getInstanceMsDeployStatusAsync(String resourceGroupName, String name, String instanceId, final ServiceCallback<MSDeployStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(getInstanceMsDeployStatusWithServiceResponseAsync(resourceGroupName, name, instanceId), serviceCallback);
    }

    /**
     * Get the status of the last MSDeploy operation.
     * Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployStatusInner object
     */
    public Observable<MSDeployStatusInner> getInstanceMsDeployStatusAsync(String resourceGroupName, String name, String instanceId) {
        return getInstanceMsDeployStatusWithServiceResponseAsync(resourceGroupName, name, instanceId).map(new Func1<ServiceResponse<MSDeployStatusInner>, MSDeployStatusInner>() {
            @Override
            public MSDeployStatusInner call(ServiceResponse<MSDeployStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the status of the last MSDeploy operation.
     * Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployStatusInner object
     */
    public Observable<ServiceResponse<MSDeployStatusInner>> getInstanceMsDeployStatusWithServiceResponseAsync(String resourceGroupName, String name, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getInstanceMsDeployStatus(resourceGroupName, name, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MSDeployStatusInner>>>() {
                @Override
                public Observable<ServiceResponse<MSDeployStatusInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MSDeployStatusInner> clientResponse = getInstanceMsDeployStatusDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MSDeployStatusInner> getInstanceMsDeployStatusDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MSDeployStatusInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MSDeployStatusInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MSDeployStatusInner object if successful.
     */
    public MSDeployStatusInner createInstanceMSDeployOperation(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        return createInstanceMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, instanceId, mSDeploy).toBlocking().last().body();
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MSDeployStatusInner> createInstanceMSDeployOperationAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, final ServiceCallback<MSDeployStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(createInstanceMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, instanceId, mSDeploy), serviceCallback);
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<MSDeployStatusInner> createInstanceMSDeployOperationAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        return createInstanceMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, instanceId, mSDeploy).map(new Func1<ServiceResponse<MSDeployStatusInner>, MSDeployStatusInner>() {
            @Override
            public MSDeployStatusInner call(ServiceResponse<MSDeployStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<MSDeployStatusInner>> createInstanceMSDeployOperationWithServiceResponseAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (mSDeploy == null) {
            throw new IllegalArgumentException("Parameter mSDeploy is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(mSDeploy);
        Observable<Response<ResponseBody>> observable = service.createInstanceMSDeployOperation(resourceGroupName, name, instanceId, this.client.subscriptionId(), mSDeploy, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<MSDeployStatusInner>() { }.getType());
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MSDeployStatusInner object if successful.
     */
    public MSDeployStatusInner beginCreateInstanceMSDeployOperation(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        return beginCreateInstanceMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, instanceId, mSDeploy).toBlocking().single().body();
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MSDeployStatusInner> beginCreateInstanceMSDeployOperationAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, final ServiceCallback<MSDeployStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateInstanceMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, instanceId, mSDeploy), serviceCallback);
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployStatusInner object
     */
    public Observable<MSDeployStatusInner> beginCreateInstanceMSDeployOperationAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        return beginCreateInstanceMSDeployOperationWithServiceResponseAsync(resourceGroupName, name, instanceId, mSDeploy).map(new Func1<ServiceResponse<MSDeployStatusInner>, MSDeployStatusInner>() {
            @Override
            public MSDeployStatusInner call(ServiceResponse<MSDeployStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Invoke the MSDeploy web app extension.
     * Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployStatusInner object
     */
    public Observable<ServiceResponse<MSDeployStatusInner>> beginCreateInstanceMSDeployOperationWithServiceResponseAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (mSDeploy == null) {
            throw new IllegalArgumentException("Parameter mSDeploy is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(mSDeploy);
        return service.beginCreateInstanceMSDeployOperation(resourceGroupName, name, instanceId, this.client.subscriptionId(), mSDeploy, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MSDeployStatusInner>>>() {
                @Override
                public Observable<ServiceResponse<MSDeployStatusInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MSDeployStatusInner> clientResponse = beginCreateInstanceMSDeployOperationDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MSDeployStatusInner> beginCreateInstanceMSDeployOperationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MSDeployStatusInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(201, new TypeToken<MSDeployStatusInner>() { }.getType())
                .register(409, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get the MSDeploy Log for the last MSDeploy operation.
     * Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MSDeployLogInner object if successful.
     */
    public MSDeployLogInner getInstanceMSDeployLog(String resourceGroupName, String name, String instanceId) {
        return getInstanceMSDeployLogWithServiceResponseAsync(resourceGroupName, name, instanceId).toBlocking().single().body();
    }

    /**
     * Get the MSDeploy Log for the last MSDeploy operation.
     * Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MSDeployLogInner> getInstanceMSDeployLogAsync(String resourceGroupName, String name, String instanceId, final ServiceCallback<MSDeployLogInner> serviceCallback) {
        return ServiceFuture.fromResponse(getInstanceMSDeployLogWithServiceResponseAsync(resourceGroupName, name, instanceId), serviceCallback);
    }

    /**
     * Get the MSDeploy Log for the last MSDeploy operation.
     * Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployLogInner object
     */
    public Observable<MSDeployLogInner> getInstanceMSDeployLogAsync(String resourceGroupName, String name, String instanceId) {
        return getInstanceMSDeployLogWithServiceResponseAsync(resourceGroupName, name, instanceId).map(new Func1<ServiceResponse<MSDeployLogInner>, MSDeployLogInner>() {
            @Override
            public MSDeployLogInner call(ServiceResponse<MSDeployLogInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the MSDeploy Log for the last MSDeploy operation.
     * Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MSDeployLogInner object
     */
    public Observable<ServiceResponse<MSDeployLogInner>> getInstanceMSDeployLogWithServiceResponseAsync(String resourceGroupName, String name, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getInstanceMSDeployLog(resourceGroupName, name, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MSDeployLogInner>>>() {
                @Override
                public Observable<ServiceResponse<MSDeployLogInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MSDeployLogInner> clientResponse = getInstanceMSDeployLogDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MSDeployLogInner> getInstanceMSDeployLogDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MSDeployLogInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MSDeployLogInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProcessInfoInner&gt; object if successful.
     */
    public PagedList<ProcessInfoInner> listInstanceProcesses(final String resourceGroupName, final String name, final String instanceId) {
        ServiceResponse<Page<ProcessInfoInner>> response = listInstanceProcessesSinglePageAsync(resourceGroupName, name, instanceId).toBlocking().single();
        return new PagedList<ProcessInfoInner>(response.body()) {
            @Override
            public Page<ProcessInfoInner> nextPage(String nextPageLink) {
                return listInstanceProcessesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProcessInfoInner>> listInstanceProcessesAsync(final String resourceGroupName, final String name, final String instanceId, final ListOperationCallback<ProcessInfoInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listInstanceProcessesSinglePageAsync(resourceGroupName, name, instanceId),
            new Func1<String, Observable<ServiceResponse<Page<ProcessInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessInfoInner>>> call(String nextPageLink) {
                    return listInstanceProcessesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProcessInfoInner&gt; object
     */
    public Observable<Page<ProcessInfoInner>> listInstanceProcessesAsync(final String resourceGroupName, final String name, final String instanceId) {
        return listInstanceProcessesWithServiceResponseAsync(resourceGroupName, name, instanceId)
            .map(new Func1<ServiceResponse<Page<ProcessInfoInner>>, Page<ProcessInfoInner>>() {
                @Override
                public Page<ProcessInfoInner> call(ServiceResponse<Page<ProcessInfoInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProcessInfoInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProcessInfoInner>>> listInstanceProcessesWithServiceResponseAsync(final String resourceGroupName, final String name, final String instanceId) {
        return listInstanceProcessesSinglePageAsync(resourceGroupName, name, instanceId)
            .concatMap(new Func1<ServiceResponse<Page<ProcessInfoInner>>, Observable<ServiceResponse<Page<ProcessInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessInfoInner>>> call(ServiceResponse<Page<ProcessInfoInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listInstanceProcessesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     * Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a web site.
     *
    ServiceResponse<PageImpl<ProcessInfoInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ProcessInfoInner>> * @param name Site name.
    ServiceResponse<PageImpl<ProcessInfoInner>> * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProcessInfoInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProcessInfoInner>>> listInstanceProcessesSinglePageAsync(final String resourceGroupName, final String name, final String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listInstanceProcesses(resourceGroupName, name, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProcessInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessInfoInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ProcessInfoInner>> result = listInstanceProcessesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProcessInfoInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ProcessInfoInner>> listInstanceProcessesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ProcessInfoInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ProcessInfoInner>>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get process information by its ID for a specific scaled-out instance in a web site.
     * Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProcessInfoInner object if successful.
     */
    public ProcessInfoInner getInstanceProcess(String resourceGroupName, String name, String processId, String instanceId) {
        return getInstanceProcessWithServiceResponseAsync(resourceGroupName, name, processId, instanceId).toBlocking().single().body();
    }

    /**
     * Get process information by its ID for a specific scaled-out instance in a web site.
     * Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProcessInfoInner> getInstanceProcessAsync(String resourceGroupName, String name, String processId, String instanceId, final ServiceCallback<ProcessInfoInner> serviceCallback) {
        return ServiceFuture.fromResponse(getInstanceProcessWithServiceResponseAsync(resourceGroupName, name, processId, instanceId), serviceCallback);
    }

    /**
     * Get process information by its ID for a specific scaled-out instance in a web site.
     * Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProcessInfoInner object
     */
    public Observable<ProcessInfoInner> getInstanceProcessAsync(String resourceGroupName, String name, String processId, String instanceId) {
        return getInstanceProcessWithServiceResponseAsync(resourceGroupName, name, processId, instanceId).map(new Func1<ServiceResponse<ProcessInfoInner>, ProcessInfoInner>() {
            @Override
            public ProcessInfoInner call(ServiceResponse<ProcessInfoInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get process information by its ID for a specific scaled-out instance in a web site.
     * Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProcessInfoInner object
     */
    public Observable<ServiceResponse<ProcessInfoInner>> getInstanceProcessWithServiceResponseAsync(String resourceGroupName, String name, String processId, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (processId == null) {
            throw new IllegalArgumentException("Parameter processId is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getInstanceProcess(resourceGroupName, name, processId, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProcessInfoInner>>>() {
                @Override
                public Observable<ServiceResponse<ProcessInfoInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProcessInfoInner> clientResponse = getInstanceProcessDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ProcessInfoInner> getInstanceProcessDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ProcessInfoInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ProcessInfoInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site.
     * Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteInstanceProcess(String resourceGroupName, String name, String processId, String instanceId) {
        deleteInstanceProcessWithServiceResponseAsync(resourceGroupName, name, processId, instanceId).toBlocking().single().body();
    }

    /**
     * Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site.
     * Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteInstanceProcessAsync(String resourceGroupName, String name, String processId, String instanceId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteInstanceProcessWithServiceResponseAsync(resourceGroupName, name, processId, instanceId), serviceCallback);
    }

    /**
     * Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site.
     * Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteInstanceProcessAsync(String resourceGroupName, String name, String processId, String instanceId) {
        return deleteInstanceProcessWithServiceResponseAsync(resourceGroupName, name, processId, instanceId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site.
     * Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteInstanceProcessWithServiceResponseAsync(String resourceGroupName, String name, String processId, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (processId == null) {
            throw new IllegalArgumentException("Parameter processId is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteInstanceProcess(resourceGroupName, name, processId, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteInstanceProcessDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteInstanceProcessDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     * Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InputStream object if successful.
     */
    public InputStream getInstanceProcessDump(String resourceGroupName, String name, String processId, String instanceId) {
        return getInstanceProcessDumpWithServiceResponseAsync(resourceGroupName, name, processId, instanceId).toBlocking().single().body();
    }

    /**
     * Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     * Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InputStream> getInstanceProcessDumpAsync(String resourceGroupName, String name, String processId, String instanceId, final ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromResponse(getInstanceProcessDumpWithServiceResponseAsync(resourceGroupName, name, processId, instanceId), serviceCallback);
    }

    /**
     * Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     * Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InputStream object
     */
    public Observable<InputStream> getInstanceProcessDumpAsync(String resourceGroupName, String name, String processId, String instanceId) {
        return getInstanceProcessDumpWithServiceResponseAsync(resourceGroupName, name, processId, instanceId).map(new Func1<ServiceResponse<InputStream>, InputStream>() {
            @Override
            public InputStream call(ServiceResponse<InputStream> response) {
                return response.body();
            }
        });
    }

    /**
     * Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     * Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InputStream object
     */
    public Observable<ServiceResponse<InputStream>> getInstanceProcessDumpWithServiceResponseAsync(String resourceGroupName, String name, String processId, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (processId == null) {
            throw new IllegalArgumentException("Parameter processId is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getInstanceProcessDump(resourceGroupName, name, processId, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InputStream>>>() {
                @Override
                public Observable<ServiceResponse<InputStream>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InputStream> clientResponse = getInstanceProcessDumpDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InputStream> getInstanceProcessDumpDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InputStream, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InputStream>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProcessModuleInfoInner&gt; object if successful.
     */
    public PagedList<ProcessModuleInfoInner> listInstanceProcessModules(final String resourceGroupName, final String name, final String processId, final String instanceId) {
        ServiceResponse<Page<ProcessModuleInfoInner>> response = listInstanceProcessModulesSinglePageAsync(resourceGroupName, name, processId, instanceId).toBlocking().single();
        return new PagedList<ProcessModuleInfoInner>(response.body()) {
            @Override
            public Page<ProcessModuleInfoInner> nextPage(String nextPageLink) {
                return listInstanceProcessModulesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProcessModuleInfoInner>> listInstanceProcessModulesAsync(final String resourceGroupName, final String name, final String processId, final String instanceId, final ListOperationCallback<ProcessModuleInfoInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listInstanceProcessModulesSinglePageAsync(resourceGroupName, name, processId, instanceId),
            new Func1<String, Observable<ServiceResponse<Page<ProcessModuleInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessModuleInfoInner>>> call(String nextPageLink) {
                    return listInstanceProcessModulesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProcessModuleInfoInner&gt; object
     */
    public Observable<Page<ProcessModuleInfoInner>> listInstanceProcessModulesAsync(final String resourceGroupName, final String name, final String processId, final String instanceId) {
        return listInstanceProcessModulesWithServiceResponseAsync(resourceGroupName, name, processId, instanceId)
            .map(new Func1<ServiceResponse<Page<ProcessModuleInfoInner>>, Page<ProcessModuleInfoInner>>() {
                @Override
                public Page<ProcessModuleInfoInner> call(ServiceResponse<Page<ProcessModuleInfoInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProcessModuleInfoInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProcessModuleInfoInner>>> listInstanceProcessModulesWithServiceResponseAsync(final String resourceGroupName, final String name, final String processId, final String instanceId) {
        return listInstanceProcessModulesSinglePageAsync(resourceGroupName, name, processId, instanceId)
            .concatMap(new Func1<ServiceResponse<Page<ProcessModuleInfoInner>>, Observable<ServiceResponse<Page<ProcessModuleInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessModuleInfoInner>>> call(ServiceResponse<Page<ProcessModuleInfoInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listInstanceProcessModulesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     * List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
    ServiceResponse<PageImpl<ProcessModuleInfoInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ProcessModuleInfoInner>> * @param name Site name.
    ServiceResponse<PageImpl<ProcessModuleInfoInner>> * @param processId PID.
    ServiceResponse<PageImpl<ProcessModuleInfoInner>> * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProcessModuleInfoInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProcessModuleInfoInner>>> listInstanceProcessModulesSinglePageAsync(final String resourceGroupName, final String name, final String processId, final String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (processId == null) {
            throw new IllegalArgumentException("Parameter processId is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listInstanceProcessModules(resourceGroupName, name, processId, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProcessModuleInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessModuleInfoInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ProcessModuleInfoInner>> result = listInstanceProcessModulesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProcessModuleInfoInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ProcessModuleInfoInner>> listInstanceProcessModulesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ProcessModuleInfoInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ProcessModuleInfoInner>>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get process information by its ID for a specific scaled-out instance in a web site.
     * Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProcessModuleInfoInner object if successful.
     */
    public ProcessModuleInfoInner getInstanceProcessModule(String resourceGroupName, String name, String processId, String baseAddress, String instanceId) {
        return getInstanceProcessModuleWithServiceResponseAsync(resourceGroupName, name, processId, baseAddress, instanceId).toBlocking().single().body();
    }

    /**
     * Get process information by its ID for a specific scaled-out instance in a web site.
     * Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProcessModuleInfoInner> getInstanceProcessModuleAsync(String resourceGroupName, String name, String processId, String baseAddress, String instanceId, final ServiceCallback<ProcessModuleInfoInner> serviceCallback) {
        return ServiceFuture.fromResponse(getInstanceProcessModuleWithServiceResponseAsync(resourceGroupName, name, processId, baseAddress, instanceId), serviceCallback);
    }

    /**
     * Get process information by its ID for a specific scaled-out instance in a web site.
     * Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProcessModuleInfoInner object
     */
    public Observable<ProcessModuleInfoInner> getInstanceProcessModuleAsync(String resourceGroupName, String name, String processId, String baseAddress, String instanceId) {
        return getInstanceProcessModuleWithServiceResponseAsync(resourceGroupName, name, processId, baseAddress, instanceId).map(new Func1<ServiceResponse<ProcessModuleInfoInner>, ProcessModuleInfoInner>() {
            @Override
            public ProcessModuleInfoInner call(ServiceResponse<ProcessModuleInfoInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get process information by its ID for a specific scaled-out instance in a web site.
     * Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProcessModuleInfoInner object
     */
    public Observable<ServiceResponse<ProcessModuleInfoInner>> getInstanceProcessModuleWithServiceResponseAsync(String resourceGroupName, String name, String processId, String baseAddress, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (processId == null) {
            throw new IllegalArgumentException("Parameter processId is required and cannot be null.");
        }
        if (baseAddress == null) {
            throw new IllegalArgumentException("Parameter baseAddress is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getInstanceProcessModule(resourceGroupName, name, processId, baseAddress, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProcessModuleInfoInner>>>() {
                @Override
                public Observable<ServiceResponse<ProcessModuleInfoInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProcessModuleInfoInner> clientResponse = getInstanceProcessModuleDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ProcessModuleInfoInner> getInstanceProcessModuleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ProcessModuleInfoInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ProcessModuleInfoInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ProcessThreadInfoInner&gt; object if successful.
     */
    public PagedList<ProcessThreadInfoInner> listInstanceProcessThreads(final String resourceGroupName, final String name, final String processId, final String instanceId) {
        ServiceResponse<Page<ProcessThreadInfoInner>> response = listInstanceProcessThreadsSinglePageAsync(resourceGroupName, name, processId, instanceId).toBlocking().single();
        return new PagedList<ProcessThreadInfoInner>(response.body()) {
            @Override
            public Page<ProcessThreadInfoInner> nextPage(String nextPageLink) {
                return listInstanceProcessThreadsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ProcessThreadInfoInner>> listInstanceProcessThreadsAsync(final String resourceGroupName, final String name, final String processId, final String instanceId, final ListOperationCallback<ProcessThreadInfoInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listInstanceProcessThreadsSinglePageAsync(resourceGroupName, name, processId, instanceId),
            new Func1<String, Observable<ServiceResponse<Page<ProcessThreadInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessThreadInfoInner>>> call(String nextPageLink) {
                    return listInstanceProcessThreadsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProcessThreadInfoInner&gt; object
     */
    public Observable<Page<ProcessThreadInfoInner>> listInstanceProcessThreadsAsync(final String resourceGroupName, final String name, final String processId, final String instanceId) {
        return listInstanceProcessThreadsWithServiceResponseAsync(resourceGroupName, name, processId, instanceId)
            .map(new Func1<ServiceResponse<Page<ProcessThreadInfoInner>>, Page<ProcessThreadInfoInner>>() {
                @Override
                public Page<ProcessThreadInfoInner> call(ServiceResponse<Page<ProcessThreadInfoInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ProcessThreadInfoInner&gt; object
     */
    public Observable<ServiceResponse<Page<ProcessThreadInfoInner>>> listInstanceProcessThreadsWithServiceResponseAsync(final String resourceGroupName, final String name, final String processId, final String instanceId) {
        return listInstanceProcessThreadsSinglePageAsync(resourceGroupName, name, processId, instanceId)
            .concatMap(new Func1<ServiceResponse<Page<ProcessThreadInfoInner>>, Observable<ServiceResponse<Page<ProcessThreadInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessThreadInfoInner>>> call(ServiceResponse<Page<ProcessThreadInfoInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listInstanceProcessThreadsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     * List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
    ServiceResponse<PageImpl<ProcessThreadInfoInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ProcessThreadInfoInner>> * @param name Site name.
    ServiceResponse<PageImpl<ProcessThreadInfoInner>> * @param processId PID.
    ServiceResponse<PageImpl<ProcessThreadInfoInner>> * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ProcessThreadInfoInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ProcessThreadInfoInner>>> listInstanceProcessThreadsSinglePageAsync(final String resourceGroupName, final String name, final String processId, final String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (processId == null) {
            throw new IllegalArgumentException("Parameter processId is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listInstanceProcessThreads(resourceGroupName, name, processId, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProcessThreadInfoInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ProcessThreadInfoInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ProcessThreadInfoInner>> result = listInstanceProcessThreadsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ProcessThreadInfoInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ProcessThreadInfoInner>> listInstanceProcessThreadsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ProcessThreadInfoInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ProcessThreadInfoInner>>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site.
     * Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param threadId TID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ProcessThreadInfoInner object if successful.
     */
    public ProcessThreadInfoInner getInstanceProcessThread(String resourceGroupName, String name, String processId, String threadId, String instanceId) {
        return getInstanceProcessThreadWithServiceResponseAsync(resourceGroupName, name, processId, threadId, instanceId).toBlocking().single().body();
    }

    /**
     * Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site.
     * Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param threadId TID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ProcessThreadInfoInner> getInstanceProcessThreadAsync(String resourceGroupName, String name, String processId, String threadId, String instanceId, final ServiceCallback<ProcessThreadInfoInner> serviceCallback) {
        return ServiceFuture.fromResponse(getInstanceProcessThreadWithServiceResponseAsync(resourceGroupName, name, processId, threadId, instanceId), serviceCallback);
    }

    /**
     * Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site.
     * Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param threadId TID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProcessThreadInfoInner object
     */
    public Observable<ProcessThreadInfoInner> getInstanceProcessThreadAsync(String resourceGroupName, String name, String processId, String threadId, String instanceId) {
        return getInstanceProcessThreadWithServiceResponseAsync(resourceGroupName, name, processId, threadId, instanceId).map(new Func1<ServiceResponse<ProcessThreadInfoInner>, ProcessThreadInfoInner>() {
            @Override
            public ProcessThreadInfoInner call(ServiceResponse<ProcessThreadInfoInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site.
     * Get thread information by Thread ID for a specific process, in a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param threadId TID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ProcessThreadInfoInner object
     */
    public Observable<ServiceResponse<ProcessThreadInfoInner>> getInstanceProcessThreadWithServiceResponseAsync(String resourceGroupName, String name, String processId, String threadId, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (processId == null) {
            throw new IllegalArgumentException("Parameter processId is required and cannot be null.");
        }
        if (threadId == null) {
            throw new IllegalArgumentException("Parameter threadId is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getInstanceProcessThread(resourceGroupName, name, processId, threadId, instanceId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProcessThreadInfoInner>>>() {
                @Override
                public Observable<ServiceResponse<ProcessThreadInfoInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ProcessThreadInfoInner> clientResponse = getInstanceProcessThreadDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ProcessThreadInfoInner> getInstanceProcessThreadDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ProcessThreadInfoInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ProcessThreadInfoInner>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Shows whether an app can be cloned to another resource group or subscription.
     * Shows whether an app can be cloned to another resource group or subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SiteCloneabilityInner object if successful.
     */
    public SiteCloneabilityInner isCloneable(String resourceGroupName, String name) {
        return isCloneableWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Shows whether an app can be cloned to another resource group or subscription.
     * Shows whether an app can be cloned to another resource group or subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SiteCloneabilityInner> isCloneableAsync(String resourceGroupName, String name, final ServiceCallback<SiteCloneabilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(isCloneableWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Shows whether an app can be cloned to another resource group or subscription.
     * Shows whether an app can be cloned to another resource group or subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteCloneabilityInner object
     */
    public Observable<SiteCloneabilityInner> isCloneableAsync(String resourceGroupName, String name) {
        return isCloneableWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<SiteCloneabilityInner>, SiteCloneabilityInner>() {
            @Override
            public SiteCloneabilityInner call(ServiceResponse<SiteCloneabilityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Shows whether an app can be cloned to another resource group or subscription.
     * Shows whether an app can be cloned to another resource group or subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SiteCloneabilityInner object
     */
    public Observable<ServiceResponse<SiteCloneabilityInner>> isCloneableWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.isCloneable(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteCloneabilityInner>>>() {
                @Override
                public Observable<ServiceResponse<SiteCloneabilityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SiteCloneabilityInner> clientResponse = isCloneableDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SiteCloneabilityInner> isCloneableDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SiteCloneabilityInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SiteCloneabilityInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * This is to allow calling via powershell and ARM template.
     * This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FunctionSecretsInner object if successful.
     */
    public FunctionSecretsInner listSyncFunctionTriggers(String resourceGroupName, String name) {
        return listSyncFunctionTriggersWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * This is to allow calling via powershell and ARM template.
     * This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FunctionSecretsInner> listSyncFunctionTriggersAsync(String resourceGroupName, String name, final ServiceCallback<FunctionSecretsInner> serviceCallback) {
        return ServiceFuture.fromResponse(listSyncFunctionTriggersWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * This is to allow calling via powershell and ARM template.
     * This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FunctionSecretsInner object
     */
    public Observable<FunctionSecretsInner> listSyncFunctionTriggersAsync(String resourceGroupName, String name) {
        return listSyncFunctionTriggersWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<FunctionSecretsInner>, FunctionSecretsInner>() {
            @Override
            public FunctionSecretsInner call(ServiceResponse<FunctionSecretsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * This is to allow calling via powershell and ARM template.
     * This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FunctionSecretsInner object
     */
    public Observable<ServiceResponse<FunctionSecretsInner>> listSyncFunctionTriggersWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSyncFunctionTriggers(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FunctionSecretsInner>>>() {
                @Override
                public Observable<ServiceResponse<FunctionSecretsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FunctionSecretsInner> clientResponse = listSyncFunctionTriggersDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FunctionSecretsInner> listSyncFunctionTriggersDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FunctionSecretsInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FunctionSecretsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets all metric definitions of an app (or deployment slot, if specified).
     * Gets all metric definitions of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object if successful.
     */
    public PagedList<ResourceMetricDefinitionInner> listMetricDefinitions(final String resourceGroupName, final String name) {
        ServiceResponse<Page<ResourceMetricDefinitionInner>> response = listMetricDefinitionsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<ResourceMetricDefinitionInner>(response.body()) {
            @Override
            public Page<ResourceMetricDefinitionInner> nextPage(String nextPageLink) {
                return listMetricDefinitionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets all metric definitions of an app (or deployment slot, if specified).
     * Gets all metric definitions of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricDefinitionInner>> listMetricDefinitionsAsync(final String resourceGroupName, final String name, final ListOperationCallback<ResourceMetricDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMetricDefinitionsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(String nextPageLink) {
                    return listMetricDefinitionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets all metric definitions of an app (or deployment slot, if specified).
     * Gets all metric definitions of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<Page<ResourceMetricDefinitionInner>> listMetricDefinitionsAsync(final String resourceGroupName, final String name) {
        return listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Page<ResourceMetricDefinitionInner>>() {
                @Override
                public Page<ResourceMetricDefinitionInner> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets all metric definitions of an app (or deployment slot, if specified).
     * Gets all metric definitions of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMetricDefinitionsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listMetricDefinitionsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricDefinitionInner>>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(ServiceResponse<Page<ResourceMetricDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMetricDefinitionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets all metric definitions of an app (or deployment slot, if specified).
     * Gets all metric definitions of an app (or deployment slot, if specified).
     *
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> listMetricDefinitionsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMetricDefinitions(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> result = listMetricDefinitionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricDefinitionInner>> listMetricDefinitionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMetrics(final String resourceGroupName, final String name) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMetricsSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMetricsAsync(final String resourceGroupName, final String name, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMetricsSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMetricsAsync(final String resourceGroupName, final String name) {
        return listMetricsWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listMetricsSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Boolean details = null;
        final String filter = null;
        return service.listMetrics(resourceGroupName, name, this.client.subscriptionId(), details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param details Specify "true" to include metric details in the response. It is "false" by default.
     * @param filter Return only metrics specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ResourceMetricInner&gt; object if successful.
     */
    public PagedList<ResourceMetricInner> listMetrics(final String resourceGroupName, final String name, final Boolean details, final String filter) {
        ServiceResponse<Page<ResourceMetricInner>> response = listMetricsSinglePageAsync(resourceGroupName, name, details, filter).toBlocking().single();
        return new PagedList<ResourceMetricInner>(response.body()) {
            @Override
            public Page<ResourceMetricInner> nextPage(String nextPageLink) {
                return listMetricsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param details Specify "true" to include metric details in the response. It is "false" by default.
     * @param filter Return only metrics specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ResourceMetricInner>> listMetricsAsync(final String resourceGroupName, final String name, final Boolean details, final String filter, final ListOperationCallback<ResourceMetricInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listMetricsSinglePageAsync(resourceGroupName, name, details, filter),
            new Func1<String, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(String nextPageLink) {
                    return listMetricsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param details Specify "true" to include metric details in the response. It is "false" by default.
     * @param filter Return only metrics specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<Page<ResourceMetricInner>> listMetricsAsync(final String resourceGroupName, final String name, final Boolean details, final String filter) {
        return listMetricsWithServiceResponseAsync(resourceGroupName, name, details, filter)
            .map(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Page<ResourceMetricInner>>() {
                @Override
                public Page<ResourceMetricInner> call(ServiceResponse<Page<ResourceMetricInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param details Specify "true" to include metric details in the response. It is "false" by default.
     * @param filter Return only metrics specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ResourceMetricInner&gt; object
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsWithServiceResponseAsync(final String resourceGroupName, final String name, final Boolean details, final String filter) {
        return listMetricsSinglePageAsync(resourceGroupName, name, details, filter)
            .concatMap(new Func1<ServiceResponse<Page<ResourceMetricInner>>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(ServiceResponse<Page<ResourceMetricInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listMetricsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets performance metrics of an app (or deployment slot, if specified).
     * Gets performance metrics of an app (or deployment slot, if specified).
     *
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param name Name of the app.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param details Specify "true" to include metric details in the response. It is "false" by default.
    ServiceResponse<PageImpl<ResourceMetricInner>> * @param filter Return only metrics specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ResourceMetricInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ResourceMetricInner>>> listMetricsSinglePageAsync(final String resourceGroupName, final String name, final Boolean details, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listMetrics(resourceGroupName, name, this.client.subscriptionId(), details, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceMetricInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ResourceMetricInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ResourceMetricInner>> result = listMetricsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ResourceMetricInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ResourceMetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ResourceMetricInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ResourceMetricInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Restores a web app.
     * Restores a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param subscriptionName Azure subscription.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageMigrationResponseInner object if successful.
     */
    public StorageMigrationResponseInner migrateStorage(String resourceGroupName, String name, String subscriptionName, StorageMigrationOptions migrationOptions) {
        return migrateStorageWithServiceResponseAsync(resourceGroupName, name, subscriptionName, migrationOptions).toBlocking().last().body();
    }

    /**
     * Restores a web app.
     * Restores a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param subscriptionName Azure subscription.
     * @param migrationOptions Migration migrationOptions.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<StorageMigrationResponseInner> migrateStorageAsync(String resourceGroupName, String name, String subscriptionName, StorageMigrationOptions migrationOptions, final ServiceCallback<StorageMigrationResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(migrateStorageWithServiceResponseAsync(resourceGroupName, name, subscriptionName, migrationOptions), serviceCallback);
    }

    /**
     * Restores a web app.
     * Restores a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param subscriptionName Azure subscription.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<StorageMigrationResponseInner> migrateStorageAsync(String resourceGroupName, String name, String subscriptionName, StorageMigrationOptions migrationOptions) {
        return migrateStorageWithServiceResponseAsync(resourceGroupName, name, subscriptionName, migrationOptions).map(new Func1<ServiceResponse<StorageMigrationResponseInner>, StorageMigrationResponseInner>() {
            @Override
            public StorageMigrationResponseInner call(ServiceResponse<StorageMigrationResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Restores a web app.
     * Restores a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param subscriptionName Azure subscription.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<StorageMigrationResponseInner>> migrateStorageWithServiceResponseAsync(String resourceGroupName, String name, String subscriptionName, StorageMigrationOptions migrationOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Parameter subscriptionName is required and cannot be null.");
        }
        if (migrationOptions == null) {
            throw new IllegalArgumentException("Parameter migrationOptions is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(migrationOptions);
        Observable<Response<ResponseBody>> observable = service.migrateStorage(resourceGroupName, name, this.client.subscriptionId(), subscriptionName, migrationOptions, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<StorageMigrationResponseInner>() { }.getType());
    }

    /**
     * Restores a web app.
     * Restores a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param subscriptionName Azure subscription.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the StorageMigrationResponseInner object if successful.
     */
    public StorageMigrationResponseInner beginMigrateStorage(String resourceGroupName, String name, String subscriptionName, StorageMigrationOptions migrationOptions) {
        return beginMigrateStorageWithServiceResponseAsync(resourceGroupName, name, subscriptionName, migrationOptions).toBlocking().single().body();
    }

    /**
     * Restores a web app.
     * Restores a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param subscriptionName Azure subscription.
     * @param migrationOptions Migration migrationOptions.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<StorageMigrationResponseInner> beginMigrateStorageAsync(String resourceGroupName, String name, String subscriptionName, StorageMigrationOptions migrationOptions, final ServiceCallback<StorageMigrationResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginMigrateStorageWithServiceResponseAsync(resourceGroupName, name, subscriptionName, migrationOptions), serviceCallback);
    }

    /**
     * Restores a web app.
     * Restores a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param subscriptionName Azure subscription.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageMigrationResponseInner object
     */
    public Observable<StorageMigrationResponseInner> beginMigrateStorageAsync(String resourceGroupName, String name, String subscriptionName, StorageMigrationOptions migrationOptions) {
        return beginMigrateStorageWithServiceResponseAsync(resourceGroupName, name, subscriptionName, migrationOptions).map(new Func1<ServiceResponse<StorageMigrationResponseInner>, StorageMigrationResponseInner>() {
            @Override
            public StorageMigrationResponseInner call(ServiceResponse<StorageMigrationResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Restores a web app.
     * Restores a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param subscriptionName Azure subscription.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the StorageMigrationResponseInner object
     */
    public Observable<ServiceResponse<StorageMigrationResponseInner>> beginMigrateStorageWithServiceResponseAsync(String resourceGroupName, String name, String subscriptionName, StorageMigrationOptions migrationOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Parameter subscriptionName is required and cannot be null.");
        }
        if (migrationOptions == null) {
            throw new IllegalArgumentException("Parameter migrationOptions is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(migrationOptions);
        return service.beginMigrateStorage(resourceGroupName, name, this.client.subscriptionId(), subscriptionName, migrationOptions, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageMigrationResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<StorageMigrationResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<StorageMigrationResponseInner> clientResponse = beginMigrateStorageDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<StorageMigrationResponseInner> beginMigrateStorageDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<StorageMigrationResponseInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<StorageMigrationResponseInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Migrates a local (in-app) MySql database to a remote MySql database.
     * Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OperationInner object if successful.
     */
    public OperationInner migrateMySql(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        return migrateMySqlWithServiceResponseAsync(resourceGroupName, name, migrationRequestEnvelope).toBlocking().last().body();
    }

    /**
     * Migrates a local (in-app) MySql database to a remote MySql database.
     * Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OperationInner> migrateMySqlAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, final ServiceCallback<OperationInner> serviceCallback) {
        return ServiceFuture.fromResponse(migrateMySqlWithServiceResponseAsync(resourceGroupName, name, migrationRequestEnvelope), serviceCallback);
    }

    /**
     * Migrates a local (in-app) MySql database to a remote MySql database.
     * Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<OperationInner> migrateMySqlAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        return migrateMySqlWithServiceResponseAsync(resourceGroupName, name, migrationRequestEnvelope).map(new Func1<ServiceResponse<OperationInner>, OperationInner>() {
            @Override
            public OperationInner call(ServiceResponse<OperationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Migrates a local (in-app) MySql database to a remote MySql database.
     * Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<OperationInner>> migrateMySqlWithServiceResponseAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (migrationRequestEnvelope == null) {
            throw new IllegalArgumentException("Parameter migrationRequestEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(migrationRequestEnvelope);
        Observable<Response<ResponseBody>> observable = service.migrateMySql(resourceGroupName, name, this.client.subscriptionId(), migrationRequestEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationInner>() { }.getType());
    }

    /**
     * Migrates a local (in-app) MySql database to a remote MySql database.
     * Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the OperationInner object if successful.
     */
    public OperationInner beginMigrateMySql(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        return beginMigrateMySqlWithServiceResponseAsync(resourceGroupName, name, migrationRequestEnvelope).toBlocking().single().body();
    }

    /**
     * Migrates a local (in-app) MySql database to a remote MySql database.
     * Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<OperationInner> beginMigrateMySqlAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, final ServiceCallback<OperationInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginMigrateMySqlWithServiceResponseAsync(resourceGroupName, name, migrationRequestEnvelope), serviceCallback);
    }

    /**
     * Migrates a local (in-app) MySql database to a remote MySql database.
     * Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OperationInner object
     */
    public Observable<OperationInner> beginMigrateMySqlAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        return beginMigrateMySqlWithServiceResponseAsync(resourceGroupName, name, migrationRequestEnvelope).map(new Func1<ServiceResponse<OperationInner>, OperationInner>() {
            @Override
            public OperationInner call(ServiceResponse<OperationInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Migrates a local (in-app) MySql database to a remote MySql database.
     * Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the OperationInner object
     */
    public Observable<ServiceResponse<OperationInner>> beginMigrateMySqlWithServiceResponseAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (migrationRequestEnvelope == null) {
            throw new IllegalArgumentException("Parameter migrationRequestEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(migrationRequestEnvelope);
        return service.beginMigrateMySql(resourceGroupName, name, this.client.subscriptionId(), migrationRequestEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationInner>>>() {
                @Override
                public Observable<ServiceResponse<OperationInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<OperationInner> clientResponse = beginMigrateMySqlDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<OperationInner> beginMigrateMySqlDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<OperationInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<OperationInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled.
     * Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the MigrateMySqlStatusInner object if successful.
     */
    public MigrateMySqlStatusInner getMigrateMySqlStatus(String resourceGroupName, String name) {
        return getMigrateMySqlStatusWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled.
     * Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<MigrateMySqlStatusInner> getMigrateMySqlStatusAsync(String resourceGroupName, String name, final ServiceCallback<MigrateMySqlStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(getMigrateMySqlStatusWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled.
     * Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MigrateMySqlStatusInner object
     */
    public Observable<MigrateMySqlStatusInner> getMigrateMySqlStatusAsync(String resourceGroupName, String name) {
        return getMigrateMySqlStatusWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<MigrateMySqlStatusInner>, MigrateMySqlStatusInner>() {
            @Override
            public MigrateMySqlStatusInner call(ServiceResponse<MigrateMySqlStatusInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled.
     * Returns the status of MySql in app migration, if one is active, and whether or not MySql in app is enabled.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the MigrateMySqlStatusInner object
     */
    public Observable<ServiceResponse<MigrateMySqlStatusInner>> getMigrateMySqlStatusWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getMigrateMySqlStatus(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<MigrateMySqlStatusInner>>>() {
                @Override
                public Observable<ServiceResponse<MigrateMySqlStatusInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<MigrateMySqlStatusInner> clientResponse = getMigrateMySqlStatusDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<MigrateMySqlStatusInner> getMigrateMySqlStatusDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<MigrateMySqlStatusInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<MigrateMySqlStatusInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a Swift Virtual Network connection.
     * Gets a Swift Virtual Network connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SwiftVirtualNetworkInner object if successful.
     */
    public SwiftVirtualNetworkInner getSwiftVirtualNetworkConnection(String resourceGroupName, String name) {
        return getSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Gets a Swift Virtual Network connection.
     * Gets a Swift Virtual Network connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SwiftVirtualNetworkInner> getSwiftVirtualNetworkConnectionAsync(String resourceGroupName, String name, final ServiceCallback<SwiftVirtualNetworkInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Gets a Swift Virtual Network connection.
     * Gets a Swift Virtual Network connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SwiftVirtualNetworkInner object
     */
    public Observable<SwiftVirtualNetworkInner> getSwiftVirtualNetworkConnectionAsync(String resourceGroupName, String name) {
        return getSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<SwiftVirtualNetworkInner>, SwiftVirtualNetworkInner>() {
            @Override
            public SwiftVirtualNetworkInner call(ServiceResponse<SwiftVirtualNetworkInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a Swift Virtual Network connection.
     * Gets a Swift Virtual Network connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SwiftVirtualNetworkInner object
     */
    public Observable<ServiceResponse<SwiftVirtualNetworkInner>> getSwiftVirtualNetworkConnectionWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSwiftVirtualNetworkConnection(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SwiftVirtualNetworkInner>>>() {
                @Override
                public Observable<ServiceResponse<SwiftVirtualNetworkInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SwiftVirtualNetworkInner> clientResponse = getSwiftVirtualNetworkConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SwiftVirtualNetworkInner> getSwiftVirtualNetworkConnectionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SwiftVirtualNetworkInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SwiftVirtualNetworkInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SwiftVirtualNetworkInner object if successful.
     */
    public SwiftVirtualNetworkInner createOrUpdateSwiftVirtualNetworkConnection(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        return createOrUpdateSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name, connectionEnvelope).toBlocking().single().body();
    }

    /**
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SwiftVirtualNetworkInner> createOrUpdateSwiftVirtualNetworkConnectionAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope, final ServiceCallback<SwiftVirtualNetworkInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name, connectionEnvelope), serviceCallback);
    }

    /**
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SwiftVirtualNetworkInner object
     */
    public Observable<SwiftVirtualNetworkInner> createOrUpdateSwiftVirtualNetworkConnectionAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        return createOrUpdateSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name, connectionEnvelope).map(new Func1<ServiceResponse<SwiftVirtualNetworkInner>, SwiftVirtualNetworkInner>() {
            @Override
            public SwiftVirtualNetworkInner call(ServiceResponse<SwiftVirtualNetworkInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SwiftVirtualNetworkInner object
     */
    public Observable<ServiceResponse<SwiftVirtualNetworkInner>> createOrUpdateSwiftVirtualNetworkConnectionWithServiceResponseAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (connectionEnvelope == null) {
            throw new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(connectionEnvelope);
        return service.createOrUpdateSwiftVirtualNetworkConnection(resourceGroupName, name, this.client.subscriptionId(), connectionEnvelope, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SwiftVirtualNetworkInner>>>() {
                @Override
                public Observable<ServiceResponse<SwiftVirtualNetworkInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SwiftVirtualNetworkInner> clientResponse = createOrUpdateSwiftVirtualNetworkConnectionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SwiftVirtualNetworkInner> createOrUpdateSwiftVirtualNetworkConnectionDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<SwiftVirtualNetworkInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<SwiftVirtualNetworkInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes a Swift Virtual Network connection from an app (or deployment slot).
     * Deletes a Swift Virtual Network connection from an app (or deployment slot).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void deleteSwiftVirtualNetwork(String resourceGroupName, String name) {
        deleteSwiftVirtualNetworkWithServiceResponseAsync(resourceGroupName, name).toBlocking().single().body();
    }

    /**
     * Deletes a Swift Virtual Network connection from an app (or deployment slot).
     * Deletes a Swift Virtual Network connection from an app (or deployment slot).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteSwiftVirtualNetworkAsync(String resourceGroupName, String name, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteSwiftVirtualNetworkWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    /**
     * Deletes a Swift Virtual Network connection from an app (or deployment slot).
     * Deletes a Swift Virtual Network connection from an app (or deployment slot).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteSwiftVirtualNetworkAsync(String resourceGroupName, String name) {
        return deleteSwiftVirtualNetworkWithServiceResponseAsync(resourceGroupName, name).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a Swift Virtual Network connection from an app (or deployment slot).
     * Deletes a Swift Virtual Network connection from an app (or deployment slot).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteSwiftVirtualNetworkWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.deleteSwiftVirtualNetwork(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteSwiftVirtualNetworkDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteSwiftVirtualNetworkDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(404, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SwiftVirtualNetworkInner object if successful.
     */
    public SwiftVirtualNetworkInner updateSwiftVirtualNetworkConnection(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        return updateSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name, connectionEnvelope).toBlocking().single().body();
    }

    /**
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SwiftVirtualNetworkInner> updateSwiftVirtualNetworkConnectionAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope, final ServiceCallback<SwiftVirtualNetworkInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name, connectionEnvelope), serviceCallback);
    }

    /**
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SwiftVirtualNetworkInner object
     */
    public Observable<SwiftVirtualNetworkInner> updateSwiftVirtualNetworkConnectionAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        return updateSwiftVirtualNetworkConnectionWithServiceResponseAsync(resourceGroupName, name, connectionEnvelope).map(new Func1<ServiceResponse<SwiftVirtualNetworkInner>, SwiftVirtualNetworkInner>() {
            @Override
            public SwiftVirtualNetworkInner call(ServiceResponse<SwiftVirtualNetworkInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not
     in use by another App Service Plan other than the one this App is in.
     * Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is tru