/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.appservice.CheckNameResourceTypes;
import com.microsoft.azure.management.appservice.CsmMoveResourceEnvelope;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.ResourceNameAvailabilityRequest;
import com.microsoft.azure.management.appservice.SkuName;
import com.microsoft.azure.management.appservice.ValidateContainerSettingsRequest;
import com.microsoft.azure.management.appservice.ValidateRequest;
import com.microsoft.azure.management.appservice.VnetParameters;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * Initializes a new instance of the WebSiteManagementClientImpl class.
 */
public class WebSiteManagementClientImpl extends AzureServiceClient {
    /** The Retrofit service to perform REST calls. */
    private WebSiteManagementClientService service;
    /** the {@link AzureClient} used for long running operations. */
    private AzureClient azureClient;

    /**
     * Gets the {@link AzureClient} used for long running operations.
     * @return the azure client;
     */
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    /** Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000). */
    private String subscriptionId;

    /**
     * Gets Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Sets Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
     *
     * @param subscriptionId the subscriptionId value.
     * @return the service client itself
     */
    public WebSiteManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /** API Version. */
    private String apiVersion;

    /**
     * Gets API Version.
     *
     * @return the apiVersion value.
     */
    public String apiVersion() {
        return this.apiVersion;
    }

    /** The preferred language for the response. */
    private String acceptLanguage;

    /**
     * Gets The preferred language for the response.
     *
     * @return the acceptLanguage value.
     */
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    /**
     * Sets The preferred language for the response.
     *
     * @param acceptLanguage the acceptLanguage value.
     * @return the service client itself
     */
    public WebSiteManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    /** The retry timeout in seconds for Long Running Operations. Default value is 30. */
    private int longRunningOperationRetryTimeout;

    /**
     * Gets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @return the longRunningOperationRetryTimeout value.
     */
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    /**
     * Sets The retry timeout in seconds for Long Running Operations. Default value is 30.
     *
     * @param longRunningOperationRetryTimeout the longRunningOperationRetryTimeout value.
     * @return the service client itself
     */
    public WebSiteManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    /** Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true. */
    private boolean generateClientRequestId;

    /**
     * Gets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @return the generateClientRequestId value.
     */
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    /**
     * Sets Whether a unique x-ms-client-request-id should be generated. When set to true a unique x-ms-client-request-id value is generated and included in each request. Default is true.
     *
     * @param generateClientRequestId the generateClientRequestId value.
     * @return the service client itself
     */
    public WebSiteManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    /**
     * The AppServiceCertificateOrdersInner object to access its operations.
     */
    private AppServiceCertificateOrdersInner appServiceCertificateOrders;

    /**
     * Gets the AppServiceCertificateOrdersInner object to access its operations.
     * @return the AppServiceCertificateOrdersInner object.
     */
    public AppServiceCertificateOrdersInner appServiceCertificateOrders() {
        return this.appServiceCertificateOrders;
    }

    /**
     * The CertificateRegistrationProvidersInner object to access its operations.
     */
    private CertificateRegistrationProvidersInner certificateRegistrationProviders;

    /**
     * Gets the CertificateRegistrationProvidersInner object to access its operations.
     * @return the CertificateRegistrationProvidersInner object.
     */
    public CertificateRegistrationProvidersInner certificateRegistrationProviders() {
        return this.certificateRegistrationProviders;
    }

    /**
     * The DomainsInner object to access its operations.
     */
    private DomainsInner domains;

    /**
     * Gets the DomainsInner object to access its operations.
     * @return the DomainsInner object.
     */
    public DomainsInner domains() {
        return this.domains;
    }

    /**
     * The TopLevelDomainsInner object to access its operations.
     */
    private TopLevelDomainsInner topLevelDomains;

    /**
     * Gets the TopLevelDomainsInner object to access its operations.
     * @return the TopLevelDomainsInner object.
     */
    public TopLevelDomainsInner topLevelDomains() {
        return this.topLevelDomains;
    }

    /**
     * The DomainRegistrationProvidersInner object to access its operations.
     */
    private DomainRegistrationProvidersInner domainRegistrationProviders;

    /**
     * Gets the DomainRegistrationProvidersInner object to access its operations.
     * @return the DomainRegistrationProvidersInner object.
     */
    public DomainRegistrationProvidersInner domainRegistrationProviders() {
        return this.domainRegistrationProviders;
    }

    /**
     * The CertificatesInner object to access its operations.
     */
    private CertificatesInner certificates;

    /**
     * Gets the CertificatesInner object to access its operations.
     * @return the CertificatesInner object.
     */
    public CertificatesInner certificates() {
        return this.certificates;
    }

    /**
     * The DeletedWebAppsInner object to access its operations.
     */
    private DeletedWebAppsInner deletedWebApps;

    /**
     * Gets the DeletedWebAppsInner object to access its operations.
     * @return the DeletedWebAppsInner object.
     */
    public DeletedWebAppsInner deletedWebApps() {
        return this.deletedWebApps;
    }

    /**
     * The DiagnosticsInner object to access its operations.
     */
    private DiagnosticsInner diagnostics;

    /**
     * Gets the DiagnosticsInner object to access its operations.
     * @return the DiagnosticsInner object.
     */
    public DiagnosticsInner diagnostics() {
        return this.diagnostics;
    }

    /**
     * The ProvidersInner object to access its operations.
     */
    private ProvidersInner providers;

    /**
     * Gets the ProvidersInner object to access its operations.
     * @return the ProvidersInner object.
     */
    public ProvidersInner providers() {
        return this.providers;
    }

    /**
     * The RecommendationsInner object to access its operations.
     */
    private RecommendationsInner recommendations;

    /**
     * Gets the RecommendationsInner object to access its operations.
     * @return the RecommendationsInner object.
     */
    public RecommendationsInner recommendations() {
        return this.recommendations;
    }

    /**
     * The WebAppsInner object to access its operations.
     */
    private WebAppsInner webApps;

    /**
     * Gets the WebAppsInner object to access its operations.
     * @return the WebAppsInner object.
     */
    public WebAppsInner webApps() {
        return this.webApps;
    }

    /**
     * The AppServiceEnvironmentsInner object to access its operations.
     */
    private AppServiceEnvironmentsInner appServiceEnvironments;

    /**
     * Gets the AppServiceEnvironmentsInner object to access its operations.
     * @return the AppServiceEnvironmentsInner object.
     */
    public AppServiceEnvironmentsInner appServiceEnvironments() {
        return this.appServiceEnvironments;
    }

    /**
     * The AppServicePlansInner object to access its operations.
     */
    private AppServicePlansInner appServicePlans;

    /**
     * Gets the AppServicePlansInner object to access its operations.
     * @return the AppServicePlansInner object.
     */
    public AppServicePlansInner appServicePlans() {
        return this.appServicePlans;
    }

    /**
     * The ResourceHealthMetadatasInner object to access its operations.
     */
    private ResourceHealthMetadatasInner resourceHealthMetadatas;

    /**
     * Gets the ResourceHealthMetadatasInner object to access its operations.
     * @return the ResourceHealthMetadatasInner object.
     */
    public ResourceHealthMetadatasInner resourceHealthMetadatas() {
        return this.resourceHealthMetadatas;
    }

    /**
     * Initializes an instance of WebSiteManagementClient client.
     *
     * @param credentials the management credentials for Azure
     */
    public WebSiteManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    /**
     * Initializes an instance of WebSiteManagementClient client.
     *
     * @param baseUrl the base URL of the host
     * @param credentials the management credentials for Azure
     */
    public WebSiteManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        initialize();
    }

    /**
     * Initializes an instance of WebSiteManagementClient client.
     *
     * @param restClient the REST client to connect to Azure.
     */
    public WebSiteManagementClientImpl(RestClient restClient) {
        super(restClient);
        initialize();
    }

    protected void initialize() {
        this.apiVersion = "2018-02-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.appServiceCertificateOrders = new AppServiceCertificateOrdersInner(restClient().retrofit(), this);
        this.certificateRegistrationProviders = new CertificateRegistrationProvidersInner(restClient().retrofit(), this);
        this.domains = new DomainsInner(restClient().retrofit(), this);
        this.topLevelDomains = new TopLevelDomainsInner(restClient().retrofit(), this);
        this.domainRegistrationProviders = new DomainRegistrationProvidersInner(restClient().retrofit(), this);
        this.certificates = new CertificatesInner(restClient().retrofit(), this);
        this.deletedWebApps = new DeletedWebAppsInner(restClient().retrofit(), this);
        this.diagnostics = new DiagnosticsInner(restClient().retrofit(), this);
        this.providers = new ProvidersInner(restClient().retrofit(), this);
        this.recommendations = new RecommendationsInner(restClient().retrofit(), this);
        this.webApps = new WebAppsInner(restClient().retrofit(), this);
        this.appServiceEnvironments = new AppServiceEnvironmentsInner(restClient().retrofit(), this);
        this.appServicePlans = new AppServicePlansInner(restClient().retrofit(), this);
        this.resourceHealthMetadatas = new ResourceHealthMetadatasInner(restClient().retrofit(), this);
        this.azureClient = new AzureClient(this);
        initializeService();
    }

    /**
     * Gets the User-Agent header for the client.
     *
     * @return the user agent string.
     */
    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "WebSiteManagementClient", "2018-02-01");
    }

    private void initializeService() {
        service = restClient().retrofit().create(WebSiteManagementClientService.class);
    }

    /**
     * The interface defining all the services for WebSiteManagementClient to be
     * used by Retrofit to perform actually REST calls.
     */
    interface WebSiteManagementClientService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient getPublishingUser" })
        @GET("providers/Microsoft.Web/publishingUsers/web")
        Observable<Response<ResponseBody>> getPublishingUser(@Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient updatePublishingUser" })
        @PUT("providers/Microsoft.Web/publishingUsers/web")
        Observable<Response<ResponseBody>> updatePublishingUser(@Body UserInner userDetails, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSourceControls" })
        @GET("providers/Microsoft.Web/sourcecontrols")
        Observable<Response<ResponseBody>> listSourceControls(@Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient getSourceControl" })
        @GET("providers/Microsoft.Web/sourcecontrols/{sourceControlType}")
        Observable<Response<ResponseBody>> getSourceControl(@Path("sourceControlType") String sourceControlType, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient updateSourceControl" })
        @PUT("providers/Microsoft.Web/sourcecontrols/{sourceControlType}")
        Observable<Response<ResponseBody>> updateSourceControl(@Path("sourceControlType") String sourceControlType, @Body SourceControlInner requestMessage, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listBillingMeters" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/billingMeters")
        Observable<Response<ResponseBody>> listBillingMeters(@Path("subscriptionId") String subscriptionId, @Query("billingLocation") String billingLocation, @Query("osType") String osType, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient checkNameAvailability" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Web/checknameavailability")
        Observable<Response<ResponseBody>> checkNameAvailability(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body ResourceNameAvailabilityRequest request, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient getSubscriptionDeploymentLocations" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/deploymentLocations")
        Observable<Response<ResponseBody>> getSubscriptionDeploymentLocations(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listGeoRegions" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/geoRegions")
        Observable<Response<ResponseBody>> listGeoRegions(@Path("subscriptionId") String subscriptionId, @Query("sku") SkuName sku, @Query("linuxWorkersEnabled") Boolean linuxWorkersEnabled, @Query("xenonWorkersEnabled") Boolean xenonWorkersEnabled, @Query("linuxDynamicWorkersEnabled") Boolean linuxDynamicWorkersEnabled, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSiteIdentifiersAssignedToHostName" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Web/listSitesAssignedToHostName")
        Observable<Response<ResponseBody>> listSiteIdentifiersAssignedToHostName(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body NameIdentifierInner nameIdentifier, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listPremierAddOnOffers" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/premieraddonoffers")
        Observable<Response<ResponseBody>> listPremierAddOnOffers(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSkus" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Web/skus")
        Observable<Response<ResponseBody>> listSkus(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient verifyHostingEnvironmentVnet" })
        @POST("subscriptions/{subscriptionId}/providers/Microsoft.Web/verifyHostingEnvironmentVnet")
        Observable<Response<ResponseBody>> verifyHostingEnvironmentVnet(@Path("subscriptionId") String subscriptionId, @Body VnetParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient move" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/moveResources")
        Observable<Response<ResponseBody>> move(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Body CsmMoveResourceEnvelope moveResourceEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient validate" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validate")
        Observable<Response<ResponseBody>> validate(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Body ValidateRequest validateRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient validateContainerSettings" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validateContainerSettings")
        Observable<Response<ResponseBody>> validateContainerSettings(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Body ValidateContainerSettingsRequest validateContainerSettingsRequest, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient validateMove" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/validateMoveResources")
        Observable<Response<ResponseBody>> validateMove(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Body CsmMoveResourceEnvelope moveResourceEnvelope, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSourceControlsNext" })
        @GET
        Observable<Response<ResponseBody>> listSourceControlsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listBillingMetersNext" })
        @GET
        Observable<Response<ResponseBody>> listBillingMetersNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listGeoRegionsNext" })
        @GET
        Observable<Response<ResponseBody>> listGeoRegionsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSiteIdentifiersAssignedToHostNameNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteIdentifiersAssignedToHostNameNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listPremierAddOnOffersNext" })
        @GET
        Observable<Response<ResponseBody>> listPremierAddOnOffersNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets publishing user.
     * Gets publishing user.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the UserInner object if successful.
     */
    public UserInner getPublishingUser() {
        return getPublishingUserWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * Gets publishing user.
     * Gets publishing user.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<UserInner> getPublishingUserAsync(final ServiceCallback<UserInner> serviceCallback) {
        return ServiceFuture.fromResponse(getPublishingUserWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Gets publishing user.
     * Gets publishing user.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserInner object
     */
    public Observable<UserInner> getPublishingUserAsync() {
        return getPublishingUserWithServiceResponseAsync().map(new Func1<ServiceResponse<UserInner>, UserInner>() {
            @Override
            public UserInner call(ServiceResponse<UserInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets publishing user.
     * Gets publishing user.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserInner object
     */
    public Observable<ServiceResponse<UserInner>> getPublishingUserWithServiceResponseAsync() {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return service.getPublishingUser(this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>() {
                @Override
                public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<UserInner> clientResponse = getPublishingUserDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<UserInner> getPublishingUserDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<UserInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<UserInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates publishing user.
     * Updates publishing user.
     *
     * @param userDetails Details of publishing user
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the UserInner object if successful.
     */
    public UserInner updatePublishingUser(UserInner userDetails) {
        return updatePublishingUserWithServiceResponseAsync(userDetails).toBlocking().single().body();
    }

    /**
     * Updates publishing user.
     * Updates publishing user.
     *
     * @param userDetails Details of publishing user
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<UserInner> updatePublishingUserAsync(UserInner userDetails, final ServiceCallback<UserInner> serviceCallback) {
        return ServiceFuture.fromResponse(updatePublishingUserWithServiceResponseAsync(userDetails), serviceCallback);
    }

    /**
     * Updates publishing user.
     * Updates publishing user.
     *
     * @param userDetails Details of publishing user
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserInner object
     */
    public Observable<UserInner> updatePublishingUserAsync(UserInner userDetails) {
        return updatePublishingUserWithServiceResponseAsync(userDetails).map(new Func1<ServiceResponse<UserInner>, UserInner>() {
            @Override
            public UserInner call(ServiceResponse<UserInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates publishing user.
     * Updates publishing user.
     *
     * @param userDetails Details of publishing user
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the UserInner object
     */
    public Observable<ServiceResponse<UserInner>> updatePublishingUserWithServiceResponseAsync(UserInner userDetails) {
        if (userDetails == null) {
            throw new IllegalArgumentException("Parameter userDetails is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(userDetails);
        return service.updatePublishingUser(userDetails, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>() {
                @Override
                public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<UserInner> clientResponse = updatePublishingUserDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<UserInner> updatePublishingUserDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<UserInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<UserInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SourceControlInner&gt; object if successful.
     */
    public PagedList<SourceControlInner> listSourceControls() {
        ServiceResponse<Page<SourceControlInner>> response = listSourceControlsSinglePageAsync().toBlocking().single();
        return new PagedList<SourceControlInner>(response.body()) {
            @Override
            public Page<SourceControlInner> nextPage(String nextPageLink) {
                return listSourceControlsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SourceControlInner>> listSourceControlsAsync(final ListOperationCallback<SourceControlInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSourceControlsSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<SourceControlInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SourceControlInner>>> call(String nextPageLink) {
                    return listSourceControlsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SourceControlInner&gt; object
     */
    public Observable<Page<SourceControlInner>> listSourceControlsAsync() {
        return listSourceControlsWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<SourceControlInner>>, Page<SourceControlInner>>() {
                @Override
                public Page<SourceControlInner> call(ServiceResponse<Page<SourceControlInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SourceControlInner&gt; object
     */
    public Observable<ServiceResponse<Page<SourceControlInner>>> listSourceControlsWithServiceResponseAsync() {
        return listSourceControlsSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<SourceControlInner>>, Observable<ServiceResponse<Page<SourceControlInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SourceControlInner>>> call(ServiceResponse<Page<SourceControlInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSourceControlsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SourceControlInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SourceControlInner>>> listSourceControlsSinglePageAsync() {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return service.listSourceControls(this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SourceControlInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SourceControlInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SourceControlInner>> result = listSourceControlsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SourceControlInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SourceControlInner>> listSourceControlsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<SourceControlInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SourceControlInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets source control token.
     * Gets source control token.
     *
     * @param sourceControlType Type of source control
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SourceControlInner object if successful.
     */
    public SourceControlInner getSourceControl(String sourceControlType) {
        return getSourceControlWithServiceResponseAsync(sourceControlType).toBlocking().single().body();
    }

    /**
     * Gets source control token.
     * Gets source control token.
     *
     * @param sourceControlType Type of source control
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SourceControlInner> getSourceControlAsync(String sourceControlType, final ServiceCallback<SourceControlInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSourceControlWithServiceResponseAsync(sourceControlType), serviceCallback);
    }

    /**
     * Gets source control token.
     * Gets source control token.
     *
     * @param sourceControlType Type of source control
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SourceControlInner object
     */
    public Observable<SourceControlInner> getSourceControlAsync(String sourceControlType) {
        return getSourceControlWithServiceResponseAsync(sourceControlType).map(new Func1<ServiceResponse<SourceControlInner>, SourceControlInner>() {
            @Override
            public SourceControlInner call(ServiceResponse<SourceControlInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets source control token.
     * Gets source control token.
     *
     * @param sourceControlType Type of source control
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SourceControlInner object
     */
    public Observable<ServiceResponse<SourceControlInner>> getSourceControlWithServiceResponseAsync(String sourceControlType) {
        if (sourceControlType == null) {
            throw new IllegalArgumentException("Parameter sourceControlType is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return service.getSourceControl(sourceControlType, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SourceControlInner>>>() {
                @Override
                public Observable<ServiceResponse<SourceControlInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SourceControlInner> clientResponse = getSourceControlDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SourceControlInner> getSourceControlDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<SourceControlInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<SourceControlInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Updates source control token.
     * Updates source control token.
     *
     * @param sourceControlType Type of source control
     * @param requestMessage Source control token information
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SourceControlInner object if successful.
     */
    public SourceControlInner updateSourceControl(String sourceControlType, SourceControlInner requestMessage) {
        return updateSourceControlWithServiceResponseAsync(sourceControlType, requestMessage).toBlocking().single().body();
    }

    /**
     * Updates source control token.
     * Updates source control token.
     *
     * @param sourceControlType Type of source control
     * @param requestMessage Source control token information
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SourceControlInner> updateSourceControlAsync(String sourceControlType, SourceControlInner requestMessage, final ServiceCallback<SourceControlInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateSourceControlWithServiceResponseAsync(sourceControlType, requestMessage), serviceCallback);
    }

    /**
     * Updates source control token.
     * Updates source control token.
     *
     * @param sourceControlType Type of source control
     * @param requestMessage Source control token information
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SourceControlInner object
     */
    public Observable<SourceControlInner> updateSourceControlAsync(String sourceControlType, SourceControlInner requestMessage) {
        return updateSourceControlWithServiceResponseAsync(sourceControlType, requestMessage).map(new Func1<ServiceResponse<SourceControlInner>, SourceControlInner>() {
            @Override
            public SourceControlInner call(ServiceResponse<SourceControlInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates source control token.
     * Updates source control token.
     *
     * @param sourceControlType Type of source control
     * @param requestMessage Source control token information
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SourceControlInner object
     */
    public Observable<ServiceResponse<SourceControlInner>> updateSourceControlWithServiceResponseAsync(String sourceControlType, SourceControlInner requestMessage) {
        if (sourceControlType == null) {
            throw new IllegalArgumentException("Parameter sourceControlType is required and cannot be null.");
        }
        if (requestMessage == null) {
            throw new IllegalArgumentException("Parameter requestMessage is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(requestMessage);
        return service.updateSourceControl(sourceControlType, requestMessage, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SourceControlInner>>>() {
                @Override
                public Observable<ServiceResponse<SourceControlInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SourceControlInner> clientResponse = updateSourceControlDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SourceControlInner> updateSourceControlDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<SourceControlInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<SourceControlInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BillingMeterInner&gt; object if successful.
     */
    public PagedList<BillingMeterInner> listBillingMeters() {
        ServiceResponse<Page<BillingMeterInner>> response = listBillingMetersSinglePageAsync().toBlocking().single();
        return new PagedList<BillingMeterInner>(response.body()) {
            @Override
            public Page<BillingMeterInner> nextPage(String nextPageLink) {
                return listBillingMetersNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BillingMeterInner>> listBillingMetersAsync(final ListOperationCallback<BillingMeterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBillingMetersSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(String nextPageLink) {
                    return listBillingMetersNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BillingMeterInner&gt; object
     */
    public Observable<Page<BillingMeterInner>> listBillingMetersAsync() {
        return listBillingMetersWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<BillingMeterInner>>, Page<BillingMeterInner>>() {
                @Override
                public Page<BillingMeterInner> call(ServiceResponse<Page<BillingMeterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BillingMeterInner&gt; object
     */
    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersWithServiceResponseAsync() {
        return listBillingMetersSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<BillingMeterInner>>, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(ServiceResponse<Page<BillingMeterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBillingMetersNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BillingMeterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        final String billingLocation = null;
        final String osType = null;
        return service.listBillingMeters(this.subscriptionId(), billingLocation, osType, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BillingMeterInner>> result = listBillingMetersDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BillingMeterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param billingLocation Azure Location of billable resource
     * @param osType App Service OS type meters used for
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BillingMeterInner&gt; object if successful.
     */
    public PagedList<BillingMeterInner> listBillingMeters(final String billingLocation, final String osType) {
        ServiceResponse<Page<BillingMeterInner>> response = listBillingMetersSinglePageAsync(billingLocation, osType).toBlocking().single();
        return new PagedList<BillingMeterInner>(response.body()) {
            @Override
            public Page<BillingMeterInner> nextPage(String nextPageLink) {
                return listBillingMetersNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param billingLocation Azure Location of billable resource
     * @param osType App Service OS type meters used for
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BillingMeterInner>> listBillingMetersAsync(final String billingLocation, final String osType, final ListOperationCallback<BillingMeterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBillingMetersSinglePageAsync(billingLocation, osType),
            new Func1<String, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(String nextPageLink) {
                    return listBillingMetersNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param billingLocation Azure Location of billable resource
     * @param osType App Service OS type meters used for
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BillingMeterInner&gt; object
     */
    public Observable<Page<BillingMeterInner>> listBillingMetersAsync(final String billingLocation, final String osType) {
        return listBillingMetersWithServiceResponseAsync(billingLocation, osType)
            .map(new Func1<ServiceResponse<Page<BillingMeterInner>>, Page<BillingMeterInner>>() {
                @Override
                public Page<BillingMeterInner> call(ServiceResponse<Page<BillingMeterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param billingLocation Azure Location of billable resource
     * @param osType App Service OS type meters used for
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BillingMeterInner&gt; object
     */
    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersWithServiceResponseAsync(final String billingLocation, final String osType) {
        return listBillingMetersSinglePageAsync(billingLocation, osType)
            .concatMap(new Func1<ServiceResponse<Page<BillingMeterInner>>, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(ServiceResponse<Page<BillingMeterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBillingMetersNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
    ServiceResponse<PageImpl<BillingMeterInner>> * @param billingLocation Azure Location of billable resource
    ServiceResponse<PageImpl<BillingMeterInner>> * @param osType App Service OS type meters used for
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BillingMeterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersSinglePageAsync(final String billingLocation, final String osType) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return service.listBillingMeters(this.subscriptionId(), billingLocation, osType, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BillingMeterInner>> result = listBillingMetersDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BillingMeterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BillingMeterInner>> listBillingMetersDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BillingMeterInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BillingMeterInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Check if a resource name is available.
     * Check if a resource name is available.
     *
     * @param name Resource name to verify.
     * @param type Resource type used for verification. Possible values include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser', 'Microsoft.Web/sites', 'Microsoft.Web/sites/slots', 'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceNameAvailabilityInner object if successful.
     */
    public ResourceNameAvailabilityInner checkNameAvailability(String name, CheckNameResourceTypes type) {
        return checkNameAvailabilityWithServiceResponseAsync(name, type).toBlocking().single().body();
    }

    /**
     * Check if a resource name is available.
     * Check if a resource name is available.
     *
     * @param name Resource name to verify.
     * @param type Resource type used for verification. Possible values include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser', 'Microsoft.Web/sites', 'Microsoft.Web/sites/slots', 'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceNameAvailabilityInner> checkNameAvailabilityAsync(String name, CheckNameResourceTypes type, final ServiceCallback<ResourceNameAvailabilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkNameAvailabilityWithServiceResponseAsync(name, type), serviceCallback);
    }

    /**
     * Check if a resource name is available.
     * Check if a resource name is available.
     *
     * @param name Resource name to verify.
     * @param type Resource type used for verification. Possible values include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser', 'Microsoft.Web/sites', 'Microsoft.Web/sites/slots', 'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceNameAvailabilityInner object
     */
    public Observable<ResourceNameAvailabilityInner> checkNameAvailabilityAsync(String name, CheckNameResourceTypes type) {
        return checkNameAvailabilityWithServiceResponseAsync(name, type).map(new Func1<ServiceResponse<ResourceNameAvailabilityInner>, ResourceNameAvailabilityInner>() {
            @Override
            public ResourceNameAvailabilityInner call(ServiceResponse<ResourceNameAvailabilityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Check if a resource name is available.
     * Check if a resource name is available.
     *
     * @param name Resource name to verify.
     * @param type Resource type used for verification. Possible values include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser', 'Microsoft.Web/sites', 'Microsoft.Web/sites/slots', 'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceNameAvailabilityInner object
     */
    public Observable<ServiceResponse<ResourceNameAvailabilityInner>> checkNameAvailabilityWithServiceResponseAsync(String name, CheckNameResourceTypes type) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        final Boolean isFqdn = null;
        ResourceNameAvailabilityRequest request = new ResourceNameAvailabilityRequest();
        request.withName(name);
        request.withType(type);
        request.withIsFqdn(null);
        return service.checkNameAvailability(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), request, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceNameAvailabilityInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceNameAvailabilityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceNameAvailabilityInner> clientResponse = checkNameAvailabilityDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Check if a resource name is available.
     * Check if a resource name is available.
     *
     * @param name Resource name to verify.
     * @param type Resource type used for verification. Possible values include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser', 'Microsoft.Web/sites', 'Microsoft.Web/sites/slots', 'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
     * @param isFqdn Is fully qualified domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ResourceNameAvailabilityInner object if successful.
     */
    public ResourceNameAvailabilityInner checkNameAvailability(String name, CheckNameResourceTypes type, Boolean isFqdn) {
        return checkNameAvailabilityWithServiceResponseAsync(name, type, isFqdn).toBlocking().single().body();
    }

    /**
     * Check if a resource name is available.
     * Check if a resource name is available.
     *
     * @param name Resource name to verify.
     * @param type Resource type used for verification. Possible values include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser', 'Microsoft.Web/sites', 'Microsoft.Web/sites/slots', 'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
     * @param isFqdn Is fully qualified domain name.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ResourceNameAvailabilityInner> checkNameAvailabilityAsync(String name, CheckNameResourceTypes type, Boolean isFqdn, final ServiceCallback<ResourceNameAvailabilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(checkNameAvailabilityWithServiceResponseAsync(name, type, isFqdn), serviceCallback);
    }

    /**
     * Check if a resource name is available.
     * Check if a resource name is available.
     *
     * @param name Resource name to verify.
     * @param type Resource type used for verification. Possible values include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser', 'Microsoft.Web/sites', 'Microsoft.Web/sites/slots', 'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
     * @param isFqdn Is fully qualified domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceNameAvailabilityInner object
     */
    public Observable<ResourceNameAvailabilityInner> checkNameAvailabilityAsync(String name, CheckNameResourceTypes type, Boolean isFqdn) {
        return checkNameAvailabilityWithServiceResponseAsync(name, type, isFqdn).map(new Func1<ServiceResponse<ResourceNameAvailabilityInner>, ResourceNameAvailabilityInner>() {
            @Override
            public ResourceNameAvailabilityInner call(ServiceResponse<ResourceNameAvailabilityInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Check if a resource name is available.
     * Check if a resource name is available.
     *
     * @param name Resource name to verify.
     * @param type Resource type used for verification. Possible values include: 'Site', 'Slot', 'HostingEnvironment', 'PublishingUser', 'Microsoft.Web/sites', 'Microsoft.Web/sites/slots', 'Microsoft.Web/hostingEnvironments', 'Microsoft.Web/publishingUsers'
     * @param isFqdn Is fully qualified domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ResourceNameAvailabilityInner object
     */
    public Observable<ServiceResponse<ResourceNameAvailabilityInner>> checkNameAvailabilityWithServiceResponseAsync(String name, CheckNameResourceTypes type, Boolean isFqdn) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        ResourceNameAvailabilityRequest request = new ResourceNameAvailabilityRequest();
        request.withName(name);
        request.withType(type);
        request.withIsFqdn(isFqdn);
        return service.checkNameAvailability(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), request, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceNameAvailabilityInner>>>() {
                @Override
                public Observable<ServiceResponse<ResourceNameAvailabilityInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ResourceNameAvailabilityInner> clientResponse = checkNameAvailabilityDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ResourceNameAvailabilityInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<ResourceNameAvailabilityInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<ResourceNameAvailabilityInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets list of available geo regions plus ministamps.
     * Gets list of available geo regions plus ministamps.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DeploymentLocationsInner object if successful.
     */
    public DeploymentLocationsInner getSubscriptionDeploymentLocations() {
        return getSubscriptionDeploymentLocationsWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * Gets list of available geo regions plus ministamps.
     * Gets list of available geo regions plus ministamps.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DeploymentLocationsInner> getSubscriptionDeploymentLocationsAsync(final ServiceCallback<DeploymentLocationsInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSubscriptionDeploymentLocationsWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * Gets list of available geo regions plus ministamps.
     * Gets list of available geo regions plus ministamps.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentLocationsInner object
     */
    public Observable<DeploymentLocationsInner> getSubscriptionDeploymentLocationsAsync() {
        return getSubscriptionDeploymentLocationsWithServiceResponseAsync().map(new Func1<ServiceResponse<DeploymentLocationsInner>, DeploymentLocationsInner>() {
            @Override
            public DeploymentLocationsInner call(ServiceResponse<DeploymentLocationsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets list of available geo regions plus ministamps.
     * Gets list of available geo regions plus ministamps.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DeploymentLocationsInner object
     */
    public Observable<ServiceResponse<DeploymentLocationsInner>> getSubscriptionDeploymentLocationsWithServiceResponseAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return service.getSubscriptionDeploymentLocations(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentLocationsInner>>>() {
                @Override
                public Observable<ServiceResponse<DeploymentLocationsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DeploymentLocationsInner> clientResponse = getSubscriptionDeploymentLocationsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DeploymentLocationsInner> getSubscriptionDeploymentLocationsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<DeploymentLocationsInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<DeploymentLocationsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GeoRegionInner&gt; object if successful.
     */
    public PagedList<GeoRegionInner> listGeoRegions() {
        ServiceResponse<Page<GeoRegionInner>> response = listGeoRegionsSinglePageAsync().toBlocking().single();
        return new PagedList<GeoRegionInner>(response.body()) {
            @Override
            public Page<GeoRegionInner> nextPage(String nextPageLink) {
                return listGeoRegionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GeoRegionInner>> listGeoRegionsAsync(final ListOperationCallback<GeoRegionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listGeoRegionsSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(String nextPageLink) {
                    return listGeoRegionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GeoRegionInner&gt; object
     */
    public Observable<Page<GeoRegionInner>> listGeoRegionsAsync() {
        return listGeoRegionsWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<GeoRegionInner>>, Page<GeoRegionInner>>() {
                @Override
                public Page<GeoRegionInner> call(ServiceResponse<Page<GeoRegionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GeoRegionInner&gt; object
     */
    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsWithServiceResponseAsync() {
        return listGeoRegionsSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<GeoRegionInner>>, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(ServiceResponse<Page<GeoRegionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listGeoRegionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GeoRegionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        final SkuName sku = null;
        final Boolean linuxWorkersEnabled = null;
        final Boolean xenonWorkersEnabled = null;
        final Boolean linuxDynamicWorkersEnabled = null;
        return service.listGeoRegions(this.subscriptionId(), sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<GeoRegionInner>> result = listGeoRegionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GeoRegionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param sku Name of SKU used to filter the regions. Possible values include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic', 'Isolated', 'PremiumV2', 'ElasticPremium', 'ElasticIsolated'
     * @param linuxWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux workers.
     * @param xenonWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Xenon workers.
     * @param linuxDynamicWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux Consumption Workers.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GeoRegionInner&gt; object if successful.
     */
    public PagedList<GeoRegionInner> listGeoRegions(final SkuName sku, final Boolean linuxWorkersEnabled, final Boolean xenonWorkersEnabled, final Boolean linuxDynamicWorkersEnabled) {
        ServiceResponse<Page<GeoRegionInner>> response = listGeoRegionsSinglePageAsync(sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled).toBlocking().single();
        return new PagedList<GeoRegionInner>(response.body()) {
            @Override
            public Page<GeoRegionInner> nextPage(String nextPageLink) {
                return listGeoRegionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param sku Name of SKU used to filter the regions. Possible values include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic', 'Isolated', 'PremiumV2', 'ElasticPremium', 'ElasticIsolated'
     * @param linuxWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux workers.
     * @param xenonWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Xenon workers.
     * @param linuxDynamicWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux Consumption Workers.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GeoRegionInner>> listGeoRegionsAsync(final SkuName sku, final Boolean linuxWorkersEnabled, final Boolean xenonWorkersEnabled, final Boolean linuxDynamicWorkersEnabled, final ListOperationCallback<GeoRegionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listGeoRegionsSinglePageAsync(sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled),
            new Func1<String, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(String nextPageLink) {
                    return listGeoRegionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param sku Name of SKU used to filter the regions. Possible values include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic', 'Isolated', 'PremiumV2', 'ElasticPremium', 'ElasticIsolated'
     * @param linuxWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux workers.
     * @param xenonWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Xenon workers.
     * @param linuxDynamicWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux Consumption Workers.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GeoRegionInner&gt; object
     */
    public Observable<Page<GeoRegionInner>> listGeoRegionsAsync(final SkuName sku, final Boolean linuxWorkersEnabled, final Boolean xenonWorkersEnabled, final Boolean linuxDynamicWorkersEnabled) {
        return listGeoRegionsWithServiceResponseAsync(sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled)
            .map(new Func1<ServiceResponse<Page<GeoRegionInner>>, Page<GeoRegionInner>>() {
                @Override
                public Page<GeoRegionInner> call(ServiceResponse<Page<GeoRegionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param sku Name of SKU used to filter the regions. Possible values include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic', 'Isolated', 'PremiumV2', 'ElasticPremium', 'ElasticIsolated'
     * @param linuxWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux workers.
     * @param xenonWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Xenon workers.
     * @param linuxDynamicWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux Consumption Workers.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GeoRegionInner&gt; object
     */
    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsWithServiceResponseAsync(final SkuName sku, final Boolean linuxWorkersEnabled, final Boolean xenonWorkersEnabled, final Boolean linuxDynamicWorkersEnabled) {
        return listGeoRegionsSinglePageAsync(sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled)
            .concatMap(new Func1<ServiceResponse<Page<GeoRegionInner>>, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(ServiceResponse<Page<GeoRegionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listGeoRegionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
    ServiceResponse<PageImpl<GeoRegionInner>> * @param sku Name of SKU used to filter the regions. Possible values include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic', 'Isolated', 'PremiumV2', 'ElasticPremium', 'ElasticIsolated'
    ServiceResponse<PageImpl<GeoRegionInner>> * @param linuxWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux workers.
    ServiceResponse<PageImpl<GeoRegionInner>> * @param xenonWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Xenon workers.
    ServiceResponse<PageImpl<GeoRegionInner>> * @param linuxDynamicWorkersEnabled Specify &lt;code&gt;true&lt;/code&gt; if you want to filter to only regions that support Linux Consumption Workers.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GeoRegionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsSinglePageAsync(final SkuName sku, final Boolean linuxWorkersEnabled, final Boolean xenonWorkersEnabled, final Boolean linuxDynamicWorkersEnabled) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return service.listGeoRegions(this.subscriptionId(), sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<GeoRegionInner>> result = listGeoRegionsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GeoRegionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<GeoRegionInner>> listGeoRegionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<GeoRegionInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<GeoRegionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IdentifierInner&gt; object if successful.
     */
    public PagedList<IdentifierInner> listSiteIdentifiersAssignedToHostName() {
        ServiceResponse<Page<IdentifierInner>> response = listSiteIdentifiersAssignedToHostNameSinglePageAsync().toBlocking().single();
        return new PagedList<IdentifierInner>(response.body()) {
            @Override
            public Page<IdentifierInner> nextPage(String nextPageLink) {
                return listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IdentifierInner>> listSiteIdentifiersAssignedToHostNameAsync(final ListOperationCallback<IdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteIdentifiersAssignedToHostNameSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(String nextPageLink) {
                    return listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentifierInner&gt; object
     */
    public Observable<Page<IdentifierInner>> listSiteIdentifiersAssignedToHostNameAsync() {
        return listSiteIdentifiersAssignedToHostNameWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<IdentifierInner>>, Page<IdentifierInner>>() {
                @Override
                public Page<IdentifierInner> call(ServiceResponse<Page<IdentifierInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentifierInner&gt; object
     */
    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameWithServiceResponseAsync() {
        return listSiteIdentifiersAssignedToHostNameSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<IdentifierInner>>, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(ServiceResponse<Page<IdentifierInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IdentifierInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        final String name = null;
        NameIdentifierInner nameIdentifier = new NameIdentifierInner();
        nameIdentifier.withName(null);
        return service.listSiteIdentifiersAssignedToHostName(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), nameIdentifier, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IdentifierInner>> result = listSiteIdentifiersAssignedToHostNameDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IdentifierInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param name Name of the object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IdentifierInner&gt; object if successful.
     */
    public PagedList<IdentifierInner> listSiteIdentifiersAssignedToHostName(final String name) {
        ServiceResponse<Page<IdentifierInner>> response = listSiteIdentifiersAssignedToHostNameSinglePageAsync(name).toBlocking().single();
        return new PagedList<IdentifierInner>(response.body()) {
            @Override
            public Page<IdentifierInner> nextPage(String nextPageLink) {
                return listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param name Name of the object.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IdentifierInner>> listSiteIdentifiersAssignedToHostNameAsync(final String name, final ListOperationCallback<IdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteIdentifiersAssignedToHostNameSinglePageAsync(name),
            new Func1<String, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(String nextPageLink) {
                    return listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param name Name of the object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentifierInner&gt; object
     */
    public Observable<Page<IdentifierInner>> listSiteIdentifiersAssignedToHostNameAsync(final String name) {
        return listSiteIdentifiersAssignedToHostNameWithServiceResponseAsync(name)
            .map(new Func1<ServiceResponse<Page<IdentifierInner>>, Page<IdentifierInner>>() {
                @Override
                public Page<IdentifierInner> call(ServiceResponse<Page<IdentifierInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param name Name of the object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentifierInner&gt; object
     */
    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameWithServiceResponseAsync(final String name) {
        return listSiteIdentifiersAssignedToHostNameSinglePageAsync(name)
            .concatMap(new Func1<ServiceResponse<Page<IdentifierInner>>, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(ServiceResponse<Page<IdentifierInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
    ServiceResponse<PageImpl<IdentifierInner>> * @param name Name of the object.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IdentifierInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameSinglePageAsync(final String name) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        NameIdentifierInner nameIdentifier = new NameIdentifierInner();
        nameIdentifier.withName(name);
        return service.listSiteIdentifiersAssignedToHostName(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), nameIdentifier, this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IdentifierInner>> result = listSiteIdentifiersAssignedToHostNameDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IdentifierInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IdentifierInner>> listSiteIdentifiersAssignedToHostNameDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<IdentifierInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IdentifierInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PremierAddOnOfferInner&gt; object if successful.
     */
    public PagedList<PremierAddOnOfferInner> listPremierAddOnOffers() {
        ServiceResponse<Page<PremierAddOnOfferInner>> response = listPremierAddOnOffersSinglePageAsync().toBlocking().single();
        return new PagedList<PremierAddOnOfferInner>(response.body()) {
            @Override
            public Page<PremierAddOnOfferInner> nextPage(String nextPageLink) {
                return listPremierAddOnOffersNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PremierAddOnOfferInner>> listPremierAddOnOffersAsync(final ListOperationCallback<PremierAddOnOfferInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPremierAddOnOffersSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(String nextPageLink) {
                    return listPremierAddOnOffersNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PremierAddOnOfferInner&gt; object
     */
    public Observable<Page<PremierAddOnOfferInner>> listPremierAddOnOffersAsync() {
        return listPremierAddOnOffersWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<PremierAddOnOfferInner>>, Page<PremierAddOnOfferInner>>() {
                @Override
                public Page<PremierAddOnOfferInner> call(ServiceResponse<Page<PremierAddOnOfferInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PremierAddOnOfferInner&gt; object
     */
    public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> listPremierAddOnOffersWithServiceResponseAsync() {
        return listPremierAddOnOffersSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<PremierAddOnOfferInner>>, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(ServiceResponse<Page<PremierAddOnOfferInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPremierAddOnOffersNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PremierAddOnOfferInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> listPremierAddOnOffersSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return service.listPremierAddOnOffers(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PremierAddOnOfferInner>> result = listPremierAddOnOffersDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PremierAddOnOfferInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PremierAddOnOfferInner>> listPremierAddOnOffersDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<PremierAddOnOfferInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PremierAddOnOfferInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all SKUs.
     * List all SKUs.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the SkuInfosInner object if successful.
     */
    public SkuInfosInner listSkus() {
        return listSkusWithServiceResponseAsync().toBlocking().single().body();
    }

    /**
     * List all SKUs.
     * List all SKUs.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<SkuInfosInner> listSkusAsync(final ServiceCallback<SkuInfosInner> serviceCallback) {
        return ServiceFuture.fromResponse(listSkusWithServiceResponseAsync(), serviceCallback);
    }

    /**
     * List all SKUs.
     * List all SKUs.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SkuInfosInner object
     */
    public Observable<SkuInfosInner> listSkusAsync() {
        return listSkusWithServiceResponseAsync().map(new Func1<ServiceResponse<SkuInfosInner>, SkuInfosInner>() {
            @Override
            public SkuInfosInner call(ServiceResponse<SkuInfosInner> response) {
                return response.body();
            }
        });
    }

    /**
     * List all SKUs.
     * List all SKUs.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the SkuInfosInner object
     */
    public Observable<ServiceResponse<SkuInfosInner>> listSkusWithServiceResponseAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return service.listSkus(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<SkuInfosInner>>>() {
                @Override
                public Observable<ServiceResponse<SkuInfosInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<SkuInfosInner> clientResponse = listSkusDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<SkuInfosInner> listSkusDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<SkuInfosInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<SkuInfosInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules.
     * Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules.
     *
     * @param parameters VNET information
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VnetValidationFailureDetailsInner object if successful.
     */
    public VnetValidationFailureDetailsInner verifyHostingEnvironmentVnet(VnetParameters parameters) {
        return verifyHostingEnvironmentVnetWithServiceResponseAsync(parameters).toBlocking().single().body();
    }

    /**
     * Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules.
     * Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules.
     *
     * @param parameters VNET information
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VnetValidationFailureDetailsInner> verifyHostingEnvironmentVnetAsync(VnetParameters parameters, final ServiceCallback<VnetValidationFailureDetailsInner> serviceCallback) {
        return ServiceFuture.fromResponse(verifyHostingEnvironmentVnetWithServiceResponseAsync(parameters), serviceCallback);
    }

    /**
     * Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules.
     * Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules.
     *
     * @param parameters VNET information
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VnetValidationFailureDetailsInner object
     */
    public Observable<VnetValidationFailureDetailsInner> verifyHostingEnvironmentVnetAsync(VnetParameters parameters) {
        return verifyHostingEnvironmentVnetWithServiceResponseAsync(parameters).map(new Func1<ServiceResponse<VnetValidationFailureDetailsInner>, VnetValidationFailureDetailsInner>() {
            @Override
            public VnetValidationFailureDetailsInner call(ServiceResponse<VnetValidationFailureDetailsInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules.
     * Verifies if this VNET is compatible with an App Service Environment by analyzing the Network Security Group rules.
     *
     * @param parameters VNET information
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VnetValidationFailureDetailsInner object
     */
    public Observable<ServiceResponse<VnetValidationFailureDetailsInner>> verifyHostingEnvironmentVnetWithServiceResponseAsync(VnetParameters parameters) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.verifyHostingEnvironmentVnet(this.subscriptionId(), parameters, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VnetValidationFailureDetailsInner>>>() {
                @Override
                public Observable<ServiceResponse<VnetValidationFailureDetailsInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VnetValidationFailureDetailsInner> clientResponse = verifyHostingEnvironmentVnetDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VnetValidationFailureDetailsInner> verifyHostingEnvironmentVnetDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<VnetValidationFailureDetailsInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<VnetValidationFailureDetailsInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Move resources between resource groups.
     * Move resources between resource groups.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param moveResourceEnvelope Object that represents the resource to move.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void move(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        moveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope).toBlocking().single().body();
    }

    /**
     * Move resources between resource groups.
     * Move resources between resource groups.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param moveResourceEnvelope Object that represents the resource to move.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> moveAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(moveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope), serviceCallback);
    }

    /**
     * Move resources between resource groups.
     * Move resources between resource groups.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param moveResourceEnvelope Object that represents the resource to move.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> moveAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        return moveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Move resources between resource groups.
     * Move resources between resource groups.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param moveResourceEnvelope Object that represents the resource to move.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> moveWithServiceResponseAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (moveResourceEnvelope == null) {
            throw new IllegalArgumentException("Parameter moveResourceEnvelope is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(moveResourceEnvelope);
        return service.move(resourceGroupName, this.subscriptionId(), moveResourceEnvelope, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = moveDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> moveDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Validate if a resource can be created.
     * Validate if a resource can be created.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param validateRequest Request with the resources to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ValidateResponseInner object if successful.
     */
    public ValidateResponseInner validate(String resourceGroupName, ValidateRequest validateRequest) {
        return validateWithServiceResponseAsync(resourceGroupName, validateRequest).toBlocking().single().body();
    }

    /**
     * Validate if a resource can be created.
     * Validate if a resource can be created.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param validateRequest Request with the resources to validate.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ValidateResponseInner> validateAsync(String resourceGroupName, ValidateRequest validateRequest, final ServiceCallback<ValidateResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(validateWithServiceResponseAsync(resourceGroupName, validateRequest), serviceCallback);
    }

    /**
     * Validate if a resource can be created.
     * Validate if a resource can be created.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param validateRequest Request with the resources to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ValidateResponseInner object
     */
    public Observable<ValidateResponseInner> validateAsync(String resourceGroupName, ValidateRequest validateRequest) {
        return validateWithServiceResponseAsync(resourceGroupName, validateRequest).map(new Func1<ServiceResponse<ValidateResponseInner>, ValidateResponseInner>() {
            @Override
            public ValidateResponseInner call(ServiceResponse<ValidateResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Validate if a resource can be created.
     * Validate if a resource can be created.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param validateRequest Request with the resources to validate.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ValidateResponseInner object
     */
    public Observable<ServiceResponse<ValidateResponseInner>> validateWithServiceResponseAsync(String resourceGroupName, ValidateRequest validateRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (validateRequest == null) {
            throw new IllegalArgumentException("Parameter validateRequest is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(validateRequest);
        return service.validate(resourceGroupName, this.subscriptionId(), validateRequest, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidateResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<ValidateResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ValidateResponseInner> clientResponse = validateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ValidateResponseInner> validateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<ValidateResponseInner, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<ValidateResponseInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Validate if the container settings are correct.
     * Validate if the container settings are correct.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param validateContainerSettingsRequest the ValidateContainerSettingsRequest value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the Object object if successful.
     */
    public Object validateContainerSettings(String resourceGroupName, ValidateContainerSettingsRequest validateContainerSettingsRequest) {
        return validateContainerSettingsWithServiceResponseAsync(resourceGroupName, validateContainerSettingsRequest).toBlocking().single().body();
    }

    /**
     * Validate if the container settings are correct.
     * Validate if the container settings are correct.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param validateContainerSettingsRequest the ValidateContainerSettingsRequest value
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Object> validateContainerSettingsAsync(String resourceGroupName, ValidateContainerSettingsRequest validateContainerSettingsRequest, final ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(validateContainerSettingsWithServiceResponseAsync(resourceGroupName, validateContainerSettingsRequest), serviceCallback);
    }

    /**
     * Validate if the container settings are correct.
     * Validate if the container settings are correct.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param validateContainerSettingsRequest the ValidateContainerSettingsRequest value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Object object
     */
    public Observable<Object> validateContainerSettingsAsync(String resourceGroupName, ValidateContainerSettingsRequest validateContainerSettingsRequest) {
        return validateContainerSettingsWithServiceResponseAsync(resourceGroupName, validateContainerSettingsRequest).map(new Func1<ServiceResponse<Object>, Object>() {
            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    /**
     * Validate if the container settings are correct.
     * Validate if the container settings are correct.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param validateContainerSettingsRequest the ValidateContainerSettingsRequest value
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the Object object
     */
    public Observable<ServiceResponse<Object>> validateContainerSettingsWithServiceResponseAsync(String resourceGroupName, ValidateContainerSettingsRequest validateContainerSettingsRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (validateContainerSettingsRequest == null) {
            throw new IllegalArgumentException("Parameter validateContainerSettingsRequest is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(validateContainerSettingsRequest);
        return service.validateContainerSettings(resourceGroupName, this.subscriptionId(), validateContainerSettingsRequest, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>() {
                @Override
                public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Object> clientResponse = validateContainerSettingsDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Object> validateContainerSettingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<Object, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<Object>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Validate whether a resource can be moved.
     * Validate whether a resource can be moved.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param moveResourceEnvelope Object that represents the resource to move.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void validateMove(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        validateMoveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope).toBlocking().single().body();
    }

    /**
     * Validate whether a resource can be moved.
     * Validate whether a resource can be moved.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param moveResourceEnvelope Object that represents the resource to move.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> validateMoveAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(validateMoveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope), serviceCallback);
    }

    /**
     * Validate whether a resource can be moved.
     * Validate whether a resource can be moved.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param moveResourceEnvelope Object that represents the resource to move.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> validateMoveAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        return validateMoveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Validate whether a resource can be moved.
     * Validate whether a resource can be moved.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param moveResourceEnvelope Object that represents the resource to move.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> validateMoveWithServiceResponseAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (moveResourceEnvelope == null) {
            throw new IllegalArgumentException("Parameter moveResourceEnvelope is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(moveResourceEnvelope);
        return service.validateMove(resourceGroupName, this.subscriptionId(), moveResourceEnvelope, this.apiVersion(), this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = validateMoveDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> validateMoveDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.serializerAdapter())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;SourceControlInner&gt; object if successful.
     */
    public PagedList<SourceControlInner> listSourceControlsNext(final String nextPageLink) {
        ServiceResponse<Page<SourceControlInner>> response = listSourceControlsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SourceControlInner>(response.body()) {
            @Override
            public Page<SourceControlInner> nextPage(String nextPageLink) {
                return listSourceControlsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<SourceControlInner>> listSourceControlsNextAsync(final String nextPageLink, final ServiceFuture<List<SourceControlInner>> serviceFuture, final ListOperationCallback<SourceControlInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSourceControlsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<SourceControlInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SourceControlInner>>> call(String nextPageLink) {
                    return listSourceControlsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SourceControlInner&gt; object
     */
    public Observable<Page<SourceControlInner>> listSourceControlsNextAsync(final String nextPageLink) {
        return listSourceControlsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<SourceControlInner>>, Page<SourceControlInner>>() {
                @Override
                public Page<SourceControlInner> call(ServiceResponse<Page<SourceControlInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;SourceControlInner&gt; object
     */
    public Observable<ServiceResponse<Page<SourceControlInner>>> listSourceControlsNextWithServiceResponseAsync(final String nextPageLink) {
        return listSourceControlsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<SourceControlInner>>, Observable<ServiceResponse<Page<SourceControlInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SourceControlInner>>> call(ServiceResponse<Page<SourceControlInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSourceControlsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the source controls available for Azure websites.
     * Gets the source controls available for Azure websites.
     *
    ServiceResponse<PageImpl<SourceControlInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;SourceControlInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<SourceControlInner>>> listSourceControlsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSourceControlsNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SourceControlInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<SourceControlInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<SourceControlInner>> result = listSourceControlsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<SourceControlInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<SourceControlInner>> listSourceControlsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<SourceControlInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<SourceControlInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;BillingMeterInner&gt; object if successful.
     */
    public PagedList<BillingMeterInner> listBillingMetersNext(final String nextPageLink) {
        ServiceResponse<Page<BillingMeterInner>> response = listBillingMetersNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BillingMeterInner>(response.body()) {
            @Override
            public Page<BillingMeterInner> nextPage(String nextPageLink) {
                return listBillingMetersNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<BillingMeterInner>> listBillingMetersNextAsync(final String nextPageLink, final ServiceFuture<List<BillingMeterInner>> serviceFuture, final ListOperationCallback<BillingMeterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listBillingMetersNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(String nextPageLink) {
                    return listBillingMetersNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BillingMeterInner&gt; object
     */
    public Observable<Page<BillingMeterInner>> listBillingMetersNextAsync(final String nextPageLink) {
        return listBillingMetersNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<BillingMeterInner>>, Page<BillingMeterInner>>() {
                @Override
                public Page<BillingMeterInner> call(ServiceResponse<Page<BillingMeterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;BillingMeterInner&gt; object
     */
    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersNextWithServiceResponseAsync(final String nextPageLink) {
        return listBillingMetersNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<BillingMeterInner>>, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(ServiceResponse<Page<BillingMeterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listBillingMetersNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of meters for a given location.
     * Gets a list of meters for a given location.
     *
    ServiceResponse<PageImpl<BillingMeterInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;BillingMeterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listBillingMetersNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BillingMeterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<BillingMeterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<BillingMeterInner>> result = listBillingMetersNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<BillingMeterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<BillingMeterInner>> listBillingMetersNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<BillingMeterInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<BillingMeterInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;GeoRegionInner&gt; object if successful.
     */
    public PagedList<GeoRegionInner> listGeoRegionsNext(final String nextPageLink) {
        ServiceResponse<Page<GeoRegionInner>> response = listGeoRegionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GeoRegionInner>(response.body()) {
            @Override
            public Page<GeoRegionInner> nextPage(String nextPageLink) {
                return listGeoRegionsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<GeoRegionInner>> listGeoRegionsNextAsync(final String nextPageLink, final ServiceFuture<List<GeoRegionInner>> serviceFuture, final ListOperationCallback<GeoRegionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listGeoRegionsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(String nextPageLink) {
                    return listGeoRegionsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GeoRegionInner&gt; object
     */
    public Observable<Page<GeoRegionInner>> listGeoRegionsNextAsync(final String nextPageLink) {
        return listGeoRegionsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<GeoRegionInner>>, Page<GeoRegionInner>>() {
                @Override
                public Page<GeoRegionInner> call(ServiceResponse<Page<GeoRegionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;GeoRegionInner&gt; object
     */
    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsNextWithServiceResponseAsync(final String nextPageLink) {
        return listGeoRegionsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<GeoRegionInner>>, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(ServiceResponse<Page<GeoRegionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listGeoRegionsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get a list of available geographical regions.
     * Get a list of available geographical regions.
     *
    ServiceResponse<PageImpl<GeoRegionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;GeoRegionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listGeoRegionsNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GeoRegionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<GeoRegionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<GeoRegionInner>> result = listGeoRegionsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<GeoRegionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<GeoRegionInner>> listGeoRegionsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<GeoRegionInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<GeoRegionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;IdentifierInner&gt; object if successful.
     */
    public PagedList<IdentifierInner> listSiteIdentifiersAssignedToHostNameNext(final String nextPageLink) {
        ServiceResponse<Page<IdentifierInner>> response = listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<IdentifierInner>(response.body()) {
            @Override
            public Page<IdentifierInner> nextPage(String nextPageLink) {
                return listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<IdentifierInner>> listSiteIdentifiersAssignedToHostNameNextAsync(final String nextPageLink, final ServiceFuture<List<IdentifierInner>> serviceFuture, final ListOperationCallback<IdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(String nextPageLink) {
                    return listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentifierInner&gt; object
     */
    public Observable<Page<IdentifierInner>> listSiteIdentifiersAssignedToHostNameNextAsync(final String nextPageLink) {
        return listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<IdentifierInner>>, Page<IdentifierInner>>() {
                @Override
                public Page<IdentifierInner> call(ServiceResponse<Page<IdentifierInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;IdentifierInner&gt; object
     */
    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<IdentifierInner>>, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(ServiceResponse<Page<IdentifierInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all apps that are assigned to a hostname.
     * List all apps that are assigned to a hostname.
     *
    ServiceResponse<PageImpl<IdentifierInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;IdentifierInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteIdentifiersAssignedToHostNameNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentifierInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<IdentifierInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<IdentifierInner>> result = listSiteIdentifiersAssignedToHostNameNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<IdentifierInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<IdentifierInner>> listSiteIdentifiersAssignedToHostNameNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<IdentifierInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<IdentifierInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PremierAddOnOfferInner&gt; object if successful.
     */
    public PagedList<PremierAddOnOfferInner> listPremierAddOnOffersNext(final String nextPageLink) {
        ServiceResponse<Page<PremierAddOnOfferInner>> response = listPremierAddOnOffersNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PremierAddOnOfferInner>(response.body()) {
            @Override
            public Page<PremierAddOnOfferInner> nextPage(String nextPageLink) {
                return listPremierAddOnOffersNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PremierAddOnOfferInner>> listPremierAddOnOffersNextAsync(final String nextPageLink, final ServiceFuture<List<PremierAddOnOfferInner>> serviceFuture, final ListOperationCallback<PremierAddOnOfferInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listPremierAddOnOffersNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(String nextPageLink) {
                    return listPremierAddOnOffersNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PremierAddOnOfferInner&gt; object
     */
    public Observable<Page<PremierAddOnOfferInner>> listPremierAddOnOffersNextAsync(final String nextPageLink) {
        return listPremierAddOnOffersNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PremierAddOnOfferInner>>, Page<PremierAddOnOfferInner>>() {
                @Override
                public Page<PremierAddOnOfferInner> call(ServiceResponse<Page<PremierAddOnOfferInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PremierAddOnOfferInner&gt; object
     */
    public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> listPremierAddOnOffersNextWithServiceResponseAsync(final String nextPageLink) {
        return listPremierAddOnOffersNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PremierAddOnOfferInner>>, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(ServiceResponse<Page<PremierAddOnOfferInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listPremierAddOnOffersNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all premier add-on offers.
     * List all premier add-on offers.
     *
    ServiceResponse<PageImpl<PremierAddOnOfferInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PremierAddOnOfferInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> listPremierAddOnOffersNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listPremierAddOnOffersNext(nextUrl, this.acceptLanguage(), this.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PremierAddOnOfferInner>> result = listPremierAddOnOffersNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PremierAddOnOfferInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PremierAddOnOfferInner>> listPremierAddOnOffersNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().<PageImpl<PremierAddOnOfferInner>, DefaultErrorResponseException>newInstance(this.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PremierAddOnOfferInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

}
