/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Description of a backup schedule. Describes how often should be the backup
 * performed and what should be the retention policy.
 */
public class BackupSchedule {
    /**
     * How often the backup should be executed (e.g. for weekly backup, this
     * should be set to 7 and FrequencyUnit should be set to Day).
     */
    @JsonProperty(value = "frequencyInterval", required = true)
    private int frequencyInterval;

    /**
     * The unit of time for how often the backup should be executed (e.g. for
     * weekly backup, this should be set to Day and FrequencyInterval should be
     * set to 7). Possible values include: 'Day', 'Hour'.
     */
    @JsonProperty(value = "frequencyUnit", required = true)
    private FrequencyUnit frequencyUnit;

    /**
     * True if the retention policy should always keep at least one backup in
     * the storage account, regardless how old it is; false otherwise.
     */
    @JsonProperty(value = "keepAtLeastOneBackup", required = true)
    private boolean keepAtLeastOneBackup;

    /**
     * After how many days backups should be deleted.
     */
    @JsonProperty(value = "retentionPeriodInDays", required = true)
    private int retentionPeriodInDays;

    /**
     * When the schedule should start working.
     */
    @JsonProperty(value = "startTime")
    private DateTime startTime;

    /**
     * Last time when this schedule was triggered.
     */
    @JsonProperty(value = "lastExecutionTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime lastExecutionTime;

    /**
     * Get the frequencyInterval value.
     *
     * @return the frequencyInterval value
     */
    public int frequencyInterval() {
        return this.frequencyInterval;
    }

    /**
     * Set the frequencyInterval value.
     *
     * @param frequencyInterval the frequencyInterval value to set
     * @return the BackupSchedule object itself.
     */
    public BackupSchedule withFrequencyInterval(int frequencyInterval) {
        this.frequencyInterval = frequencyInterval;
        return this;
    }

    /**
     * Get the frequencyUnit value.
     *
     * @return the frequencyUnit value
     */
    public FrequencyUnit frequencyUnit() {
        return this.frequencyUnit;
    }

    /**
     * Set the frequencyUnit value.
     *
     * @param frequencyUnit the frequencyUnit value to set
     * @return the BackupSchedule object itself.
     */
    public BackupSchedule withFrequencyUnit(FrequencyUnit frequencyUnit) {
        this.frequencyUnit = frequencyUnit;
        return this;
    }

    /**
     * Get the keepAtLeastOneBackup value.
     *
     * @return the keepAtLeastOneBackup value
     */
    public boolean keepAtLeastOneBackup() {
        return this.keepAtLeastOneBackup;
    }

    /**
     * Set the keepAtLeastOneBackup value.
     *
     * @param keepAtLeastOneBackup the keepAtLeastOneBackup value to set
     * @return the BackupSchedule object itself.
     */
    public BackupSchedule withKeepAtLeastOneBackup(boolean keepAtLeastOneBackup) {
        this.keepAtLeastOneBackup = keepAtLeastOneBackup;
        return this;
    }

    /**
     * Get the retentionPeriodInDays value.
     *
     * @return the retentionPeriodInDays value
     */
    public int retentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    /**
     * Set the retentionPeriodInDays value.
     *
     * @param retentionPeriodInDays the retentionPeriodInDays value to set
     * @return the BackupSchedule object itself.
     */
    public BackupSchedule withRetentionPeriodInDays(int retentionPeriodInDays) {
        this.retentionPeriodInDays = retentionPeriodInDays;
        return this;
    }

    /**
     * Get the startTime value.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime value.
     *
     * @param startTime the startTime value to set
     * @return the BackupSchedule object itself.
     */
    public BackupSchedule withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the lastExecutionTime value.
     *
     * @return the lastExecutionTime value
     */
    public DateTime lastExecutionTime() {
        return this.lastExecutionTime;
    }

}
