/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ResourceScopeType.
 */
public final class ResourceScopeType {
    /** Static value ServerFarm for ResourceScopeType. */
    public static final ResourceScopeType SERVER_FARM = new ResourceScopeType("ServerFarm");

    /** Static value Subscription for ResourceScopeType. */
    public static final ResourceScopeType SUBSCRIPTION = new ResourceScopeType("Subscription");

    /** Static value WebSite for ResourceScopeType. */
    public static final ResourceScopeType WEB_SITE = new ResourceScopeType("WebSite");

    private String value;

    /**
     * Creates a custom value for ResourceScopeType.
     * @param value the custom value
     */
    public ResourceScopeType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceScopeType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ResourceScopeType rhs = (ResourceScopeType) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
