/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for RouteType.
 */
public final class RouteType {
    /** Static value DEFAULT for RouteType. */
    public static final RouteType DEFAULT = new RouteType("DEFAULT");

    /** Static value INHERITED for RouteType. */
    public static final RouteType INHERITED = new RouteType("INHERITED");

    /** Static value STATIC for RouteType. */
    public static final RouteType STATIC = new RouteType("STATIC");

    private String value;

    /**
     * Creates a custom value for RouteType.
     * @param value the custom value
     */
    public RouteType(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RouteType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RouteType rhs = (RouteType) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
