/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.implementation.PageImpl1;
import com.microsoft.azure.management.appservice.implementation.RecommendationInner;
import com.microsoft.azure.management.appservice.implementation.RecommendationRuleInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class RecommendationsInner {
    private RecommendationsService service;
    private WebSiteManagementClientImpl client;

    public RecommendationsInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (RecommendationsService)retrofit.create(RecommendationsService.class);
        this.client = client;
    }

    public PagedList<RecommendationInner> list() {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<RecommendationInner>(page){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listAsync(ServiceCallback<List<RecommendationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<List<RecommendationInner>> response) {
                PageImpl1<RecommendationInner> page = new PageImpl1<RecommendationInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<RecommendationInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        Boolean featured = null;
        String filter = null;
        return this.service.list(this.client.subscriptionId(), featured, filter, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<RecommendationInner>>>>(){

            public Observable<ServiceResponse<List<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<RecommendationInner> list(Boolean featured, String filter) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync(featured, filter).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<RecommendationInner>(page){

            public Page<RecommendationInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<RecommendationInner>> listAsync(Boolean featured, String filter, ServiceCallback<List<RecommendationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(featured, filter), serviceCallback);
    }

    public Observable<Page<RecommendationInner>> listAsync(Boolean featured, String filter) {
        return this.listWithServiceResponseAsync(featured, filter).map((Func1)new Func1<ServiceResponse<List<RecommendationInner>>, Page<RecommendationInner>>(){

            public Page<RecommendationInner> call(ServiceResponse<List<RecommendationInner>> response) {
                PageImpl1<RecommendationInner> page = new PageImpl1<RecommendationInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<RecommendationInner>>> listWithServiceResponseAsync(Boolean featured, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.list(this.client.subscriptionId(), featured, filter, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<RecommendationInner>>>>(){

            public Observable<ServiceResponse<List<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RecommendationsInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl1)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<RecommendationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<RecommendationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resetAllFilters() {
        ((ServiceResponse)this.resetAllFiltersWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<Void> resetAllFiltersAsync(ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetAllFiltersWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Void> resetAllFiltersAsync() {
        return this.resetAllFiltersWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resetAllFiltersWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.resetAllFilters(this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.resetAllFiltersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> resetAllFiltersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<RecommendationInner> listHistoryForWebApp(String resourceGroupName, String siteName) {
        return (List)((ServiceResponse)this.listHistoryForWebAppWithServiceResponseAsync(resourceGroupName, siteName).toBlocking().single()).body();
    }

    public ServiceFuture<List<RecommendationInner>> listHistoryForWebAppAsync(String resourceGroupName, String siteName, ServiceCallback<List<RecommendationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listHistoryForWebAppWithServiceResponseAsync(resourceGroupName, siteName), serviceCallback);
    }

    public Observable<List<RecommendationInner>> listHistoryForWebAppAsync(String resourceGroupName, String siteName) {
        return this.listHistoryForWebAppWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<List<RecommendationInner>>, List<RecommendationInner>>(){

            public List<RecommendationInner> call(ServiceResponse<List<RecommendationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<RecommendationInner>>> listHistoryForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        String filter = null;
        return this.service.listHistoryForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), filter, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<RecommendationInner>>>>(){

            public Observable<ServiceResponse<List<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.listHistoryForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<RecommendationInner> listHistoryForWebApp(String resourceGroupName, String siteName, String filter) {
        return (List)((ServiceResponse)this.listHistoryForWebAppWithServiceResponseAsync(resourceGroupName, siteName, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<RecommendationInner>> listHistoryForWebAppAsync(String resourceGroupName, String siteName, String filter, ServiceCallback<List<RecommendationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listHistoryForWebAppWithServiceResponseAsync(resourceGroupName, siteName, filter), serviceCallback);
    }

    public Observable<List<RecommendationInner>> listHistoryForWebAppAsync(String resourceGroupName, String siteName, String filter) {
        return this.listHistoryForWebAppWithServiceResponseAsync(resourceGroupName, siteName, filter).map((Func1)new Func1<ServiceResponse<List<RecommendationInner>>, List<RecommendationInner>>(){

            public List<RecommendationInner> call(ServiceResponse<List<RecommendationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<RecommendationInner>>> listHistoryForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listHistoryForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), filter, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<RecommendationInner>>>>(){

            public Observable<ServiceResponse<List<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.listHistoryForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<RecommendationInner>> listHistoryForWebAppDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<RecommendationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<RecommendationInner> listRecommendedRulesForWebApp(String resourceGroupName, String siteName) {
        return (List)((ServiceResponse)this.listRecommendedRulesForWebAppWithServiceResponseAsync(resourceGroupName, siteName).toBlocking().single()).body();
    }

    public ServiceFuture<List<RecommendationInner>> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName, ServiceCallback<List<RecommendationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listRecommendedRulesForWebAppWithServiceResponseAsync(resourceGroupName, siteName), serviceCallback);
    }

    public Observable<List<RecommendationInner>> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName) {
        return this.listRecommendedRulesForWebAppWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<List<RecommendationInner>>, List<RecommendationInner>>(){

            public List<RecommendationInner> call(ServiceResponse<List<RecommendationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<RecommendationInner>>> listRecommendedRulesForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        Boolean featured = null;
        String filter = null;
        return this.service.listRecommendedRulesForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), featured, filter, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<RecommendationInner>>>>(){

            public Observable<ServiceResponse<List<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.listRecommendedRulesForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<RecommendationInner> listRecommendedRulesForWebApp(String resourceGroupName, String siteName, Boolean featured, String filter) {
        return (List)((ServiceResponse)this.listRecommendedRulesForWebAppWithServiceResponseAsync(resourceGroupName, siteName, featured, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<RecommendationInner>> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName, Boolean featured, String filter, ServiceCallback<List<RecommendationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listRecommendedRulesForWebAppWithServiceResponseAsync(resourceGroupName, siteName, featured, filter), serviceCallback);
    }

    public Observable<List<RecommendationInner>> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName, Boolean featured, String filter) {
        return this.listRecommendedRulesForWebAppWithServiceResponseAsync(resourceGroupName, siteName, featured, filter).map((Func1)new Func1<ServiceResponse<List<RecommendationInner>>, List<RecommendationInner>>(){

            public List<RecommendationInner> call(ServiceResponse<List<RecommendationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<RecommendationInner>>> listRecommendedRulesForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName, Boolean featured, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listRecommendedRulesForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), featured, filter, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<RecommendationInner>>>>(){

            public Observable<ServiceResponse<List<RecommendationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.listRecommendedRulesForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<RecommendationInner>> listRecommendedRulesForWebAppDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<RecommendationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void disableAllForWebApp(String resourceGroupName, String siteName) {
        ((ServiceResponse)this.disableAllForWebAppWithServiceResponseAsync(resourceGroupName, siteName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> disableAllForWebAppAsync(String resourceGroupName, String siteName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.disableAllForWebAppWithServiceResponseAsync(resourceGroupName, siteName), serviceCallback);
    }

    public Observable<Void> disableAllForWebAppAsync(String resourceGroupName, String siteName) {
        return this.disableAllForWebAppWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> disableAllForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.disableAllForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.disableAllForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> disableAllForWebAppDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resetAllFiltersForWebApp(String resourceGroupName, String siteName) {
        ((ServiceResponse)this.resetAllFiltersForWebAppWithServiceResponseAsync(resourceGroupName, siteName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> resetAllFiltersForWebAppAsync(String resourceGroupName, String siteName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetAllFiltersForWebAppWithServiceResponseAsync(resourceGroupName, siteName), serviceCallback);
    }

    public Observable<Void> resetAllFiltersForWebAppAsync(String resourceGroupName, String siteName) {
        return this.resetAllFiltersForWebAppWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resetAllFiltersForWebAppWithServiceResponseAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.resetAllFiltersForWebApp(resourceGroupName, siteName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.resetAllFiltersForWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> resetAllFiltersForWebAppDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RecommendationRuleInner getRuleDetailsByWebApp(String resourceGroupName, String siteName, String name) {
        return (RecommendationRuleInner)((ServiceResponse)this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name).toBlocking().single()).body();
    }

    public ServiceFuture<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name, ServiceCallback<RecommendationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name), serviceCallback);
    }

    public Observable<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name) {
        return this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name).map((Func1)new Func1<ServiceResponse<RecommendationRuleInner>, RecommendationRuleInner>(){

            public RecommendationRuleInner call(ServiceResponse<RecommendationRuleInner> response) {
                return (RecommendationRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RecommendationRuleInner>> getRuleDetailsByWebAppWithServiceResponseAsync(String resourceGroupName, String siteName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        Boolean updateSeen = null;
        return this.service.getRuleDetailsByWebApp(resourceGroupName, siteName, name, this.client.subscriptionId(), updateSeen, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecommendationRuleInner>>>(){

            public Observable<ServiceResponse<RecommendationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.getRuleDetailsByWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public RecommendationRuleInner getRuleDetailsByWebApp(String resourceGroupName, String siteName, String name, Boolean updateSeen) {
        return (RecommendationRuleInner)((ServiceResponse)this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name, updateSeen).toBlocking().single()).body();
    }

    public ServiceFuture<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen, ServiceCallback<RecommendationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name, updateSeen), serviceCallback);
    }

    public Observable<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen) {
        return this.getRuleDetailsByWebAppWithServiceResponseAsync(resourceGroupName, siteName, name, updateSeen).map((Func1)new Func1<ServiceResponse<RecommendationRuleInner>, RecommendationRuleInner>(){

            public RecommendationRuleInner call(ServiceResponse<RecommendationRuleInner> response) {
                return (RecommendationRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RecommendationRuleInner>> getRuleDetailsByWebAppWithServiceResponseAsync(String resourceGroupName, String siteName, String name, Boolean updateSeen) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getRuleDetailsByWebApp(resourceGroupName, siteName, name, this.client.subscriptionId(), updateSeen, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RecommendationRuleInner>>>(){

            public Observable<ServiceResponse<RecommendationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RecommendationsInner.this.getRuleDetailsByWebAppDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RecommendationRuleInner> getRuleDetailsByWebAppDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RecommendationRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RecommendationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="featured") Boolean var2, @Query(value="$filter", encoded=true) String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations resetAllFilters"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/reset")
        public Observable<Response<ResponseBody>> resetAllFilters(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listHistoryForWebApp"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendationHistory")
        public Observable<Response<ResponseBody>> listHistoryForWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="$filter", encoded=true) String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations listRecommendedRulesForWebApp"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations")
        public Observable<Response<ResponseBody>> listRecommendedRulesForWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="featured") Boolean var4, @Query(value="$filter", encoded=true) String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations disableAllForWebApp"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/disable")
        public Observable<Response<ResponseBody>> disableAllForWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations resetAllFiltersForWebApp"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/reset")
        public Observable<Response<ResponseBody>> resetAllFiltersForWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Recommendations getRuleDetailsByWebApp"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}")
        public Observable<Response<ResponseBody>> getRuleDetailsByWebApp(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="updateSeen") Boolean var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

