/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.appservice.SiteRuntimeState;
import java.util.Map;
import com.microsoft.azure.management.appservice.ContainerInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * The WebSiteInstanceStatusInner model.
 */
@JsonFlatten
public class WebSiteInstanceStatusInner extends ProxyOnlyResource {
    /**
     * Possible values include: 'READY', 'STOPPED', 'UNKNOWN'.
     */
    @JsonProperty(value = "properties.state")
    private SiteRuntimeState state;

    /**
     * Link to the GetStatusApi in Kudu.
     */
    @JsonProperty(value = "properties.statusUrl")
    private String statusUrl;

    /**
     * Link to the Diagnose and Solve Portal.
     */
    @JsonProperty(value = "properties.detectorUrl")
    private String detectorUrl;

    /**
     * Link to the Diagnose and Solve Portal.
     */
    @JsonProperty(value = "properties.consoleUrl")
    private String consoleUrl;

    /**
     * The containers property.
     */
    @JsonProperty(value = "properties.containers")
    private Map<String, ContainerInfo> containers;

    /**
     * Get possible values include: 'READY', 'STOPPED', 'UNKNOWN'.
     *
     * @return the state value
     */
    public SiteRuntimeState state() {
        return this.state;
    }

    /**
     * Set possible values include: 'READY', 'STOPPED', 'UNKNOWN'.
     *
     * @param state the state value to set
     * @return the WebSiteInstanceStatusInner object itself.
     */
    public WebSiteInstanceStatusInner withState(SiteRuntimeState state) {
        this.state = state;
        return this;
    }

    /**
     * Get link to the GetStatusApi in Kudu.
     *
     * @return the statusUrl value
     */
    public String statusUrl() {
        return this.statusUrl;
    }

    /**
     * Set link to the GetStatusApi in Kudu.
     *
     * @param statusUrl the statusUrl value to set
     * @return the WebSiteInstanceStatusInner object itself.
     */
    public WebSiteInstanceStatusInner withStatusUrl(String statusUrl) {
        this.statusUrl = statusUrl;
        return this;
    }

    /**
     * Get link to the Diagnose and Solve Portal.
     *
     * @return the detectorUrl value
     */
    public String detectorUrl() {
        return this.detectorUrl;
    }

    /**
     * Set link to the Diagnose and Solve Portal.
     *
     * @param detectorUrl the detectorUrl value to set
     * @return the WebSiteInstanceStatusInner object itself.
     */
    public WebSiteInstanceStatusInner withDetectorUrl(String detectorUrl) {
        this.detectorUrl = detectorUrl;
        return this;
    }

    /**
     * Get link to the Diagnose and Solve Portal.
     *
     * @return the consoleUrl value
     */
    public String consoleUrl() {
        return this.consoleUrl;
    }

    /**
     * Set link to the Diagnose and Solve Portal.
     *
     * @param consoleUrl the consoleUrl value to set
     * @return the WebSiteInstanceStatusInner object itself.
     */
    public WebSiteInstanceStatusInner withConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
        return this;
    }

    /**
     * Get the containers value.
     *
     * @return the containers value
     */
    public Map<String, ContainerInfo> containers() {
        return this.containers;
    }

    /**
     * Set the containers value.
     *
     * @param containers the containers value to set
     * @return the WebSiteInstanceStatusInner object itself.
     */
    public WebSiteInstanceStatusInner withContainers(Map<String, ContainerInfo> containers) {
        this.containers = containers;
        return this;
    }

}
