/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ConfigReferenceLocation.
 */
public enum ConfigReferenceLocation {
    /** Enum value ApplicationSetting. */
    APPLICATION_SETTING("ApplicationSetting");

    /** The actual serialized value for a ConfigReferenceLocation instance. */
    private String value;

    ConfigReferenceLocation(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ConfigReferenceLocation instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ConfigReferenceLocation object, or null if unable to parse.
     */
    @JsonCreator
    public static ConfigReferenceLocation fromString(String value) {
        ConfigReferenceLocation[] items = ConfigReferenceLocation.values();
        for (ConfigReferenceLocation item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
