/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A domain name that a service is reached at, including details of the current
 * connection status.
 */
public class EndpointDependency {
    /**
     * The domain name of the dependency.
     */
    @JsonProperty(value = "domainName")
    private String domainName;

    /**
     * The IP Addresses and Ports used when connecting to DomainName.
     */
    @JsonProperty(value = "endpointDetails")
    private List<EndpointDetail> endpointDetails;

    /**
     * Get the domain name of the dependency.
     *
     * @return the domainName value
     */
    public String domainName() {
        return this.domainName;
    }

    /**
     * Set the domain name of the dependency.
     *
     * @param domainName the domainName value to set
     * @return the EndpointDependency object itself.
     */
    public EndpointDependency withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    /**
     * Get the IP Addresses and Ports used when connecting to DomainName.
     *
     * @return the endpointDetails value
     */
    public List<EndpointDetail> endpointDetails() {
        return this.endpointDetails;
    }

    /**
     * Set the IP Addresses and Ports used when connecting to DomainName.
     *
     * @param endpointDetails the endpointDetails value to set
     * @return the EndpointDependency object itself.
     */
    public EndpointDependency withEndpointDetails(List<EndpointDetail> endpointDetails) {
        this.endpointDetails = endpointDetails;
        return this;
    }

}
