/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import java.util.List;
import com.microsoft.azure.management.appservice.StackMajorVersion;
import com.microsoft.azure.management.appservice.ApplicationStack;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * ARM resource for a ApplicationStack.
 */
@JsonFlatten
public class ApplicationStackResourceInner extends ProxyOnlyResource {
    /**
     * Application stack name.
     */
    @JsonProperty(value = "properties.name")
    private String applicationStackResourceName;

    /**
     * Application stack display name.
     */
    @JsonProperty(value = "properties.display")
    private String display;

    /**
     * Application stack dependency.
     */
    @JsonProperty(value = "properties.dependency")
    private String dependency;

    /**
     * List of major versions available.
     */
    @JsonProperty(value = "properties.majorVersions")
    private List<StackMajorVersion> majorVersions;

    /**
     * List of frameworks associated with application stack.
     */
    @JsonProperty(value = "properties.frameworks")
    private List<ApplicationStack> frameworks;

    /**
     * Get application stack name.
     *
     * @return the applicationStackResourceName value
     */
    public String applicationStackResourceName() {
        return this.applicationStackResourceName;
    }

    /**
     * Set application stack name.
     *
     * @param applicationStackResourceName the applicationStackResourceName value to set
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withApplicationStackResourceName(String applicationStackResourceName) {
        this.applicationStackResourceName = applicationStackResourceName;
        return this;
    }

    /**
     * Get application stack display name.
     *
     * @return the display value
     */
    public String display() {
        return this.display;
    }

    /**
     * Set application stack display name.
     *
     * @param display the display value to set
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withDisplay(String display) {
        this.display = display;
        return this;
    }

    /**
     * Get application stack dependency.
     *
     * @return the dependency value
     */
    public String dependency() {
        return this.dependency;
    }

    /**
     * Set application stack dependency.
     *
     * @param dependency the dependency value to set
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withDependency(String dependency) {
        this.dependency = dependency;
        return this;
    }

    /**
     * Get list of major versions available.
     *
     * @return the majorVersions value
     */
    public List<StackMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    /**
     * Set list of major versions available.
     *
     * @param majorVersions the majorVersions value to set
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withMajorVersions(List<StackMajorVersion> majorVersions) {
        this.majorVersions = majorVersions;
        return this;
    }

    /**
     * Get list of frameworks associated with application stack.
     *
     * @return the frameworks value
     */
    public List<ApplicationStack> frameworks() {
        return this.frameworks;
    }

    /**
     * Set list of frameworks associated with application stack.
     *
     * @param frameworks the frameworks value to set
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withFrameworks(List<ApplicationStack> frameworks) {
        this.frameworks = frameworks;
        return this;
    }

}
