/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Streaming;
import rx.Completable;
import rx.Emitter;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;

class KuduClient {
    private KuduService service;

    KuduClient(WebAppBase webAppBase) {
        if (webAppBase.defaultHostName() == null) {
            throw new UnsupportedOperationException("Cannot initialize kudu client before web app is created");
        }
        String host = webAppBase.defaultHostName().toLowerCase().replace("http://", "").replace("https://", "");
        String[] parts = host.split("\\.", 2);
        host = Joiner.on((char)'.').join((Object)parts[0], (Object)"scm", new Object[]{parts[1]});
        this.service = (KuduService)((AppServiceManager)((Object)webAppBase.manager())).restClient().newBuilder().withBaseUrl("https://" + host).withConnectionTimeout(3L, TimeUnit.MINUTES).withReadTimeout(3L, TimeUnit.MINUTES).build().retrofit().create(KuduService.class);
    }

    Observable<String> streamApplicationLogsAsync() {
        return this.service.streamApplicationLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    Observable<String> streamHttpLogsAsync() {
        return this.service.streamHttpLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    Observable<String> streamTraceLogsAsync() {
        return this.service.streamTraceLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    Observable<String> streamDeploymentLogsAsync() {
        return this.service.streamDeploymentLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    Observable<String> streamAllLogsAsync() {
        return this.service.streamAllLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    private Observable<String> streamFromBufferedSource(final BufferedSource source) {
        return Observable.create((Action1)new Action1<Emitter<String>>(){

            public void call(Emitter<String> stringEmitter) {
                try {
                    while (!source.exhausted()) {
                        stringEmitter.onNext((Object)source.readUtf8Line());
                    }
                    stringEmitter.onCompleted();
                }
                catch (IOException e) {
                    stringEmitter.onError((Throwable)e);
                }
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER);
    }

    Completable warDeployAsync(InputStream warFile, String appName) {
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])ByteStreams.toByteArray((InputStream)warFile));
            return this.getCompletable(this.service.warDeploy(body, appName));
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    Completable zipDeployAsync(InputStream zipFile) {
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])ByteStreams.toByteArray((InputStream)zipFile));
            return this.getCompletable(this.service.zipDeploy(body));
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    private Completable getCompletable(Observable<Void> observable) {
        return observable.toCompletable().retryWhen(new Func1<Observable<? extends Throwable>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Throwable> observable) {
                return observable.zipWith(Observable.range((int)1, (int)6), (Func2)new Func2<Throwable, Integer, Integer>(){

                    public Integer call(Throwable throwable, Integer integer) {
                        if (throwable instanceof CloudException && ((CloudException)throwable).response().code() == 502 || throwable instanceof JsonParseException || throwable instanceof SocketTimeoutException) {
                            return integer;
                        }
                        throw Exceptions.propagate((Throwable)throwable);
                    }
                }).flatMap(new Func1<Integer, Observable<?>>(){

                    public Observable<?> call(Integer i) {
                        return Observable.timer((long)(i * 10), (TimeUnit)TimeUnit.SECONDS);
                    }
                });
            }
        });
    }

    private static interface KuduService {
        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamApplicationLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream/application")
        @Streaming
        public Observable<ResponseBody> streamApplicationLogs();

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamHttpLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream/http")
        @Streaming
        public Observable<ResponseBody> streamHttpLogs();

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamTraceLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream/kudu/trace")
        @Streaming
        public Observable<ResponseBody> streamTraceLogs();

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamDeploymentLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream/kudu/deployment")
        @Streaming
        public Observable<ResponseBody> streamDeploymentLogs();

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamAllLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream")
        @Streaming
        public Observable<ResponseBody> streamAllLogs();

        @Headers(value={"Content-Type: application/octet-stream", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps warDeploy", "x-ms-body-logging: false"})
        @POST(value="api/wardeploy")
        @Streaming
        public Observable<Void> warDeploy(@Body RequestBody var1, @Query(value="name") String var2);

        @Headers(value={"Content-Type: application/octet-stream", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps zipDeploy", "x-ms-body-logging: false"})
        @POST(value="api/zipdeploy")
        @Streaming
        public Observable<Void> zipDeploy(@Body RequestBody var1);
    }
}

