/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.DeploymentSlots;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebAppRuntimeStack;
import com.microsoft.azure.management.appservice.implementation.AppServiceBaseImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.DeploymentSlotsImpl;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.StringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class WebAppImpl
extends AppServiceBaseImpl<WebApp, WebAppImpl, WebApp.DefinitionStages.WithCreate, WebApp.Update>
implements WebApp,
WebApp.Definition,
WebApp.DefinitionStages.ExistingWindowsPlanWithGroup,
WebApp.DefinitionStages.ExistingLinuxPlanWithGroup,
WebApp.DefinitionStages.WithWindowsRuntimeStack,
WebApp.Update,
WebApp.UpdateStages.WithCredentials,
WebApp.UpdateStages.WithStartUpCommand {
    private DeploymentSlots deploymentSlots;
    private WebAppRuntimeStack runtimeStackOnWindowsOSToUpdate;

    WebAppImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, AppServiceManager manager) {
        super(name, innerObject, siteConfig, logConfig, manager);
    }

    public WebAppImpl update() {
        this.runtimeStackOnWindowsOSToUpdate = null;
        return (WebAppImpl)super.update();
    }

    @Override
    public DeploymentSlots deploymentSlots() {
        if (this.deploymentSlots == null) {
            this.deploymentSlots = new DeploymentSlotsImpl(this);
        }
        return this.deploymentSlots;
    }

    @Override
    public WebAppImpl withBuiltInImage(RuntimeStack runtimeStack) {
        this.ensureLinuxPlan();
        this.cleanUpContainerSettings();
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withLinuxFxVersion(String.format("%s|%s", runtimeStack.stack(), runtimeStack.version()));
        if (runtimeStack.stack().equals("NODE")) {
            this.siteConfig.withNodeVersion(runtimeStack.version());
        }
        if (runtimeStack.stack().equals("PHP")) {
            this.siteConfig.withPhpVersion(runtimeStack.version());
        }
        if (runtimeStack.stack().equals("DOTNETCORE")) {
            this.siteConfig.withNetFrameworkVersion(runtimeStack.version());
        }
        return this;
    }

    @Override
    protected void cleanUpContainerSettings() {
        if (this.siteConfig != null && this.siteConfig.linuxFxVersion() != null) {
            this.siteConfig.withLinuxFxVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.phpVersion() != null) {
            this.siteConfig.withPhpVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.nodeVersion() != null) {
            this.siteConfig.withNodeVersion(null);
        }
        if (this.siteConfig != null && this.siteConfig.netFrameworkVersion() != null) {
            this.siteConfig.withNetFrameworkVersion("v4.0");
        }
        this.withoutAppSetting("DOCKER_CUSTOM_IMAGE_NAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_URL");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_USERNAME");
        this.withoutAppSetting("DOCKER_REGISTRY_SERVER_PASSWORD");
    }

    @Override
    public WebAppImpl withStartUpCommand(String startUpCommand) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withAppCommandLine(startUpCommand);
        return this;
    }

    @Override
    public WebAppImpl withExistingWindowsPlan(AppServicePlan appServicePlan) {
        return (WebAppImpl)super.withExistingAppServicePlan(appServicePlan);
    }

    @Override
    public WebAppImpl withExistingLinuxPlan(AppServicePlan appServicePlan) {
        return (WebAppImpl)super.withExistingAppServicePlan(appServicePlan);
    }

    @Override
    public WebAppImpl withNewWindowsPlan(PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(OperatingSystem.WINDOWS, pricingTier);
    }

    @Override
    public WebAppImpl withNewWindowsPlan(String appServicePlanName, PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanName, OperatingSystem.WINDOWS, pricingTier);
    }

    @Override
    public WebAppImpl withNewWindowsPlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanCreatable);
    }

    @Override
    public WebAppImpl withNewLinuxPlan(PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public WebAppImpl withNewLinuxPlan(String appServicePlanName, PricingTier pricingTier) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanName, OperatingSystem.LINUX, pricingTier);
    }

    @Override
    public WebAppImpl withNewLinuxPlan(Creatable<AppServicePlan> appServicePlanCreatable) {
        return (WebAppImpl)super.withNewAppServicePlan(appServicePlanCreatable);
    }

    @Override
    public WebAppImpl withRuntimeStack(WebAppRuntimeStack runtimeStack) {
        this.runtimeStackOnWindowsOSToUpdate = runtimeStack;
        return this;
    }

    @Override
    public Completable warDeployAsync(File warFile) {
        return this.warDeployAsync(warFile, null);
    }

    @Override
    public void warDeploy(File warFile) {
        this.warDeployAsync(warFile).await();
    }

    @Override
    public Completable warDeployAsync(InputStream warFile) {
        return this.warDeployAsync(warFile, null);
    }

    @Override
    public void warDeploy(InputStream warFile) {
        this.warDeployAsync(warFile).await();
    }

    @Override
    public Completable warDeployAsync(File warFile, String appName) {
        try {
            return this.warDeployAsync(new FileInputStream(warFile), appName);
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    public void warDeploy(File warFile, String appName) {
        this.warDeployAsync(warFile, appName).await();
    }

    @Override
    public void warDeploy(InputStream warFile, String appName) {
        this.warDeployAsync(warFile, appName).await();
    }

    @Override
    public Completable warDeployAsync(InputStream warFile, String appName) {
        return this.kuduClient.warDeployAsync(warFile, appName);
    }

    @Override
    public Completable zipDeployAsync(File zipFile) {
        try {
            return this.zipDeployAsync(new FileInputStream(zipFile));
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).await();
    }

    @Override
    public Completable zipDeployAsync(InputStream zipFile) {
        return this.kuduClient.zipDeployAsync(zipFile).concatWith(this.stopAsync()).concatWith(this.startAsync());
    }

    @Override
    public void zipDeploy(InputStream zipFile) {
        this.zipDeployAsync(zipFile).await();
    }

    @Override
    Observable<Indexable> submitMetadata() {
        Observable observable = super.submitMetadata();
        if (this.runtimeStackOnWindowsOSToUpdate != null) {
            observable = observable.flatMap((Func1)new Func1<Indexable, Observable<StringDictionaryInner>>(){

                public Observable<StringDictionaryInner> call(Indexable indexable) {
                    return WebAppImpl.this.listMetadata();
                }
            }).flatMap((Func1)new Func1<StringDictionaryInner, Observable<StringDictionaryInner>>(){

                public Observable<StringDictionaryInner> call(StringDictionaryInner stringDictionaryInner) {
                    if (stringDictionaryInner == null) {
                        stringDictionaryInner = new StringDictionaryInner();
                    }
                    if (stringDictionaryInner.properties() == null) {
                        stringDictionaryInner.withProperties(new HashMap<String, String>());
                    }
                    stringDictionaryInner.properties().put("CURRENT_STACK", WebAppImpl.this.runtimeStackOnWindowsOSToUpdate.runtime());
                    return WebAppImpl.this.updateMetadata(stringDictionaryInner);
                }
            }).map((Func1)new Func1<StringDictionaryInner, Indexable>(){

                public Indexable call(StringDictionaryInner stringDictionaryInner) {
                    WebAppImpl.this.runtimeStackOnWindowsOSToUpdate = null;
                    return WebAppImpl.this;
                }
            });
        }
        return observable;
    }

    Observable<StringDictionaryInner> listMetadata() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listMetadataAsync(this.resourceGroupName(), this.name());
    }

    Observable<StringDictionaryInner> updateMetadata(StringDictionaryInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateMetadataAsync(this.resourceGroupName(), this.name(), inner);
    }
}

