/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Cross-Origin Resource Sharing (CORS) settings for the app.
 */
public class CorsSettings {
    /**
     * Gets or sets the list of origins that should be allowed to make
     * cross-origin
     * calls (for example: http://example.com:12345). Use "*" to allow all.
     */
    @JsonProperty(value = "allowedOrigins")
    private List<String> allowedOrigins;

    /**
     * Gets or sets whether CORS requests with credentials are allowed. See
     * https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     * for more details.
     */
    @JsonProperty(value = "supportCredentials")
    private Boolean supportCredentials;

    /**
     * Get gets or sets the list of origins that should be allowed to make cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
     *
     * @return the allowedOrigins value
     */
    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    /**
     * Set gets or sets the list of origins that should be allowed to make cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
     *
     * @param allowedOrigins the allowedOrigins value to set
     * @return the CorsSettings object itself.
     */
    public CorsSettings withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    /**
     * Get gets or sets whether CORS requests with credentials are allowed. See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
     *
     * @return the supportCredentials value
     */
    public Boolean supportCredentials() {
        return this.supportCredentials;
    }

    /**
     * Set gets or sets whether CORS requests with credentials are allowed. See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
     *
     * @param supportCredentials the supportCredentials value to set
     * @return the CorsSettings object itself.
     */
    public CorsSettings withSupportCredentials(Boolean supportCredentials) {
        this.supportCredentials = supportCredentials;
        return this;
    }

}
