/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Column definition.
 */
public class DataTableResponseColumn {
    /**
     * Name of the column.
     */
    @JsonProperty(value = "columnName")
    private String columnName;

    /**
     * Data type which looks like 'String' or 'Int32'.
     */
    @JsonProperty(value = "dataType")
    private String dataType;

    /**
     * Column Type.
     */
    @JsonProperty(value = "columnType")
    private String columnType;

    /**
     * Get name of the column.
     *
     * @return the columnName value
     */
    public String columnName() {
        return this.columnName;
    }

    /**
     * Set name of the column.
     *
     * @param columnName the columnName value to set
     * @return the DataTableResponseColumn object itself.
     */
    public DataTableResponseColumn withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    /**
     * Get data type which looks like 'String' or 'Int32'.
     *
     * @return the dataType value
     */
    public String dataType() {
        return this.dataType;
    }

    /**
     * Set data type which looks like 'String' or 'Int32'.
     *
     * @param dataType the dataType value to set
     * @return the DataTableResponseColumn object itself.
     */
    public DataTableResponseColumn withDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Get column Type.
     *
     * @return the columnType value
     */
    public String columnType() {
        return this.columnType;
    }

    /**
     * Set column Type.
     *
     * @param columnType the columnType value to set
     * @return the DataTableResponseColumn object itself.
     */
    public DataTableResponseColumn withColumnType(String columnType) {
        this.columnType = columnType;
        return this;
    }

}
