/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for RenderingType.
 */
public enum RenderingType {
    /** Enum value NoGraph. */
    NO_GRAPH("NoGraph"),

    /** Enum value Table. */
    TABLE("Table"),

    /** Enum value TimeSeries. */
    TIME_SERIES("TimeSeries"),

    /** Enum value TimeSeriesPerInstance. */
    TIME_SERIES_PER_INSTANCE("TimeSeriesPerInstance");

    /** The actual serialized value for a RenderingType instance. */
    private String value;

    RenderingType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a RenderingType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed RenderingType object, or null if unable to parse.
     */
    @JsonCreator
    public static RenderingType fromString(String value) {
        RenderingType[] items = RenderingType.values();
        for (RenderingType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
