/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Diagnostics.
 */
public class DiagnosticsInner {
    /** The Retrofit service to perform REST calls. */
    private DiagnosticsService service;
    /** The service client containing this operation class. */
    private WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of DiagnosticsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public DiagnosticsInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = retrofit.create(DiagnosticsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Diagnostics to be
     * used by Retrofit to perform actually REST calls.
     */
    interface DiagnosticsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listHostingEnvironmentDetectorResponses" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors")
        Observable<Response<ResponseBody>> listHostingEnvironmentDetectorResponses(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getHostingEnvironmentDetectorResponse" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/detectors/{detectorName}")
        Observable<Response<ResponseBody>> getHostingEnvironmentDetectorResponse(@Path("resourceGroupName") String resourceGroupName, @Path("name") String name, @Path("detectorName") String detectorName, @Path("subscriptionId") String subscriptionId, @Query("startTime") DateTime startTime, @Query("endTime") DateTime endTime, @Query("timeGrain") String timeGrain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorResponses" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors")
        Observable<Response<ResponseBody>> listSiteDetectorResponses(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDetectorResponse" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/detectors/{detectorName}")
        Observable<Response<ResponseBody>> getSiteDetectorResponse(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("detectorName") String detectorName, @Path("subscriptionId") String subscriptionId, @Query("startTime") DateTime startTime, @Query("endTime") DateTime endTime, @Query("timeGrain") String timeGrain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDiagnosticCategories" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics")
        Observable<Response<ResponseBody>> listSiteDiagnosticCategories(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDiagnosticCategory" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}")
        Observable<Response<ResponseBody>> getSiteDiagnosticCategory(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteAnalyses" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses")
        Observable<Response<ResponseBody>> listSiteAnalyses(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteAnalysis" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}")
        Observable<Response<ResponseBody>> getSiteAnalysis(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("analysisName") String analysisName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics executeSiteAnalysis" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute")
        Observable<Response<ResponseBody>> executeSiteAnalysis(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("analysisName") String analysisName, @Path("subscriptionId") String subscriptionId, @Query("startTime") DateTime startTime, @Query("endTime") DateTime endTime, @Query("timeGrain") String timeGrain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectors" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors")
        Observable<Response<ResponseBody>> listSiteDetectors(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDetector" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}")
        Observable<Response<ResponseBody>> getSiteDetector(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("detectorName") String detectorName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics executeSiteDetector" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute")
        Observable<Response<ResponseBody>> executeSiteDetector(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("detectorName") String detectorName, @Path("diagnosticCategory") String diagnosticCategory, @Path("subscriptionId") String subscriptionId, @Query("startTime") DateTime startTime, @Query("endTime") DateTime endTime, @Query("timeGrain") String timeGrain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorResponsesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors")
        Observable<Response<ResponseBody>> listSiteDetectorResponsesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDetectorResponseSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/detectors/{detectorName}")
        Observable<Response<ResponseBody>> getSiteDetectorResponseSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("detectorName") String detectorName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("startTime") DateTime startTime, @Query("endTime") DateTime endTime, @Query("timeGrain") String timeGrain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDiagnosticCategoriesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics")
        Observable<Response<ResponseBody>> listSiteDiagnosticCategoriesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDiagnosticCategorySlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}")
        Observable<Response<ResponseBody>> getSiteDiagnosticCategorySlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteAnalysesSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses")
        Observable<Response<ResponseBody>> listSiteAnalysesSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteAnalysisSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}")
        Observable<Response<ResponseBody>> getSiteAnalysisSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("analysisName") String analysisName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics executeSiteAnalysisSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute")
        Observable<Response<ResponseBody>> executeSiteAnalysisSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("analysisName") String analysisName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("startTime") DateTime startTime, @Query("endTime") DateTime endTime, @Query("timeGrain") String timeGrain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorsSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors")
        Observable<Response<ResponseBody>> listSiteDetectorsSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDetectorSlot" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}")
        Observable<Response<ResponseBody>> getSiteDetectorSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("diagnosticCategory") String diagnosticCategory, @Path("detectorName") String detectorName, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics executeSiteDetectorSlot" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute")
        Observable<Response<ResponseBody>> executeSiteDetectorSlot(@Path("resourceGroupName") String resourceGroupName, @Path("siteName") String siteName, @Path("detectorName") String detectorName, @Path("diagnosticCategory") String diagnosticCategory, @Path("slot") String slot, @Path("subscriptionId") String subscriptionId, @Query("startTime") DateTime startTime, @Query("endTime") DateTime endTime, @Query("timeGrain") String timeGrain, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listHostingEnvironmentDetectorResponsesNext" })
        @GET
        Observable<Response<ResponseBody>> listHostingEnvironmentDetectorResponsesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorResponsesNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteDetectorResponsesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDiagnosticCategoriesNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteDiagnosticCategoriesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteAnalysesNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteAnalysesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorsNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteDetectorsNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorResponsesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteDetectorResponsesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDiagnosticCategoriesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteDiagnosticCategoriesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteAnalysesSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteAnalysesSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorsSlotNext" })
        @GET
        Observable<Response<ResponseBody>> listSiteDetectorsSlotNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorResponseInner&gt; object if successful.
     */
    public PagedList<DetectorResponseInner> listHostingEnvironmentDetectorResponses(final String resourceGroupName, final String name) {
        ServiceResponse<Page<DetectorResponseInner>> response = listHostingEnvironmentDetectorResponsesSinglePageAsync(resourceGroupName, name).toBlocking().single();
        return new PagedList<DetectorResponseInner>(response.body()) {
            @Override
            public Page<DetectorResponseInner> nextPage(String nextPageLink) {
                return listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesAsync(final String resourceGroupName, final String name, final ListOperationCallback<DetectorResponseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listHostingEnvironmentDetectorResponsesSinglePageAsync(resourceGroupName, name),
            new Func1<String, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(String nextPageLink) {
                    return listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<Page<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesAsync(final String resourceGroupName, final String name) {
        return listHostingEnvironmentDetectorResponsesWithServiceResponseAsync(resourceGroupName, name)
            .map(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Page<DetectorResponseInner>>() {
                @Override
                public Page<DetectorResponseInner> call(ServiceResponse<Page<DetectorResponseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listHostingEnvironmentDetectorResponsesWithServiceResponseAsync(final String resourceGroupName, final String name) {
        return listHostingEnvironmentDetectorResponsesSinglePageAsync(resourceGroupName, name)
            .concatMap(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(ServiceResponse<Page<DetectorResponseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listHostingEnvironmentDetectorResponsesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param name Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorResponseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listHostingEnvironmentDetectorResponsesSinglePageAsync(final String resourceGroupName, final String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listHostingEnvironmentDetectorResponses(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorResponseInner>> result = listHostingEnvironmentDetectorResponsesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorResponseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorResponseInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorResponseInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Hosting Environment Detector Response.
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name
     * @param detectorName Detector Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DetectorResponseInner object if successful.
     */
    public DetectorResponseInner getHostingEnvironmentDetectorResponse(String resourceGroupName, String name, String detectorName) {
        return getHostingEnvironmentDetectorResponseWithServiceResponseAsync(resourceGroupName, name, detectorName).toBlocking().single().body();
    }

    /**
     * Get Hosting Environment Detector Response.
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name
     * @param detectorName Detector Resource Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DetectorResponseInner> getHostingEnvironmentDetectorResponseAsync(String resourceGroupName, String name, String detectorName, final ServiceCallback<DetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getHostingEnvironmentDetectorResponseWithServiceResponseAsync(resourceGroupName, name, detectorName), serviceCallback);
    }

    /**
     * Get Hosting Environment Detector Response.
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name
     * @param detectorName Detector Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<DetectorResponseInner> getHostingEnvironmentDetectorResponseAsync(String resourceGroupName, String name, String detectorName) {
        return getHostingEnvironmentDetectorResponseWithServiceResponseAsync(resourceGroupName, name, detectorName).map(new Func1<ServiceResponse<DetectorResponseInner>, DetectorResponseInner>() {
            @Override
            public DetectorResponseInner call(ServiceResponse<DetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Hosting Environment Detector Response.
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name
     * @param detectorName Detector Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<ServiceResponse<DetectorResponseInner>> getHostingEnvironmentDetectorResponseWithServiceResponseAsync(String resourceGroupName, String name, String detectorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startTime = null;
        final DateTime endTime = null;
        final String timeGrain = null;
        return service.getHostingEnvironmentDetectorResponse(resourceGroupName, name, detectorName, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DetectorResponseInner> clientResponse = getHostingEnvironmentDetectorResponseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get Hosting Environment Detector Response.
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name
     * @param detectorName Detector Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DetectorResponseInner object if successful.
     */
    public DetectorResponseInner getHostingEnvironmentDetectorResponse(String resourceGroupName, String name, String detectorName, DateTime startTime, DateTime endTime, String timeGrain) {
        return getHostingEnvironmentDetectorResponseWithServiceResponseAsync(resourceGroupName, name, detectorName, startTime, endTime, timeGrain).toBlocking().single().body();
    }

    /**
     * Get Hosting Environment Detector Response.
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name
     * @param detectorName Detector Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DetectorResponseInner> getHostingEnvironmentDetectorResponseAsync(String resourceGroupName, String name, String detectorName, DateTime startTime, DateTime endTime, String timeGrain, final ServiceCallback<DetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getHostingEnvironmentDetectorResponseWithServiceResponseAsync(resourceGroupName, name, detectorName, startTime, endTime, timeGrain), serviceCallback);
    }

    /**
     * Get Hosting Environment Detector Response.
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name
     * @param detectorName Detector Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<DetectorResponseInner> getHostingEnvironmentDetectorResponseAsync(String resourceGroupName, String name, String detectorName, DateTime startTime, DateTime endTime, String timeGrain) {
        return getHostingEnvironmentDetectorResponseWithServiceResponseAsync(resourceGroupName, name, detectorName, startTime, endTime, timeGrain).map(new Func1<ServiceResponse<DetectorResponseInner>, DetectorResponseInner>() {
            @Override
            public DetectorResponseInner call(ServiceResponse<DetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Hosting Environment Detector Response.
     * Description for Get Hosting Environment Detector Response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name App Service Environment Name
     * @param detectorName Detector Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<ServiceResponse<DetectorResponseInner>> getHostingEnvironmentDetectorResponseWithServiceResponseAsync(String resourceGroupName, String name, String detectorName, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getHostingEnvironmentDetectorResponse(resourceGroupName, name, detectorName, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DetectorResponseInner> clientResponse = getHostingEnvironmentDetectorResponseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DetectorResponseInner> getHostingEnvironmentDetectorResponseDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DetectorResponseInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DetectorResponseInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorResponseInner&gt; object if successful.
     */
    public PagedList<DetectorResponseInner> listSiteDetectorResponses(final String resourceGroupName, final String siteName) {
        ServiceResponse<Page<DetectorResponseInner>> response = listSiteDetectorResponsesSinglePageAsync(resourceGroupName, siteName).toBlocking().single();
        return new PagedList<DetectorResponseInner>(response.body()) {
            @Override
            public Page<DetectorResponseInner> nextPage(String nextPageLink) {
                return listSiteDetectorResponsesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorResponseInner>> listSiteDetectorResponsesAsync(final String resourceGroupName, final String siteName, final ListOperationCallback<DetectorResponseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDetectorResponsesSinglePageAsync(resourceGroupName, siteName),
            new Func1<String, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(String nextPageLink) {
                    return listSiteDetectorResponsesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<Page<DetectorResponseInner>> listSiteDetectorResponsesAsync(final String resourceGroupName, final String siteName) {
        return listSiteDetectorResponsesWithServiceResponseAsync(resourceGroupName, siteName)
            .map(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Page<DetectorResponseInner>>() {
                @Override
                public Page<DetectorResponseInner> call(ServiceResponse<Page<DetectorResponseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listSiteDetectorResponsesWithServiceResponseAsync(final String resourceGroupName, final String siteName) {
        return listSiteDetectorResponsesSinglePageAsync(resourceGroupName, siteName)
            .concatMap(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(ServiceResponse<Page<DetectorResponseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDetectorResponsesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param siteName Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorResponseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listSiteDetectorResponsesSinglePageAsync(final String resourceGroupName, final String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSiteDetectorResponses(resourceGroupName, siteName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorResponseInner>> result = listSiteDetectorResponsesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorResponseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorResponseInner>> listSiteDetectorResponsesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorResponseInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorResponseInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DetectorResponseInner object if successful.
     */
    public DetectorResponseInner getSiteDetectorResponse(String resourceGroupName, String siteName, String detectorName) {
        return getSiteDetectorResponseWithServiceResponseAsync(resourceGroupName, siteName, detectorName).toBlocking().single().body();
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DetectorResponseInner> getSiteDetectorResponseAsync(String resourceGroupName, String siteName, String detectorName, final ServiceCallback<DetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteDetectorResponseWithServiceResponseAsync(resourceGroupName, siteName, detectorName), serviceCallback);
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<DetectorResponseInner> getSiteDetectorResponseAsync(String resourceGroupName, String siteName, String detectorName) {
        return getSiteDetectorResponseWithServiceResponseAsync(resourceGroupName, siteName, detectorName).map(new Func1<ServiceResponse<DetectorResponseInner>, DetectorResponseInner>() {
            @Override
            public DetectorResponseInner call(ServiceResponse<DetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<ServiceResponse<DetectorResponseInner>> getSiteDetectorResponseWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startTime = null;
        final DateTime endTime = null;
        final String timeGrain = null;
        return service.getSiteDetectorResponse(resourceGroupName, siteName, detectorName, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DetectorResponseInner> clientResponse = getSiteDetectorResponseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DetectorResponseInner object if successful.
     */
    public DetectorResponseInner getSiteDetectorResponse(String resourceGroupName, String siteName, String detectorName, DateTime startTime, DateTime endTime, String timeGrain) {
        return getSiteDetectorResponseWithServiceResponseAsync(resourceGroupName, siteName, detectorName, startTime, endTime, timeGrain).toBlocking().single().body();
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DetectorResponseInner> getSiteDetectorResponseAsync(String resourceGroupName, String siteName, String detectorName, DateTime startTime, DateTime endTime, String timeGrain, final ServiceCallback<DetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteDetectorResponseWithServiceResponseAsync(resourceGroupName, siteName, detectorName, startTime, endTime, timeGrain), serviceCallback);
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<DetectorResponseInner> getSiteDetectorResponseAsync(String resourceGroupName, String siteName, String detectorName, DateTime startTime, DateTime endTime, String timeGrain) {
        return getSiteDetectorResponseWithServiceResponseAsync(resourceGroupName, siteName, detectorName, startTime, endTime, timeGrain).map(new Func1<ServiceResponse<DetectorResponseInner>, DetectorResponseInner>() {
            @Override
            public DetectorResponseInner call(ServiceResponse<DetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<ServiceResponse<DetectorResponseInner>> getSiteDetectorResponseWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSiteDetectorResponse(resourceGroupName, siteName, detectorName, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DetectorResponseInner> clientResponse = getSiteDetectorResponseDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DetectorResponseInner> getSiteDetectorResponseDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DetectorResponseInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DetectorResponseInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiagnosticCategoryInner&gt; object if successful.
     */
    public PagedList<DiagnosticCategoryInner> listSiteDiagnosticCategories(final String resourceGroupName, final String siteName) {
        ServiceResponse<Page<DiagnosticCategoryInner>> response = listSiteDiagnosticCategoriesSinglePageAsync(resourceGroupName, siteName).toBlocking().single();
        return new PagedList<DiagnosticCategoryInner>(response.body()) {
            @Override
            public Page<DiagnosticCategoryInner> nextPage(String nextPageLink) {
                return listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesAsync(final String resourceGroupName, final String siteName, final ListOperationCallback<DiagnosticCategoryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDiagnosticCategoriesSinglePageAsync(resourceGroupName, siteName),
            new Func1<String, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(String nextPageLink) {
                    return listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiagnosticCategoryInner&gt; object
     */
    public Observable<Page<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesAsync(final String resourceGroupName, final String siteName) {
        return listSiteDiagnosticCategoriesWithServiceResponseAsync(resourceGroupName, siteName)
            .map(new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Page<DiagnosticCategoryInner>>() {
                @Override
                public Page<DiagnosticCategoryInner> call(ServiceResponse<Page<DiagnosticCategoryInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiagnosticCategoryInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesWithServiceResponseAsync(final String resourceGroupName, final String siteName) {
        return listSiteDiagnosticCategoriesSinglePageAsync(resourceGroupName, siteName)
            .concatMap(new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(ServiceResponse<Page<DiagnosticCategoryInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDiagnosticCategoriesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
    ServiceResponse<PageImpl<DiagnosticCategoryInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<DiagnosticCategoryInner>> * @param siteName Site Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiagnosticCategoryInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSinglePageAsync(final String resourceGroupName, final String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSiteDiagnosticCategories(resourceGroupName, siteName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DiagnosticCategoryInner>> result = listSiteDiagnosticCategoriesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiagnosticCategoryInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DiagnosticCategoryInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DiagnosticCategoryInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Diagnostics Category.
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticCategoryInner object if successful.
     */
    public DiagnosticCategoryInner getSiteDiagnosticCategory(String resourceGroupName, String siteName, String diagnosticCategory) {
        return getSiteDiagnosticCategoryWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory).toBlocking().single().body();
    }

    /**
     * Get Diagnostics Category.
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticCategoryInner> getSiteDiagnosticCategoryAsync(String resourceGroupName, String siteName, String diagnosticCategory, final ServiceCallback<DiagnosticCategoryInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteDiagnosticCategoryWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory), serviceCallback);
    }

    /**
     * Get Diagnostics Category.
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticCategoryInner object
     */
    public Observable<DiagnosticCategoryInner> getSiteDiagnosticCategoryAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        return getSiteDiagnosticCategoryWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory).map(new Func1<ServiceResponse<DiagnosticCategoryInner>, DiagnosticCategoryInner>() {
            @Override
            public DiagnosticCategoryInner call(ServiceResponse<DiagnosticCategoryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Diagnostics Category.
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticCategoryInner object
     */
    public Observable<ServiceResponse<DiagnosticCategoryInner>> getSiteDiagnosticCategoryWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSiteDiagnosticCategory(resourceGroupName, siteName, diagnosticCategory, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticCategoryInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticCategoryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticCategoryInner> clientResponse = getSiteDiagnosticCategoryDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiagnosticCategoryInner> getSiteDiagnosticCategoryDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiagnosticCategoryInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiagnosticCategoryInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AnalysisDefinitionInner&gt; object if successful.
     */
    public PagedList<AnalysisDefinitionInner> listSiteAnalyses(final String resourceGroupName, final String siteName, final String diagnosticCategory) {
        ServiceResponse<Page<AnalysisDefinitionInner>> response = listSiteAnalysesSinglePageAsync(resourceGroupName, siteName, diagnosticCategory).toBlocking().single();
        return new PagedList<AnalysisDefinitionInner>(response.body()) {
            @Override
            public Page<AnalysisDefinitionInner> nextPage(String nextPageLink) {
                return listSiteAnalysesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AnalysisDefinitionInner>> listSiteAnalysesAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final ListOperationCallback<AnalysisDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteAnalysesSinglePageAsync(resourceGroupName, siteName, diagnosticCategory),
            new Func1<String, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(String nextPageLink) {
                    return listSiteAnalysesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AnalysisDefinitionInner&gt; object
     */
    public Observable<Page<AnalysisDefinitionInner>> listSiteAnalysesAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory) {
        return listSiteAnalysesWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory)
            .map(new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Page<AnalysisDefinitionInner>>() {
                @Override
                public Page<AnalysisDefinitionInner> call(ServiceResponse<Page<AnalysisDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AnalysisDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesWithServiceResponseAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory) {
        return listSiteAnalysesSinglePageAsync(resourceGroupName, siteName, diagnosticCategory)
            .concatMap(new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(ServiceResponse<Page<AnalysisDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteAnalysesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param siteName Site Name
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AnalysisDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSinglePageAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSiteAnalyses(resourceGroupName, siteName, diagnosticCategory, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AnalysisDefinitionInner>> result = listSiteAnalysesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AnalysisDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AnalysisDefinitionInner>> listSiteAnalysesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AnalysisDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AnalysisDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Site Analysis.
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param analysisName Analysis Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AnalysisDefinitionInner object if successful.
     */
    public AnalysisDefinitionInner getSiteAnalysis(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return getSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).toBlocking().single().body();
    }

    /**
     * Get Site Analysis.
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param analysisName Analysis Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AnalysisDefinitionInner> getSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, final ServiceCallback<AnalysisDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName), serviceCallback);
    }

    /**
     * Get Site Analysis.
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param analysisName Analysis Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AnalysisDefinitionInner object
     */
    public Observable<AnalysisDefinitionInner> getSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return getSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).map(new Func1<ServiceResponse<AnalysisDefinitionInner>, AnalysisDefinitionInner>() {
            @Override
            public AnalysisDefinitionInner call(ServiceResponse<AnalysisDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Site Analysis.
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param analysisName Analysis Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AnalysisDefinitionInner object
     */
    public Observable<ServiceResponse<AnalysisDefinitionInner>> getSiteAnalysisWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSiteAnalysis(resourceGroupName, siteName, diagnosticCategory, analysisName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AnalysisDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<AnalysisDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AnalysisDefinitionInner> clientResponse = getSiteAnalysisDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AnalysisDefinitionInner> getSiteAnalysisDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AnalysisDefinitionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AnalysisDefinitionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticAnalysisInner object if successful.
     */
    public DiagnosticAnalysisInner executeSiteAnalysis(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).toBlocking().single().body();
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticAnalysisInner> executeSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, final ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName), serviceCallback);
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticAnalysisInner object
     */
    public Observable<DiagnosticAnalysisInner> executeSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).map(new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>() {
            @Override
            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticAnalysisInner object
     */
    public Observable<ServiceResponse<DiagnosticAnalysisInner>> executeSiteAnalysisWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startTime = null;
        final DateTime endTime = null;
        final String timeGrain = null;
        return service.executeSiteAnalysis(resourceGroupName, siteName, diagnosticCategory, analysisName, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticAnalysisInner> clientResponse = executeSiteAnalysisDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticAnalysisInner object if successful.
     */
    public DiagnosticAnalysisInner executeSiteAnalysis(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, DateTime startTime, DateTime endTime, String timeGrain) {
        return executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain).toBlocking().single().body();
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticAnalysisInner> executeSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, DateTime startTime, DateTime endTime, String timeGrain, final ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain), serviceCallback);
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticAnalysisInner object
     */
    public Observable<DiagnosticAnalysisInner> executeSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, DateTime startTime, DateTime endTime, String timeGrain) {
        return executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain).map(new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>() {
            @Override
            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticAnalysisInner object
     */
    public Observable<ServiceResponse<DiagnosticAnalysisInner>> executeSiteAnalysisWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.executeSiteAnalysis(resourceGroupName, siteName, diagnosticCategory, analysisName, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticAnalysisInner> clientResponse = executeSiteAnalysisDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiagnosticAnalysisInner> executeSiteAnalysisDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiagnosticAnalysisInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiagnosticAnalysisInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorDefinitionInner&gt; object if successful.
     */
    public PagedList<DetectorDefinitionInner> listSiteDetectors(final String resourceGroupName, final String siteName, final String diagnosticCategory) {
        ServiceResponse<Page<DetectorDefinitionInner>> response = listSiteDetectorsSinglePageAsync(resourceGroupName, siteName, diagnosticCategory).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>(response.body()) {
            @Override
            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return listSiteDetectorsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorDefinitionInner>> listSiteDetectorsAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDetectorsSinglePageAsync(resourceGroupName, siteName, diagnosticCategory),
            new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                    return listSiteDetectorsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorDefinitionInner&gt; object
     */
    public Observable<Page<DetectorDefinitionInner>> listSiteDetectorsAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory) {
        return listSiteDetectorsWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory)
            .map(new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>() {
                @Override
                public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsWithServiceResponseAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory) {
        return listSiteDetectorsSinglePageAsync(resourceGroupName, siteName, diagnosticCategory)
            .concatMap(new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDetectorsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param siteName Site Name
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param diagnosticCategory Diagnostic Category
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSinglePageAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSiteDetectors(resourceGroupName, siteName, diagnosticCategory, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorDefinitionInner>> result = listSiteDetectorsDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> listSiteDetectorsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Detector.
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param detectorName Detector Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DetectorDefinitionInner object if successful.
     */
    public DetectorDefinitionInner getSiteDetector(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        return getSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName).toBlocking().single().body();
    }

    /**
     * Get Detector.
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param detectorName Detector Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DetectorDefinitionInner> getSiteDetectorAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, final ServiceCallback<DetectorDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName), serviceCallback);
    }

    /**
     * Get Detector.
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param detectorName Detector Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorDefinitionInner object
     */
    public Observable<DetectorDefinitionInner> getSiteDetectorAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        return getSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName).map(new Func1<ServiceResponse<DetectorDefinitionInner>, DetectorDefinitionInner>() {
            @Override
            public DetectorDefinitionInner call(ServiceResponse<DetectorDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Detector.
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param detectorName Detector Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorDefinitionInner object
     */
    public Observable<ServiceResponse<DetectorDefinitionInner>> getSiteDetectorWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSiteDetector(resourceGroupName, siteName, diagnosticCategory, detectorName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DetectorDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<DetectorDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DetectorDefinitionInner> clientResponse = getSiteDetectorDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DetectorDefinitionInner> getSiteDetectorDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DetectorDefinitionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DetectorDefinitionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticDetectorResponseInner object if successful.
     */
    public DiagnosticDetectorResponseInner executeSiteDetector(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory) {
        return executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory).toBlocking().single().body();
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, final ServiceCallback<DiagnosticDetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory), serviceCallback);
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticDetectorResponseInner object
     */
    public Observable<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory) {
        return executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory).map(new Func1<ServiceResponse<DiagnosticDetectorResponseInner>, DiagnosticDetectorResponseInner>() {
            @Override
            public DiagnosticDetectorResponseInner call(ServiceResponse<DiagnosticDetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticDetectorResponseInner object
     */
    public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> executeSiteDetectorWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startTime = null;
        final DateTime endTime = null;
        final String timeGrain = null;
        return service.executeSiteDetector(resourceGroupName, siteName, detectorName, diagnosticCategory, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticDetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticDetectorResponseInner> clientResponse = executeSiteDetectorDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticDetectorResponseInner object if successful.
     */
    public DiagnosticDetectorResponseInner executeSiteDetector(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, DateTime startTime, DateTime endTime, String timeGrain) {
        return executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain).toBlocking().single().body();
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, DateTime startTime, DateTime endTime, String timeGrain, final ServiceCallback<DiagnosticDetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain), serviceCallback);
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticDetectorResponseInner object
     */
    public Observable<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, DateTime startTime, DateTime endTime, String timeGrain) {
        return executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain).map(new Func1<ServiceResponse<DiagnosticDetectorResponseInner>, DiagnosticDetectorResponseInner>() {
            @Override
            public DiagnosticDetectorResponseInner call(ServiceResponse<DiagnosticDetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticDetectorResponseInner object
     */
    public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> executeSiteDetectorWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.executeSiteDetector(resourceGroupName, siteName, detectorName, diagnosticCategory, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticDetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticDetectorResponseInner> clientResponse = executeSiteDetectorDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiagnosticDetectorResponseInner> executeSiteDetectorDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiagnosticDetectorResponseInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiagnosticDetectorResponseInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorResponseInner&gt; object if successful.
     */
    public PagedList<DetectorResponseInner> listSiteDetectorResponsesSlot(final String resourceGroupName, final String siteName, final String slot) {
        ServiceResponse<Page<DetectorResponseInner>> response = listSiteDetectorResponsesSlotSinglePageAsync(resourceGroupName, siteName, slot).toBlocking().single();
        return new PagedList<DetectorResponseInner>(response.body()) {
            @Override
            public Page<DetectorResponseInner> nextPage(String nextPageLink) {
                return listSiteDetectorResponsesSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorResponseInner>> listSiteDetectorResponsesSlotAsync(final String resourceGroupName, final String siteName, final String slot, final ListOperationCallback<DetectorResponseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDetectorResponsesSlotSinglePageAsync(resourceGroupName, siteName, slot),
            new Func1<String, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(String nextPageLink) {
                    return listSiteDetectorResponsesSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<Page<DetectorResponseInner>> listSiteDetectorResponsesSlotAsync(final String resourceGroupName, final String siteName, final String slot) {
        return listSiteDetectorResponsesSlotWithServiceResponseAsync(resourceGroupName, siteName, slot)
            .map(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Page<DetectorResponseInner>>() {
                @Override
                public Page<DetectorResponseInner> call(ServiceResponse<Page<DetectorResponseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listSiteDetectorResponsesSlotWithServiceResponseAsync(final String resourceGroupName, final String siteName, final String slot) {
        return listSiteDetectorResponsesSlotSinglePageAsync(resourceGroupName, siteName, slot)
            .concatMap(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(ServiceResponse<Page<DetectorResponseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDetectorResponsesSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param siteName Site Name
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorResponseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listSiteDetectorResponsesSlotSinglePageAsync(final String resourceGroupName, final String siteName, final String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSiteDetectorResponsesSlot(resourceGroupName, siteName, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorResponseInner>> result = listSiteDetectorResponsesSlotDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorResponseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorResponseInner>> listSiteDetectorResponsesSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorResponseInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorResponseInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DetectorResponseInner object if successful.
     */
    public DetectorResponseInner getSiteDetectorResponseSlot(String resourceGroupName, String siteName, String detectorName, String slot) {
        return getSiteDetectorResponseSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, slot).toBlocking().single().body();
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DetectorResponseInner> getSiteDetectorResponseSlotAsync(String resourceGroupName, String siteName, String detectorName, String slot, final ServiceCallback<DetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteDetectorResponseSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, slot), serviceCallback);
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<DetectorResponseInner> getSiteDetectorResponseSlotAsync(String resourceGroupName, String siteName, String detectorName, String slot) {
        return getSiteDetectorResponseSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, slot).map(new Func1<ServiceResponse<DetectorResponseInner>, DetectorResponseInner>() {
            @Override
            public DetectorResponseInner call(ServiceResponse<DetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<ServiceResponse<DetectorResponseInner>> getSiteDetectorResponseSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startTime = null;
        final DateTime endTime = null;
        final String timeGrain = null;
        return service.getSiteDetectorResponseSlot(resourceGroupName, siteName, detectorName, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DetectorResponseInner> clientResponse = getSiteDetectorResponseSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DetectorResponseInner object if successful.
     */
    public DetectorResponseInner getSiteDetectorResponseSlot(String resourceGroupName, String siteName, String detectorName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return getSiteDetectorResponseSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, slot, startTime, endTime, timeGrain).toBlocking().single().body();
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DetectorResponseInner> getSiteDetectorResponseSlotAsync(String resourceGroupName, String siteName, String detectorName, String slot, DateTime startTime, DateTime endTime, String timeGrain, final ServiceCallback<DetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteDetectorResponseSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, slot, startTime, endTime, timeGrain), serviceCallback);
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<DetectorResponseInner> getSiteDetectorResponseSlotAsync(String resourceGroupName, String siteName, String detectorName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return getSiteDetectorResponseSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, slot, startTime, endTime, timeGrain).map(new Func1<ServiceResponse<DetectorResponseInner>, DetectorResponseInner>() {
            @Override
            public DetectorResponseInner call(ServiceResponse<DetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get site detector response.
     * Description for Get site detector response.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorResponseInner object
     */
    public Observable<ServiceResponse<DetectorResponseInner>> getSiteDetectorResponseSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSiteDetectorResponseSlot(resourceGroupName, siteName, detectorName, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DetectorResponseInner> clientResponse = getSiteDetectorResponseSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DetectorResponseInner> getSiteDetectorResponseSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DetectorResponseInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DetectorResponseInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiagnosticCategoryInner&gt; object if successful.
     */
    public PagedList<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlot(final String resourceGroupName, final String siteName, final String slot) {
        ServiceResponse<Page<DiagnosticCategoryInner>> response = listSiteDiagnosticCategoriesSlotSinglePageAsync(resourceGroupName, siteName, slot).toBlocking().single();
        return new PagedList<DiagnosticCategoryInner>(response.body()) {
            @Override
            public Page<DiagnosticCategoryInner> nextPage(String nextPageLink) {
                return listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotAsync(final String resourceGroupName, final String siteName, final String slot, final ListOperationCallback<DiagnosticCategoryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDiagnosticCategoriesSlotSinglePageAsync(resourceGroupName, siteName, slot),
            new Func1<String, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(String nextPageLink) {
                    return listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiagnosticCategoryInner&gt; object
     */
    public Observable<Page<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotAsync(final String resourceGroupName, final String siteName, final String slot) {
        return listSiteDiagnosticCategoriesSlotWithServiceResponseAsync(resourceGroupName, siteName, slot)
            .map(new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Page<DiagnosticCategoryInner>>() {
                @Override
                public Page<DiagnosticCategoryInner> call(ServiceResponse<Page<DiagnosticCategoryInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiagnosticCategoryInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSlotWithServiceResponseAsync(final String resourceGroupName, final String siteName, final String slot) {
        return listSiteDiagnosticCategoriesSlotSinglePageAsync(resourceGroupName, siteName, slot)
            .concatMap(new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(ServiceResponse<Page<DiagnosticCategoryInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDiagnosticCategoriesSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
    ServiceResponse<PageImpl<DiagnosticCategoryInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<DiagnosticCategoryInner>> * @param siteName Site Name
    ServiceResponse<PageImpl<DiagnosticCategoryInner>> * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiagnosticCategoryInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSlotSinglePageAsync(final String resourceGroupName, final String siteName, final String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSiteDiagnosticCategoriesSlot(resourceGroupName, siteName, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DiagnosticCategoryInner>> result = listSiteDiagnosticCategoriesSlotDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiagnosticCategoryInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DiagnosticCategoryInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DiagnosticCategoryInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Diagnostics Category.
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticCategoryInner object if successful.
     */
    public DiagnosticCategoryInner getSiteDiagnosticCategorySlot(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return getSiteDiagnosticCategorySlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot).toBlocking().single().body();
    }

    /**
     * Get Diagnostics Category.
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot, final ServiceCallback<DiagnosticCategoryInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteDiagnosticCategorySlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot), serviceCallback);
    }

    /**
     * Get Diagnostics Category.
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticCategoryInner object
     */
    public Observable<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return getSiteDiagnosticCategorySlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot).map(new Func1<ServiceResponse<DiagnosticCategoryInner>, DiagnosticCategoryInner>() {
            @Override
            public DiagnosticCategoryInner call(ServiceResponse<DiagnosticCategoryInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Diagnostics Category.
     * Description for Get Diagnostics Category.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticCategoryInner object
     */
    public Observable<ServiceResponse<DiagnosticCategoryInner>> getSiteDiagnosticCategorySlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSiteDiagnosticCategorySlot(resourceGroupName, siteName, diagnosticCategory, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticCategoryInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticCategoryInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticCategoryInner> clientResponse = getSiteDiagnosticCategorySlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiagnosticCategoryInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiagnosticCategoryInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AnalysisDefinitionInner&gt; object if successful.
     */
    public PagedList<AnalysisDefinitionInner> listSiteAnalysesSlot(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot) {
        ServiceResponse<Page<AnalysisDefinitionInner>> response = listSiteAnalysesSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot).toBlocking().single();
        return new PagedList<AnalysisDefinitionInner>(response.body()) {
            @Override
            public Page<AnalysisDefinitionInner> nextPage(String nextPageLink) {
                return listSiteAnalysesSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AnalysisDefinitionInner>> listSiteAnalysesSlotAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot, final ListOperationCallback<AnalysisDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteAnalysesSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot),
            new Func1<String, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(String nextPageLink) {
                    return listSiteAnalysesSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AnalysisDefinitionInner&gt; object
     */
    public Observable<Page<AnalysisDefinitionInner>> listSiteAnalysesSlotAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot) {
        return listSiteAnalysesSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot)
            .map(new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Page<AnalysisDefinitionInner>>() {
                @Override
                public Page<AnalysisDefinitionInner> call(ServiceResponse<Page<AnalysisDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AnalysisDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSlotWithServiceResponseAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot) {
        return listSiteAnalysesSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot)
            .concatMap(new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(ServiceResponse<Page<AnalysisDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteAnalysesSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param siteName Site Name
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param diagnosticCategory Diagnostic Category
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AnalysisDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSlotSinglePageAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSiteAnalysesSlot(resourceGroupName, siteName, diagnosticCategory, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AnalysisDefinitionInner>> result = listSiteAnalysesSlotDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AnalysisDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AnalysisDefinitionInner>> listSiteAnalysesSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AnalysisDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AnalysisDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Site Analysis.
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param analysisName Analysis Name
     * @param slot Slot - optional
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the AnalysisDefinitionInner object if successful.
     */
    public AnalysisDefinitionInner getSiteAnalysisSlot(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return getSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).toBlocking().single().body();
    }

    /**
     * Get Site Analysis.
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param analysisName Analysis Name
     * @param slot Slot - optional
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<AnalysisDefinitionInner> getSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, final ServiceCallback<AnalysisDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot), serviceCallback);
    }

    /**
     * Get Site Analysis.
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param analysisName Analysis Name
     * @param slot Slot - optional
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AnalysisDefinitionInner object
     */
    public Observable<AnalysisDefinitionInner> getSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return getSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).map(new Func1<ServiceResponse<AnalysisDefinitionInner>, AnalysisDefinitionInner>() {
            @Override
            public AnalysisDefinitionInner call(ServiceResponse<AnalysisDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Site Analysis.
     * Description for Get Site Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param analysisName Analysis Name
     * @param slot Slot - optional
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the AnalysisDefinitionInner object
     */
    public Observable<ServiceResponse<AnalysisDefinitionInner>> getSiteAnalysisSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSiteAnalysisSlot(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<AnalysisDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<AnalysisDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<AnalysisDefinitionInner> clientResponse = getSiteAnalysisSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<AnalysisDefinitionInner> getSiteAnalysisSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<AnalysisDefinitionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<AnalysisDefinitionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticAnalysisInner object if successful.
     */
    public DiagnosticAnalysisInner executeSiteAnalysisSlot(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).toBlocking().single().body();
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, final ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot), serviceCallback);
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticAnalysisInner object
     */
    public Observable<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).map(new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>() {
            @Override
            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticAnalysisInner object
     */
    public Observable<ServiceResponse<DiagnosticAnalysisInner>> executeSiteAnalysisSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startTime = null;
        final DateTime endTime = null;
        final String timeGrain = null;
        return service.executeSiteAnalysisSlot(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticAnalysisInner> clientResponse = executeSiteAnalysisSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticAnalysisInner object if successful.
     */
    public DiagnosticAnalysisInner executeSiteAnalysisSlot(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain).toBlocking().single().body();
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, DateTime startTime, DateTime endTime, String timeGrain, final ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain), serviceCallback);
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticAnalysisInner object
     */
    public Observable<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain).map(new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>() {
            @Override
            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Execute Analysis.
     * Description for Execute Analysis.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Category Name
     * @param analysisName Analysis Resource Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticAnalysisInner object
     */
    public Observable<ServiceResponse<DiagnosticAnalysisInner>> executeSiteAnalysisSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.executeSiteAnalysisSlot(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticAnalysisInner> clientResponse = executeSiteAnalysisSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiagnosticAnalysisInner> executeSiteAnalysisSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiagnosticAnalysisInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiagnosticAnalysisInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorDefinitionInner&gt; object if successful.
     */
    public PagedList<DetectorDefinitionInner> listSiteDetectorsSlot(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot) {
        ServiceResponse<Page<DetectorDefinitionInner>> response = listSiteDetectorsSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>(response.body()) {
            @Override
            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return listSiteDetectorsSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorDefinitionInner>> listSiteDetectorsSlotAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot, final ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDetectorsSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot),
            new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                    return listSiteDetectorsSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorDefinitionInner&gt; object
     */
    public Observable<Page<DetectorDefinitionInner>> listSiteDetectorsSlotAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot) {
        return listSiteDetectorsSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot)
            .map(new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>() {
                @Override
                public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSlotWithServiceResponseAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot) {
        return listSiteDetectorsSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot)
            .concatMap(new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDetectorsSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param siteName Site Name
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param diagnosticCategory Diagnostic Category
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSlotSinglePageAsync(final String resourceGroupName, final String siteName, final String diagnosticCategory, final String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listSiteDetectorsSlot(resourceGroupName, siteName, diagnosticCategory, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorDefinitionInner>> result = listSiteDetectorsSlotDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> listSiteDetectorsSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Detector.
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param detectorName Detector Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DetectorDefinitionInner object if successful.
     */
    public DetectorDefinitionInner getSiteDetectorSlot(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        return getSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot).toBlocking().single().body();
    }

    /**
     * Get Detector.
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param detectorName Detector Name
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DetectorDefinitionInner> getSiteDetectorSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot, final ServiceCallback<DetectorDefinitionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot), serviceCallback);
    }

    /**
     * Get Detector.
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param detectorName Detector Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorDefinitionInner object
     */
    public Observable<DetectorDefinitionInner> getSiteDetectorSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        return getSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot).map(new Func1<ServiceResponse<DetectorDefinitionInner>, DetectorDefinitionInner>() {
            @Override
            public DetectorDefinitionInner call(ServiceResponse<DetectorDefinitionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get Detector.
     * Description for Get Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param diagnosticCategory Diagnostic Category
     * @param detectorName Detector Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DetectorDefinitionInner object
     */
    public Observable<ServiceResponse<DetectorDefinitionInner>> getSiteDetectorSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.getSiteDetectorSlot(resourceGroupName, siteName, diagnosticCategory, detectorName, slot, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DetectorDefinitionInner>>>() {
                @Override
                public Observable<ServiceResponse<DetectorDefinitionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DetectorDefinitionInner> clientResponse = getSiteDetectorSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DetectorDefinitionInner> getSiteDetectorSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DetectorDefinitionInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DetectorDefinitionInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticDetectorResponseInner object if successful.
     */
    public DiagnosticDetectorResponseInner executeSiteDetectorSlot(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot) {
        return executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot).toBlocking().single().body();
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param slot Slot Name
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, final ServiceCallback<DiagnosticDetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot), serviceCallback);
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticDetectorResponseInner object
     */
    public Observable<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot) {
        return executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot).map(new Func1<ServiceResponse<DiagnosticDetectorResponseInner>, DiagnosticDetectorResponseInner>() {
            @Override
            public DiagnosticDetectorResponseInner call(ServiceResponse<DiagnosticDetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param slot Slot Name
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticDetectorResponseInner object
     */
    public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> executeSiteDetectorSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final DateTime startTime = null;
        final DateTime endTime = null;
        final String timeGrain = null;
        return service.executeSiteDetectorSlot(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticDetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticDetectorResponseInner> clientResponse = executeSiteDetectorSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the DiagnosticDetectorResponseInner object if successful.
     */
    public DiagnosticDetectorResponseInner executeSiteDetectorSlot(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain).toBlocking().single().body();
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, DateTime startTime, DateTime endTime, String timeGrain, final ServiceCallback<DiagnosticDetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain), serviceCallback);
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticDetectorResponseInner object
     */
    public Observable<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain).map(new Func1<ServiceResponse<DiagnosticDetectorResponseInner>, DiagnosticDetectorResponseInner>() {
            @Override
            public DiagnosticDetectorResponseInner call(ServiceResponse<DiagnosticDetectorResponseInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Execute Detector.
     * Description for Execute Detector.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site Name
     * @param detectorName Detector Resource Name
     * @param diagnosticCategory Category Name
     * @param slot Slot Name
     * @param startTime Start Time
     * @param endTime End Time
     * @param timeGrain Time Grain
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the DiagnosticDetectorResponseInner object
     */
    public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> executeSiteDetectorSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.executeSiteDetectorSlot(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticDetectorResponseInner>>>() {
                @Override
                public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<DiagnosticDetectorResponseInner> clientResponse = executeSiteDetectorSlotDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<DiagnosticDetectorResponseInner> executeSiteDetectorSlotDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<DiagnosticDetectorResponseInner, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<DiagnosticDetectorResponseInner>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorResponseInner&gt; object if successful.
     */
    public PagedList<DetectorResponseInner> listHostingEnvironmentDetectorResponsesNext(final String nextPageLink) {
        ServiceResponse<Page<DetectorResponseInner>> response = listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorResponseInner>(response.body()) {
            @Override
            public Page<DetectorResponseInner> nextPage(String nextPageLink) {
                return listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesNextAsync(final String nextPageLink, final ServiceFuture<List<DetectorResponseInner>> serviceFuture, final ListOperationCallback<DetectorResponseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(String nextPageLink) {
                    return listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<Page<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesNextAsync(final String nextPageLink) {
        return listHostingEnvironmentDetectorResponsesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Page<DetectorResponseInner>>() {
                @Override
                public Page<DetectorResponseInner> call(ServiceResponse<Page<DetectorResponseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listHostingEnvironmentDetectorResponsesNextWithServiceResponseAsync(final String nextPageLink) {
        return listHostingEnvironmentDetectorResponsesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(ServiceResponse<Page<DetectorResponseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listHostingEnvironmentDetectorResponsesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List Hosting Environment Detector Responses.
     * Description for List Hosting Environment Detector Responses.
     *
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorResponseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listHostingEnvironmentDetectorResponsesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listHostingEnvironmentDetectorResponsesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorResponseInner>> result = listHostingEnvironmentDetectorResponsesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorResponseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorResponseInner>> listHostingEnvironmentDetectorResponsesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorResponseInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorResponseInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorResponseInner&gt; object if successful.
     */
    public PagedList<DetectorResponseInner> listSiteDetectorResponsesNext(final String nextPageLink) {
        ServiceResponse<Page<DetectorResponseInner>> response = listSiteDetectorResponsesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorResponseInner>(response.body()) {
            @Override
            public Page<DetectorResponseInner> nextPage(String nextPageLink) {
                return listSiteDetectorResponsesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorResponseInner>> listSiteDetectorResponsesNextAsync(final String nextPageLink, final ServiceFuture<List<DetectorResponseInner>> serviceFuture, final ListOperationCallback<DetectorResponseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDetectorResponsesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(String nextPageLink) {
                    return listSiteDetectorResponsesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<Page<DetectorResponseInner>> listSiteDetectorResponsesNextAsync(final String nextPageLink) {
        return listSiteDetectorResponsesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Page<DetectorResponseInner>>() {
                @Override
                public Page<DetectorResponseInner> call(ServiceResponse<Page<DetectorResponseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listSiteDetectorResponsesNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteDetectorResponsesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(ServiceResponse<Page<DetectorResponseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDetectorResponsesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorResponseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listSiteDetectorResponsesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteDetectorResponsesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorResponseInner>> result = listSiteDetectorResponsesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorResponseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorResponseInner>> listSiteDetectorResponsesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorResponseInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorResponseInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiagnosticCategoryInner&gt; object if successful.
     */
    public PagedList<DiagnosticCategoryInner> listSiteDiagnosticCategoriesNext(final String nextPageLink) {
        ServiceResponse<Page<DiagnosticCategoryInner>> response = listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiagnosticCategoryInner>(response.body()) {
            @Override
            public Page<DiagnosticCategoryInner> nextPage(String nextPageLink) {
                return listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesNextAsync(final String nextPageLink, final ServiceFuture<List<DiagnosticCategoryInner>> serviceFuture, final ListOperationCallback<DiagnosticCategoryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(String nextPageLink) {
                    return listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiagnosticCategoryInner&gt; object
     */
    public Observable<Page<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesNextAsync(final String nextPageLink) {
        return listSiteDiagnosticCategoriesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Page<DiagnosticCategoryInner>>() {
                @Override
                public Page<DiagnosticCategoryInner> call(ServiceResponse<Page<DiagnosticCategoryInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiagnosticCategoryInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(ServiceResponse<Page<DiagnosticCategoryInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDiagnosticCategoriesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
    ServiceResponse<PageImpl<DiagnosticCategoryInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiagnosticCategoryInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteDiagnosticCategoriesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DiagnosticCategoryInner>> result = listSiteDiagnosticCategoriesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiagnosticCategoryInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DiagnosticCategoryInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DiagnosticCategoryInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AnalysisDefinitionInner&gt; object if successful.
     */
    public PagedList<AnalysisDefinitionInner> listSiteAnalysesNext(final String nextPageLink) {
        ServiceResponse<Page<AnalysisDefinitionInner>> response = listSiteAnalysesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AnalysisDefinitionInner>(response.body()) {
            @Override
            public Page<AnalysisDefinitionInner> nextPage(String nextPageLink) {
                return listSiteAnalysesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AnalysisDefinitionInner>> listSiteAnalysesNextAsync(final String nextPageLink, final ServiceFuture<List<AnalysisDefinitionInner>> serviceFuture, final ListOperationCallback<AnalysisDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteAnalysesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(String nextPageLink) {
                    return listSiteAnalysesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AnalysisDefinitionInner&gt; object
     */
    public Observable<Page<AnalysisDefinitionInner>> listSiteAnalysesNextAsync(final String nextPageLink) {
        return listSiteAnalysesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Page<AnalysisDefinitionInner>>() {
                @Override
                public Page<AnalysisDefinitionInner> call(ServiceResponse<Page<AnalysisDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AnalysisDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteAnalysesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(ServiceResponse<Page<AnalysisDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteAnalysesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AnalysisDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteAnalysesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AnalysisDefinitionInner>> result = listSiteAnalysesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AnalysisDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AnalysisDefinitionInner>> listSiteAnalysesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AnalysisDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AnalysisDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorDefinitionInner&gt; object if successful.
     */
    public PagedList<DetectorDefinitionInner> listSiteDetectorsNext(final String nextPageLink) {
        ServiceResponse<Page<DetectorDefinitionInner>> response = listSiteDetectorsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>(response.body()) {
            @Override
            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return listSiteDetectorsNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorDefinitionInner>> listSiteDetectorsNextAsync(final String nextPageLink, final ServiceFuture<List<DetectorDefinitionInner>> serviceFuture, final ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDetectorsNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                    return listSiteDetectorsNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorDefinitionInner&gt; object
     */
    public Observable<Page<DetectorDefinitionInner>> listSiteDetectorsNextAsync(final String nextPageLink) {
        return listSiteDetectorsNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>() {
                @Override
                public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteDetectorsNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDetectorsNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteDetectorsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorDefinitionInner>> result = listSiteDetectorsNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> listSiteDetectorsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorResponseInner&gt; object if successful.
     */
    public PagedList<DetectorResponseInner> listSiteDetectorResponsesSlotNext(final String nextPageLink) {
        ServiceResponse<Page<DetectorResponseInner>> response = listSiteDetectorResponsesSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorResponseInner>(response.body()) {
            @Override
            public Page<DetectorResponseInner> nextPage(String nextPageLink) {
                return listSiteDetectorResponsesSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorResponseInner>> listSiteDetectorResponsesSlotNextAsync(final String nextPageLink, final ServiceFuture<List<DetectorResponseInner>> serviceFuture, final ListOperationCallback<DetectorResponseInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDetectorResponsesSlotNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(String nextPageLink) {
                    return listSiteDetectorResponsesSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<Page<DetectorResponseInner>> listSiteDetectorResponsesSlotNextAsync(final String nextPageLink) {
        return listSiteDetectorResponsesSlotNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Page<DetectorResponseInner>>() {
                @Override
                public Page<DetectorResponseInner> call(ServiceResponse<Page<DetectorResponseInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorResponseInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listSiteDetectorResponsesSlotNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteDetectorResponsesSlotNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DetectorResponseInner>>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(ServiceResponse<Page<DetectorResponseInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDetectorResponsesSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List Site Detector Responses.
     * Description for List Site Detector Responses.
     *
    ServiceResponse<PageImpl<DetectorResponseInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorResponseInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorResponseInner>>> listSiteDetectorResponsesSlotNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteDetectorResponsesSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorResponseInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorResponseInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorResponseInner>> result = listSiteDetectorResponsesSlotNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorResponseInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorResponseInner>> listSiteDetectorResponsesSlotNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorResponseInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorResponseInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DiagnosticCategoryInner&gt; object if successful.
     */
    public PagedList<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlotNext(final String nextPageLink) {
        ServiceResponse<Page<DiagnosticCategoryInner>> response = listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiagnosticCategoryInner>(response.body()) {
            @Override
            public Page<DiagnosticCategoryInner> nextPage(String nextPageLink) {
                return listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotNextAsync(final String nextPageLink, final ServiceFuture<List<DiagnosticCategoryInner>> serviceFuture, final ListOperationCallback<DiagnosticCategoryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(String nextPageLink) {
                    return listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiagnosticCategoryInner&gt; object
     */
    public Observable<Page<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotNextAsync(final String nextPageLink) {
        return listSiteDiagnosticCategoriesSlotNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Page<DiagnosticCategoryInner>>() {
                @Override
                public Page<DiagnosticCategoryInner> call(ServiceResponse<Page<DiagnosticCategoryInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DiagnosticCategoryInner&gt; object
     */
    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSlotNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(ServiceResponse<Page<DiagnosticCategoryInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDiagnosticCategoriesSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Diagnostics Categories.
     * Description for Get Diagnostics Categories.
     *
    ServiceResponse<PageImpl<DiagnosticCategoryInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DiagnosticCategoryInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSlotNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteDiagnosticCategoriesSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DiagnosticCategoryInner>> result = listSiteDiagnosticCategoriesSlotNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DiagnosticCategoryInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DiagnosticCategoryInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DiagnosticCategoryInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;AnalysisDefinitionInner&gt; object if successful.
     */
    public PagedList<AnalysisDefinitionInner> listSiteAnalysesSlotNext(final String nextPageLink) {
        ServiceResponse<Page<AnalysisDefinitionInner>> response = listSiteAnalysesSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AnalysisDefinitionInner>(response.body()) {
            @Override
            public Page<AnalysisDefinitionInner> nextPage(String nextPageLink) {
                return listSiteAnalysesSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<AnalysisDefinitionInner>> listSiteAnalysesSlotNextAsync(final String nextPageLink, final ServiceFuture<List<AnalysisDefinitionInner>> serviceFuture, final ListOperationCallback<AnalysisDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteAnalysesSlotNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(String nextPageLink) {
                    return listSiteAnalysesSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AnalysisDefinitionInner&gt; object
     */
    public Observable<Page<AnalysisDefinitionInner>> listSiteAnalysesSlotNextAsync(final String nextPageLink) {
        return listSiteAnalysesSlotNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Page<AnalysisDefinitionInner>>() {
                @Override
                public Page<AnalysisDefinitionInner> call(ServiceResponse<Page<AnalysisDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;AnalysisDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSlotNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteAnalysesSlotNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(ServiceResponse<Page<AnalysisDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteAnalysesSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Site Analyses.
     * Description for Get Site Analyses.
     *
    ServiceResponse<PageImpl<AnalysisDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;AnalysisDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSlotNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteAnalysesSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<AnalysisDefinitionInner>> result = listSiteAnalysesSlotNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<AnalysisDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<AnalysisDefinitionInner>> listSiteAnalysesSlotNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<AnalysisDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<AnalysisDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws DefaultErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;DetectorDefinitionInner&gt; object if successful.
     */
    public PagedList<DetectorDefinitionInner> listSiteDetectorsSlotNext(final String nextPageLink) {
        ServiceResponse<Page<DetectorDefinitionInner>> response = listSiteDetectorsSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>(response.body()) {
            @Override
            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return listSiteDetectorsSlotNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<DetectorDefinitionInner>> listSiteDetectorsSlotNextAsync(final String nextPageLink, final ServiceFuture<List<DetectorDefinitionInner>> serviceFuture, final ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSiteDetectorsSlotNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                    return listSiteDetectorsSlotNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorDefinitionInner&gt; object
     */
    public Observable<Page<DetectorDefinitionInner>> listSiteDetectorsSlotNextAsync(final String nextPageLink) {
        return listSiteDetectorsSlotNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>() {
                @Override
                public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;DetectorDefinitionInner&gt; object
     */
    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSlotNextWithServiceResponseAsync(final String nextPageLink) {
        return listSiteDetectorsSlotNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listSiteDetectorsSlotNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Get Detectors.
     * Description for Get Detectors.
     *
    ServiceResponse<PageImpl<DetectorDefinitionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;DetectorDefinitionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSlotNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listSiteDetectorsSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<DetectorDefinitionInner>> result = listSiteDetectorsSlotNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<DetectorDefinitionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> listSiteDetectorsSlotNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<DetectorDefinitionInner>, DefaultErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>() { }.getType())
                .registerError(DefaultErrorResponseException.class)
                .build(response);
    }

}
