/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.implementation.AnalysisDefinitionInner;
import com.microsoft.azure.management.appservice.implementation.DetectorDefinitionInner;
import com.microsoft.azure.management.appservice.implementation.DiagnosticAnalysisInner;
import com.microsoft.azure.management.appservice.implementation.DiagnosticCategoryInner;
import com.microsoft.azure.management.appservice.implementation.DiagnosticDetectorResponseInner;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DiagnosticsInner {
    private DiagnosticsService service;
    private WebSiteManagementClientImpl client;

    public DiagnosticsInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (DiagnosticsService)retrofit.create(DiagnosticsService.class);
        this.client = client;
    }

    public PagedList<DiagnosticCategoryInner> listSiteDiagnosticCategories(String resourceGroupName, String siteName) {
        ServiceResponse response = (ServiceResponse)this.listSiteDiagnosticCategoriesSinglePageAsync(resourceGroupName, siteName).toBlocking().single();
        return new PagedList<DiagnosticCategoryInner>((Page)response.body()){

            public Page<DiagnosticCategoryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesAsync(String resourceGroupName, String siteName, ListOperationCallback<DiagnosticCategoryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteDiagnosticCategoriesSinglePageAsync(resourceGroupName, siteName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesAsync(String resourceGroupName, String siteName) {
        return this.listSiteDiagnosticCategoriesWithServiceResponseAsync(resourceGroupName, siteName).map((Func1)new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Page<DiagnosticCategoryInner>>(){

            public Page<DiagnosticCategoryInner> call(ServiceResponse<Page<DiagnosticCategoryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesWithServiceResponseAsync(String resourceGroupName, String siteName) {
        return this.listSiteDiagnosticCategoriesSinglePageAsync(resourceGroupName, siteName).concatMap((Func1)new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(ServiceResponse<Page<DiagnosticCategoryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteDiagnosticCategoriesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSinglePageAsync(String resourceGroupName, String siteName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listSiteDiagnosticCategories(resourceGroupName, siteName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteDiagnosticCategoriesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DiagnosticCategoryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiagnosticCategoryInner getSiteDiagnosticCategory(String resourceGroupName, String siteName, String diagnosticCategory) {
        return (DiagnosticCategoryInner)((ServiceResponse)this.getSiteDiagnosticCategoryWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticCategoryInner> getSiteDiagnosticCategoryAsync(String resourceGroupName, String siteName, String diagnosticCategory, ServiceCallback<DiagnosticCategoryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSiteDiagnosticCategoryWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory), serviceCallback);
    }

    public Observable<DiagnosticCategoryInner> getSiteDiagnosticCategoryAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        return this.getSiteDiagnosticCategoryWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory).map((Func1)new Func1<ServiceResponse<DiagnosticCategoryInner>, DiagnosticCategoryInner>(){

            public DiagnosticCategoryInner call(ServiceResponse<DiagnosticCategoryInner> response) {
                return (DiagnosticCategoryInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticCategoryInner>> getSiteDiagnosticCategoryWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getSiteDiagnosticCategory(resourceGroupName, siteName, diagnosticCategory, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticCategoryInner>>>(){

            public Observable<ServiceResponse<DiagnosticCategoryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.getSiteDiagnosticCategoryDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticCategoryInner> getSiteDiagnosticCategoryDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticCategoryInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AnalysisDefinitionInner> listSiteAnalyses(String resourceGroupName, String siteName, String diagnosticCategory) {
        ServiceResponse response = (ServiceResponse)this.listSiteAnalysesSinglePageAsync(resourceGroupName, siteName, diagnosticCategory).toBlocking().single();
        return new PagedList<AnalysisDefinitionInner>((Page)response.body()){

            public Page<AnalysisDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteAnalysesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AnalysisDefinitionInner>> listSiteAnalysesAsync(String resourceGroupName, String siteName, String diagnosticCategory, ListOperationCallback<AnalysisDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteAnalysesSinglePageAsync(resourceGroupName, siteName, diagnosticCategory), (Func1)new Func1<String, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteAnalysesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AnalysisDefinitionInner>> listSiteAnalysesAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        return this.listSiteAnalysesWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory).map((Func1)new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Page<AnalysisDefinitionInner>>(){

            public Page<AnalysisDefinitionInner> call(ServiceResponse<Page<AnalysisDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        return this.listSiteAnalysesSinglePageAsync(resourceGroupName, siteName, diagnosticCategory).concatMap((Func1)new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(ServiceResponse<Page<AnalysisDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteAnalysesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSinglePageAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listSiteAnalyses(resourceGroupName, siteName, diagnosticCategory, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteAnalysesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AnalysisDefinitionInner>> listSiteAnalysesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AnalysisDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiagnosticAnalysisInner getSiteAnalysis(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return (DiagnosticAnalysisInner)((ServiceResponse)this.getSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticAnalysisInner> getSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName), serviceCallback);
    }

    public Observable<DiagnosticAnalysisInner> getSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return this.getSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).map((Func1)new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>(){

            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return (DiagnosticAnalysisInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticAnalysisInner>> getSiteAnalysisWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getSiteAnalysis(resourceGroupName, siteName, diagnosticCategory, analysisName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>(){

            public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.getSiteAnalysisDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticAnalysisInner> getSiteAnalysisDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticAnalysisInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiagnosticAnalysisInner executeSiteAnalysis(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return (DiagnosticAnalysisInner)((ServiceResponse)this.executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticAnalysisInner> executeSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName), serviceCallback);
    }

    public Observable<DiagnosticAnalysisInner> executeSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        return this.executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName).map((Func1)new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>(){

            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return (DiagnosticAnalysisInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticAnalysisInner>> executeSiteAnalysisWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        DateTime startTime = null;
        DateTime endTime = null;
        String timeGrain = null;
        return this.service.executeSiteAnalysis(resourceGroupName, siteName, diagnosticCategory, analysisName, this.client.subscriptionId(), startTime, endTime, timeGrain, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>(){

            public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.executeSiteAnalysisDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DiagnosticAnalysisInner executeSiteAnalysis(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, DateTime startTime, DateTime endTime, String timeGrain) {
        return (DiagnosticAnalysisInner)((ServiceResponse)this.executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticAnalysisInner> executeSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, DateTime startTime, DateTime endTime, String timeGrain, ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain), serviceCallback);
    }

    public Observable<DiagnosticAnalysisInner> executeSiteAnalysisAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, DateTime startTime, DateTime endTime, String timeGrain) {
        return this.executeSiteAnalysisWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, startTime, endTime, timeGrain).map((Func1)new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>(){

            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return (DiagnosticAnalysisInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticAnalysisInner>> executeSiteAnalysisWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.executeSiteAnalysis(resourceGroupName, siteName, diagnosticCategory, analysisName, this.client.subscriptionId(), startTime, endTime, timeGrain, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>(){

            public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.executeSiteAnalysisDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticAnalysisInner> executeSiteAnalysisDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticAnalysisInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DetectorDefinitionInner> listSiteDetectors(String resourceGroupName, String siteName, String diagnosticCategory) {
        ServiceResponse response = (ServiceResponse)this.listSiteDetectorsSinglePageAsync(resourceGroupName, siteName, diagnosticCategory).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>((Page)response.body()){

            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteDetectorsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DetectorDefinitionInner>> listSiteDetectorsAsync(String resourceGroupName, String siteName, String diagnosticCategory, ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteDetectorsSinglePageAsync(resourceGroupName, siteName, diagnosticCategory), (Func1)new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteDetectorsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DetectorDefinitionInner>> listSiteDetectorsAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        return this.listSiteDetectorsWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory).map((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>(){

            public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        return this.listSiteDetectorsSinglePageAsync(resourceGroupName, siteName, diagnosticCategory).concatMap((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteDetectorsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSinglePageAsync(String resourceGroupName, String siteName, String diagnosticCategory) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listSiteDetectors(resourceGroupName, siteName, diagnosticCategory, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteDetectorsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> listSiteDetectorsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DetectorDefinitionInner> getSiteDetector(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        ServiceResponse response = (ServiceResponse)this.getSiteDetectorSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, detectorName).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>((Page)response.body()){

            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.getSiteDetectorNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DetectorDefinitionInner>> getSiteDetectorAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSiteDetectorSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, detectorName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.getSiteDetectorNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DetectorDefinitionInner>> getSiteDetectorAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        return this.getSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName).map((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>(){

            public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> getSiteDetectorWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        return this.getSiteDetectorSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, detectorName).concatMap((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.getSiteDetectorNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> getSiteDetectorSinglePageAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getSiteDetector(resourceGroupName, siteName, diagnosticCategory, detectorName, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.getSiteDetectorDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> getSiteDetectorDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiagnosticDetectorResponseInner executeSiteDetector(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory) {
        return (DiagnosticDetectorResponseInner)((ServiceResponse)this.executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, ServiceCallback<DiagnosticDetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory), serviceCallback);
    }

    public Observable<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory) {
        return this.executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory).map((Func1)new Func1<ServiceResponse<DiagnosticDetectorResponseInner>, DiagnosticDetectorResponseInner>(){

            public DiagnosticDetectorResponseInner call(ServiceResponse<DiagnosticDetectorResponseInner> response) {
                return (DiagnosticDetectorResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> executeSiteDetectorWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        DateTime startTime = null;
        DateTime endTime = null;
        String timeGrain = null;
        return this.service.executeSiteDetector(resourceGroupName, siteName, detectorName, diagnosticCategory, this.client.subscriptionId(), startTime, endTime, timeGrain, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticDetectorResponseInner>>>(){

            public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.executeSiteDetectorDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DiagnosticDetectorResponseInner executeSiteDetector(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, DateTime startTime, DateTime endTime, String timeGrain) {
        return (DiagnosticDetectorResponseInner)((ServiceResponse)this.executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, DateTime startTime, DateTime endTime, String timeGrain, ServiceCallback<DiagnosticDetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain), serviceCallback);
    }

    public Observable<DiagnosticDetectorResponseInner> executeSiteDetectorAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, DateTime startTime, DateTime endTime, String timeGrain) {
        return this.executeSiteDetectorWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, startTime, endTime, timeGrain).map((Func1)new Func1<ServiceResponse<DiagnosticDetectorResponseInner>, DiagnosticDetectorResponseInner>(){

            public DiagnosticDetectorResponseInner call(ServiceResponse<DiagnosticDetectorResponseInner> response) {
                return (DiagnosticDetectorResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> executeSiteDetectorWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.executeSiteDetector(resourceGroupName, siteName, detectorName, diagnosticCategory, this.client.subscriptionId(), startTime, endTime, timeGrain, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticDetectorResponseInner>>>(){

            public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.executeSiteDetectorDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticDetectorResponseInner> executeSiteDetectorDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticDetectorResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlot(String resourceGroupName, String siteName, String slot) {
        ServiceResponse response = (ServiceResponse)this.listSiteDiagnosticCategoriesSlotSinglePageAsync(resourceGroupName, siteName, slot).toBlocking().single();
        return new PagedList<DiagnosticCategoryInner>((Page)response.body()){

            public Page<DiagnosticCategoryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotAsync(String resourceGroupName, String siteName, String slot, ListOperationCallback<DiagnosticCategoryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteDiagnosticCategoriesSlotSinglePageAsync(resourceGroupName, siteName, slot), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotAsync(String resourceGroupName, String siteName, String slot) {
        return this.listSiteDiagnosticCategoriesSlotWithServiceResponseAsync(resourceGroupName, siteName, slot).map((Func1)new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Page<DiagnosticCategoryInner>>(){

            public Page<DiagnosticCategoryInner> call(ServiceResponse<Page<DiagnosticCategoryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String slot) {
        return this.listSiteDiagnosticCategoriesSlotSinglePageAsync(resourceGroupName, siteName, slot).concatMap((Func1)new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(ServiceResponse<Page<DiagnosticCategoryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteDiagnosticCategoriesSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSlotSinglePageAsync(String resourceGroupName, String siteName, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listSiteDiagnosticCategoriesSlot(resourceGroupName, siteName, slot, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteDiagnosticCategoriesSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DiagnosticCategoryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiagnosticCategoryInner getSiteDiagnosticCategorySlot(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return (DiagnosticCategoryInner)((ServiceResponse)this.getSiteDiagnosticCategorySlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot, ServiceCallback<DiagnosticCategoryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSiteDiagnosticCategorySlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot), serviceCallback);
    }

    public Observable<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return this.getSiteDiagnosticCategorySlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot).map((Func1)new Func1<ServiceResponse<DiagnosticCategoryInner>, DiagnosticCategoryInner>(){

            public DiagnosticCategoryInner call(ServiceResponse<DiagnosticCategoryInner> response) {
                return (DiagnosticCategoryInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticCategoryInner>> getSiteDiagnosticCategorySlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getSiteDiagnosticCategorySlot(resourceGroupName, siteName, diagnosticCategory, slot, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticCategoryInner>>>(){

            public Observable<ServiceResponse<DiagnosticCategoryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.getSiteDiagnosticCategorySlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticCategoryInner> getSiteDiagnosticCategorySlotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticCategoryInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AnalysisDefinitionInner> listSiteAnalysesSlot(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        ServiceResponse response = (ServiceResponse)this.listSiteAnalysesSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot).toBlocking().single();
        return new PagedList<AnalysisDefinitionInner>((Page)response.body()){

            public Page<AnalysisDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteAnalysesSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AnalysisDefinitionInner>> listSiteAnalysesSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot, ListOperationCallback<AnalysisDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteAnalysesSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot), (Func1)new Func1<String, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteAnalysesSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AnalysisDefinitionInner>> listSiteAnalysesSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return this.listSiteAnalysesSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot).map((Func1)new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Page<AnalysisDefinitionInner>>(){

            public Page<AnalysisDefinitionInner> call(ServiceResponse<Page<AnalysisDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return this.listSiteAnalysesSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot).concatMap((Func1)new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(ServiceResponse<Page<AnalysisDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteAnalysesSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSlotSinglePageAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listSiteAnalysesSlot(resourceGroupName, siteName, diagnosticCategory, slot, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteAnalysesSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AnalysisDefinitionInner>> listSiteAnalysesSlotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AnalysisDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiagnosticAnalysisInner getSiteAnalysisSlot(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return (DiagnosticAnalysisInner)((ServiceResponse)this.getSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticAnalysisInner> getSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot), serviceCallback);
    }

    public Observable<DiagnosticAnalysisInner> getSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return this.getSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).map((Func1)new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>(){

            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return (DiagnosticAnalysisInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticAnalysisInner>> getSiteAnalysisSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getSiteAnalysisSlot(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>(){

            public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.getSiteAnalysisSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticAnalysisInner> getSiteAnalysisSlotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticAnalysisInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiagnosticAnalysisInner executeSiteAnalysisSlot(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return (DiagnosticAnalysisInner)((ServiceResponse)this.executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot), serviceCallback);
    }

    public Observable<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        return this.executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot).map((Func1)new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>(){

            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return (DiagnosticAnalysisInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticAnalysisInner>> executeSiteAnalysisSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        DateTime startTime = null;
        DateTime endTime = null;
        String timeGrain = null;
        return this.service.executeSiteAnalysisSlot(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>(){

            public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.executeSiteAnalysisSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DiagnosticAnalysisInner executeSiteAnalysisSlot(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return (DiagnosticAnalysisInner)((ServiceResponse)this.executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, DateTime startTime, DateTime endTime, String timeGrain, ServiceCallback<DiagnosticAnalysisInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain), serviceCallback);
    }

    public Observable<DiagnosticAnalysisInner> executeSiteAnalysisSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return this.executeSiteAnalysisSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, startTime, endTime, timeGrain).map((Func1)new Func1<ServiceResponse<DiagnosticAnalysisInner>, DiagnosticAnalysisInner>(){

            public DiagnosticAnalysisInner call(ServiceResponse<DiagnosticAnalysisInner> response) {
                return (DiagnosticAnalysisInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticAnalysisInner>> executeSiteAnalysisSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String analysisName, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (analysisName == null) {
            throw new IllegalArgumentException("Parameter analysisName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.executeSiteAnalysisSlot(resourceGroupName, siteName, diagnosticCategory, analysisName, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticAnalysisInner>>>(){

            public Observable<ServiceResponse<DiagnosticAnalysisInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.executeSiteAnalysisSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticAnalysisInner> executeSiteAnalysisSlotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticAnalysisInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DetectorDefinitionInner> listSiteDetectorsSlot(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        ServiceResponse response = (ServiceResponse)this.listSiteDetectorsSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>((Page)response.body()){

            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteDetectorsSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DetectorDefinitionInner>> listSiteDetectorsSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot, ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteDetectorsSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot), (Func1)new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteDetectorsSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DetectorDefinitionInner>> listSiteDetectorsSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return this.listSiteDetectorsSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, slot).map((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>(){

            public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        return this.listSiteDetectorsSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, slot).concatMap((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteDetectorsSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSlotSinglePageAsync(String resourceGroupName, String siteName, String diagnosticCategory, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.listSiteDetectorsSlot(resourceGroupName, siteName, diagnosticCategory, slot, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteDetectorsSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> listSiteDetectorsSlotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DetectorDefinitionInner> getSiteDetectorSlot(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        ServiceResponse response = (ServiceResponse)this.getSiteDetectorSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>((Page)response.body()){

            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.getSiteDetectorSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DetectorDefinitionInner>> getSiteDetectorSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot, ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSiteDetectorSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot), (Func1)new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.getSiteDetectorSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DetectorDefinitionInner>> getSiteDetectorSlotAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        return this.getSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot).map((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>(){

            public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> getSiteDetectorSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        return this.getSiteDetectorSlotSinglePageAsync(resourceGroupName, siteName, diagnosticCategory, detectorName, slot).concatMap((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.getSiteDetectorSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> getSiteDetectorSlotSinglePageAsync(String resourceGroupName, String siteName, String diagnosticCategory, String detectorName, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getSiteDetectorSlot(resourceGroupName, siteName, diagnosticCategory, detectorName, slot, this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.getSiteDetectorSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> getSiteDetectorSlotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DiagnosticDetectorResponseInner executeSiteDetectorSlot(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot) {
        return (DiagnosticDetectorResponseInner)((ServiceResponse)this.executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, ServiceCallback<DiagnosticDetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot), serviceCallback);
    }

    public Observable<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot) {
        return this.executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot).map((Func1)new Func1<ServiceResponse<DiagnosticDetectorResponseInner>, DiagnosticDetectorResponseInner>(){

            public DiagnosticDetectorResponseInner call(ServiceResponse<DiagnosticDetectorResponseInner> response) {
                return (DiagnosticDetectorResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> executeSiteDetectorSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        DateTime startTime = null;
        DateTime endTime = null;
        String timeGrain = null;
        return this.service.executeSiteDetectorSlot(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticDetectorResponseInner>>>(){

            public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.executeSiteDetectorSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DiagnosticDetectorResponseInner executeSiteDetectorSlot(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return (DiagnosticDetectorResponseInner)((ServiceResponse)this.executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain).toBlocking().single()).body();
    }

    public ServiceFuture<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, DateTime startTime, DateTime endTime, String timeGrain, ServiceCallback<DiagnosticDetectorResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain), serviceCallback);
    }

    public Observable<DiagnosticDetectorResponseInner> executeSiteDetectorSlotAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        return this.executeSiteDetectorSlotWithServiceResponseAsync(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, startTime, endTime, timeGrain).map((Func1)new Func1<ServiceResponse<DiagnosticDetectorResponseInner>, DiagnosticDetectorResponseInner>(){

            public DiagnosticDetectorResponseInner call(ServiceResponse<DiagnosticDetectorResponseInner> response) {
                return (DiagnosticDetectorResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> executeSiteDetectorSlotWithServiceResponseAsync(String resourceGroupName, String siteName, String detectorName, String diagnosticCategory, String slot, DateTime startTime, DateTime endTime, String timeGrain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (siteName == null) {
            throw new IllegalArgumentException("Parameter siteName is required and cannot be null.");
        }
        if (detectorName == null) {
            throw new IllegalArgumentException("Parameter detectorName is required and cannot be null.");
        }
        if (diagnosticCategory == null) {
            throw new IllegalArgumentException("Parameter diagnosticCategory is required and cannot be null.");
        }
        if (slot == null) {
            throw new IllegalArgumentException("Parameter slot is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.executeSiteDetectorSlot(resourceGroupName, siteName, detectorName, diagnosticCategory, slot, this.client.subscriptionId(), startTime, endTime, timeGrain, "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DiagnosticDetectorResponseInner>>>(){

            public Observable<ServiceResponse<DiagnosticDetectorResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DiagnosticsInner.this.executeSiteDetectorSlotDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DiagnosticDetectorResponseInner> executeSiteDetectorSlotDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DiagnosticDetectorResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiagnosticCategoryInner> listSiteDiagnosticCategoriesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiagnosticCategoryInner>((Page)response.body()){

            public Page<DiagnosticCategoryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesNextAsync(String nextPageLink, ServiceFuture<List<DiagnosticCategoryInner>> serviceFuture, ListOperationCallback<DiagnosticCategoryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesNextAsync(String nextPageLink) {
        return this.listSiteDiagnosticCategoriesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Page<DiagnosticCategoryInner>>(){

            public Page<DiagnosticCategoryInner> call(ServiceResponse<Page<DiagnosticCategoryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSiteDiagnosticCategoriesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(ServiceResponse<Page<DiagnosticCategoryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteDiagnosticCategoriesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSiteDiagnosticCategoriesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteDiagnosticCategoriesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DiagnosticCategoryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AnalysisDefinitionInner> listSiteAnalysesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSiteAnalysesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AnalysisDefinitionInner>((Page)response.body()){

            public Page<AnalysisDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteAnalysesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AnalysisDefinitionInner>> listSiteAnalysesNextAsync(String nextPageLink, ServiceFuture<List<AnalysisDefinitionInner>> serviceFuture, ListOperationCallback<AnalysisDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteAnalysesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteAnalysesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AnalysisDefinitionInner>> listSiteAnalysesNextAsync(String nextPageLink) {
        return this.listSiteAnalysesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Page<AnalysisDefinitionInner>>(){

            public Page<AnalysisDefinitionInner> call(ServiceResponse<Page<AnalysisDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSiteAnalysesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(ServiceResponse<Page<AnalysisDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteAnalysesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSiteAnalysesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteAnalysesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AnalysisDefinitionInner>> listSiteAnalysesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AnalysisDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DetectorDefinitionInner> listSiteDetectorsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSiteDetectorsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>((Page)response.body()){

            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteDetectorsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DetectorDefinitionInner>> listSiteDetectorsNextAsync(String nextPageLink, ServiceFuture<List<DetectorDefinitionInner>> serviceFuture, ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteDetectorsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteDetectorsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DetectorDefinitionInner>> listSiteDetectorsNextAsync(String nextPageLink) {
        return this.listSiteDetectorsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>(){

            public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSiteDetectorsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteDetectorsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSiteDetectorsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteDetectorsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> listSiteDetectorsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DetectorDefinitionInner> getSiteDetectorNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getSiteDetectorNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>((Page)response.body()){

            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.getSiteDetectorNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DetectorDefinitionInner>> getSiteDetectorNextAsync(String nextPageLink, ServiceFuture<List<DetectorDefinitionInner>> serviceFuture, ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSiteDetectorNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.getSiteDetectorNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DetectorDefinitionInner>> getSiteDetectorNextAsync(String nextPageLink) {
        return this.getSiteDetectorNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>(){

            public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> getSiteDetectorNextWithServiceResponseAsync(String nextPageLink) {
        return this.getSiteDetectorNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.getSiteDetectorNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> getSiteDetectorNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getSiteDetectorNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.getSiteDetectorNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> getSiteDetectorNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DiagnosticCategoryInner> listSiteDiagnosticCategoriesSlotNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DiagnosticCategoryInner>((Page)response.body()){

            public Page<DiagnosticCategoryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotNextAsync(String nextPageLink, ServiceFuture<List<DiagnosticCategoryInner>> serviceFuture, ListOperationCallback<DiagnosticCategoryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotNextAsync(String nextPageLink) {
        return this.listSiteDiagnosticCategoriesSlotNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Page<DiagnosticCategoryInner>>(){

            public Page<DiagnosticCategoryInner> call(ServiceResponse<Page<DiagnosticCategoryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSlotNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSiteDiagnosticCategoriesSlotNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DiagnosticCategoryInner>>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(ServiceResponse<Page<DiagnosticCategoryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteDiagnosticCategoriesSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> listSiteDiagnosticCategoriesSlotNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSiteDiagnosticCategoriesSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DiagnosticCategoryInner>>>>(){

            public Observable<ServiceResponse<Page<DiagnosticCategoryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteDiagnosticCategoriesSlotNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DiagnosticCategoryInner>> listSiteDiagnosticCategoriesSlotNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DiagnosticCategoryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AnalysisDefinitionInner> listSiteAnalysesSlotNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSiteAnalysesSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AnalysisDefinitionInner>((Page)response.body()){

            public Page<AnalysisDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteAnalysesSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AnalysisDefinitionInner>> listSiteAnalysesSlotNextAsync(String nextPageLink, ServiceFuture<List<AnalysisDefinitionInner>> serviceFuture, ListOperationCallback<AnalysisDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteAnalysesSlotNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteAnalysesSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AnalysisDefinitionInner>> listSiteAnalysesSlotNextAsync(String nextPageLink) {
        return this.listSiteAnalysesSlotNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Page<AnalysisDefinitionInner>>(){

            public Page<AnalysisDefinitionInner> call(ServiceResponse<Page<AnalysisDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSlotNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSiteAnalysesSlotNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AnalysisDefinitionInner>>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(ServiceResponse<Page<AnalysisDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteAnalysesSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> listSiteAnalysesSlotNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSiteAnalysesSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AnalysisDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<AnalysisDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteAnalysesSlotNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AnalysisDefinitionInner>> listSiteAnalysesSlotNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AnalysisDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DetectorDefinitionInner> listSiteDetectorsSlotNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSiteDetectorsSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>((Page)response.body()){

            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.listSiteDetectorsSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DetectorDefinitionInner>> listSiteDetectorsSlotNextAsync(String nextPageLink, ServiceFuture<List<DetectorDefinitionInner>> serviceFuture, ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteDetectorsSlotNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.listSiteDetectorsSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DetectorDefinitionInner>> listSiteDetectorsSlotNextAsync(String nextPageLink) {
        return this.listSiteDetectorsSlotNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>(){

            public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSlotNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSiteDetectorsSlotNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.listSiteDetectorsSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> listSiteDetectorsSlotNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSiteDetectorsSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.listSiteDetectorsSlotNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> listSiteDetectorsSlotNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DetectorDefinitionInner> getSiteDetectorSlotNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getSiteDetectorSlotNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DetectorDefinitionInner>((Page)response.body()){

            public Page<DetectorDefinitionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DiagnosticsInner.this.getSiteDetectorSlotNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DetectorDefinitionInner>> getSiteDetectorSlotNextAsync(String nextPageLink, ServiceFuture<List<DetectorDefinitionInner>> serviceFuture, ListOperationCallback<DetectorDefinitionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getSiteDetectorSlotNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(String nextPageLink) {
                return DiagnosticsInner.this.getSiteDetectorSlotNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DetectorDefinitionInner>> getSiteDetectorSlotNextAsync(String nextPageLink) {
        return this.getSiteDetectorSlotNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Page<DetectorDefinitionInner>>(){

            public Page<DetectorDefinitionInner> call(ServiceResponse<Page<DetectorDefinitionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> getSiteDetectorSlotNextWithServiceResponseAsync(String nextPageLink) {
        return this.getSiteDetectorSlotNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DetectorDefinitionInner>>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(ServiceResponse<Page<DetectorDefinitionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DiagnosticsInner.this.getSiteDetectorSlotNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> getSiteDetectorSlotNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getSiteDetectorSlotNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DetectorDefinitionInner>>>>(){

            public Observable<ServiceResponse<Page<DetectorDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DiagnosticsInner.this.getSiteDetectorSlotNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DetectorDefinitionInner>> getSiteDetectorSlotNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DetectorDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DiagnosticsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDiagnosticCategories"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics")
        public Observable<Response<ResponseBody>> listSiteDiagnosticCategories(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDiagnosticCategory"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}")
        public Observable<Response<ResponseBody>> getSiteDiagnosticCategory(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteAnalyses"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses")
        public Observable<Response<ResponseBody>> listSiteAnalyses(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteAnalysis"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}")
        public Observable<Response<ResponseBody>> getSiteAnalysis(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="analysisName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics executeSiteAnalysis"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute")
        public Observable<Response<ResponseBody>> executeSiteAnalysis(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="analysisName") String var4, @Path(value="subscriptionId") String var5, @Query(value="startTime") DateTime var6, @Query(value="endTime") DateTime var7, @Query(value="timeGrain") String var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectors"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors")
        public Observable<Response<ResponseBody>> listSiteDetectors(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDetector"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}")
        public Observable<Response<ResponseBody>> getSiteDetector(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="detectorName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics executeSiteDetector"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute")
        public Observable<Response<ResponseBody>> executeSiteDetector(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="detectorName") String var3, @Path(value="diagnosticCategory") String var4, @Path(value="subscriptionId") String var5, @Query(value="startTime") DateTime var6, @Query(value="endTime") DateTime var7, @Query(value="timeGrain") String var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDiagnosticCategoriesSlot"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics")
        public Observable<Response<ResponseBody>> listSiteDiagnosticCategoriesSlot(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="slot") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDiagnosticCategorySlot"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}")
        public Observable<Response<ResponseBody>> getSiteDiagnosticCategorySlot(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="slot") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteAnalysesSlot"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses")
        public Observable<Response<ResponseBody>> listSiteAnalysesSlot(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="slot") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteAnalysisSlot"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}")
        public Observable<Response<ResponseBody>> getSiteAnalysisSlot(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="analysisName") String var4, @Path(value="slot") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics executeSiteAnalysisSlot"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/analyses/{analysisName}/execute")
        public Observable<Response<ResponseBody>> executeSiteAnalysisSlot(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="analysisName") String var4, @Path(value="slot") String var5, @Path(value="subscriptionId") String var6, @Query(value="startTime") DateTime var7, @Query(value="endTime") DateTime var8, @Query(value="timeGrain") String var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorsSlot"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors")
        public Observable<Response<ResponseBody>> listSiteDetectorsSlot(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="slot") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDetectorSlot"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}")
        public Observable<Response<ResponseBody>> getSiteDetectorSlot(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="diagnosticCategory") String var3, @Path(value="detectorName") String var4, @Path(value="slot") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics executeSiteDetectorSlot"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slot}/diagnostics/{diagnosticCategory}/detectors/{detectorName}/execute")
        public Observable<Response<ResponseBody>> executeSiteDetectorSlot(@Path(value="resourceGroupName") String var1, @Path(value="siteName") String var2, @Path(value="detectorName") String var3, @Path(value="diagnosticCategory") String var4, @Path(value="slot") String var5, @Path(value="subscriptionId") String var6, @Query(value="startTime") DateTime var7, @Query(value="endTime") DateTime var8, @Query(value="timeGrain") String var9, @Query(value="api-version") String var10, @Header(value="accept-language") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDiagnosticCategoriesNext"})
        @GET
        public Observable<Response<ResponseBody>> listSiteDiagnosticCategoriesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteAnalysesNext"})
        @GET
        public Observable<Response<ResponseBody>> listSiteAnalysesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorsNext"})
        @GET
        public Observable<Response<ResponseBody>> listSiteDetectorsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDetectorNext"})
        @GET
        public Observable<Response<ResponseBody>> getSiteDetectorNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDiagnosticCategoriesSlotNext"})
        @GET
        public Observable<Response<ResponseBody>> listSiteDiagnosticCategoriesSlotNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteAnalysesSlotNext"})
        @GET
        public Observable<Response<ResponseBody>> listSiteAnalysesSlotNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics listSiteDetectorsSlotNext"})
        @GET
        public Observable<Response<ResponseBody>> listSiteDetectorsSlotNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Diagnostics getSiteDetectorSlotNext"})
        @GET
        public Observable<Response<ResponseBody>> getSiteDetectorSlotNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

