/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice;

import org.joda.time.DateTime;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Class representing Abnormal Time Period detected.
 */
public class DetectorAbnormalTimePeriod {
    /**
     * Start time of the corelated event.
     */
    @JsonProperty(value = "startTime")
    private DateTime startTime;

    /**
     * End time of the corelated event.
     */
    @JsonProperty(value = "endTime")
    private DateTime endTime;

    /**
     * Message describing the event.
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Represents the name of the Detector.
     */
    @JsonProperty(value = "source")
    private String source;

    /**
     * Represents the rank of the Detector.
     */
    @JsonProperty(value = "priority")
    private Double priority;

    /**
     * Downtime metadata.
     */
    @JsonProperty(value = "metaData")
    private List<List<NameValuePair>> metaData;

    /**
     * Represents the type of the Detector. Possible values include:
     * 'ServiceIncident', 'AppDeployment', 'AppCrash', 'RuntimeIssueDetected',
     * 'AseDeployment', 'UserIssue', 'PlatformIssue', 'Other'.
     */
    @JsonProperty(value = "type")
    private IssueType type;

    /**
     * List of proposed solutions.
     */
    @JsonProperty(value = "solutions")
    private List<Solution> solutions;

    /**
     * Get the startTime value.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime value.
     *
     * @param startTime the startTime value to set
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime value.
     *
     * @return the endTime value
     */
    public DateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime value.
     *
     * @param endTime the endTime value to set
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withEndTime(DateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the message value.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message value.
     *
     * @param message the message value to set
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the source value.
     *
     * @return the source value
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source value.
     *
     * @param source the source value to set
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the priority value.
     *
     * @return the priority value
     */
    public Double priority() {
        return this.priority;
    }

    /**
     * Set the priority value.
     *
     * @param priority the priority value to set
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withPriority(Double priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the metaData value.
     *
     * @return the metaData value
     */
    public List<List<NameValuePair>> metaData() {
        return this.metaData;
    }

    /**
     * Set the metaData value.
     *
     * @param metaData the metaData value to set
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withMetaData(List<List<NameValuePair>> metaData) {
        this.metaData = metaData;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public IssueType type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withType(IssueType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the solutions value.
     *
     * @return the solutions value
     */
    public List<Solution> solutions() {
        return this.solutions;
    }

    /**
     * Set the solutions value.
     *
     * @param solutions the solutions value to set
     * @return the DetectorAbnormalTimePeriod object itself.
     */
    public DetectorAbnormalTimePeriod withSolutions(List<Solution> solutions) {
        this.solutions = solutions;
        return this;
    }

}
