/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import org.joda.time.DateTime;
import java.util.List;
import com.microsoft.azure.management.appservice.AbnormalTimePeriod;
import com.microsoft.azure.management.appservice.AnalysisData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Class representing a diagnostic analysis done on an application.
 */
@JsonFlatten
public class DiagnosticAnalysisInner extends ProxyOnlyResource {
    /**
     * Start time of the period.
     */
    @JsonProperty(value = "properties.startTime")
    private DateTime startTime;

    /**
     * End time of the period.
     */
    @JsonProperty(value = "properties.endTime")
    private DateTime endTime;

    /**
     * List of time periods.
     */
    @JsonProperty(value = "properties.abnormalTimePeriods")
    private List<AbnormalTimePeriod> abnormalTimePeriods;

    /**
     * Data by each detector.
     */
    @JsonProperty(value = "properties.payload")
    private List<AnalysisData> payload;

    /**
     * Data by each detector for detectors that did not corelate.
     */
    @JsonProperty(value = "properties.nonCorrelatedDetectors")
    private List<DetectorDefinitionInner> nonCorrelatedDetectors;

    /**
     * Get the startTime value.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime value.
     *
     * @param startTime the startTime value to set
     * @return the DiagnosticAnalysisInner object itself.
     */
    public DiagnosticAnalysisInner withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime value.
     *
     * @return the endTime value
     */
    public DateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime value.
     *
     * @param endTime the endTime value to set
     * @return the DiagnosticAnalysisInner object itself.
     */
    public DiagnosticAnalysisInner withEndTime(DateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the abnormalTimePeriods value.
     *
     * @return the abnormalTimePeriods value
     */
    public List<AbnormalTimePeriod> abnormalTimePeriods() {
        return this.abnormalTimePeriods;
    }

    /**
     * Set the abnormalTimePeriods value.
     *
     * @param abnormalTimePeriods the abnormalTimePeriods value to set
     * @return the DiagnosticAnalysisInner object itself.
     */
    public DiagnosticAnalysisInner withAbnormalTimePeriods(List<AbnormalTimePeriod> abnormalTimePeriods) {
        this.abnormalTimePeriods = abnormalTimePeriods;
        return this;
    }

    /**
     * Get the payload value.
     *
     * @return the payload value
     */
    public List<AnalysisData> payload() {
        return this.payload;
    }

    /**
     * Set the payload value.
     *
     * @param payload the payload value to set
     * @return the DiagnosticAnalysisInner object itself.
     */
    public DiagnosticAnalysisInner withPayload(List<AnalysisData> payload) {
        this.payload = payload;
        return this;
    }

    /**
     * Get the nonCorrelatedDetectors value.
     *
     * @return the nonCorrelatedDetectors value
     */
    public List<DetectorDefinitionInner> nonCorrelatedDetectors() {
        return this.nonCorrelatedDetectors;
    }

    /**
     * Set the nonCorrelatedDetectors value.
     *
     * @param nonCorrelatedDetectors the nonCorrelatedDetectors value to set
     * @return the DiagnosticAnalysisInner object itself.
     */
    public DiagnosticAnalysisInner withNonCorrelatedDetectors(List<DetectorDefinitionInner> nonCorrelatedDetectors) {
        this.nonCorrelatedDetectors = nonCorrelatedDetectors;
        return this;
    }

}
