/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Web Job Information.
 */
@JsonFlatten
public class FunctionEnvelopeInner extends ProxyOnlyResource {
    /**
     * Function name.
     */
    @JsonProperty(value = "properties.name", access = JsonProperty.Access.WRITE_ONLY)
    private String functionEnvelopeName;

    /**
     * Function App ID.
     */
    @JsonProperty(value = "properties.functionAppId", access = JsonProperty.Access.WRITE_ONLY)
    private String functionAppId;

    /**
     * Script root path URI.
     */
    @JsonProperty(value = "properties.scriptRootPathHref")
    private String scriptRootPathHref;

    /**
     * Script URI.
     */
    @JsonProperty(value = "properties.scriptHref")
    private String scriptHref;

    /**
     * Config URI.
     */
    @JsonProperty(value = "properties.configHref")
    private String configHref;

    /**
     * Secrets file URI.
     */
    @JsonProperty(value = "properties.secretsFileHref")
    private String secretsFileHref;

    /**
     * Function URI.
     */
    @JsonProperty(value = "properties.href")
    private String href;

    /**
     * Config information.
     */
    @JsonProperty(value = "properties.config")
    private Object config;

    /**
     * File list.
     */
    @JsonProperty(value = "properties.files")
    private Map<String, String> files;

    /**
     * Test data used when testing via the Azure Portal.
     */
    @JsonProperty(value = "properties.testData")
    private String testData;

    /**
     * Get the functionEnvelopeName value.
     *
     * @return the functionEnvelopeName value
     */
    public String functionEnvelopeName() {
        return this.functionEnvelopeName;
    }

    /**
     * Get the functionAppId value.
     *
     * @return the functionAppId value
     */
    public String functionAppId() {
        return this.functionAppId;
    }

    /**
     * Get the scriptRootPathHref value.
     *
     * @return the scriptRootPathHref value
     */
    public String scriptRootPathHref() {
        return this.scriptRootPathHref;
    }

    /**
     * Set the scriptRootPathHref value.
     *
     * @param scriptRootPathHref the scriptRootPathHref value to set
     * @return the FunctionEnvelopeInner object itself.
     */
    public FunctionEnvelopeInner withScriptRootPathHref(String scriptRootPathHref) {
        this.scriptRootPathHref = scriptRootPathHref;
        return this;
    }

    /**
     * Get the scriptHref value.
     *
     * @return the scriptHref value
     */
    public String scriptHref() {
        return this.scriptHref;
    }

    /**
     * Set the scriptHref value.
     *
     * @param scriptHref the scriptHref value to set
     * @return the FunctionEnvelopeInner object itself.
     */
    public FunctionEnvelopeInner withScriptHref(String scriptHref) {
        this.scriptHref = scriptHref;
        return this;
    }

    /**
     * Get the configHref value.
     *
     * @return the configHref value
     */
    public String configHref() {
        return this.configHref;
    }

    /**
     * Set the configHref value.
     *
     * @param configHref the configHref value to set
     * @return the FunctionEnvelopeInner object itself.
     */
    public FunctionEnvelopeInner withConfigHref(String configHref) {
        this.configHref = configHref;
        return this;
    }

    /**
     * Get the secretsFileHref value.
     *
     * @return the secretsFileHref value
     */
    public String secretsFileHref() {
        return this.secretsFileHref;
    }

    /**
     * Set the secretsFileHref value.
     *
     * @param secretsFileHref the secretsFileHref value to set
     * @return the FunctionEnvelopeInner object itself.
     */
    public FunctionEnvelopeInner withSecretsFileHref(String secretsFileHref) {
        this.secretsFileHref = secretsFileHref;
        return this;
    }

    /**
     * Get the href value.
     *
     * @return the href value
     */
    public String href() {
        return this.href;
    }

    /**
     * Set the href value.
     *
     * @param href the href value to set
     * @return the FunctionEnvelopeInner object itself.
     */
    public FunctionEnvelopeInner withHref(String href) {
        this.href = href;
        return this;
    }

    /**
     * Get the config value.
     *
     * @return the config value
     */
    public Object config() {
        return this.config;
    }

    /**
     * Set the config value.
     *
     * @param config the config value to set
     * @return the FunctionEnvelopeInner object itself.
     */
    public FunctionEnvelopeInner withConfig(Object config) {
        this.config = config;
        return this;
    }

    /**
     * Get the files value.
     *
     * @return the files value
     */
    public Map<String, String> files() {
        return this.files;
    }

    /**
     * Set the files value.
     *
     * @param files the files value to set
     * @return the FunctionEnvelopeInner object itself.
     */
    public FunctionEnvelopeInner withFiles(Map<String, String> files) {
        this.files = files;
        return this;
    }

    /**
     * Get the testData value.
     *
     * @return the testData value
     */
    public String testData() {
        return this.testData;
    }

    /**
     * Set the testData value.
     *
     * @param testData the testData value to set
     * @return the FunctionEnvelopeInner object itself.
     */
    public FunctionEnvelopeInner withTestData(String testData) {
        this.testData = testData;
        return this;
    }

}
