/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.appservice.OperationStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * MySQL migration status.
 */
@JsonFlatten
public class MigrateMySqlStatusInner extends ProxyOnlyResource {
    /**
     * Status of the migration task. Possible values include: 'InProgress',
     * 'Failed', 'Succeeded', 'TimedOut', 'Created'.
     */
    @JsonProperty(value = "properties.migrationOperationStatus", access = JsonProperty.Access.WRITE_ONLY)
    private OperationStatus migrationOperationStatus;

    /**
     * Operation ID for the migration task.
     */
    @JsonProperty(value = "properties.operationId", access = JsonProperty.Access.WRITE_ONLY)
    private String operationId;

    /**
     * True if the web app has in app MySql enabled.
     */
    @JsonProperty(value = "properties.localMySqlEnabled", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean localMySqlEnabled;

    /**
     * Get the migrationOperationStatus value.
     *
     * @return the migrationOperationStatus value
     */
    public OperationStatus migrationOperationStatus() {
        return this.migrationOperationStatus;
    }

    /**
     * Get the operationId value.
     *
     * @return the operationId value
     */
    public String operationId() {
        return this.operationId;
    }

    /**
     * Get the localMySqlEnabled value.
     *
     * @return the localMySqlEnabled value
     */
    public Boolean localMySqlEnabled() {
        return this.localMySqlEnabled;
    }

}
