/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Premier add-on.
 */
@JsonFlatten
public class PremierAddOnInner extends Resource {
    /**
     * Premier add on SKU.
     */
    @JsonProperty(value = "properties.sku")
    private String sku;

    /**
     * Premier add on Product.
     */
    @JsonProperty(value = "properties.product")
    private String product;

    /**
     * Premier add on Vendor.
     */
    @JsonProperty(value = "properties.vendor")
    private String vendor;

    /**
     * Premier add on Name.
     */
    @JsonProperty(value = "properties.name")
    private String premierAddOnName;

    /**
     * Premier add on Location.
     */
    @JsonProperty(value = "properties.location")
    private String premierAddOnLocation;

    /**
     * Premier add on Tags.
     */
    @JsonProperty(value = "properties.tags")
    private Map<String, String> premierAddOnTags;

    /**
     * Premier add on Marketplace publisher.
     */
    @JsonProperty(value = "properties.marketplacePublisher")
    private String marketplacePublisher;

    /**
     * Premier add on Marketplace offer.
     */
    @JsonProperty(value = "properties.marketplaceOffer")
    private String marketplaceOffer;

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the PremierAddOnInner object itself.
     */
    public PremierAddOnInner withSku(String sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the product value.
     *
     * @return the product value
     */
    public String product() {
        return this.product;
    }

    /**
     * Set the product value.
     *
     * @param product the product value to set
     * @return the PremierAddOnInner object itself.
     */
    public PremierAddOnInner withProduct(String product) {
        this.product = product;
        return this;
    }

    /**
     * Get the vendor value.
     *
     * @return the vendor value
     */
    public String vendor() {
        return this.vendor;
    }

    /**
     * Set the vendor value.
     *
     * @param vendor the vendor value to set
     * @return the PremierAddOnInner object itself.
     */
    public PremierAddOnInner withVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    /**
     * Get the premierAddOnName value.
     *
     * @return the premierAddOnName value
     */
    public String premierAddOnName() {
        return this.premierAddOnName;
    }

    /**
     * Set the premierAddOnName value.
     *
     * @param premierAddOnName the premierAddOnName value to set
     * @return the PremierAddOnInner object itself.
     */
    public PremierAddOnInner withPremierAddOnName(String premierAddOnName) {
        this.premierAddOnName = premierAddOnName;
        return this;
    }

    /**
     * Get the premierAddOnLocation value.
     *
     * @return the premierAddOnLocation value
     */
    public String premierAddOnLocation() {
        return this.premierAddOnLocation;
    }

    /**
     * Set the premierAddOnLocation value.
     *
     * @param premierAddOnLocation the premierAddOnLocation value to set
     * @return the PremierAddOnInner object itself.
     */
    public PremierAddOnInner withPremierAddOnLocation(String premierAddOnLocation) {
        this.premierAddOnLocation = premierAddOnLocation;
        return this;
    }

    /**
     * Get the premierAddOnTags value.
     *
     * @return the premierAddOnTags value
     */
    public Map<String, String> premierAddOnTags() {
        return this.premierAddOnTags;
    }

    /**
     * Set the premierAddOnTags value.
     *
     * @param premierAddOnTags the premierAddOnTags value to set
     * @return the PremierAddOnInner object itself.
     */
    public PremierAddOnInner withPremierAddOnTags(Map<String, String> premierAddOnTags) {
        this.premierAddOnTags = premierAddOnTags;
        return this;
    }

    /**
     * Get the marketplacePublisher value.
     *
     * @return the marketplacePublisher value
     */
    public String marketplacePublisher() {
        return this.marketplacePublisher;
    }

    /**
     * Set the marketplacePublisher value.
     *
     * @param marketplacePublisher the marketplacePublisher value to set
     * @return the PremierAddOnInner object itself.
     */
    public PremierAddOnInner withMarketplacePublisher(String marketplacePublisher) {
        this.marketplacePublisher = marketplacePublisher;
        return this;
    }

    /**
     * Get the marketplaceOffer value.
     *
     * @return the marketplaceOffer value
     */
    public String marketplaceOffer() {
        return this.marketplaceOffer;
    }

    /**
     * Set the marketplaceOffer value.
     *
     * @param marketplaceOffer the marketplaceOffer value to set
     * @return the PremierAddOnInner object itself.
     */
    public PremierAddOnInner withMarketplaceOffer(String marketplaceOffer) {
        this.marketplaceOffer = marketplaceOffer;
        return this;
    }

}
