/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import java.util.List;
import org.joda.time.DateTime;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Process Information.
 */
@JsonFlatten
public class ProcessInfoInner extends ProxyOnlyResource {
    /**
     * ARM Identifier for deployment.
     */
    @JsonProperty(value = "properties.id")
    private Integer processInfoId;

    /**
     * Deployment name.
     */
    @JsonProperty(value = "properties.name")
    private String processInfoName;

    /**
     * HRef URI.
     */
    @JsonProperty(value = "properties.href")
    private String href;

    /**
     * Minidump URI.
     */
    @JsonProperty(value = "properties.miniDump")
    private String miniDump;

    /**
     * Is profile running?.
     */
    @JsonProperty(value = "properties.isProfileRunning")
    private Boolean isProfileRunning;

    /**
     * Is the IIS Profile running?.
     */
    @JsonProperty(value = "properties.isIisProfileRunning")
    private Boolean isIisProfileRunning;

    /**
     * IIS Profile timeout (seconds).
     */
    @JsonProperty(value = "properties.iisProfileTimeoutInSeconds")
    private Double iisProfileTimeoutInSeconds;

    /**
     * Parent process.
     */
    @JsonProperty(value = "properties.parent")
    private String parent;

    /**
     * Child process list.
     */
    @JsonProperty(value = "properties.children")
    private List<String> children;

    /**
     * Thread list.
     */
    @JsonProperty(value = "properties.threads")
    private List<ProcessThreadInfoInner> threads;

    /**
     * List of open files.
     */
    @JsonProperty(value = "properties.openFileHandles")
    private List<String> openFileHandles;

    /**
     * List of modules.
     */
    @JsonProperty(value = "properties.modules")
    private List<ProcessModuleInfoInner> modules;

    /**
     * File name of this process.
     */
    @JsonProperty(value = "properties.fileName")
    private String fileName;

    /**
     * Command line.
     */
    @JsonProperty(value = "properties.commandLine")
    private String commandLine;

    /**
     * User name.
     */
    @JsonProperty(value = "properties.userName")
    private String userName;

    /**
     * Handle count.
     */
    @JsonProperty(value = "properties.handleCount")
    private Integer handleCount;

    /**
     * Module count.
     */
    @JsonProperty(value = "properties.moduleCount")
    private Integer moduleCount;

    /**
     * Thread count.
     */
    @JsonProperty(value = "properties.threadCount")
    private Integer threadCount;

    /**
     * Start time.
     */
    @JsonProperty(value = "properties.startTime")
    private DateTime startTime;

    /**
     * Total CPU time.
     */
    @JsonProperty(value = "properties.totalProcessorTime")
    private String totalProcessorTime;

    /**
     * User CPU time.
     */
    @JsonProperty(value = "properties.userProcessorTime")
    private String userProcessorTime;

    /**
     * Privileged CPU time.
     */
    @JsonProperty(value = "properties.privilegedProcessorTime")
    private String privilegedProcessorTime;

    /**
     * Working set.
     */
    @JsonProperty(value = "properties.workingSet64")
    private Long workingSet64;

    /**
     * Peak working set.
     */
    @JsonProperty(value = "properties.peakWorkingSet64")
    private Long peakWorkingSet64;

    /**
     * Private memory size.
     */
    @JsonProperty(value = "properties.privateMemorySize64")
    private Long privateMemorySize64;

    /**
     * Virtual memory size.
     */
    @JsonProperty(value = "properties.virtualMemorySize64")
    private Long virtualMemorySize64;

    /**
     * Peak virtual memory usage.
     */
    @JsonProperty(value = "properties.peakVirtualMemorySize64")
    private Long peakVirtualMemorySize64;

    /**
     * Paged system memory.
     */
    @JsonProperty(value = "properties.pagedSystemMemorySize64")
    private Long pagedSystemMemorySize64;

    /**
     * Non-paged system memory.
     */
    @JsonProperty(value = "properties.nonpagedSystemMemorySize64")
    private Long nonpagedSystemMemorySize64;

    /**
     * Paged memory.
     */
    @JsonProperty(value = "properties.pagedMemorySize64")
    private Long pagedMemorySize64;

    /**
     * Peak paged memory.
     */
    @JsonProperty(value = "properties.peakPagedMemorySize64")
    private Long peakPagedMemorySize64;

    /**
     * Time stamp.
     */
    @JsonProperty(value = "properties.timeStamp")
    private DateTime timeStamp;

    /**
     * List of environment variables.
     */
    @JsonProperty(value = "properties.environmentVariables")
    private Map<String, String> environmentVariables;

    /**
     * Is this the SCM site?.
     */
    @JsonProperty(value = "properties.isScmSite")
    private Boolean isScmSite;

    /**
     * Is this a Web Job?.
     */
    @JsonProperty(value = "properties.isWebJob")
    private Boolean isWebJob;

    /**
     * Description of process.
     */
    @JsonProperty(value = "properties.description")
    private String description;

    /**
     * Get the processInfoId value.
     *
     * @return the processInfoId value
     */
    public Integer processInfoId() {
        return this.processInfoId;
    }

    /**
     * Set the processInfoId value.
     *
     * @param processInfoId the processInfoId value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withProcessInfoId(Integer processInfoId) {
        this.processInfoId = processInfoId;
        return this;
    }

    /**
     * Get the processInfoName value.
     *
     * @return the processInfoName value
     */
    public String processInfoName() {
        return this.processInfoName;
    }

    /**
     * Set the processInfoName value.
     *
     * @param processInfoName the processInfoName value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withProcessInfoName(String processInfoName) {
        this.processInfoName = processInfoName;
        return this;
    }

    /**
     * Get the href value.
     *
     * @return the href value
     */
    public String href() {
        return this.href;
    }

    /**
     * Set the href value.
     *
     * @param href the href value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withHref(String href) {
        this.href = href;
        return this;
    }

    /**
     * Get the miniDump value.
     *
     * @return the miniDump value
     */
    public String miniDump() {
        return this.miniDump;
    }

    /**
     * Set the miniDump value.
     *
     * @param miniDump the miniDump value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withMiniDump(String miniDump) {
        this.miniDump = miniDump;
        return this;
    }

    /**
     * Get the isProfileRunning value.
     *
     * @return the isProfileRunning value
     */
    public Boolean isProfileRunning() {
        return this.isProfileRunning;
    }

    /**
     * Set the isProfileRunning value.
     *
     * @param isProfileRunning the isProfileRunning value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withIsProfileRunning(Boolean isProfileRunning) {
        this.isProfileRunning = isProfileRunning;
        return this;
    }

    /**
     * Get the isIisProfileRunning value.
     *
     * @return the isIisProfileRunning value
     */
    public Boolean isIisProfileRunning() {
        return this.isIisProfileRunning;
    }

    /**
     * Set the isIisProfileRunning value.
     *
     * @param isIisProfileRunning the isIisProfileRunning value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withIsIisProfileRunning(Boolean isIisProfileRunning) {
        this.isIisProfileRunning = isIisProfileRunning;
        return this;
    }

    /**
     * Get the iisProfileTimeoutInSeconds value.
     *
     * @return the iisProfileTimeoutInSeconds value
     */
    public Double iisProfileTimeoutInSeconds() {
        return this.iisProfileTimeoutInSeconds;
    }

    /**
     * Set the iisProfileTimeoutInSeconds value.
     *
     * @param iisProfileTimeoutInSeconds the iisProfileTimeoutInSeconds value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withIisProfileTimeoutInSeconds(Double iisProfileTimeoutInSeconds) {
        this.iisProfileTimeoutInSeconds = iisProfileTimeoutInSeconds;
        return this;
    }

    /**
     * Get the parent value.
     *
     * @return the parent value
     */
    public String parent() {
        return this.parent;
    }

    /**
     * Set the parent value.
     *
     * @param parent the parent value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withParent(String parent) {
        this.parent = parent;
        return this;
    }

    /**
     * Get the children value.
     *
     * @return the children value
     */
    public List<String> children() {
        return this.children;
    }

    /**
     * Set the children value.
     *
     * @param children the children value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withChildren(List<String> children) {
        this.children = children;
        return this;
    }

    /**
     * Get the threads value.
     *
     * @return the threads value
     */
    public List<ProcessThreadInfoInner> threads() {
        return this.threads;
    }

    /**
     * Set the threads value.
     *
     * @param threads the threads value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withThreads(List<ProcessThreadInfoInner> threads) {
        this.threads = threads;
        return this;
    }

    /**
     * Get the openFileHandles value.
     *
     * @return the openFileHandles value
     */
    public List<String> openFileHandles() {
        return this.openFileHandles;
    }

    /**
     * Set the openFileHandles value.
     *
     * @param openFileHandles the openFileHandles value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withOpenFileHandles(List<String> openFileHandles) {
        this.openFileHandles = openFileHandles;
        return this;
    }

    /**
     * Get the modules value.
     *
     * @return the modules value
     */
    public List<ProcessModuleInfoInner> modules() {
        return this.modules;
    }

    /**
     * Set the modules value.
     *
     * @param modules the modules value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withModules(List<ProcessModuleInfoInner> modules) {
        this.modules = modules;
        return this;
    }

    /**
     * Get the fileName value.
     *
     * @return the fileName value
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName value.
     *
     * @param fileName the fileName value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the commandLine value.
     *
     * @return the commandLine value
     */
    public String commandLine() {
        return this.commandLine;
    }

    /**
     * Set the commandLine value.
     *
     * @param commandLine the commandLine value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    /**
     * Get the userName value.
     *
     * @return the userName value
     */
    public String userName() {
        return this.userName;
    }

    /**
     * Set the userName value.
     *
     * @param userName the userName value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    /**
     * Get the handleCount value.
     *
     * @return the handleCount value
     */
    public Integer handleCount() {
        return this.handleCount;
    }

    /**
     * Set the handleCount value.
     *
     * @param handleCount the handleCount value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withHandleCount(Integer handleCount) {
        this.handleCount = handleCount;
        return this;
    }

    /**
     * Get the moduleCount value.
     *
     * @return the moduleCount value
     */
    public Integer moduleCount() {
        return this.moduleCount;
    }

    /**
     * Set the moduleCount value.
     *
     * @param moduleCount the moduleCount value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withModuleCount(Integer moduleCount) {
        this.moduleCount = moduleCount;
        return this;
    }

    /**
     * Get the threadCount value.
     *
     * @return the threadCount value
     */
    public Integer threadCount() {
        return this.threadCount;
    }

    /**
     * Set the threadCount value.
     *
     * @param threadCount the threadCount value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    /**
     * Get the startTime value.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime value.
     *
     * @param startTime the startTime value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the totalProcessorTime value.
     *
     * @return the totalProcessorTime value
     */
    public String totalProcessorTime() {
        return this.totalProcessorTime;
    }

    /**
     * Set the totalProcessorTime value.
     *
     * @param totalProcessorTime the totalProcessorTime value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withTotalProcessorTime(String totalProcessorTime) {
        this.totalProcessorTime = totalProcessorTime;
        return this;
    }

    /**
     * Get the userProcessorTime value.
     *
     * @return the userProcessorTime value
     */
    public String userProcessorTime() {
        return this.userProcessorTime;
    }

    /**
     * Set the userProcessorTime value.
     *
     * @param userProcessorTime the userProcessorTime value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withUserProcessorTime(String userProcessorTime) {
        this.userProcessorTime = userProcessorTime;
        return this;
    }

    /**
     * Get the privilegedProcessorTime value.
     *
     * @return the privilegedProcessorTime value
     */
    public String privilegedProcessorTime() {
        return this.privilegedProcessorTime;
    }

    /**
     * Set the privilegedProcessorTime value.
     *
     * @param privilegedProcessorTime the privilegedProcessorTime value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withPrivilegedProcessorTime(String privilegedProcessorTime) {
        this.privilegedProcessorTime = privilegedProcessorTime;
        return this;
    }

    /**
     * Get the workingSet64 value.
     *
     * @return the workingSet64 value
     */
    public Long workingSet64() {
        return this.workingSet64;
    }

    /**
     * Set the workingSet64 value.
     *
     * @param workingSet64 the workingSet64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withWorkingSet64(Long workingSet64) {
        this.workingSet64 = workingSet64;
        return this;
    }

    /**
     * Get the peakWorkingSet64 value.
     *
     * @return the peakWorkingSet64 value
     */
    public Long peakWorkingSet64() {
        return this.peakWorkingSet64;
    }

    /**
     * Set the peakWorkingSet64 value.
     *
     * @param peakWorkingSet64 the peakWorkingSet64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withPeakWorkingSet64(Long peakWorkingSet64) {
        this.peakWorkingSet64 = peakWorkingSet64;
        return this;
    }

    /**
     * Get the privateMemorySize64 value.
     *
     * @return the privateMemorySize64 value
     */
    public Long privateMemorySize64() {
        return this.privateMemorySize64;
    }

    /**
     * Set the privateMemorySize64 value.
     *
     * @param privateMemorySize64 the privateMemorySize64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withPrivateMemorySize64(Long privateMemorySize64) {
        this.privateMemorySize64 = privateMemorySize64;
        return this;
    }

    /**
     * Get the virtualMemorySize64 value.
     *
     * @return the virtualMemorySize64 value
     */
    public Long virtualMemorySize64() {
        return this.virtualMemorySize64;
    }

    /**
     * Set the virtualMemorySize64 value.
     *
     * @param virtualMemorySize64 the virtualMemorySize64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withVirtualMemorySize64(Long virtualMemorySize64) {
        this.virtualMemorySize64 = virtualMemorySize64;
        return this;
    }

    /**
     * Get the peakVirtualMemorySize64 value.
     *
     * @return the peakVirtualMemorySize64 value
     */
    public Long peakVirtualMemorySize64() {
        return this.peakVirtualMemorySize64;
    }

    /**
     * Set the peakVirtualMemorySize64 value.
     *
     * @param peakVirtualMemorySize64 the peakVirtualMemorySize64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withPeakVirtualMemorySize64(Long peakVirtualMemorySize64) {
        this.peakVirtualMemorySize64 = peakVirtualMemorySize64;
        return this;
    }

    /**
     * Get the pagedSystemMemorySize64 value.
     *
     * @return the pagedSystemMemorySize64 value
     */
    public Long pagedSystemMemorySize64() {
        return this.pagedSystemMemorySize64;
    }

    /**
     * Set the pagedSystemMemorySize64 value.
     *
     * @param pagedSystemMemorySize64 the pagedSystemMemorySize64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withPagedSystemMemorySize64(Long pagedSystemMemorySize64) {
        this.pagedSystemMemorySize64 = pagedSystemMemorySize64;
        return this;
    }

    /**
     * Get the nonpagedSystemMemorySize64 value.
     *
     * @return the nonpagedSystemMemorySize64 value
     */
    public Long nonpagedSystemMemorySize64() {
        return this.nonpagedSystemMemorySize64;
    }

    /**
     * Set the nonpagedSystemMemorySize64 value.
     *
     * @param nonpagedSystemMemorySize64 the nonpagedSystemMemorySize64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withNonpagedSystemMemorySize64(Long nonpagedSystemMemorySize64) {
        this.nonpagedSystemMemorySize64 = nonpagedSystemMemorySize64;
        return this;
    }

    /**
     * Get the pagedMemorySize64 value.
     *
     * @return the pagedMemorySize64 value
     */
    public Long pagedMemorySize64() {
        return this.pagedMemorySize64;
    }

    /**
     * Set the pagedMemorySize64 value.
     *
     * @param pagedMemorySize64 the pagedMemorySize64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withPagedMemorySize64(Long pagedMemorySize64) {
        this.pagedMemorySize64 = pagedMemorySize64;
        return this;
    }

    /**
     * Get the peakPagedMemorySize64 value.
     *
     * @return the peakPagedMemorySize64 value
     */
    public Long peakPagedMemorySize64() {
        return this.peakPagedMemorySize64;
    }

    /**
     * Set the peakPagedMemorySize64 value.
     *
     * @param peakPagedMemorySize64 the peakPagedMemorySize64 value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withPeakPagedMemorySize64(Long peakPagedMemorySize64) {
        this.peakPagedMemorySize64 = peakPagedMemorySize64;
        return this;
    }

    /**
     * Get the timeStamp value.
     *
     * @return the timeStamp value
     */
    public DateTime timeStamp() {
        return this.timeStamp;
    }

    /**
     * Set the timeStamp value.
     *
     * @param timeStamp the timeStamp value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withTimeStamp(DateTime timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    /**
     * Get the environmentVariables value.
     *
     * @return the environmentVariables value
     */
    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables value.
     *
     * @param environmentVariables the environmentVariables value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the isScmSite value.
     *
     * @return the isScmSite value
     */
    public Boolean isScmSite() {
        return this.isScmSite;
    }

    /**
     * Set the isScmSite value.
     *
     * @param isScmSite the isScmSite value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withIsScmSite(Boolean isScmSite) {
        this.isScmSite = isScmSite;
        return this;
    }

    /**
     * Get the isWebJob value.
     *
     * @return the isWebJob value
     */
    public Boolean isWebJob() {
        return this.isWebJob;
    }

    /**
     * Set the isWebJob value.
     *
     * @param isWebJob the isWebJob value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withIsWebJob(Boolean isWebJob) {
        this.isWebJob = isWebJob;
        return this;
    }

    /**
     * Get the description value.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description value.
     *
     * @param description the description value to set
     * @return the ProcessInfoInner object itself.
     */
    public ProcessInfoInner withDescription(String description) {
        this.description = description;
        return this;
    }

}
