/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Process Thread Information.
 */
@JsonFlatten
public class ProcessThreadInfoInner extends ProxyOnlyResource {
    /**
     * ARM Identifier for deployment.
     */
    @JsonProperty(value = "properties.id")
    private Integer processThreadInfoId;

    /**
     * HRef URI.
     */
    @JsonProperty(value = "properties.href")
    private String href;

    /**
     * Process URI.
     */
    @JsonProperty(value = "properties.process")
    private String process;

    /**
     * Start address.
     */
    @JsonProperty(value = "properties.startAddress")
    private String startAddress;

    /**
     * Current thread priority.
     */
    @JsonProperty(value = "properties.currentPriority")
    private Integer currentPriority;

    /**
     * Thread priority level.
     */
    @JsonProperty(value = "properties.priorityLevel")
    private String priorityLevel;

    /**
     * Base priority.
     */
    @JsonProperty(value = "properties.basePriority")
    private Integer basePriority;

    /**
     * Start time.
     */
    @JsonProperty(value = "properties.startTime")
    private DateTime startTime;

    /**
     * Total processor time.
     */
    @JsonProperty(value = "properties.totalProcessorTime")
    private String totalProcessorTime;

    /**
     * User processor time.
     */
    @JsonProperty(value = "properties.userProcessorTime")
    private String userProcessorTime;

    /**
     * Priviledged processor time.
     */
    @JsonProperty(value = "properties.priviledgedProcessorTime")
    private String priviledgedProcessorTime;

    /**
     * Thread state.
     */
    @JsonProperty(value = "properties.state")
    private String state;

    /**
     * Wait reason.
     */
    @JsonProperty(value = "properties.waitReason")
    private String waitReason;

    /**
     * Get the processThreadInfoId value.
     *
     * @return the processThreadInfoId value
     */
    public Integer processThreadInfoId() {
        return this.processThreadInfoId;
    }

    /**
     * Set the processThreadInfoId value.
     *
     * @param processThreadInfoId the processThreadInfoId value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withProcessThreadInfoId(Integer processThreadInfoId) {
        this.processThreadInfoId = processThreadInfoId;
        return this;
    }

    /**
     * Get the href value.
     *
     * @return the href value
     */
    public String href() {
        return this.href;
    }

    /**
     * Set the href value.
     *
     * @param href the href value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withHref(String href) {
        this.href = href;
        return this;
    }

    /**
     * Get the process value.
     *
     * @return the process value
     */
    public String process() {
        return this.process;
    }

    /**
     * Set the process value.
     *
     * @param process the process value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withProcess(String process) {
        this.process = process;
        return this;
    }

    /**
     * Get the startAddress value.
     *
     * @return the startAddress value
     */
    public String startAddress() {
        return this.startAddress;
    }

    /**
     * Set the startAddress value.
     *
     * @param startAddress the startAddress value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withStartAddress(String startAddress) {
        this.startAddress = startAddress;
        return this;
    }

    /**
     * Get the currentPriority value.
     *
     * @return the currentPriority value
     */
    public Integer currentPriority() {
        return this.currentPriority;
    }

    /**
     * Set the currentPriority value.
     *
     * @param currentPriority the currentPriority value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withCurrentPriority(Integer currentPriority) {
        this.currentPriority = currentPriority;
        return this;
    }

    /**
     * Get the priorityLevel value.
     *
     * @return the priorityLevel value
     */
    public String priorityLevel() {
        return this.priorityLevel;
    }

    /**
     * Set the priorityLevel value.
     *
     * @param priorityLevel the priorityLevel value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withPriorityLevel(String priorityLevel) {
        this.priorityLevel = priorityLevel;
        return this;
    }

    /**
     * Get the basePriority value.
     *
     * @return the basePriority value
     */
    public Integer basePriority() {
        return this.basePriority;
    }

    /**
     * Set the basePriority value.
     *
     * @param basePriority the basePriority value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withBasePriority(Integer basePriority) {
        this.basePriority = basePriority;
        return this;
    }

    /**
     * Get the startTime value.
     *
     * @return the startTime value
     */
    public DateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime value.
     *
     * @param startTime the startTime value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the totalProcessorTime value.
     *
     * @return the totalProcessorTime value
     */
    public String totalProcessorTime() {
        return this.totalProcessorTime;
    }

    /**
     * Set the totalProcessorTime value.
     *
     * @param totalProcessorTime the totalProcessorTime value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withTotalProcessorTime(String totalProcessorTime) {
        this.totalProcessorTime = totalProcessorTime;
        return this;
    }

    /**
     * Get the userProcessorTime value.
     *
     * @return the userProcessorTime value
     */
    public String userProcessorTime() {
        return this.userProcessorTime;
    }

    /**
     * Set the userProcessorTime value.
     *
     * @param userProcessorTime the userProcessorTime value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withUserProcessorTime(String userProcessorTime) {
        this.userProcessorTime = userProcessorTime;
        return this;
    }

    /**
     * Get the priviledgedProcessorTime value.
     *
     * @return the priviledgedProcessorTime value
     */
    public String priviledgedProcessorTime() {
        return this.priviledgedProcessorTime;
    }

    /**
     * Set the priviledgedProcessorTime value.
     *
     * @param priviledgedProcessorTime the priviledgedProcessorTime value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withPriviledgedProcessorTime(String priviledgedProcessorTime) {
        this.priviledgedProcessorTime = priviledgedProcessorTime;
        return this;
    }

    /**
     * Get the state value.
     *
     * @return the state value
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state value.
     *
     * @param state the state value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the waitReason value.
     *
     * @return the waitReason value
     */
    public String waitReason() {
        return this.waitReason;
    }

    /**
     * Set the waitReason value.
     *
     * @param waitReason the waitReason value to set
     * @return the ProcessThreadInfoInner object itself.
     */
    public ProcessThreadInfoInner withWaitReason(String waitReason) {
        this.waitReason = waitReason;
        return this;
    }

}
