/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Class representing certificate reissue request.
 */
@JsonFlatten
public class ReissueCertificateOrderRequestInner extends ProxyOnlyResource {
    /**
     * Certificate Key Size.
     */
    @JsonProperty(value = "properties.keySize")
    private Integer keySize;

    /**
     * Delay in hours to revoke existing certificate after the new certificate
     * is issued.
     */
    @JsonProperty(value = "properties.delayExistingRevokeInHours")
    private Integer delayExistingRevokeInHours;

    /**
     * Csr to be used for re-key operation.
     */
    @JsonProperty(value = "properties.csr")
    private String csr;

    /**
     * Should we change the ASC type (from managed private key to external
     * private key and vice versa).
     */
    @JsonProperty(value = "properties.isPrivateKeyExternal")
    private Boolean isPrivateKeyExternal;

    /**
     * Get the keySize value.
     *
     * @return the keySize value
     */
    public Integer keySize() {
        return this.keySize;
    }

    /**
     * Set the keySize value.
     *
     * @param keySize the keySize value to set
     * @return the ReissueCertificateOrderRequestInner object itself.
     */
    public ReissueCertificateOrderRequestInner withKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    /**
     * Get the delayExistingRevokeInHours value.
     *
     * @return the delayExistingRevokeInHours value
     */
    public Integer delayExistingRevokeInHours() {
        return this.delayExistingRevokeInHours;
    }

    /**
     * Set the delayExistingRevokeInHours value.
     *
     * @param delayExistingRevokeInHours the delayExistingRevokeInHours value to set
     * @return the ReissueCertificateOrderRequestInner object itself.
     */
    public ReissueCertificateOrderRequestInner withDelayExistingRevokeInHours(Integer delayExistingRevokeInHours) {
        this.delayExistingRevokeInHours = delayExistingRevokeInHours;
        return this;
    }

    /**
     * Get the csr value.
     *
     * @return the csr value
     */
    public String csr() {
        return this.csr;
    }

    /**
     * Set the csr value.
     *
     * @param csr the csr value to set
     * @return the ReissueCertificateOrderRequestInner object itself.
     */
    public ReissueCertificateOrderRequestInner withCsr(String csr) {
        this.csr = csr;
        return this;
    }

    /**
     * Get the isPrivateKeyExternal value.
     *
     * @return the isPrivateKeyExternal value
     */
    public Boolean isPrivateKeyExternal() {
        return this.isPrivateKeyExternal;
    }

    /**
     * Set the isPrivateKeyExternal value.
     *
     * @param isPrivateKeyExternal the isPrivateKeyExternal value to set
     * @return the ReissueCertificateOrderRequestInner object itself.
     */
    public ReissueCertificateOrderRequestInner withIsPrivateKeyExternal(Boolean isPrivateKeyExternal) {
        this.isPrivateKeyExternal = isPrivateKeyExternal;
        return this;
    }

}
