/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import java.util.List;
import com.microsoft.azure.management.appservice.DatabaseBackupSetting;
import com.microsoft.azure.management.appservice.BackupRestoreOperationType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Description of a restore request.
 */
@JsonFlatten
public class RestoreRequestInner extends ProxyOnlyResource {
    /**
     * SAS URL to the container.
     */
    @JsonProperty(value = "properties.storageAccountUrl", required = true)
    private String storageAccountUrl;

    /**
     * Name of a blob which contains the backup.
     */
    @JsonProperty(value = "properties.blobName")
    private String blobName;

    /**
     * &lt;code&gt;true&lt;/code&gt; if the restore operation can overwrite
     * target app; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * &lt;code&gt;true&lt;/code&gt; is needed if trying to restore over an
     * existing app.
     */
    @JsonProperty(value = "properties.overwrite", required = true)
    private boolean overwrite;

    /**
     * Name of an app.
     */
    @JsonProperty(value = "properties.siteName")
    private String siteName;

    /**
     * Collection of databases which should be restored. This list has to match
     * the list of databases included in the backup.
     */
    @JsonProperty(value = "properties.databases")
    private List<DatabaseBackupSetting> databases;

    /**
     * Changes a logic when restoring an app with custom domains.
     * &lt;code&gt;true&lt;/code&gt; to remove custom domains automatically. If
     * &lt;code&gt;false&lt;/code&gt;, custom domains are added to
     * the app's object when it is being restored, but that might fail due to
     * conflicts during the operation.
     */
    @JsonProperty(value = "properties.ignoreConflictingHostNames")
    private Boolean ignoreConflictingHostNames;

    /**
     * Ignore the databases and only restore the site content.
     */
    @JsonProperty(value = "properties.ignoreDatabases")
    private Boolean ignoreDatabases;

    /**
     * Specify app service plan that will own restored site.
     */
    @JsonProperty(value = "properties.appServicePlan")
    private String appServicePlan;

    /**
     * Operation type. Possible values include: 'Default', 'Clone',
     * 'Relocation', 'Snapshot'.
     */
    @JsonProperty(value = "properties.operationType")
    private BackupRestoreOperationType operationType;

    /**
     * &lt;code&gt;true&lt;/code&gt; if SiteConfig.ConnectionStrings should be
     * set in new app; otherwise, &lt;code&gt;false&lt;/code&gt;.
     */
    @JsonProperty(value = "properties.adjustConnectionStrings")
    private Boolean adjustConnectionStrings;

    /**
     * App Service Environment name, if needed (only when restoring an app to
     * an App Service Environment).
     */
    @JsonProperty(value = "properties.hostingEnvironment")
    private String hostingEnvironment;

    /**
     * Get the storageAccountUrl value.
     *
     * @return the storageAccountUrl value
     */
    public String storageAccountUrl() {
        return this.storageAccountUrl;
    }

    /**
     * Set the storageAccountUrl value.
     *
     * @param storageAccountUrl the storageAccountUrl value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withStorageAccountUrl(String storageAccountUrl) {
        this.storageAccountUrl = storageAccountUrl;
        return this;
    }

    /**
     * Get the blobName value.
     *
     * @return the blobName value
     */
    public String blobName() {
        return this.blobName;
    }

    /**
     * Set the blobName value.
     *
     * @param blobName the blobName value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withBlobName(String blobName) {
        this.blobName = blobName;
        return this;
    }

    /**
     * Get the overwrite value.
     *
     * @return the overwrite value
     */
    public boolean overwrite() {
        return this.overwrite;
    }

    /**
     * Set the overwrite value.
     *
     * @param overwrite the overwrite value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    /**
     * Get the siteName value.
     *
     * @return the siteName value
     */
    public String siteName() {
        return this.siteName;
    }

    /**
     * Set the siteName value.
     *
     * @param siteName the siteName value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withSiteName(String siteName) {
        this.siteName = siteName;
        return this;
    }

    /**
     * Get the databases value.
     *
     * @return the databases value
     */
    public List<DatabaseBackupSetting> databases() {
        return this.databases;
    }

    /**
     * Set the databases value.
     *
     * @param databases the databases value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withDatabases(List<DatabaseBackupSetting> databases) {
        this.databases = databases;
        return this;
    }

    /**
     * Get the ignoreConflictingHostNames value.
     *
     * @return the ignoreConflictingHostNames value
     */
    public Boolean ignoreConflictingHostNames() {
        return this.ignoreConflictingHostNames;
    }

    /**
     * Set the ignoreConflictingHostNames value.
     *
     * @param ignoreConflictingHostNames the ignoreConflictingHostNames value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withIgnoreConflictingHostNames(Boolean ignoreConflictingHostNames) {
        this.ignoreConflictingHostNames = ignoreConflictingHostNames;
        return this;
    }

    /**
     * Get the ignoreDatabases value.
     *
     * @return the ignoreDatabases value
     */
    public Boolean ignoreDatabases() {
        return this.ignoreDatabases;
    }

    /**
     * Set the ignoreDatabases value.
     *
     * @param ignoreDatabases the ignoreDatabases value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withIgnoreDatabases(Boolean ignoreDatabases) {
        this.ignoreDatabases = ignoreDatabases;
        return this;
    }

    /**
     * Get the appServicePlan value.
     *
     * @return the appServicePlan value
     */
    public String appServicePlan() {
        return this.appServicePlan;
    }

    /**
     * Set the appServicePlan value.
     *
     * @param appServicePlan the appServicePlan value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withAppServicePlan(String appServicePlan) {
        this.appServicePlan = appServicePlan;
        return this;
    }

    /**
     * Get the operationType value.
     *
     * @return the operationType value
     */
    public BackupRestoreOperationType operationType() {
        return this.operationType;
    }

    /**
     * Set the operationType value.
     *
     * @param operationType the operationType value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withOperationType(BackupRestoreOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    /**
     * Get the adjustConnectionStrings value.
     *
     * @return the adjustConnectionStrings value
     */
    public Boolean adjustConnectionStrings() {
        return this.adjustConnectionStrings;
    }

    /**
     * Set the adjustConnectionStrings value.
     *
     * @param adjustConnectionStrings the adjustConnectionStrings value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withAdjustConnectionStrings(Boolean adjustConnectionStrings) {
        this.adjustConnectionStrings = adjustConnectionStrings;
        return this;
    }

    /**
     * Get the hostingEnvironment value.
     *
     * @return the hostingEnvironment value
     */
    public String hostingEnvironment() {
        return this.hostingEnvironment;
    }

    /**
     * Set the hostingEnvironment value.
     *
     * @param hostingEnvironment the hostingEnvironment value to set
     * @return the RestoreRequestInner object itself.
     */
    public RestoreRequestInner withHostingEnvironment(String hostingEnvironment) {
        this.hostingEnvironment = hostingEnvironment;
        return this;
    }

}
