/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import org.joda.time.DateTime;
import com.microsoft.azure.management.appservice.ComputeModeOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Usage of the quota resource.
 */
@JsonFlatten
public class UsageInner extends ProxyOnlyResource {
    /**
     * Friendly name shown in the UI.
     */
    @JsonProperty(value = "properties.displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /**
     * Name of the quota.
     */
    @JsonProperty(value = "properties.name", access = JsonProperty.Access.WRITE_ONLY)
    private String usageName;

    /**
     * Name of the quota resource.
     */
    @JsonProperty(value = "properties.resourceName", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceName;

    /**
     * Units of measurement for the quota resource.
     */
    @JsonProperty(value = "properties.unit", access = JsonProperty.Access.WRITE_ONLY)
    private String unit;

    /**
     * The current value of the resource counter.
     */
    @JsonProperty(value = "properties.currentValue", access = JsonProperty.Access.WRITE_ONLY)
    private Long currentValue;

    /**
     * The resource limit.
     */
    @JsonProperty(value = "properties.limit", access = JsonProperty.Access.WRITE_ONLY)
    private Long limit;

    /**
     * Next reset time for the resource counter.
     */
    @JsonProperty(value = "properties.nextResetTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime nextResetTime;

    /**
     * Compute mode used for this usage. Possible values include: 'Shared',
     * 'Dedicated', 'Dynamic'.
     */
    @JsonProperty(value = "properties.computeMode", access = JsonProperty.Access.WRITE_ONLY)
    private ComputeModeOptions computeMode;

    /**
     * Site mode used for this usage.
     */
    @JsonProperty(value = "properties.siteMode", access = JsonProperty.Access.WRITE_ONLY)
    private String siteMode;

    /**
     * Get the displayName value.
     *
     * @return the displayName value
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the usageName value.
     *
     * @return the usageName value
     */
    public String usageName() {
        return this.usageName;
    }

    /**
     * Get the resourceName value.
     *
     * @return the resourceName value
     */
    public String resourceName() {
        return this.resourceName;
    }

    /**
     * Get the unit value.
     *
     * @return the unit value
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the currentValue value.
     *
     * @return the currentValue value
     */
    public Long currentValue() {
        return this.currentValue;
    }

    /**
     * Get the limit value.
     *
     * @return the limit value
     */
    public Long limit() {
        return this.limit;
    }

    /**
     * Get the nextResetTime value.
     *
     * @return the nextResetTime value
     */
    public DateTime nextResetTime() {
        return this.nextResetTime;
    }

    /**
     * Get the computeMode value.
     *
     * @return the computeMode value
     */
    public ComputeModeOptions computeMode() {
        return this.computeMode;
    }

    /**
     * Get the siteMode value.
     *
     * @return the siteMode value
     */
    public String siteMode() {
        return this.siteMode;
    }

}
