/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * The required set of inputs to validate a VNET.
 */
@JsonFlatten
public class VnetParametersInner extends ProxyOnlyResource {
    /**
     * The Resource Group of the VNET to be validated.
     */
    @JsonProperty(value = "properties.vnetResourceGroup")
    private String vnetResourceGroup;

    /**
     * The name of the VNET to be validated.
     */
    @JsonProperty(value = "properties.vnetName")
    private String vnetName;

    /**
     * The subnet name to be validated.
     */
    @JsonProperty(value = "properties.vnetSubnetName")
    private String vnetSubnetName;

    /**
     * Get the vnetResourceGroup value.
     *
     * @return the vnetResourceGroup value
     */
    public String vnetResourceGroup() {
        return this.vnetResourceGroup;
    }

    /**
     * Set the vnetResourceGroup value.
     *
     * @param vnetResourceGroup the vnetResourceGroup value to set
     * @return the VnetParametersInner object itself.
     */
    public VnetParametersInner withVnetResourceGroup(String vnetResourceGroup) {
        this.vnetResourceGroup = vnetResourceGroup;
        return this;
    }

    /**
     * Get the vnetName value.
     *
     * @return the vnetName value
     */
    public String vnetName() {
        return this.vnetName;
    }

    /**
     * Set the vnetName value.
     *
     * @param vnetName the vnetName value to set
     * @return the VnetParametersInner object itself.
     */
    public VnetParametersInner withVnetName(String vnetName) {
        this.vnetName = vnetName;
        return this;
    }

    /**
     * Get the vnetSubnetName value.
     *
     * @return the vnetSubnetName value
     */
    public String vnetSubnetName() {
        return this.vnetSubnetName;
    }

    /**
     * Set the vnetSubnetName value.
     *
     * @param vnetSubnetName the vnetSubnetName value to set
     * @return the VnetParametersInner object itself.
     */
    public VnetParametersInner withVnetSubnetName(String vnetSubnetName) {
        this.vnetSubnetName = vnetSubnetName;
        return this;
    }

}
