/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.microsoft.azure.Page;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServiceDomain;
import com.microsoft.azure.management.appservice.Contact;
import com.microsoft.azure.management.appservice.DomainPurchaseConsent;
import com.microsoft.azure.management.appservice.DomainStatus;
import com.microsoft.azure.management.appservice.HostName;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.DomainContactImpl;
import com.microsoft.azure.management.appservice.implementation.DomainInner;
import com.microsoft.azure.management.appservice.implementation.DomainOwnershipIdentifierInner;
import com.microsoft.azure.management.appservice.implementation.DomainsInner;
import com.microsoft.azure.management.appservice.implementation.TldLegalAgreementInner;
import com.microsoft.azure.management.appservice.implementation.TopLevelDomainAgreementOptionInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class AppServiceDomainImpl
extends GroupableResourceImpl<AppServiceDomain, DomainInner, AppServiceDomainImpl, AppServiceManager>
implements AppServiceDomain,
AppServiceDomain.Definition,
AppServiceDomain.Update {
    private Map<String, HostName> hostNameMap;

    AppServiceDomainImpl(String name, DomainInner innerObject, AppServiceManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        ((DomainInner)((Object)this.inner())).withLocation("global");
        if (((DomainInner)((Object)this.inner())).managedHostNames() != null) {
            this.hostNameMap = Maps.uniqueIndex(((DomainInner)((Object)this.inner())).managedHostNames(), (Function)new Function<HostName, String>(){

                public String apply(HostName input) {
                    return input.name();
                }
            });
        }
    }

    public Observable<AppServiceDomain> createResourceAsync() {
        String[] domainParts = this.name().split("\\.");
        String topLevel = domainParts[domainParts.length - 1];
        final DomainsInner client = ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).domains();
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).topLevelDomains().listAgreementsAsync(topLevel, new TopLevelDomainAgreementOptionInner()).flatMap((Func1)new Func1<Page<TldLegalAgreementInner>, Observable<List<String>>>(){

            public Observable<List<String>> call(Page<TldLegalAgreementInner> tldLegalAgreementInnerPage) {
                ArrayList<String> agreementKeys = new ArrayList<String>();
                for (TldLegalAgreementInner agreementInner : tldLegalAgreementInnerPage.items()) {
                    agreementKeys.add(agreementInner.agreementKey());
                }
                return Observable.just(agreementKeys);
            }
        }).flatMap((Func1)new Func1<List<String>, Observable<DomainInner>>(){

            public Observable<DomainInner> call(List<String> keys) {
                try {
                    ((DomainInner)((Object)AppServiceDomainImpl.this.inner())).withConsent(new DomainPurchaseConsent().withAgreedAt(new DateTime()).withAgreedBy(Inet4Address.getLocalHost().getHostAddress()).withAgreementKeys(keys));
                }
                catch (UnknownHostException e) {
                    return Observable.error((Throwable)e);
                }
                return client.createOrUpdateAsync(AppServiceDomainImpl.this.resourceGroupName(), AppServiceDomainImpl.this.name(), (DomainInner)((Object)AppServiceDomainImpl.this.inner()));
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<DomainInner> getInnerAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).domains().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Contact adminContact() {
        return ((DomainInner)((Object)this.inner())).contactAdmin();
    }

    @Override
    public Contact billingContact() {
        return ((DomainInner)((Object)this.inner())).contactBilling();
    }

    @Override
    public Contact registrantContact() {
        return ((DomainInner)((Object)this.inner())).contactRegistrant();
    }

    @Override
    public Contact techContact() {
        return ((DomainInner)((Object)this.inner())).contactTech();
    }

    @Override
    public DomainStatus registrationStatus() {
        return ((DomainInner)((Object)this.inner())).registrationStatus();
    }

    @Override
    public List<String> nameServers() {
        return Collections.unmodifiableList(((DomainInner)((Object)this.inner())).nameServers());
    }

    @Override
    public boolean privacy() {
        return Utils.toPrimitiveBoolean((Boolean)((DomainInner)((Object)this.inner())).privacy());
    }

    @Override
    public DateTime createdTime() {
        return ((DomainInner)((Object)this.inner())).createdTime();
    }

    @Override
    public DateTime expirationTime() {
        return ((DomainInner)((Object)this.inner())).expirationTime();
    }

    @Override
    public DateTime lastRenewedTime() {
        return ((DomainInner)((Object)this.inner())).lastRenewedTime();
    }

    @Override
    public boolean autoRenew() {
        return Utils.toPrimitiveBoolean((Boolean)((DomainInner)((Object)this.inner())).autoRenew());
    }

    @Override
    public boolean readyForDnsRecordManagement() {
        return Utils.toPrimitiveBoolean((Boolean)((DomainInner)((Object)this.inner())).readyForDnsRecordManagement());
    }

    @Override
    public Map<String, HostName> managedHostNames() {
        if (this.hostNameMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.hostNameMap);
    }

    @Override
    public DomainPurchaseConsent consent() {
        return ((DomainInner)((Object)this.inner())).consent();
    }

    @Override
    public void verifyDomainOwnership(String certificateOrderName, String domainVerificationToken) {
        this.verifyDomainOwnershipAsync(certificateOrderName, domainVerificationToken).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable verifyDomainOwnershipAsync(String certificateOrderName, String domainVerificationToken) {
        DomainOwnershipIdentifierInner identifierInner = new DomainOwnershipIdentifierInner().withOwnershipId(domainVerificationToken);
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).domains().createOrUpdateOwnershipIdentifierAsync(this.resourceGroupName(), this.name(), certificateOrderName, identifierInner).map((Func1)new Func1<DomainOwnershipIdentifierInner, Void>(){

            public Void call(DomainOwnershipIdentifierInner domainOwnershipIdentifierInner) {
                return null;
            }
        }).toCompletable();
    }

    @Override
    public AppServiceDomainImpl withAdminContact(Contact contact) {
        ((DomainInner)((Object)this.inner())).withContactAdmin(contact);
        return this;
    }

    @Override
    public AppServiceDomainImpl withBillingContact(Contact contact) {
        ((DomainInner)((Object)this.inner())).withContactBilling(contact);
        return this;
    }

    @Override
    public AppServiceDomainImpl withRegistrantContact(Contact contact) {
        ((DomainInner)((Object)this.inner())).withContactAdmin(contact);
        ((DomainInner)((Object)this.inner())).withContactBilling(contact);
        ((DomainInner)((Object)this.inner())).withContactRegistrant(contact);
        ((DomainInner)((Object)this.inner())).withContactTech(contact);
        return this;
    }

    public DomainContactImpl defineRegistrantContact() {
        return new DomainContactImpl(new Contact(), this);
    }

    @Override
    public AppServiceDomainImpl withTechContact(Contact contact) {
        ((DomainInner)((Object)this.inner())).withContactTech(contact);
        return this;
    }

    @Override
    public AppServiceDomainImpl withDomainPrivacyEnabled(boolean domainPrivacy) {
        ((DomainInner)((Object)this.inner())).withPrivacy(domainPrivacy);
        return this;
    }

    @Override
    public AppServiceDomainImpl withAutoRenewEnabled(boolean autoRenew) {
        ((DomainInner)((Object)this.inner())).withAutoRenew(autoRenew);
        return this;
    }
}

