/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.implementation.DomainAvailablilityCheckResultInner;
import com.microsoft.azure.management.appservice.implementation.DomainControlCenterSsoRequestInner;
import com.microsoft.azure.management.appservice.implementation.DomainInner;
import com.microsoft.azure.management.appservice.implementation.DomainOwnershipIdentifierInner;
import com.microsoft.azure.management.appservice.implementation.DomainPatchResourceInner;
import com.microsoft.azure.management.appservice.implementation.DomainRecommendationSearchParametersInner;
import com.microsoft.azure.management.appservice.implementation.NameIdentifierInner;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DomainsInner
implements InnerSupportsGet<DomainInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<DomainInner> {
    private DomainsService service;
    private WebSiteManagementClientImpl client;

    public DomainsInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (DomainsService)retrofit.create(DomainsService.class);
        this.client = client;
    }

    public DomainAvailablilityCheckResultInner checkAvailability() {
        return (DomainAvailablilityCheckResultInner)((ServiceResponse)this.checkAvailabilityWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<DomainAvailablilityCheckResultInner> checkAvailabilityAsync(ServiceCallback<DomainAvailablilityCheckResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkAvailabilityWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<DomainAvailablilityCheckResultInner> checkAvailabilityAsync() {
        return this.checkAvailabilityWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<DomainAvailablilityCheckResultInner>, DomainAvailablilityCheckResultInner>(){

            public DomainAvailablilityCheckResultInner call(ServiceResponse<DomainAvailablilityCheckResultInner> response) {
                return (DomainAvailablilityCheckResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DomainAvailablilityCheckResultInner>> checkAvailabilityWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        Object name = null;
        NameIdentifierInner identifier = new NameIdentifierInner();
        identifier.withName(null);
        return this.service.checkAvailability(this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), identifier, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainAvailablilityCheckResultInner>>>(){

            public Observable<ServiceResponse<DomainAvailablilityCheckResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.checkAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public DomainAvailablilityCheckResultInner checkAvailability(String name) {
        return (DomainAvailablilityCheckResultInner)((ServiceResponse)this.checkAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<DomainAvailablilityCheckResultInner> checkAvailabilityAsync(String name, ServiceCallback<DomainAvailablilityCheckResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<DomainAvailablilityCheckResultInner> checkAvailabilityAsync(String name) {
        return this.checkAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<DomainAvailablilityCheckResultInner>, DomainAvailablilityCheckResultInner>(){

            public DomainAvailablilityCheckResultInner call(ServiceResponse<DomainAvailablilityCheckResultInner> response) {
                return (DomainAvailablilityCheckResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DomainAvailablilityCheckResultInner>> checkAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        NameIdentifierInner identifier = new NameIdentifierInner();
        identifier.withName(name);
        return this.service.checkAvailability(this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), identifier, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainAvailablilityCheckResultInner>>>(){

            public Observable<ServiceResponse<DomainAvailablilityCheckResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.checkAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainAvailablilityCheckResultInner> checkAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainAvailablilityCheckResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DomainInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<DomainInner>((Page)response.body()){

            public Page<DomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DomainsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DomainInner>> listAsync(ListOperationCallback<DomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(String nextPageLink) {
                return DomainsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DomainInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<DomainInner>>, Page<DomainInner>>(){

            public Page<DomainInner> call(ServiceResponse<Page<DomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<DomainInner>>, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(ServiceResponse<Page<DomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DomainsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.list(this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DomainInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DomainInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DomainControlCenterSsoRequestInner getControlCenterSsoRequest() {
        return (DomainControlCenterSsoRequestInner)((ServiceResponse)this.getControlCenterSsoRequestWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<DomainControlCenterSsoRequestInner> getControlCenterSsoRequestAsync(ServiceCallback<DomainControlCenterSsoRequestInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getControlCenterSsoRequestWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<DomainControlCenterSsoRequestInner> getControlCenterSsoRequestAsync() {
        return this.getControlCenterSsoRequestWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<DomainControlCenterSsoRequestInner>, DomainControlCenterSsoRequestInner>(){

            public DomainControlCenterSsoRequestInner call(ServiceResponse<DomainControlCenterSsoRequestInner> response) {
                return (DomainControlCenterSsoRequestInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DomainControlCenterSsoRequestInner>> getControlCenterSsoRequestWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.getControlCenterSsoRequest(this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainControlCenterSsoRequestInner>>>(){

            public Observable<ServiceResponse<DomainControlCenterSsoRequestInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.getControlCenterSsoRequestDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainControlCenterSsoRequestInner> getControlCenterSsoRequestDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainControlCenterSsoRequestInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NameIdentifierInner> listRecommendations(DomainRecommendationSearchParametersInner parameters) {
        ServiceResponse response = (ServiceResponse)this.listRecommendationsSinglePageAsync(parameters).toBlocking().single();
        return new PagedList<NameIdentifierInner>((Page)response.body()){

            public Page<NameIdentifierInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DomainsInner.this.listRecommendationsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NameIdentifierInner>> listRecommendationsAsync(DomainRecommendationSearchParametersInner parameters, ListOperationCallback<NameIdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRecommendationsSinglePageAsync(parameters), (Func1)new Func1<String, Observable<ServiceResponse<Page<NameIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<NameIdentifierInner>>> call(String nextPageLink) {
                return DomainsInner.this.listRecommendationsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NameIdentifierInner>> listRecommendationsAsync(DomainRecommendationSearchParametersInner parameters) {
        return this.listRecommendationsWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<Page<NameIdentifierInner>>, Page<NameIdentifierInner>>(){

            public Page<NameIdentifierInner> call(ServiceResponse<Page<NameIdentifierInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NameIdentifierInner>>> listRecommendationsWithServiceResponseAsync(DomainRecommendationSearchParametersInner parameters) {
        return this.listRecommendationsSinglePageAsync(parameters).concatMap((Func1)new Func1<ServiceResponse<Page<NameIdentifierInner>>, Observable<ServiceResponse<Page<NameIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<NameIdentifierInner>>> call(ServiceResponse<Page<NameIdentifierInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DomainsInner.this.listRecommendationsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NameIdentifierInner>>> listRecommendationsSinglePageAsync(DomainRecommendationSearchParametersInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-04-01";
        return this.service.listRecommendations(this.client.subscriptionId(), parameters, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NameIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<NameIdentifierInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listRecommendationsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NameIdentifierInner>> listRecommendationsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NameIdentifierInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DomainInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<DomainInner>((Page)response.body()){

            public Page<DomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DomainsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DomainInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<DomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(String nextPageLink) {
                return DomainsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DomainInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<DomainInner>>, Page<DomainInner>>(){

            public Page<DomainInner> call(ServiceResponse<Page<DomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<DomainInner>>, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(ServiceResponse<Page<DomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DomainsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DomainInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DomainInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DomainInner getByResourceGroup(String resourceGroupName, String domainName) {
        return (DomainInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, domainName).toBlocking().single()).body());
    }

    public ServiceFuture<DomainInner> getByResourceGroupAsync(String resourceGroupName, String domainName, ServiceCallback<DomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, domainName), serviceCallback);
    }

    public Observable<DomainInner> getByResourceGroupAsync(String resourceGroupName, String domainName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, domainName).map((Func1)new Func1<ServiceResponse<DomainInner>, DomainInner>(){

            public DomainInner call(ServiceResponse<DomainInner> response) {
                return (DomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DomainInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String domainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.getByResourceGroup(resourceGroupName, domainName, this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainInner>>>(){

            public Observable<ServiceResponse<DomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DomainInner createOrUpdate(String resourceGroupName, String domainName, DomainInner domain) {
        return (DomainInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, domainName, domain).toBlocking().last()).body());
    }

    public ServiceFuture<DomainInner> createOrUpdateAsync(String resourceGroupName, String domainName, DomainInner domain, ServiceCallback<DomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, domainName, domain), serviceCallback);
    }

    public Observable<DomainInner> createOrUpdateAsync(String resourceGroupName, String domainName, DomainInner domain) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, domainName, domain).map((Func1)new Func1<ServiceResponse<DomainInner>, DomainInner>(){

            public DomainInner call(ServiceResponse<DomainInner> response) {
                return (DomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DomainInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String domainName, DomainInner domain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (domain == null) {
            throw new IllegalArgumentException("Parameter domain is required and cannot be null.");
        }
        Validator.validate((Object)((Object)domain));
        String apiVersion = "2015-04-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, domainName, this.client.subscriptionId(), domain, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<DomainInner>(){}.getType());
    }

    public DomainInner beginCreateOrUpdate(String resourceGroupName, String domainName, DomainInner domain) {
        return (DomainInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, domainName, domain).toBlocking().single()).body());
    }

    public ServiceFuture<DomainInner> beginCreateOrUpdateAsync(String resourceGroupName, String domainName, DomainInner domain, ServiceCallback<DomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, domainName, domain), serviceCallback);
    }

    public Observable<DomainInner> beginCreateOrUpdateAsync(String resourceGroupName, String domainName, DomainInner domain) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, domainName, domain).map((Func1)new Func1<ServiceResponse<DomainInner>, DomainInner>(){

            public DomainInner call(ServiceResponse<DomainInner> response) {
                return (DomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DomainInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String domainName, DomainInner domain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (domain == null) {
            throw new IllegalArgumentException("Parameter domain is required and cannot be null.");
        }
        Validator.validate((Object)((Object)domain));
        String apiVersion = "2015-04-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, domainName, this.client.subscriptionId(), domain, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainInner>>>(){

            public Observable<ServiceResponse<DomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainInner>(){}.getType()).register(202, new TypeToken<DomainInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String domainName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, domainName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String domainName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, domainName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String domainName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, domainName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String domainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        Boolean forceHardDeleteDomain = null;
        return this.service.delete(resourceGroupName, domainName, this.client.subscriptionId(), forceHardDeleteDomain, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void delete(String resourceGroupName, String domainName, Boolean forceHardDeleteDomain) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, domainName, forceHardDeleteDomain).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String domainName, Boolean forceHardDeleteDomain, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, domainName, forceHardDeleteDomain), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String domainName, Boolean forceHardDeleteDomain) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, domainName, forceHardDeleteDomain).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String domainName, Boolean forceHardDeleteDomain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.delete(resourceGroupName, domainName, this.client.subscriptionId(), forceHardDeleteDomain, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DomainInner update(String resourceGroupName, String domainName, DomainPatchResourceInner domain) {
        return (DomainInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, domainName, domain).toBlocking().single()).body());
    }

    public ServiceFuture<DomainInner> updateAsync(String resourceGroupName, String domainName, DomainPatchResourceInner domain, ServiceCallback<DomainInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, domainName, domain), serviceCallback);
    }

    public Observable<DomainInner> updateAsync(String resourceGroupName, String domainName, DomainPatchResourceInner domain) {
        return this.updateWithServiceResponseAsync(resourceGroupName, domainName, domain).map((Func1)new Func1<ServiceResponse<DomainInner>, DomainInner>(){

            public DomainInner call(ServiceResponse<DomainInner> response) {
                return (DomainInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DomainInner>> updateWithServiceResponseAsync(String resourceGroupName, String domainName, DomainPatchResourceInner domain) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (domain == null) {
            throw new IllegalArgumentException("Parameter domain is required and cannot be null.");
        }
        Validator.validate((Object)domain);
        String apiVersion = "2015-04-01";
        return this.service.update(resourceGroupName, domainName, this.client.subscriptionId(), domain, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainInner>>>(){

            public Observable<ServiceResponse<DomainInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainInner>(){}.getType()).register(202, new TypeToken<DomainInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DomainOwnershipIdentifierInner> listOwnershipIdentifiers(String resourceGroupName, String domainName) {
        ServiceResponse response = (ServiceResponse)this.listOwnershipIdentifiersSinglePageAsync(resourceGroupName, domainName).toBlocking().single();
        return new PagedList<DomainOwnershipIdentifierInner>((Page)response.body()){

            public Page<DomainOwnershipIdentifierInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DomainsInner.this.listOwnershipIdentifiersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DomainOwnershipIdentifierInner>> listOwnershipIdentifiersAsync(String resourceGroupName, String domainName, ListOperationCallback<DomainOwnershipIdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOwnershipIdentifiersSinglePageAsync(resourceGroupName, domainName), (Func1)new Func1<String, Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> call(String nextPageLink) {
                return DomainsInner.this.listOwnershipIdentifiersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DomainOwnershipIdentifierInner>> listOwnershipIdentifiersAsync(String resourceGroupName, String domainName) {
        return this.listOwnershipIdentifiersWithServiceResponseAsync(resourceGroupName, domainName).map((Func1)new Func1<ServiceResponse<Page<DomainOwnershipIdentifierInner>>, Page<DomainOwnershipIdentifierInner>>(){

            public Page<DomainOwnershipIdentifierInner> call(ServiceResponse<Page<DomainOwnershipIdentifierInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> listOwnershipIdentifiersWithServiceResponseAsync(String resourceGroupName, String domainName) {
        return this.listOwnershipIdentifiersSinglePageAsync(resourceGroupName, domainName).concatMap((Func1)new Func1<ServiceResponse<Page<DomainOwnershipIdentifierInner>>, Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> call(ServiceResponse<Page<DomainOwnershipIdentifierInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DomainsInner.this.listOwnershipIdentifiersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> listOwnershipIdentifiersSinglePageAsync(String resourceGroupName, String domainName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.listOwnershipIdentifiers(resourceGroupName, domainName, this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listOwnershipIdentifiersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DomainOwnershipIdentifierInner>> listOwnershipIdentifiersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DomainOwnershipIdentifierInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DomainOwnershipIdentifierInner getOwnershipIdentifier(String resourceGroupName, String domainName, String name) {
        return (DomainOwnershipIdentifierInner)((ServiceResponse)this.getOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name).toBlocking().single()).body();
    }

    public ServiceFuture<DomainOwnershipIdentifierInner> getOwnershipIdentifierAsync(String resourceGroupName, String domainName, String name, ServiceCallback<DomainOwnershipIdentifierInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name), serviceCallback);
    }

    public Observable<DomainOwnershipIdentifierInner> getOwnershipIdentifierAsync(String resourceGroupName, String domainName, String name) {
        return this.getOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name).map((Func1)new Func1<ServiceResponse<DomainOwnershipIdentifierInner>, DomainOwnershipIdentifierInner>(){

            public DomainOwnershipIdentifierInner call(ServiceResponse<DomainOwnershipIdentifierInner> response) {
                return (DomainOwnershipIdentifierInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DomainOwnershipIdentifierInner>> getOwnershipIdentifierWithServiceResponseAsync(String resourceGroupName, String domainName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.getOwnershipIdentifier(resourceGroupName, domainName, name, this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainOwnershipIdentifierInner>>>(){

            public Observable<ServiceResponse<DomainOwnershipIdentifierInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.getOwnershipIdentifierDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainOwnershipIdentifierInner> getOwnershipIdentifierDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainOwnershipIdentifierInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DomainOwnershipIdentifierInner createOrUpdateOwnershipIdentifier(String resourceGroupName, String domainName, String name, DomainOwnershipIdentifierInner domainOwnershipIdentifier) {
        return (DomainOwnershipIdentifierInner)((ServiceResponse)this.createOrUpdateOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name, domainOwnershipIdentifier).toBlocking().single()).body();
    }

    public ServiceFuture<DomainOwnershipIdentifierInner> createOrUpdateOwnershipIdentifierAsync(String resourceGroupName, String domainName, String name, DomainOwnershipIdentifierInner domainOwnershipIdentifier, ServiceCallback<DomainOwnershipIdentifierInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name, domainOwnershipIdentifier), serviceCallback);
    }

    public Observable<DomainOwnershipIdentifierInner> createOrUpdateOwnershipIdentifierAsync(String resourceGroupName, String domainName, String name, DomainOwnershipIdentifierInner domainOwnershipIdentifier) {
        return this.createOrUpdateOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name, domainOwnershipIdentifier).map((Func1)new Func1<ServiceResponse<DomainOwnershipIdentifierInner>, DomainOwnershipIdentifierInner>(){

            public DomainOwnershipIdentifierInner call(ServiceResponse<DomainOwnershipIdentifierInner> response) {
                return (DomainOwnershipIdentifierInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DomainOwnershipIdentifierInner>> createOrUpdateOwnershipIdentifierWithServiceResponseAsync(String resourceGroupName, String domainName, String name, DomainOwnershipIdentifierInner domainOwnershipIdentifier) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (domainOwnershipIdentifier == null) {
            throw new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null.");
        }
        Validator.validate((Object)domainOwnershipIdentifier);
        String apiVersion = "2015-04-01";
        return this.service.createOrUpdateOwnershipIdentifier(resourceGroupName, domainName, name, this.client.subscriptionId(), domainOwnershipIdentifier, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainOwnershipIdentifierInner>>>(){

            public Observable<ServiceResponse<DomainOwnershipIdentifierInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.createOrUpdateOwnershipIdentifierDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainOwnershipIdentifierInner> createOrUpdateOwnershipIdentifierDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainOwnershipIdentifierInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteOwnershipIdentifier(String resourceGroupName, String domainName, String name) {
        ((ServiceResponse)this.deleteOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteOwnershipIdentifierAsync(String resourceGroupName, String domainName, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name), serviceCallback);
    }

    public Observable<Void> deleteOwnershipIdentifierAsync(String resourceGroupName, String domainName, String name) {
        return this.deleteOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteOwnershipIdentifierWithServiceResponseAsync(String resourceGroupName, String domainName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-04-01";
        return this.service.deleteOwnershipIdentifier(resourceGroupName, domainName, name, this.client.subscriptionId(), "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.deleteOwnershipIdentifierDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteOwnershipIdentifierDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DomainOwnershipIdentifierInner updateOwnershipIdentifier(String resourceGroupName, String domainName, String name, DomainOwnershipIdentifierInner domainOwnershipIdentifier) {
        return (DomainOwnershipIdentifierInner)((ServiceResponse)this.updateOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name, domainOwnershipIdentifier).toBlocking().single()).body();
    }

    public ServiceFuture<DomainOwnershipIdentifierInner> updateOwnershipIdentifierAsync(String resourceGroupName, String domainName, String name, DomainOwnershipIdentifierInner domainOwnershipIdentifier, ServiceCallback<DomainOwnershipIdentifierInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name, domainOwnershipIdentifier), serviceCallback);
    }

    public Observable<DomainOwnershipIdentifierInner> updateOwnershipIdentifierAsync(String resourceGroupName, String domainName, String name, DomainOwnershipIdentifierInner domainOwnershipIdentifier) {
        return this.updateOwnershipIdentifierWithServiceResponseAsync(resourceGroupName, domainName, name, domainOwnershipIdentifier).map((Func1)new Func1<ServiceResponse<DomainOwnershipIdentifierInner>, DomainOwnershipIdentifierInner>(){

            public DomainOwnershipIdentifierInner call(ServiceResponse<DomainOwnershipIdentifierInner> response) {
                return (DomainOwnershipIdentifierInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DomainOwnershipIdentifierInner>> updateOwnershipIdentifierWithServiceResponseAsync(String resourceGroupName, String domainName, String name, DomainOwnershipIdentifierInner domainOwnershipIdentifier) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Parameter domainName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (domainOwnershipIdentifier == null) {
            throw new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null.");
        }
        Validator.validate((Object)domainOwnershipIdentifier);
        String apiVersion = "2015-04-01";
        return this.service.updateOwnershipIdentifier(resourceGroupName, domainName, name, this.client.subscriptionId(), domainOwnershipIdentifier, "2015-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DomainOwnershipIdentifierInner>>>(){

            public Observable<ServiceResponse<DomainOwnershipIdentifierInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DomainsInner.this.updateOwnershipIdentifierDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DomainOwnershipIdentifierInner> updateOwnershipIdentifierDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DomainOwnershipIdentifierInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DomainInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DomainInner>((Page)response.body()){

            public Page<DomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DomainsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DomainInner>> listNextAsync(String nextPageLink, ServiceFuture<List<DomainInner>> serviceFuture, ListOperationCallback<DomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(String nextPageLink) {
                return DomainsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DomainInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DomainInner>>, Page<DomainInner>>(){

            public Page<DomainInner> call(ServiceResponse<Page<DomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DomainInner>>, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(ServiceResponse<Page<DomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DomainsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DomainInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DomainInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<NameIdentifierInner> listRecommendationsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listRecommendationsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NameIdentifierInner>((Page)response.body()){

            public Page<NameIdentifierInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DomainsInner.this.listRecommendationsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<NameIdentifierInner>> listRecommendationsNextAsync(String nextPageLink, ServiceFuture<List<NameIdentifierInner>> serviceFuture, ListOperationCallback<NameIdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRecommendationsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<NameIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<NameIdentifierInner>>> call(String nextPageLink) {
                return DomainsInner.this.listRecommendationsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<NameIdentifierInner>> listRecommendationsNextAsync(String nextPageLink) {
        return this.listRecommendationsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<NameIdentifierInner>>, Page<NameIdentifierInner>>(){

            public Page<NameIdentifierInner> call(ServiceResponse<Page<NameIdentifierInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<NameIdentifierInner>>> listRecommendationsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listRecommendationsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<NameIdentifierInner>>, Observable<ServiceResponse<Page<NameIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<NameIdentifierInner>>> call(ServiceResponse<Page<NameIdentifierInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DomainsInner.this.listRecommendationsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<NameIdentifierInner>>> listRecommendationsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listRecommendationsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<NameIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<NameIdentifierInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listRecommendationsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<NameIdentifierInner>> listRecommendationsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NameIdentifierInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DomainInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DomainInner>((Page)response.body()){

            public Page<DomainInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DomainsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DomainInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<DomainInner>> serviceFuture, ListOperationCallback<DomainInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(String nextPageLink) {
                return DomainsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DomainInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DomainInner>>, Page<DomainInner>>(){

            public Page<DomainInner> call(ServiceResponse<Page<DomainInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DomainInner>>, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(ServiceResponse<Page<DomainInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DomainsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DomainInner>>>>(){

            public Observable<ServiceResponse<Page<DomainInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DomainInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DomainInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<DomainOwnershipIdentifierInner> listOwnershipIdentifiersNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listOwnershipIdentifiersNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<DomainOwnershipIdentifierInner>((Page)response.body()){

            public Page<DomainOwnershipIdentifierInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DomainsInner.this.listOwnershipIdentifiersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<DomainOwnershipIdentifierInner>> listOwnershipIdentifiersNextAsync(String nextPageLink, ServiceFuture<List<DomainOwnershipIdentifierInner>> serviceFuture, ListOperationCallback<DomainOwnershipIdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOwnershipIdentifiersNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> call(String nextPageLink) {
                return DomainsInner.this.listOwnershipIdentifiersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<DomainOwnershipIdentifierInner>> listOwnershipIdentifiersNextAsync(String nextPageLink) {
        return this.listOwnershipIdentifiersNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<DomainOwnershipIdentifierInner>>, Page<DomainOwnershipIdentifierInner>>(){

            public Page<DomainOwnershipIdentifierInner> call(ServiceResponse<Page<DomainOwnershipIdentifierInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> listOwnershipIdentifiersNextWithServiceResponseAsync(String nextPageLink) {
        return this.listOwnershipIdentifiersNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<DomainOwnershipIdentifierInner>>, Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> call(ServiceResponse<Page<DomainOwnershipIdentifierInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DomainsInner.this.listOwnershipIdentifiersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> listOwnershipIdentifiersNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listOwnershipIdentifiersNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<DomainOwnershipIdentifierInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DomainsInner.this.listOwnershipIdentifiersNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<DomainOwnershipIdentifierInner>> listOwnershipIdentifiersNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<DomainOwnershipIdentifierInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DomainsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains checkAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/checkDomainAvailability")
        public Observable<Response<ResponseBody>> checkAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body NameIdentifierInner var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/domains")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains getControlCenterSsoRequest"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/generateSsoRequest")
        public Observable<Response<ResponseBody>> getControlCenterSsoRequest(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains listRecommendations"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/listDomainRecommendations")
        public Observable<Response<ResponseBody>> listRecommendations(@Path(value="subscriptionId") String var1, @Body DomainRecommendationSearchParametersInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="subscriptionId") String var3, @Body DomainInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="subscriptionId") String var3, @Body DomainInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="subscriptionId") String var3, @Query(value="forceHardDeleteDomain") Boolean var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="subscriptionId") String var3, @Body DomainPatchResourceInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains listOwnershipIdentifiers"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers")
        public Observable<Response<ResponseBody>> listOwnershipIdentifiers(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains getOwnershipIdentifier"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}")
        public Observable<Response<ResponseBody>> getOwnershipIdentifier(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains createOrUpdateOwnershipIdentifier"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}")
        public Observable<Response<ResponseBody>> createOrUpdateOwnershipIdentifier(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Body DomainOwnershipIdentifierInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains deleteOwnershipIdentifier"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteOwnershipIdentifier(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains updateOwnershipIdentifier"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}")
        public Observable<Response<ResponseBody>> updateOwnershipIdentifier(@Path(value="resourceGroupName") String var1, @Path(value="domainName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Body DomainOwnershipIdentifierInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains listRecommendationsNext"})
        @GET
        public Observable<Response<ResponseBody>> listRecommendationsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Domains listOwnershipIdentifiersNext"})
        @GET
        public Observable<Response<ResponseBody>> listOwnershipIdentifiersNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

